/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.engine.api.column.ClosableIterator;
import net.openhft.chronicle.engine.api.column.Row;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.engine.server.internal.ColumnViewIteratorHandler;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteValue;
import org.jetbrains.annotations.NotNull;

public class RemoteColumnViewRowIterator
extends AbstractStatelessClient<CollectionWireHandler.EventId>
implements ClosableIterator<Row> {
    private static final int ITTERATOR_PAGE_SIZE = 300;
    private Iterator<Row> iterator;
    private final WriteValue pageSize = valueOut -> valueOut.int32(300);
    @NotNull
    private AtomicBoolean isClosed = new AtomicBoolean();

    public RemoteColumnViewRowIterator(@NotNull TcpChannelHub hub, @NotNull String csp, long cid) {
        super(hub, cid, csp);
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.iterator != null && this.iterator.hasNext()) {
            return true;
        }
        this.iterator = this.nextIterator();
        return this.iterator.hasNext();
    }

    @Override
    public synchronized Row next() {
        if (this.iterator != null && this.iterator.hasNext()) {
            return this.iterator.next();
        }
        this.iterator = this.nextIterator();
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next();
    }

    private Iterator<Row> nextIterator() {
        return ((Collection)this.proxyReturnWireConsumerInOut((WireKey)ColumnViewIteratorHandler.EventId.next, (WireKey)CoreFields.reply, this.pageSize, f -> (List)f.object(List.class))).iterator();
    }

    public void close() {
        this.isClosed.set(true);
        this.proxyReturnVoid((WireKey)ColumnViewIteratorHandler.EventId.close);
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        super.finalize();
    }
}

