/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.collection;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaValuesCollection<K, V>
extends AbstractCollection<V>
implements ValuesCollection<V> {
    private final Asset asset;
    private final MapView<K, V> mapView;

    public VanillaValuesCollection(RequestContext requestContext, Asset asset, MapView<K, V> mapView) {
        this.asset = asset;
        this.mapView = mapView;
    }

    @Override
    public boolean contains(Object o) {
        return this.mapView.containsValue(o);
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return ((KeyValueStore)this.mapView.underlying()).valuesIterator();
    }

    @Override
    public int size() {
        return this.mapView.size();
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (V v : this) {
            h += Objects.hashCode(v);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)obj;
        if (collection.size() != this.size()) {
            return false;
        }
        for (Object v : collection) {
            if (v != null && this.contains(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    @Nullable
    public MapView<?, V> underlying() {
        return this.mapView;
    }
}

