/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class EngineConnectionManager
implements ConnectionManager {
    private final Set<ConnectionManager.ConnectionListener> connectionListeners = Collections.newSetFromMap(new IdentityHashMap());
    @NotNull
    private ConcurrentHashMap<NetworkContext, AtomicBoolean> isConnected = new ConcurrentHashMap();

    private EngineConnectionManager() {
    }

    public synchronized void addListener(@NotNull ConnectionManager.ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
        this.isConnected.forEach((wireOutPublisher, connected) -> connectionListener.onConnectionChange(wireOutPublisher, connected.get()));
    }

    public synchronized void onConnectionChanged(boolean isConnected, NetworkContext nc) {
        Function<NetworkContext, AtomicBoolean> f = v -> new AtomicBoolean();
        boolean wasConnected = this.isConnected.computeIfAbsent(nc, f).getAndSet(isConnected);
        if (wasConnected != isConnected) {
            this.connectionListeners.forEach(l -> {
                try {
                    l.onConnectionChange(nc, isConnected);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
    }

    public static class Factory
    implements Supplier<ConnectionManager>,
    Demarshallable,
    WriteMarshallable {
        @UsedViaReflection
        private Factory(@NotNull WireIn wireIn) {
        }

        public Factory() {
        }

        public void writeMarshallable(@NotNull WireOut wire) {
        }

        @Override
        @NotNull
        public EngineConnectionManager get() {
            return new EngineConnectionManager();
        }
    }
}

