/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.KVSSubscription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaKeyValueStore<K, V>
implements AuthenticatedKeyValueStore<K, V> {
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();
    private final Asset asset;

    public VanillaKeyValueStore(RequestContext context, Asset asset) {
        this.asset = asset;
    }

    public VanillaKeyValueStore(Asset asset) {
        this(null, asset);
    }

    @Override
    public boolean put(K key, V value) {
        return this.map.put(key, value) != null;
    }

    @Override
    public V getAndPut(K key, V value) {
        V oldValue = this.map.put(key, value);
        return oldValue;
    }

    @Override
    public boolean remove(K key) {
        return this.map.remove(key) != null;
    }

    @Override
    public V getAndRemove(K key) {
        Object oldValue = this.map.remove(key);
        return oldValue;
    }

    @Override
    public V getUsing(K key, Object value) {
        return this.map.get(key);
    }

    @Override
    public long longSize() {
        return this.map.size();
    }

    @Override
    public void keysFor(int segment, @NotNull SubscriptionConsumer<K> kConsumer) throws InvalidSubscriberException {
        SubscriptionConsumer.notifyEachEvent(this.map.keySet(), kConsumer);
    }

    @Override
    public void entriesFor(int segment, @NotNull SubscriptionConsumer<MapEvent<K, V>> kvConsumer) throws InvalidSubscriberException {
        SubscriptionConsumer.notifyEachEvent(this.map.entrySet(), e -> kvConsumer.accept(InsertedEvent.of(this.asset.fullName(), e.getKey(), e.getValue(), false)));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    @NotNull
    public Iterator<K> keySetIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public void clear() {
        try {
            int segs = this.segments();
            for (int i = 0; i < segs; ++i) {
                this.keysFor(i, this.map::remove);
            }
        }
        catch (InvalidSubscriberException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean containsValue(V value) {
        return this.map.containsValue(value);
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    @Nullable
    public KeyValueStore underlying() {
        return null;
    }

    public void close() {
    }

    @Override
    @NotNull
    public KVSSubscription<K, V> subscription(boolean createIfAbsent) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException("todo");
    }
}

