/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map.remote;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.map.remote.KeyFunctionPair;
import net.openhft.chronicle.engine.map.remote.KeyValueFunctionTuple;
import net.openhft.chronicle.engine.map.remote.KeyValuePair;
import net.openhft.chronicle.engine.map.remote.KeyValuesTuple;
import org.jetbrains.annotations.NotNull;

public enum MapFunction implements SerializableBiFunction<MapView, Object, Object>
{
    CONTAINS_VALUE{

        public Boolean apply(@NotNull MapView map, Object value) {
            Class vClass = map.valueType();
            return map.containsValue(ObjectUtils.convertTo(vClass, (Object)value));
        }
    }
    ,
    REMOVE{

        public Object apply(@NotNull MapView map, Object o) {
            Class kClass = map.keyType();
            Class vClass = map.valueType();
            KeyValuePair kf = (KeyValuePair)o;
            return map.remove(ObjectUtils.convertTo(kClass, (Object)kf.key), ObjectUtils.convertTo(vClass, (Object)kf.value));
        }
    }
    ,
    REPLACE{

        public Object apply(@NotNull MapView map, Object o) {
            Class kClass = map.keyType();
            Class vClass = map.valueType();
            if (o instanceof KeyValuePair) {
                KeyValuePair kf = (KeyValuePair)o;
                return map.replace(ObjectUtils.convertTo(kClass, (Object)kf.key), ObjectUtils.convertTo(vClass, (Object)kf.value));
            }
            KeyValuesTuple kf = (KeyValuesTuple)o;
            return map.replace(ObjectUtils.convertTo(kClass, (Object)kf.key), ObjectUtils.convertTo(vClass, (Object)kf.oldValue), ObjectUtils.convertTo(vClass, (Object)kf.value));
        }
    }
    ,
    PUT_IF_ABSENT{

        public Object apply(@NotNull MapView map, Object o) {
            Class kClass = map.keyType();
            Class vClass = map.valueType();
            KeyValuePair kf = (KeyValuePair)o;
            return map.putIfAbsent(ObjectUtils.convertTo(kClass, (Object)kf.key), ObjectUtils.convertTo(vClass, (Object)kf.value));
        }
    }
    ,
    COMPUTE_IF_ABSENT{

        public Object apply(@NotNull MapView map, Object o) {
            Class kClass = map.keyType();
            KeyFunctionPair kf = (KeyFunctionPair)o;
            return map.computeIfAbsent(ObjectUtils.convertTo(kClass, (Object)kf.key), (Function)kf.function);
        }
    }
    ,
    COMPUTE_IF_PRESENT{

        public Object apply(@NotNull MapView map, Object o) {
            Class kClass = map.keyType();
            KeyFunctionPair kf = (KeyFunctionPair)o;
            return map.computeIfPresent(ObjectUtils.convertTo(kClass, (Object)kf.key), (BiFunction)kf.function);
        }
    }
    ,
    COMPUTE{

        public Object apply(@NotNull MapView map, Object o) {
            Class kClass = map.keyType();
            KeyFunctionPair kf = (KeyFunctionPair)o;
            return map.compute(ObjectUtils.convertTo(kClass, (Object)kf.key), (BiFunction)kf.function);
        }
    }
    ,
    MERGE{

        public Object apply(@NotNull MapView map, Object o) {
            Class kClass = map.keyType();
            Class vClass = map.valueType();
            KeyValueFunctionTuple kvf = (KeyValueFunctionTuple)o;
            return map.merge(ObjectUtils.convertTo(kClass, (Object)kvf.key), ObjectUtils.convertTo(vClass, (Object)kvf.value), (BiFunction)kvf.function);
        }
    }
    ,
    HASH_CODE{

        public Object apply(@NotNull MapView map, Object ignored) {
            return map.hashCode();
        }
    }
    ,
    EQUALS{

        public Object apply(@NotNull MapView map, Object o) {
            return map.equals(o);
        }
    };

}

