/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map.remote;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.SerializableBiFunction;
import net.openhft.chronicle.core.util.SerializableFunction;
import net.openhft.chronicle.core.util.SerializableUpdater;
import net.openhft.chronicle.core.util.SerializableUpdaterWithArg;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.engine.map.remote.KeyFunctionPair;
import net.openhft.chronicle.engine.map.remote.KeyValueFunctionTuple;
import net.openhft.chronicle.engine.map.remote.KeyValuePair;
import net.openhft.chronicle.engine.map.remote.KeyValuesTuple;
import net.openhft.chronicle.engine.map.remote.MapFunction;
import net.openhft.chronicle.engine.map.remote.MapUpdate;
import net.openhft.chronicle.engine.map.remote.RemoteKeyValueStore;
import net.openhft.chronicle.engine.query.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteMapView<K, MV, V>
extends VanillaMapView<K, V> {
    @NotNull
    private final RequestContext context;

    public RemoteMapView(@NotNull @net.openhft.chronicle.core.annotation.NotNull RequestContext context, @NotNull @net.openhft.chronicle.core.annotation.NotNull Asset asset, @NotNull @net.openhft.chronicle.core.annotation.NotNull KeyValueStore<K, V> kvStore) {
        super(context, asset, kvStore);
        this.context = context;
    }

    @Override
    public boolean containsValue(Object value) {
        return (Boolean)ObjectUtils.convertTo(Boolean.class, (Object)this.applyTo(MapFunction.CONTAINS_VALUE, (A)value));
    }

    @Override
    public void registerKeySubscriber(@NotNull @net.openhft.chronicle.core.annotation.NotNull Subscriber<K> subscriber, @NotNull @net.openhft.chronicle.core.annotation.NotNull Filter filter, @NotNull @net.openhft.chronicle.core.annotation.NotNull Set<RequestContext.Operation> contextOperations) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        RequestContext rc = RequestContext.requestContext().type(this.keyClass).type2(this.valueType);
        contextOperations.forEach((? super T e) -> e.apply(rc));
        subscription.registerKeySubscriber(rc, subscriber, filter);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.asyncUpdate(MapUpdate.REPLACE_ALL, (A)function);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Map && (Boolean)this.applyTo(MapFunction.EQUALS, (A)o) != false;
    }

    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public Reference<V> referenceFor(K key) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public int hashCode() {
        return (Integer)this.applyTo(MapFunction.HASH_CODE, (A)null);
    }

    @Override
    @Nullable
    public V putIfAbsent(@net.openhft.chronicle.core.annotation.NotNull K key, V value) {
        this.checkKey(key);
        this.checkValue(value);
        return (V)this.applyTo(MapFunction.PUT_IF_ABSENT, (A)KeyValuePair.of(key, value));
    }

    @Override
    public boolean remove(@net.openhft.chronicle.core.annotation.NotNull Object key, Object value) {
        this.checkKey(key);
        this.checkValue(value);
        return (Boolean)this.applyTo(MapFunction.REMOVE, (A)KeyValuePair.of(key, value));
    }

    @Override
    public boolean replace(@net.openhft.chronicle.core.annotation.NotNull K key, @net.openhft.chronicle.core.annotation.NotNull V oldValue, @net.openhft.chronicle.core.annotation.NotNull V newValue) {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        Object o = this.applyTo(MapFunction.REPLACE, (A)KeyValuesTuple.of(key, oldValue, newValue));
        return (Boolean)ObjectUtils.convertTo(Boolean.class, (Object)o);
    }

    @Override
    @Nullable
    public V replace(@net.openhft.chronicle.core.annotation.NotNull K key, @net.openhft.chronicle.core.annotation.NotNull V value) {
        this.checkKey(key);
        this.checkValue(value);
        return (V)this.applyTo(MapFunction.REPLACE, (A)KeyValuePair.of(key, value));
    }

    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public V computeIfAbsent(K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
        this.checkKey(key);
        return (V)this.applyTo(MapFunction.COMPUTE_IF_ABSENT, (A)KeyFunctionPair.of(key, mappingFunction));
    }

    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public V computeIfPresent(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        return (V)this.applyTo(MapFunction.COMPUTE_IF_PRESENT, (A)KeyFunctionPair.of(key, remappingFunction));
    }

    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public V compute(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        return (V)this.applyTo(MapFunction.COMPUTE, (A)KeyFunctionPair.of(key, remappingFunction));
    }

    @Override
    @NotNull
    @net.openhft.chronicle.core.annotation.NotNull
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.checkKey(key);
        this.checkValue(value);
        return (V)this.applyTo(MapFunction.MERGE, (A)KeyValueFunctionTuple.of(key, value, remappingFunction));
    }

    @Override
    @Nullable
    public <A, R> R applyTo(@net.openhft.chronicle.core.annotation.NotNull SerializableBiFunction<MapView<K, V>, A, R> function, A arg) {
        RemoteKeyValueStore store = (RemoteKeyValueStore)this.underlying();
        return store.applyTo(function, arg);
    }

    @Override
    public <A> void asyncUpdate(@net.openhft.chronicle.core.annotation.NotNull SerializableUpdaterWithArg<MapView<K, V>, A> updateFunction, A arg) {
        RemoteKeyValueStore store = (RemoteKeyValueStore)this.underlying();
        store.asyncUpdate(updateFunction, arg);
    }

    @Override
    @Nullable
    public <UA, RA, R> R syncUpdate(@net.openhft.chronicle.core.annotation.NotNull SerializableUpdaterWithArg<MapView<K, V>, UA> updateFunction, UA ua, @net.openhft.chronicle.core.annotation.NotNull SerializableBiFunction<MapView<K, V>, RA, R> returnFunction, RA ra) {
        RemoteKeyValueStore store = (RemoteKeyValueStore)this.underlying();
        return store.syncUpdate(updateFunction, ua, returnFunction, ra);
    }

    @Override
    @Nullable
    public <R> R applyTo(@net.openhft.chronicle.core.annotation.NotNull SerializableFunction<MapView<K, V>, R> function) {
        return this.applyTo((SerializableBiFunction<MapView<K, V>, A, R>)(SerializableBiFunction & Serializable)(x, $) -> function.apply(x), (A)null);
    }

    @Override
    public void asyncUpdate(@net.openhft.chronicle.core.annotation.NotNull SerializableUpdater<MapView<K, V>> updateFunction) {
        this.asyncUpdate((SerializableUpdaterWithArg<MapView<K, V>, A>)(SerializableUpdaterWithArg & Serializable)(x, $) -> updateFunction.accept(x), (A)null);
    }

    @Override
    @Nullable
    public <R> R syncUpdate(@net.openhft.chronicle.core.annotation.NotNull SerializableUpdater<MapView<K, V>> updateFunction, @net.openhft.chronicle.core.annotation.NotNull SerializableFunction<MapView<K, V>, R> returnFunction) {
        return this.syncUpdate((SerializableUpdaterWithArg<MapView<K, V>, UA>)(SerializableUpdaterWithArg & Serializable)(x, $) -> updateFunction.accept(x), (UA)null, (SerializableBiFunction<MapView<K, V>, RA, R>)(SerializableBiFunction & Serializable)(x, $) -> returnFunction.apply(x), (RA)null);
    }

    @Override
    @Nullable
    public <R> R applyToKey(K key, @net.openhft.chronicle.core.annotation.NotNull SerializableFunction<V, R> function) {
        this.checkKey(key);
        return this.applyTo((SerializableBiFunction<MapView<K, V>, A, R>)(SerializableBiFunction & Serializable)(x, k) -> function.apply(x.get(k)), (A)key);
    }

    @Override
    @Nullable
    public <T, R> R applyToKey(K key, @net.openhft.chronicle.core.annotation.NotNull SerializableBiFunction<V, T, R> function, T argument) {
        this.checkKey(key);
        return this.applyTo((SerializableBiFunction<MapView<K, V>, A, R>)(SerializableBiFunction & Serializable)(map, kv) -> function.apply(map.get(kv.key), kv.value), (A)KeyValuePair.of(key, argument));
    }

    @Override
    public void asyncUpdateKey(K key, @net.openhft.chronicle.core.annotation.NotNull SerializableFunction<V, V> updateFunction) {
        this.checkKey(key);
        SerializableBiFunction & Serializable kvvBiFunction = (SerializableBiFunction & Serializable)(k, v) -> updateFunction.apply(v);
        this.compute(key, (BiFunction<? super K, ? super V, ? extends V>)kvvBiFunction);
    }

    @Override
    public <T> void asyncUpdateKey(K key, @net.openhft.chronicle.core.annotation.NotNull SerializableBiFunction<V, T, V> updateFunction, T argument) {
        this.checkKey(key);
        SerializableBiFunction & Serializable kvvBiFunction = (SerializableBiFunction & Serializable)(k, v) -> updateFunction.apply(v, argument);
        this.compute(key, (BiFunction<? super K, ? super V, ? extends V>)kvvBiFunction);
    }

    @Override
    @Nullable
    public <R> R syncUpdateKey(K key, @net.openhft.chronicle.core.annotation.NotNull SerializableFunction<V, V> updateFunction, @net.openhft.chronicle.core.annotation.NotNull SerializableFunction<V, R> returnFunction) {
        this.checkKey(key);
        SerializableBiFunction & Serializable kvvBiFunction = (SerializableBiFunction & Serializable)(k, v) -> updateFunction.apply(v);
        return this.applyTo((SerializableBiFunction<MapView<K, V>, A, R>)(SerializableBiFunction & Serializable)(map, kvf) -> returnFunction.apply(map.compute(key, kvvBiFunction)), (A)key);
    }

    @Override
    @Nullable
    public <T, RT, R> R syncUpdateKey(K key, @net.openhft.chronicle.core.annotation.NotNull SerializableBiFunction<V, T, V> updateFunction, @Nullable T updateArgument, @net.openhft.chronicle.core.annotation.NotNull SerializableBiFunction<V, RT, R> returnFunction, @Nullable RT returnArgument) {
        this.checkKey(key);
        SerializableBiFunction & Serializable kvvBiFunction = (SerializableBiFunction & Serializable)(k, v) -> updateFunction.apply(v, updateArgument);
        return this.applyTo((SerializableBiFunction<MapView<K, V>, A, R>)(SerializableBiFunction & Serializable)(map, kvf) -> returnFunction.apply(map.compute(key, kvvBiFunction), returnArgument), (A)key);
    }
}

