/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.PublisherHandler;
import net.openhft.chronicle.engine.server.internal.TopicPublisherHandler;
import net.openhft.chronicle.network.connection.AbstractAsyncSubscription;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.AsyncSubscription;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteTopicPublisher<T, M>
extends AbstractStatelessClient<TopicPublisherHandler.EventId>
implements TopicPublisher<T, M> {
    final Class<T> topicClass;
    final Class<M> messageClass;

    public RemoteTopicPublisher(@NotNull RequestContext context, @NotNull Asset asset) throws AssetNotFoundException {
        super(asset.findView(TcpChannelHub.class), 0L, RemoteTopicPublisher.toUri(context, "topicPublisher"));
        this.topicClass = context.topicType();
        this.messageClass = context.messageType();
    }

    protected RemoteTopicPublisher(@NotNull RequestContext context, @NotNull Asset asset, String view) throws AssetNotFoundException {
        super(asset.findView(TcpChannelHub.class), 0L, RemoteTopicPublisher.toUri(context, view));
        this.topicClass = context.keyType();
        this.messageClass = context.valueType();
    }

    private static String toUri(@NotNull RequestContext context, String view) {
        StringBuilder uri = new StringBuilder(context.fullName() + "?view=" + view);
        if (context.keyType() != String.class) {
            uri.append("&keyType=").append(context.keyType().getName());
        }
        if (context.valueType() != String.class) {
            uri.append("&valueType=").append(context.valueType().getName());
        }
        if (context.dontPersist()) {
            uri.append("&dontPersist=").append(context.dontPersist());
        }
        return uri.toString();
    }

    @Override
    public void publish(@NotNull T topic, @NotNull M message) {
        this.checkTopic(topic);
        this.checkMessage(message);
        this.sendEventAsync((WireKey)TopicPublisherHandler.EventId.publish, valueOut -> valueOut.marshallable(m -> {
            m.write((WireKey)TopicPublisherHandler.Params.topic).object(topic);
            m.write((WireKey)TopicPublisherHandler.Params.message).object(message);
        }), true);
    }

    private void checkTopic(@Nullable Object topic) {
        if (topic == null) {
            throw new NullPointerException("topic can not be null");
        }
    }

    private void checkMessage(@Nullable Object message) {
        if (message == null) {
            throw new NullPointerException("message can not be null");
        }
    }

    @Override
    public void registerTopicSubscriber(final @NotNull TopicSubscriber<T, M> topicSubscriber) throws AssetNotFoundException {
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        this.hub.subscribe((AsyncSubscription)new AbstractAsyncSubscription(this.hub, this.csp, "Remote Topic publisher register subscribe"){

            public void onSubscribe(@NotNull WireOut wireOut) {
                wireOut.writeEventName((WireKey)PublisherHandler.EventId.registerSubscriber).text("");
            }

            public void onConsumer(@NotNull WireIn w) {
                w.readDocument(null, d -> {
                    StringBuilder eventname = Wires.acquireStringBuilder();
                    ValueIn valueIn = d.readEventName(eventname);
                    if (TopicPublisherHandler.EventId.onEndOfSubscription.contentEquals(eventname)) {
                        topicSubscriber.onEndOfSubscription();
                        RemoteTopicPublisher.this.hub.unsubscribe(this.tid());
                    } else if (CoreFields.reply.contentEquals((CharSequence)eventname)) {
                        valueIn.marshallable(m -> {
                            Object topic = m.read(() -> "topic").object(RemoteTopicPublisher.this.topicClass);
                            Object message = m.read(() -> "message").object(RemoteTopicPublisher.this.messageClass);
                            try {
                                RemoteTopicPublisher.this.onEvent(topic, message, topicSubscriber);
                            }
                            catch (InvalidSubscriberException e) {
                                throw Jvm.rethrow((Throwable)e);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public void unregisterTopicSubscriber(@NotNull TopicSubscriber<T, M> topicSubscriber) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    @NotNull
    public Publisher<M> publisher(@NotNull T topic) {
        throw new UnsupportedOperationException("tood");
    }

    @Override
    public void registerSubscriber(@NotNull T topic, @NotNull Subscriber<M> subscriber) {
    }

    private void onEvent(T topic, @Nullable M message, @NotNull TopicSubscriber<T, M> topicSubscriber) throws InvalidSubscriberException {
        if (message != null) {
            topicSubscriber.onMessage(topic, message);
        }
    }
}

