/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.SerializableFunction;
import net.openhft.chronicle.core.util.SerializablePredicate;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.query.Query;
import net.openhft.chronicle.engine.query.Operation;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class Filter<E>
implements Marshallable,
Iterable<Operation> {
    static final Filter EMPTY = new Filter(){

        @Override
        protected void add(Operation operation) {
            throw new UnsupportedOperationException("Must be empty");
        }
    };
    @NotNull
    private List<Operation> pipeline = new ArrayList<Operation>();

    @NotNull
    public static <N> Filter<N> empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.pipeline == null || this.pipeline.isEmpty();
    }

    public void readMarshallable(@NotNull WireIn wireIn) throws IllegalStateException {
        this.clearPipeline();
        wireIn.read(() -> "pipeline").sequence(this.pipeline, (p, s) -> {
            while (s.hasNextSequenceItem()) {
                p.add(s.object(Operation.class));
            }
        });
    }

    private void clearPipeline() {
        if (this.pipeline == null) {
            this.pipeline = new ArrayList<Operation>();
        } else {
            this.pipeline.clear();
        }
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "pipeline").sequence(w -> this.pipeline.forEach(arg_0 -> ((ValueOut)w).object(arg_0)));
    }

    @Override
    @NotNull
    public Iterator<Operation> iterator() {
        return this.pipeline.iterator();
    }

    protected void add(Operation operation) {
        this.pipeline.add(operation);
    }

    void add(SerializablePredicate<? super E> predicate, Operation.OperationType filter) {
        this.add(new Operation(filter, predicate));
    }

    void add(SerializableFunction<? super E, ?> mapper, Operation.OperationType map) {
        this.add(new Operation(map, mapper));
    }

    <R> void add(Class<R> rClass, Operation.OperationType project) {
        this.add(new Operation(project, rClass));
    }

    @NotNull
    public String toString() {
        return "Filter{pipeline=" + this.pipeline + '}';
    }

    public void addFilter(SerializablePredicate<? super E> predicate) {
        this.add(new Operation(Operation.OperationType.FILTER, predicate));
    }

    public <R> void addMap(SerializableFunction<? super E, ? extends R> mapper) {
        this.add(new Operation(Operation.OperationType.MAP, mapper));
    }

    public void addProject(Class rClass) {
        this.add(new Operation(Operation.OperationType.PROJECT, rClass));
    }

    public <R> void addFlatMap(SerializableFunction<? super E, ? extends Query<? extends R>> mapper) {
        this.add(new Operation(Operation.OperationType.FLAT_MAP, mapper));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter filter = (Filter)o;
        return !(this.pipeline == null ? filter.pipeline != null : !this.pipeline.equals(filter.pipeline));
    }

    public int hashCode() {
        return this.pipeline != null ? this.pipeline.hashCode() : 0;
    }

    public int pipelineSize() {
        return this.pipeline == null ? 0 : this.pipeline.size();
    }

    public Operation getPipeline(int index) {
        return this.pipeline.get(index);
    }

    public static class FilteredSubscriber<E>
    implements Subscriber<E> {
        @NotNull
        private final Subscriber<E> subscriber;
        @NotNull
        private final Filter<E> filter;

        public FilteredSubscriber(@NotNull Filter<E> filter, @NotNull Subscriber<E> subscriber) {
            this.filter = filter;
            this.subscriber = subscriber;
        }

        @Override
        public void onMessage(@NotNull E message) throws InvalidSubscriberException {
            for (Operation o : this.filter) {
                switch (o.op()) {
                    case FILTER: {
                        Predicate serializable = (Predicate)o.wrapped();
                        if (serializable.test(message)) break;
                        return;
                    }
                    case MAP: {
                        Function function = (Function)o.wrapped();
                        message = function.apply(message);
                        break;
                    }
                    case FLAT_MAP: {
                        Function func = (Function)o.wrapped();
                        ((Stream)func.apply(message)).forEach(e -> {
                            try {
                                this.onMessage(e);
                            }
                            catch (InvalidSubscriberException ise) {
                                throw Jvm.rethrow((Throwable)ise);
                            }
                        });
                        break;
                    }
                    case PROJECT: {
                        throw new UnsupportedOperationException("todo");
                    }
                }
            }
            this.subscriber.onMessage(message);
        }

        @Override
        public void onEndOfSubscription() {
            this.subscriber.onEndOfSubscription();
        }
    }
}

