/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.queue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.engine.api.column.ChronicleQueueRow;
import net.openhft.chronicle.engine.api.column.ClosableIterator;
import net.openhft.chronicle.engine.api.column.Column;
import net.openhft.chronicle.engine.api.column.ColumnViewInternal;
import net.openhft.chronicle.engine.api.column.QueueColumnView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueWrappingColumnView<K, V>
implements QueueColumnView {
    private final Asset asset;
    @NotNull
    private final QueueView<String, V> queueView;
    @Nullable
    private ArrayList<String> columnNames = null;
    private final Class<?> messageClass;
    @NotNull
    Map<List<ColumnViewInternal.MarshableFilter>, NavigableMap<Long, ChronicleQueueRow>> indexCache = new ConcurrentHashMap<List<ColumnViewInternal.MarshableFilter>, NavigableMap<Long, ChronicleQueueRow>>();

    public QueueWrappingColumnView(RequestContext requestContext, Asset asset, @NotNull QueueView<String, V> queueView) {
        this.asset = asset;
        this.queueView = queueView;
        QueueView.Excerpt<String, V> excerpt = queueView.getExcerpt((String)0L);
        this.messageClass = excerpt != null ? excerpt.message().getClass() : Object.class;
    }

    @Override
    public void registerChangeListener(@NotNull Runnable r) {
        this.queueView.registerSubscriber("", o -> r.run());
    }

    private ClosableIterator<ChronicleQueueRow> iteratorWithCountFromEnd(@NotNull List<ColumnViewInternal.MarshableFilter> filters, long countFromEnd) {
        long index = this.toIndexFromEnd(countFromEnd);
        return this.toIterator(filters, index);
    }

    @NotNull
    public ClosableIterator<ChronicleQueueRow> iterator(@NotNull ColumnViewInternal.SortedFilter filters) {
        long countFromEnd = filters.countFromEnd;
        if (countFromEnd > 0L) {
            return this.iteratorWithCountFromEnd(filters.marshableFilters, countFromEnd);
        }
        return this.iterator(filters.marshableFilters, filters.fromIndex);
    }

    @NotNull
    private ClosableIterator<ChronicleQueueRow> iterator(@NotNull List<ColumnViewInternal.MarshableFilter> filters, long fromSequenceNumber) {
        long index0;
        long count = 0L;
        NavigableMap map = this.indexCache.computeIfAbsent(filters, k -> new ConcurrentSkipListMap());
        Map.Entry longChronicleQueueRowEntry = map.floorEntry(fromSequenceNumber);
        if (longChronicleQueueRowEntry != null) {
            ChronicleQueueRow value = (ChronicleQueueRow)((Object)longChronicleQueueRowEntry.getValue());
            count = value.seqNumber();
            index0 = ((ChronicleQueueRow)((Object)longChronicleQueueRowEntry.getValue())).index();
        } else {
            index0 = 0L;
        }
        ClosableIterator<ChronicleQueueRow> result = this.toIterator(filters, index0);
        ChronicleQueueRow r = null;
        while (count < fromSequenceNumber && result.hasNext()) {
            r = (ChronicleQueueRow)((Object)result.next());
            r.seqNumber(++count);
            if (r.seqNumber() % 1024L != 0L) continue;
            map.put(count, r);
        }
        if (longChronicleQueueRowEntry == null && r != null) {
            map.put(r.seqNumber(), r);
        }
        return result;
    }

    @NotNull
    private ClosableIterator<ChronicleQueueRow> toIterator(@NotNull List<ColumnViewInternal.MarshableFilter> filters, final long index) {
        Iterator i = new Iterator<QueueView.Excerpt<String, V>>(){
            @Nullable
            QueueView.Excerpt<String, V> next;
            {
                this.next = QueueWrappingColumnView.this.queueView.getExcerpt(index);
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = QueueWrappingColumnView.this.queueView.getExcerpt("");
                }
                return this.next != null;
            }

            @Override
            @Nullable
            public QueueView.Excerpt<String, V> next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                try {
                    QueueView.Excerpt excerpt = this.next;
                    return excerpt;
                }
                finally {
                    this.next = null;
                }
            }
        };
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(i, 21);
        final Iterator core = StreamSupport.stream(spliterator, false).filter(this.filter(filters)).iterator();
        return new ClosableIterator<ChronicleQueueRow>(){

            public void close() {
            }

            @Override
            public boolean hasNext() {
                return core.hasNext();
            }

            @Override
            @NotNull
            public ChronicleQueueRow next() {
                QueueView.Excerpt e = (QueueView.Excerpt)core.next();
                ChronicleQueueRow row = new ChronicleQueueRow(QueueWrappingColumnView.this.columns());
                Object value = e.message();
                row.set("index", Long.toHexString(e.index()));
                row.index(e.index());
                for (FieldInfo info : Wires.fieldInfos(value.getClass())) {
                    if (!QueueWrappingColumnView.this.columnNames().contains(info.name())) continue;
                    try {
                        Object newValue = info.get(value);
                        row.set(info.name(), newValue);
                    }
                    catch (Exception e1) {
                        Jvm.warn().on(VanillaMapView.class, (Throwable)e1);
                    }
                }
                return row;
            }
        };
    }

    private long toIndexFromEnd(long countFromEnd) {
        long fromSequenceNumber = -1L;
        if (countFromEnd > 0L) {
            SingleChronicleQueue chronicleQueue = (SingleChronicleQueue)this.queueView.underlying();
            ExcerptTailer excerptTailer = chronicleQueue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            fromSequenceNumber = excerptTailer.index();
            if (fromSequenceNumber == 0L) {
                return 0L;
            }
            int i = 0;
            while ((long)i < countFromEnd) {
                try (DocumentContext documentContext = excerptTailer.readingDocument();){
                    if (!documentContext.isPresent()) break;
                    fromSequenceNumber = documentContext.index();
                }
                ++i;
            }
        }
        return fromSequenceNumber;
    }

    @Override
    public boolean containsRowWithKey(@NotNull List keys) {
        if (keys.size() == 1 && keys.get(0) instanceof String) {
            long l = Long.parseLong(keys.get(0).toString(), 16);
            return this.queueView.getExcerpt((String)l) != null;
        }
        throw new IllegalStateException("unsupported format, keys=" + keys);
    }

    @Override
    @Nullable
    public ObjectSubscription objectSubscription() {
        return this.queueView.asset().getView(ObjectSubscription.class);
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    @NotNull
    public List<Column> columns() {
        ArrayList<Column> result = new ArrayList<Column>();
        result.add(new Column("index", true, true, "", String.class, false));
        for (FieldInfo fi : Wires.fieldInfos(this.messageClass)) {
            result.add(new Column(fi.name(), false, false, "", fi.type(), false));
        }
        return result;
    }

    @Nullable
    private List<String> columnNames() {
        if (this.columnNames != null) {
            return this.columnNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add("index");
        for (FieldInfo fi : Wires.fieldInfos(this.messageClass)) {
            result.add(fi.name());
        }
        this.columnNames = new ArrayList(result);
        return this.columnNames;
    }

    @Override
    public boolean canDeleteRows() {
        return false;
    }

    @Override
    public int changedRow(@NotNull Map<String, Object> row, @NotNull Map<String, Object> oldRow) {
        return 0;
    }

    @Nullable
    public Predicate<QueueView.Excerpt<String, V>> filter(@Nullable List<ColumnViewInternal.MarshableFilter> filters) {
        Predicate<Number> predicate = this.predicate(filters);
        return excerpt -> {
            if (filters == null || filters.isEmpty()) {
                return true;
            }
            try {
                for (ColumnViewInternal.MarshableFilter f : filters) {
                    Object item;
                    Class<?> messageClass = excerpt.message().getClass();
                    if (Marshallable.class.isAssignableFrom(messageClass)) {
                        try {
                            Object message = excerpt.message();
                            FieldInfo info = Wires.fieldInfo(message.getClass(), (String)f.columnName);
                            Object o = info.get(message);
                            if (o == null) {
                                return false;
                            }
                            if (o instanceof Number) {
                                if (predicate.test((Number)o)) continue;
                                return false;
                            }
                            item = o;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    if (!(item instanceof CharSequence ? !item.toString().toLowerCase().contains(f.filter.toLowerCase()) : (item instanceof Number ? !predicate.test((Number)item) : !item.equals(ObjectUtils.convertTo(item.getClass(), (Object)f.filter.trim()))))) continue;
                    return false;
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
    }

    @Override
    public int rowCount(@NotNull ColumnViewInternal.SortedFilter filters) {
        ClosableIterator<ChronicleQueueRow> iterator;
        long fromSequenceNumber = filters.fromIndex;
        long countFromEnd = filters.countFromEnd;
        assert (countFromEnd != 0L && fromSequenceNumber == 0L);
        if (countFromEnd > 0L) {
            int count0 = 0;
            ClosableIterator<ChronicleQueueRow> iterator2 = this.iterator(filters);
            while (iterator2.hasNext()) {
                iterator2.next();
                ++count0;
            }
            return count0;
        }
        NavigableMap map = this.indexCache.computeIfAbsent(filters.marshableFilters, k -> new ConcurrentSkipListMap());
        long count = 0L;
        if (map != null) {
            Map.Entry last = map.lastEntry();
            if (last == null) {
                iterator = this.iterator(filters);
            } else {
                ChronicleQueueRow value = (ChronicleQueueRow)((Object)last.getValue());
                count = value.seqNumber();
                filters.fromIndex = ((ChronicleQueueRow)((Object)last.getValue())).index();
                iterator = this.iterator(filters);
            }
        } else {
            iterator = this.iterator(filters);
        }
        boolean hasMoreData = false;
        ChronicleQueueRow row = null;
        while (iterator.hasNext()) {
            row = (ChronicleQueueRow)((Object)iterator.next());
            row.seqNumber(++count);
            hasMoreData = true;
            if (row.seqNumber() % 1024L != 0L) continue;
            map.put(count, row);
        }
        if (hasMoreData) {
            map.put(count, row);
        }
        return (int)count;
    }
}

