/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.server.internal.EngineWireHandler;
import net.openhft.chronicle.engine.server.internal.EngineWireNetworkContext;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.HeaderTcpHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.WireTypeSniffingTcpHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.VanillaWireOutPublisher;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEndpoint
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ServerEndpoint.class);
    @Nullable
    private final EventLoop eg;
    @NotNull
    private final AtomicBoolean isClosed = new AtomicBoolean();
    @Nullable
    private AcceptorEventHandler eah;

    public ServerEndpoint(@NotNull String hostPortDescription, @NotNull AssetTree assetTree, @NotNull NetworkStatsListener networkStatsListener) throws IOException {
        this.eg = assetTree.root().acquireView(EventLoop.class);
        Threads.withThreadGroup((ThreadGroup)assetTree.root().getView(ThreadGroup.class), () -> {
            this.start(hostPortDescription, assetTree, networkStatsListener);
            return null;
        });
        assetTree.root().addView(ServerEndpoint.class, this);
    }

    public ServerEndpoint(@NotNull String hostPortDescription, @NotNull AssetTree assetTree) throws IOException {
        this(hostPortDescription, assetTree, new NetworkStatsListener(){
            private String host;
            private long port;

            public void close() {
                LOG.info(" host=" + this.host + ", port=" + this.port + ", isConnected=false");
            }

            public void networkContext(NetworkContext networkContext) {
            }

            public void onNetworkStats(long writeBps, long readBps, long socketPollCountPerSecond) {
                LOG.info("writeKBps=" + writeBps / 1000L + ", readKBps=" + readBps / 1000L + ", socketPollCountPerSecond=" + socketPollCountPerSecond / 1000L + "K, host=" + this.host + ", port=" + this.port + ", isConnected=true");
            }

            public void onHostPort(String hostName, int port) {
                this.host = hostName;
                this.port = port;
            }

            public void onRoundTripLatency(long nanosecondLatency) {
            }
        });
    }

    @Nullable
    private AcceptorEventHandler start(@NotNull String hostPortDescription, @NotNull AssetTree assetTree, @NotNull NetworkStatsListener networkStatsListener) throws IOException {
        assert (this.eg != null);
        this.eg.start();
        if (LOG.isInfoEnabled()) {
            LOG.info("starting server=" + hostPortDescription);
        }
        EventLoop eventLoop = assetTree.root().findOrCreateView(EventLoop.class);
        assert (eventLoop != null);
        Function<NetworkContext, TcpEventHandler> networkContextTcpEventHandlerFunction = networkContext -> {
            EngineWireNetworkContext nc = (EngineWireNetworkContext)((Object)networkContext);
            if (nc.isAcceptor()) {
                nc.wireOutPublisher((WireOutPublisher)new VanillaWireOutPublisher(WireType.TEXT));
            }
            TcpEventHandler handler = new TcpEventHandler(networkContext);
            Function<Object, TcpHandler> consumer = o -> {
                if (o instanceof SessionDetailsProvider) {
                    SessionDetailsProvider sessionDetails = (SessionDetailsProvider)o;
                    nc.sessionDetails(sessionDetails);
                    nc.wireType(sessionDetails.wireType());
                    WireType wireType = nc.sessionDetails().wireType();
                    if (wireType != null) {
                        nc.wireOutPublisher().wireType(wireType);
                    }
                    return new EngineWireHandler();
                }
                if (o instanceof TcpHandler) {
                    return (TcpHandler)o;
                }
                throw new UnsupportedOperationException("not supported class=" + o.getClass());
            };
            Function<EngineWireNetworkContext, TcpHandler> f = x -> new HeaderTcpHandler(handler, consumer, (NetworkContext)x);
            WireTypeSniffingTcpHandler sniffer = new WireTypeSniffingTcpHandler(handler, f);
            handler.tcpHandler((TcpHandler)sniffer);
            return handler;
        };
        AcceptorEventHandler eah = new AcceptorEventHandler(hostPortDescription, networkContextTcpEventHandlerFunction, () -> this.createNetworkContext(assetTree, networkStatsListener));
        this.eg.addHandler((EventHandler)eah);
        this.eah = eah;
        return eah;
    }

    @NotNull
    private EngineWireNetworkContext createNetworkContext(@NotNull AssetTree assetTree, @NotNull NetworkStatsListener networkStatsListener) {
        EngineWireNetworkContext nc = new EngineWireNetworkContext(assetTree.root());
        nc.networkStatsListener(networkStatsListener);
        networkStatsListener.networkContext(nc);
        return nc;
    }

    public void close() {
        this.isClosed.set(true);
        Closeable.closeQuietly((Object)this.eah);
        this.eah = null;
    }
}

