/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandler.class);
    @Nullable
    WireOut outWire = null;
    volatile boolean connectionClosed = false;
    RequestContext requestContext;
    long readPosAfterValueIn = -1L;
    private boolean hasSkipped;

    AbstractHandler() {
    }

    boolean startEnforceInValueReadCheck(WireIn w) {
        assert (this.readPosAfterValueIn == -1L);
        this.readPosAfterValueIn = w.bytes().readPosition();
        this.hasSkipped = false;
        return true;
    }

    void skipValue(ValueIn valueIn) {
        if (!$assertionsDisabled) {
            this.hasSkipped = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        valueIn.skipValue();
    }

    boolean endEnforceInValueReadCheck(WireIn w) {
        try {
            assert (this.readPosAfterValueIn != -1L);
            if (this.hasSkipped) {
                boolean bl = true;
                return bl;
            }
            boolean bl = w.bytes().readPosition() > this.readPosAfterValueIn;
            return bl;
        }
        finally {
            this.readPosAfterValueIn = -1L;
        }
    }

    static void nullCheck(@Nullable Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    void setOutWire(@NotNull WireOut outWire) {
        this.outWire = outWire;
    }

    void writeData(@NotNull WireIn wireIn, @NotNull WriteMarshallable c) {
        Bytes inBytes = wireIn.bytes();
        this.outWire.writeDocument(false, out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable(this.outWire);
            }
            catch (Throwable t) {
                String readingYaml = wireIn.readingPeekYaml();
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While readingBytes=" + inBytes.toDebugString() + "\nreadingYaml=" + readingYaml, (Object)("\nprocessing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "readingYaml").text(readingYaml);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        });
        this.logYaml();
    }

    void writeData(boolean isNotComplete, @NotNull Bytes inBytes, @NotNull WriteMarshallable c) {
        WriteMarshallable marshallable = out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable(this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        };
        if (isNotComplete) {
            this.outWire.writeNotCompleteDocument(false, marshallable);
        } else {
            this.outWire.writeDocument(false, marshallable);
        }
        this.logYaml();
    }

    void logYaml() {
        block7: {
            if (YamlLogging.showServerWrites()) {
                try {
                    assert (this.outWire.startUse());
                    LOG.info("\nServer Sends:\n" + Wires.fromSizePrefixedBlobs((WireIn)((Wire)this.outWire)));
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), "\nServer Sends ( corrupted ) :\n" + this.outWire.bytes().toDebugString());
                }
                finally {
                    if ($assertionsDisabled || this.outWire.endUse()) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    void onEndOfConnection() {
        this.connectionClosed = true;
        this.unregisterAll();
    }

    protected void unregisterAll() {
    }

    @NotNull
    WireOutPublisher publisher(@NotNull WireOutPublisher publisher) {
        return this.requestContext.throttlePeriodMs() == 0 ? publisher : WireOutPublisher.newThrottledWireOutPublisher((int)this.requestContext.throttlePeriodMs(), (WireOutPublisher)publisher);
    }
}

