/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenericWireAdapter<K, V>
implements WireAdapter<K, V> {
    private final BiConsumer<ValueOut, K> keyToWire = ValueOut::object;
    @Nullable
    private final Function<ValueIn, K> wireToKey;
    private final BiConsumer<ValueOut, V> valueToWire = ValueOut::object;
    @NotNull
    private final Function<ValueIn, V> wireToValue;
    @NotNull
    private final Function<ValueIn, Map.Entry<K, V>> wireToEntry;
    private final BiConsumer<ValueOut, Map.Entry<K, V>> entryToWire = (v, e) -> v.marshallable(w -> w.write(() -> "key").object(e.getKey()).write(() -> "value").object(e.getValue()));
    private final ThreadLocal<CharSequence> usingKey = ThreadLocal.withInitial(StringBuilder::new);
    private final ThreadLocal<CharSequence> usingValue = ThreadLocal.withInitial(StringBuilder::new);
    @NotNull
    private final Class<K> kClass;
    @NotNull
    private final Class<V> vClass;

    GenericWireAdapter(@NotNull Class<K> kClass, @NotNull Class<V> vClass) {
        this.kClass = kClass;
        this.vClass = vClass;
        this.wireToKey = valueIn -> valueIn.object(kClass);
        this.wireToValue = in -> in.object(vClass);
        this.wireToEntry = valueIn -> valueIn.applyToMarshallable(x -> {
            final Object key = kClass == CharSequence.class ? x.read(() -> "key").object((Object)this.usingKey.get(), CharSequence.class) : x.read(() -> "key").object(kClass);
            final Object value = vClass == CharSequence.class ? x.read(() -> "value").object((Object)this.usingValue.get(), CharSequence.class) : x.read(() -> "value").object(vClass);
            return new Map.Entry<K, V>(){

                @Override
                @Nullable
                public K getKey() {
                    return key;
                }

                @Override
                @Nullable
                public V getValue() {
                    return value;
                }

                @Override
                @NotNull
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }
            };
        });
    }

    @Override
    @NotNull
    public BiConsumer<ValueOut, K> keyToWire() {
        return this.keyToWire;
    }

    @Override
    @NotNull
    public Function<ValueIn, K> wireToKey() {
        return this.wireToKey;
    }

    @Override
    @NotNull
    public BiConsumer<ValueOut, V> valueToWire() {
        return this.valueToWire;
    }

    @Override
    @NotNull
    public Function<ValueIn, V> wireToValue() {
        return this.wireToValue;
    }

    @Override
    @NotNull
    public BiConsumer<ValueOut, Map.Entry<K, V>> entryToWire() {
        return this.entryToWire;
    }

    @Override
    @NotNull
    public Function<ValueIn, Map.Entry<K, V>> wireToEntry() {
        return this.wireToEntry;
    }

    @NotNull
    public String toString() {
        return "GenericWireAdapter{kClass=" + this.kClass + ", vClass=" + this.vClass + '}';
    }
}

