/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.TopicPublisherHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueueHandler<T, M>
extends TopicPublisherHandler<T, M> {
    private final StringBuilder eventName = new StringBuilder();
    private WireOutPublisher publisher;
    private TopicPublisher<T, M> view;
    @Nullable
    private Function<ValueIn, T> wireToT;
    @Nullable
    private Function<ValueIn, M> wireToM;
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull WireIn inWire, final Long inputTid) {
            assert (QueueHandler.this.wireToT != null);
            assert (QueueHandler.this.wireToM != null);
            QueueHandler.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(QueueHandler.this.eventName);
            assert (QueueHandler.this.startEnforceInValueReadCheck(inWire));
            try {
                if (TopicPublisherHandler.EventId.registerTopicSubscriber.contentEquals(QueueHandler.this.eventName)) {
                    TopicSubscriber listener = new TopicSubscriber(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onMessage(Object topic, Object message) {
                            WireOutPublisher wireOutPublisher = QueueHandler.this.publisher;
                            synchronized (wireOutPublisher) {
                                QueueHandler.this.publisher.put(topic, publish -> {
                                    publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                                    publish.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> {
                                        m.write(() -> "topic").object(topic);
                                        m.write(() -> "message").object(message);
                                    }));
                                });
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onEndOfSubscription() {
                            WireOutPublisher wireOutPublisher = QueueHandler.this.publisher;
                            synchronized (wireOutPublisher) {
                                QueueHandler.this.publisher.put(null, publish -> {
                                    publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                                    publish.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)EventId.onEndOfSubscription).text(""));
                                });
                            }
                        }
                    };
                    valueIn.marshallable(m -> QueueHandler.this.view.registerTopicSubscriber(listener));
                    return;
                }
                if (TopicPublisherHandler.EventId.publish.contentEquals(QueueHandler.this.eventName)) {
                    valueIn.marshallable(wire -> {
                        Params[] params = (Params[])TopicPublisherHandler.EventId.publish.params();
                        Object topic = QueueHandler.this.wireToT.apply(wire.read((WireKey)params[0]));
                        Object message = QueueHandler.this.wireToM.apply(wire.read((WireKey)params[1]));
                        AbstractHandler.nullCheck(topic);
                        AbstractHandler.nullCheck(message);
                        QueueHandler.this.view.publish(topic, message);
                    });
                }
            }
            finally {
                assert (QueueHandler.this.endEnforceInValueReadCheck(inWire));
            }
        }
    };

    @Override
    void process(@NotNull WireIn inWire, WireOutPublisher publisher, long tid, @NotNull Wire outWire, TopicPublisher view, @NotNull WireAdapter wireAdapter) {
        this.setOutWire((WireOut)outWire);
        this.view = view;
        this.publisher = publisher;
        this.wireToT = wireAdapter.wireToKey();
        this.wireToM = wireAdapter.wireToValue();
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        publish((WireKey[])new TopicPublisherHandler.Params[]{TopicPublisherHandler.Params.topic, TopicPublisherHandler.Params.message}),
        onEndOfSubscription(new WireKey[0]),
        registerTopicSubscriber((WireKey[])new TopicPublisherHandler.Params[]{TopicPublisherHandler.Params.topic, TopicPublisherHandler.Params.message}),
        replay(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        topic,
        message;

    }
}

