/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopicPublisherHandler<T, M>
extends AbstractHandler {
    private final StringBuilder eventName = new StringBuilder();
    private WireOutPublisher publisher;
    private TopicPublisher<T, M> view;
    @Nullable
    private Function<ValueIn, T> wireToT;
    @Nullable
    private Function<ValueIn, M> wireToM;
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull WireIn inWire, final Long inputTid) {
            assert (TopicPublisherHandler.this.wireToT != null);
            assert (TopicPublisherHandler.this.wireToM != null);
            TopicPublisherHandler.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(TopicPublisherHandler.this.eventName);
            try {
                assert (TopicPublisherHandler.this.startEnforceInValueReadCheck(inWire));
                if (EventId.registerTopicSubscriber.contentEquals(TopicPublisherHandler.this.eventName)) {
                    TopicSubscriber listener = new TopicSubscriber(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onMessage(Object topic, Object message) {
                            WireOutPublisher wireOutPublisher = TopicPublisherHandler.this.publisher;
                            synchronized (wireOutPublisher) {
                                TopicPublisherHandler.this.publisher.put(topic, publish -> {
                                    publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                                    publish.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> {
                                        m.write(() -> "topic").object(topic);
                                        m.write(() -> "message").object(message);
                                    }));
                                });
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onEndOfSubscription() {
                            WireOutPublisher wireOutPublisher = TopicPublisherHandler.this.publisher;
                            synchronized (wireOutPublisher) {
                                TopicPublisherHandler.this.publisher.put(null, publish -> {
                                    publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                                    publish.writeNotCompleteDocument(false, wire -> wire.writeEventName((WireKey)EventId.onEndOfSubscription).text(""));
                                });
                            }
                        }
                    };
                    valueIn.marshallable(m -> TopicPublisherHandler.this.view.registerTopicSubscriber(listener));
                    return;
                }
                if (EventId.publish.contentEquals(TopicPublisherHandler.this.eventName)) {
                    valueIn.marshallable(wire -> {
                        Params[] params = (Params[])EventId.publish.params();
                        Object topic = TopicPublisherHandler.this.wireToT.apply(wire.read((WireKey)params[0]));
                        Object message = TopicPublisherHandler.this.wireToM.apply(wire.read((WireKey)params[1]));
                        AbstractHandler.nullCheck(topic);
                        AbstractHandler.nullCheck(message);
                        TopicPublisherHandler.this.view.publish(topic, message);
                    });
                    return;
                }
                TopicPublisherHandler.this.outWire.writeDocument(true, wire -> TopicPublisherHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                TopicPublisherHandler.this.writeData(inWire, out -> {
                    if (EventId.getNextAtIndex.contentEquals(TopicPublisherHandler.this.eventName)) {
                        out.writeEventName((WireKey)CoreFields.reply).object(((QueueView)TopicPublisherHandler.this.view).getExcerpt(valueIn.int64()));
                        return;
                    }
                    if (EventId.getNextAtTopic.contentEquals(TopicPublisherHandler.this.eventName)) {
                        out.writeEventName((WireKey)CoreFields.reply).object(((QueueView)TopicPublisherHandler.this.view).getExcerpt(valueIn.object()));
                        return;
                    }
                    if (EventId.publishAndIndex.contentEquals(TopicPublisherHandler.this.eventName)) {
                        long index = (Long)valueIn.applyToMarshallable(wire -> {
                            Params[] params = (Params[])EventId.publish.params();
                            Object topic = TopicPublisherHandler.this.wireToT.apply(wire.read((WireKey)params[0]));
                            Object message = TopicPublisherHandler.this.wireToM.apply(wire.read((WireKey)params[1]));
                            AbstractHandler.nullCheck(topic);
                            AbstractHandler.nullCheck(message);
                            return ((QueueView)TopicPublisherHandler.this.view).publishAndIndex(topic, message);
                        });
                        out.writeEventName((WireKey)CoreFields.reply).int64(index);
                        return;
                    }
                });
            }
            finally {
                assert (TopicPublisherHandler.this.endEnforceInValueReadCheck(inWire));
            }
        }
    };

    void process(@NotNull WireIn inWire, WireOutPublisher publisher, long tid, @NotNull Wire outWire, TopicPublisher view, @NotNull WireAdapter wireAdapter) {
        this.setOutWire((WireOut)outWire);
        this.view = view;
        this.publisher = publisher;
        this.wireToT = wireAdapter.wireToKey();
        this.wireToM = wireAdapter.wireToValue();
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        publish((WireKey[])new Params[]{Params.topic, Params.message}),
        onEndOfSubscription(new WireKey[0]),
        registerTopicSubscriber((WireKey[])new Params[]{Params.topic, Params.message}),
        replay(new WireKey[0]),
        getNextAtIndex((WireKey[])new Params[]{Params.index}),
        getNextAtTopic((WireKey[])new Params[]{Params.topic}),
        next(new WireKey[0]),
        publishAndIndex((WireKey[])new Params[]{Params.topic, Params.message});

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        topic,
        message,
        index;

    }
}

