/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.SubscriptionHandler;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopologySubscriptionHandler
extends SubscriptionHandler<TopologySubscription> {
    @Nullable
    private final BiConsumer<WireIn, Long> dataConsumer = (inWire, inputTid) -> {
        this.eventName.setLength(0);
        ValueIn valueIn = inWire.readEventName(this.eventName);
        assert (this.startEnforceInValueReadCheck((WireIn)inWire));
        try {
            if (this.before((Long)inputTid, valueIn)) {
                return;
            }
        }
        catch (AssetNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            assert (this.endEnforceInValueReadCheck((WireIn)inWire));
        }
        this.outWire.writeDocument(true, wire -> this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
        this.writeData((WireIn)inWire, out -> {
            if (this.after(this.eventName)) {
                return;
            }
            if (EventId.notifyEvent.contentEquals(this.eventName)) {
                ((TopologySubscription)this.subscription).notifyEvent((TopologicalEvent)valueIn.typedMarshallable());
                this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)((TopologySubscription)this.subscription).entrySubscriberCount());
            }
        });
    };

    void process(@NotNull WireIn inWire, @NotNull RequestContext requestContext, @NotNull WireOutPublisher publisher, @NotNull Asset asset, long tid, @NotNull Wire outWire, @NotNull TopologySubscription subscription) {
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.subscription = subscription;
        this.requestContext = requestContext;
        this.publisher = publisher;
        this.asset = asset;
        assert (this.dataConsumer != null);
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        notifyEvent(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }
}

