/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Arrays;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.constraints.NotNull;

class AddressAndPort
implements Comparable<AddressAndPort>,
BytesMarshallable {
    private byte[] address;
    private short port;

    AddressAndPort(byte[] address, short port) {
        this.address = address;
        this.port = port;
    }

    public AddressAndPort() {
    }

    public byte[] getAddress() {
        return this.address;
    }

    public short getPort() {
        return this.port;
    }

    public byte[] address() {
        return this.address;
    }

    public short port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressAndPort that = (AddressAndPort)o;
        if (this.port != that.port) {
            return false;
        }
        return Arrays.equals(this.address, that.address);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.address);
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public int compareTo(AddressAndPort o) {
        int i = 0;
        for (byte b : this.address) {
            int compare;
            if ((compare = Byte.compare(b, o.address[i++])) == 0) continue;
            return compare;
        }
        return Short.compare(this.port, o.port);
    }

    public String toString() {
        return "AddressAndPort{address=" + AddressAndPort.numericToTextFormat(this.address) + ", port=" + this.port + '}';
    }

    static String numericToTextFormat(byte[] src) {
        if (src.length == 4) {
            return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
        }
        throw new UnsupportedOperationException();
    }

    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        int len = in.readShort();
        this.address = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.address[i] = in.readByte();
        }
        this.port = in.readShort();
    }

    public void writeMarshallable(@NotNull Bytes out) {
        out.writeShort(this.getAddress().length);
        for (byte address : this.getAddress()) {
            out.write((int)address);
        }
        out.writeShort((int)this.port);
    }
}

