/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.map.AddressAndPort;
import net.openhft.chronicle.map.ConcurrentExpiryMap;
import net.openhft.chronicle.map.KnownNodes;
import net.openhft.chronicle.map.NodeDiscoveryBroadcaster;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.UDPEventListener;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.constraints.NotNull;

class DiscoveryNodeBytesMarshallable
implements BytesMarshallable {
    private final KnownNodes remoteNode;
    private final AtomicBoolean bootstrapRequired = new AtomicBoolean();
    private final UDPEventListener udpEventListener;
    private ProposedNodes ourProposedIdentifier;
    final ConcurrentExpiryMap<AddressAndPort, ProposedNodes> proposedIdentifiersWithHost = new ConcurrentExpiryMap<AddressAndPort, ProposedNodes>(AddressAndPort.class, ProposedNodes.class);
    Replica.ModificationNotifier modificationNotifier;

    public ProposedNodes getOurProposedIdentifier() {
        return this.ourProposedIdentifier;
    }

    private void setOurProposedIdentifier(ProposedNodes ourProposedIdentifier) {
        this.ourProposedIdentifier = ourProposedIdentifier;
    }

    public void setModificationNotifier(Replica.ModificationNotifier modificationNotifier) {
        this.modificationNotifier = modificationNotifier;
    }

    public DiscoveryNodeBytesMarshallable(KnownNodes remoteNode, UDPEventListener udpEventListener) {
        this.remoteNode = remoteNode;
        this.udpEventListener = udpEventListener;
    }

    public KnownNodes getRemoteNodes() {
        return this.remoteNode;
    }

    public void writeMarshallable(@NotNull Bytes out) {
        if (this.bootstrapRequired.getAndSet(false)) {
            this.writeBootstrap(out);
            return;
        }
        this.remoteNode.writeMarshallable(out);
        this.proposedIdentifiersWithHost.expireEntries(System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(1L));
        this.proposedIdentifiersWithHost.writeMarshallable(out);
    }

    private boolean writeBootstrap(Bytes out) {
        ProposedNodes ourProposedIdentifier = this.getOurProposedIdentifier();
        if (ourProposedIdentifier == null || ourProposedIdentifier.addressAndPort == null) {
            return false;
        }
        NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.clear();
        out.write((RandomDataInput)NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES);
        ourProposedIdentifier.writeMarshallable(out);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProposedNodes readBootstrapMessage(Bytes in) {
        long start = in.position();
        try {
            long size = NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.limit();
            if (size > in.remaining()) {
                ProposedNodes proposedNodes = null;
                return proposedNodes;
            }
            int i = 0;
            while ((long)i < size) {
                byte byteRead = in.readByte();
                byte expectedByte = NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.readByte((long)i);
                if (expectedByte != byteRead) {
                    ProposedNodes proposedNodes = null;
                    return proposedNodes;
                }
                ++i;
            }
            ProposedNodes result = new ProposedNodes();
            result.readMarshallable(in);
            ProposedNodes proposedNodes = result;
            return proposedNodes;
        }
        finally {
            in.position(start);
        }
    }

    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        ProposedNodes bootstrap = this.readBootstrapMessage(in);
        if (bootstrap != null) {
            NodeDiscoveryBroadcaster.LOG.debug("received Bootstrap");
            this.proposedIdentifiersWithHost.put(bootstrap.addressAndPort, bootstrap);
            try {
                Thread.sleep((int)(Math.random() * 9.0));
                this.onChange();
            }
            catch (InterruptedException e) {
                NodeDiscoveryBroadcaster.LOG.error("", (Throwable)e);
            }
            return;
        }
        this.remoteNode.readMarshallable(in);
        this.proposedIdentifiersWithHost.readMarshallable(in);
        if (this.udpEventListener != null) {
            this.udpEventListener.onRemoteNodeEvent(this.remoteNode, this.proposedIdentifiersWithHost);
        }
    }

    public void onChange() {
        if (this.modificationNotifier != null) {
            this.modificationNotifier.onChange();
        }
    }

    public void sendBootStrap(ProposedNodes proposedNodes) {
        this.setOurProposedIdentifier(proposedNodes);
        this.bootstrapRequired.set(true);
        this.onChange();
    }

    static class ProposedNodes
    implements BytesMarshallable {
        private byte identifier;
        private long timestamp;
        private AddressAndPort addressAndPort;

        public ProposedNodes() {
        }

        public byte identifier() {
            return this.identifier;
        }

        ProposedNodes(@org.jetbrains.annotations.NotNull AddressAndPort addressAndPort, byte identifier) {
            this.addressAndPort = addressAndPort;
            this.identifier = identifier;
            this.timestamp = System.currentTimeMillis();
        }

        AddressAndPort addressAndPort() {
            return this.addressAndPort;
        }

        public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
            this.addressAndPort = new AddressAndPort();
            this.addressAndPort.readMarshallable(in);
            this.timestamp = in.readLong();
            this.identifier = in.readByte();
        }

        public void writeMarshallable(@NotNull Bytes out) {
            this.addressAndPort.writeMarshallable(out);
            out.writeLong(this.timestamp);
            out.writeByte((int)this.identifier);
        }

        public String toString() {
            return "ProposedIdentifierWithHost{identifier=" + this.identifier + ", timestamp=" + this.timestamp + ", addressAndPort=" + this.addressAndPort + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProposedNodes that = (ProposedNodes)o;
            if (this.identifier != that.identifier) {
                return false;
            }
            return this.addressAndPort.equals(that.addressAndPort);
        }

        public int hashCode() {
            int result = this.identifier;
            result = 31 * result + this.addressAndPort.hashCode();
            return result;
        }
    }
}

