/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.IntIntMultiMap;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.SharedSegment;
import net.openhft.chronicle.map.TimeProvider;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.serialization.BytesReader;
import net.openhft.chronicle.map.serialization.Hasher;
import net.openhft.chronicle.map.serialization.MetaBytesInterop;
import net.openhft.chronicle.map.serialization.MetaBytesWriter;
import net.openhft.chronicle.map.threadlocal.ThreadLocalCopies;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.model.Byteable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicatedChronicleMap<K, KI, MKI extends MetaBytesInterop<K, KI>, V, VW, MVW extends MetaBytesWriter<V, VW>>
extends VanillaChronicleMap<K, KI, MKI, V, VW, MVW>
implements ChronicleMap<K, V>,
Replica,
Replica.EntryExternalizable,
Replica.EntryResolver<K, V>,
Closeable {
    public static final int RESERVED_MOD_ITER = 8;
    static final int MAX_UNSIGNED_SHORT = 65535;
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedChronicleMap.class);
    private static final long LAST_UPDATED_HEADER_SIZE = 1024L;
    private final TimeProvider timeProvider;
    private final byte localIdentifier;
    transient Set<Closeable> closeables;
    private transient Bytes identifierUpdatedBytes;
    private transient ModificationDelegator modificationDelegator;
    private transient long startOfModificationIterators;

    public ReplicatedChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder) throws IOException {
        super(builder);
        this.timeProvider = builder.timeProvider();
        Replicator firstReplicator = builder.firstReplicator;
        this.localIdentifier = firstReplicator != null ? firstReplicator.identifier() : (byte)1;
    }

    private int assignedModIterBitSetSizeInBytes() {
        return (int)ReplicatedChronicleMap.align64(16L);
    }

    @Override
    Segment createSegment(NativeBytes bytes, int index) {
        return new Segment(bytes, index);
    }

    @Override
    Class segmentType() {
        return Segment.class;
    }

    @Override
    void initTransients() {
        super.initTransients();
        this.closeables = new CopyOnWriteArraySet<Closeable>();
    }

    long modIterBitSetSizeInBytes() {
        return ReplicatedChronicleMap.align64(this.bitsPerSegmentInModIterBitSet() * (long)this.segments.length / 8L);
    }

    private long bitsPerSegmentInModIterBitSet() {
        return Maths.nextPower2((long)this.entriesPerSegment, (long)1024L);
    }

    @Override
    int multiMapsPerSegment() {
        return 2;
    }

    @Override
    long getHeaderSize() {
        return super.getHeaderSize() + 1024L + this.modIterBitSetSizeInBytes() * 136L + (long)this.assignedModIterBitSetSizeInBytes();
    }

    void setLastModificationTime(byte identifier, long timestamp) {
        long offset = (long)identifier * 8L;
        if (this.identifierUpdatedBytes.readLong(offset) < timestamp) {
            this.identifierUpdatedBytes.writeLong(offset, timestamp);
        }
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        assert (remoteIdentifier != this.identifier());
        return this.identifierUpdatedBytes.readLong((long)remoteIdentifier * 8L);
    }

    @Override
    void onHeaderCreated() {
        long offset = super.getHeaderSize();
        this.identifierUpdatedBytes = this.ms.bytes(offset, 1024L).zeroOut();
        Bytes modDelBytes = this.ms.bytes(offset += 1024L, (long)this.assignedModIterBitSetSizeInBytes()).zeroOut();
        this.startOfModificationIterators = offset += (long)this.assignedModIterBitSetSizeInBytes();
        this.modificationDelegator = new ModificationDelegator(this.eventListener, modDelBytes);
    }

    @Override
    MapEventListener<K, V, ChronicleMap<K, V>> eventListener() {
        return this.modificationDelegator;
    }

    @Override
    public V put(K key, V value) {
        return this.put0(key, value, true, this.localIdentifier, this.timeProvider.currentTimeMillis());
    }

    V put(K key, V value, byte identifier, long timeStamp) {
        assert (identifier > 0);
        return this.put0(key, value, true, identifier, timeStamp);
    }

    @Override
    public V putIfAbsent(@net.openhft.lang.model.constraints.NotNull K key, V value) {
        return this.put0(key, value, false, this.localIdentifier, this.timeProvider.currentTimeMillis());
    }

    private V put0(K key, V value, boolean replaceIfPresent, byte identifier, long timeStamp) {
        this.checkKey(key);
        this.checkValue(value);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyWriter = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyWriter = this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyWriter, key);
        long hash = metaKeyWriter.hash(keyWriter, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segment(segmentNum).put(copies, metaKeyWriter, keyWriter, key, value, segmentHash, replaceIfPresent, identifier, timeStamp);
    }

    private Segment segment(int segmentNum) {
        return (Segment)this.segments[segmentNum];
    }

    @Override
    V lookupUsing(K key, V value, boolean create) {
        this.checkKey(key);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyWriter = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyWriter = this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyWriter, key);
        long hash = metaKeyWriter.hash(keyWriter, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segment(segmentNum).acquire(copies, metaKeyWriter, keyWriter, key, value, segmentHash, create, this.timeProvider.currentTimeMillis());
    }

    @Override
    public V remove(Object key) {
        return this.removeIfValueIs(key, null, this.localIdentifier, this.timeProvider.currentTimeMillis());
    }

    V remove(K key, V value, byte identifier, long timeStamp) {
        assert (identifier > 0);
        return this.removeIfValueIs(key, value, identifier, timeStamp);
    }

    void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.close();
    }

    @Override
    public byte identifier() {
        return this.localIdentifier;
    }

    @Override
    public Replica.ModificationIterator acquireModificationIterator(short remoteIdentifier, @NotNull Replica.ModificationNotifier modificationNotifier) {
        return this.modificationDelegator.acquireModificationIterator(remoteIdentifier, modificationNotifier);
    }

    @Override
    public boolean remove(@net.openhft.lang.model.constraints.NotNull Object key, Object value) {
        if (value == null) {
            return false;
        }
        return this.removeIfValueIs(key, value, this.localIdentifier, this.timeProvider.currentTimeMillis()) != null;
    }

    private V removeIfValueIs(Object k, V expectedValue, byte identifier, long timestamp) {
        this.checkKey(k);
        Object key = k;
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyWriter = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyWriter = this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyWriter, key);
        long hash = metaKeyWriter.hash(keyWriter, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segment(segmentNum).remove(copies, metaKeyWriter, keyWriter, key, expectedValue, segmentHash, timestamp, identifier);
    }

    @Override
    V replaceIfValueIs(@net.openhft.lang.model.constraints.NotNull K key, V existingValue, V newValue) {
        this.checkKey(key);
        this.checkValue(newValue);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyWriter = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyWriter = this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyWriter, key);
        long hash = metaKeyWriter.hash(keyWriter, key);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        return this.segment(segmentNum).replace(copies, metaKeyWriter, keyWriter, key, existingValue, newValue, segmentHash, this.timeProvider.currentTimeMillis());
    }

    @Override
    public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int chronicleId) {
        long valueSize;
        long initialLimit = entry.limit();
        long keySize = this.keySizeMarshaller.readSize(entry);
        long keyPosition = entry.position();
        entry.skip(keySize);
        long keyLimit = entry.position();
        long timeStamp = entry.readLong();
        byte identifier = entry.readByte();
        if (identifier != this.localIdentifier) {
            return;
        }
        boolean isDeleted = entry.readBoolean();
        if (!isDeleted) {
            valueSize = this.valueSizeMarshaller.readSize(entry);
            assert (valueSize > 0L);
        } else {
            valueSize = 0L;
        }
        long valuePosition = entry.position();
        this.keySizeMarshaller.writeSize(destination, keySize);
        this.valueSizeMarshaller.writeSize(destination, valueSize);
        destination.writeStopBit(timeStamp);
        destination.writeByte((int)(isDeleted ? -identifier : identifier));
        entry.position(keyPosition);
        entry.limit(keyLimit);
        destination.write((RandomDataInput)entry);
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.localIdentifier, (Object)entry.toString().trim());
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.localIdentifier, entry.toString().trim());
            }
        }
        if (isDeleted) {
            return;
        }
        entry.limit(initialLimit);
        entry.position(valuePosition);
        this.alignment.alignPositionAddr(entry);
        entry.limit(entry.position() + valueSize);
        destination.write((RandomDataInput)entry);
        if (debugEnabled) {
            LOG.debug(message + "value=" + entry.toString().trim() + ")");
        }
    }

    @Override
    public void readExternalEntry(@NotNull Bytes source) {
        byte remoteIdentifier;
        boolean isDeleted;
        long keySize = this.keySizeMarshaller.readSize(source);
        long valueSize = this.valueSizeMarshaller.readSize(source);
        long timeStamp = source.readStopBit();
        byte id = source.readByte();
        if (id < 0) {
            isDeleted = true;
            remoteIdentifier = -id;
        } else if (id != 0) {
            isDeleted = false;
            remoteIdentifier = id;
        } else {
            throw new IllegalStateException("identifier can't be 0");
        }
        if (remoteIdentifier == this.identifier()) {
            return;
        }
        long keyPosition = source.position();
        long keyLimit = keyPosition + keySize;
        source.limit(keyLimit);
        long hash = Hasher.hash(source);
        int segmentNum = this.getSegment(hash);
        int segmentHash = this.segmentHash(hash);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (isDeleted) {
            if (debugEnabled) {
                LOG.debug("READING FROM SOURCE -  into local-id={}, remote={}, remove(key={})", new Object[]{this.localIdentifier, remoteIdentifier, source.toString().trim()});
            }
            this.segment(segmentNum).remoteRemove(source, segmentHash, timeStamp, remoteIdentifier);
            this.setLastModificationTime(remoteIdentifier, timeStamp);
            return;
        }
        String message = null;
        if (debugEnabled) {
            message = String.format("READING FROM SOURCE -  into local-id=%d, remote-id=%d, put(key=%s,", this.localIdentifier, remoteIdentifier, source.toString().trim());
        }
        long valuePosition = keyLimit;
        long valueLimit = valuePosition + valueSize;
        this.segment(segmentNum).remotePut(source, segmentHash, remoteIdentifier, timeStamp, valuePosition, valueLimit);
        this.setLastModificationTime(remoteIdentifier, timeStamp);
        if (debugEnabled) {
            source.limit(valueLimit);
            source.position(valuePosition);
            LOG.debug(message + "value=" + source.toString().trim() + ")");
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K key(@NotNull Bytes entry, K usingKey) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            ThreadLocalCopies copies = this.keyReaderProvider.getCopies(null);
            Object e = this.keyReaderProvider.get(copies, this.originalKeyReader).read(entry, keySize);
            return (K)e;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V value(@NotNull Bytes entry, V usingValue) {
        long start = entry.position();
        try {
            long valueSize;
            entry.skip(this.keySizeMarshaller.readSize(entry));
            entry.readLong();
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                V v = null;
                return v;
            }
            boolean isDeleted = entry.readBoolean();
            if (!isDeleted) {
                valueSize = this.valueSizeMarshaller.readSize(entry);
                assert (valueSize > 0L);
            } else {
                V v = null;
                return v;
            }
            this.alignment.alignPositionAddr(entry);
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = this.valueReaderProvider.get(copies, this.originalValueReader);
            V v = valueReader.read(entry, valueSize, usingValue);
            return v;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasRemoved(@NotNull Bytes entry) {
        long start = entry.position();
        try {
            boolean bl = entry.readBoolean(this.keySizeMarshaller.readSize(entry) + 10L);
            return bl;
        }
        finally {
            entry.position(start);
        }
    }

    class ModificationIterator
    extends MapEventListener<K, V, ChronicleMap<K, V>>
    implements Replica.ModificationIterator {
        private static final long serialVersionUID = 0L;
        private final Replica.ModificationNotifier modificationNotifier;
        private final ATSDirectBitSet changes;
        private final int segmentIndexShift;
        private final long posMask;
        private final net.openhft.chronicle.map.ReplicatedChronicleMap$ModificationIterator.EntryModifiableCallback entryModifiableCallback = new EntryModifiableCallback();
        private long position = -1L;

        public ModificationIterator(@NotNull Bytes bytes, Replica.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
            long bitsPerSegment = ReplicatedChronicleMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.changes = new ATSDirectBitSet(bytes);
        }

        private long combine(int segmentIndex, long pos) {
            return (long)segmentIndex << this.segmentIndexShift | pos;
        }

        @Override
        public void onPut(ChronicleMap<K, V> map, Bytes entry, int metaDataBytes, boolean added, K key, V value, long pos, SharedSegment segment) {
            assert (ReplicatedChronicleMap.this == map) : "ModificationIterator.onPut() is called from outside of the parent map";
            this.changes.set(this.combine(segment.getIndex(), pos));
            this.modificationNotifier.onChange();
        }

        @Override
        public void onRemove(ChronicleMap<K, V> map, Bytes entry, int metaDataBytes, K key, V value, int pos, SharedSegment segment) {
            assert (ReplicatedChronicleMap.this == map) : "ModificationIterator.onRemove() is called from outside of the parent map";
            this.changes.set(this.combine(segment.getIndex(), pos));
            this.modificationNotifier.onChange();
        }

        @Override
        void onRelocation(int pos, SharedSegment segment) {
            this.changes.clear(this.combine(segment.getIndex(), pos));
        }

        @Override
        public boolean hasNext() {
            long position = this.position;
            return this.changes.nextSetBit(position == -1L ? 0L : position) != -1L || position > 0L && this.changes.nextSetBit(0L) != -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean nextEntry(@NotNull Replica.EntryCallback entryCallback, int chronicleId) {
            long position = this.position;
            while (true) {
                long oldPosition;
                if ((position = this.changes.nextSetBit((oldPosition = position) + 1L)) == -1L) {
                    if (oldPosition != -1L) continue;
                    this.position = -1L;
                    return false;
                }
                this.position = position;
                Segment segment = ReplicatedChronicleMap.this.segment((int)(position >>> this.segmentIndexShift));
                segment.lock();
                try {
                    if (!this.changes.clearIfSet(position)) continue;
                    entryCallback.onBeforeEntry();
                    long segmentPos = position & this.posMask;
                    NativeBytes entry = segment.entry(segment.offsetFromPos(segmentPos));
                    boolean success = entryCallback.onEntry((Bytes)entry, chronicleId);
                    entryCallback.onAfterEntry();
                    if (!success) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    segment.unlock();
                    continue;
                }
                break;
            }
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) {
            for (Segment segment : (Segment[])ReplicatedChronicleMap.this.segments) {
                segment.dirtyEntries(fromTimeStamp, (EntryModifiableCallback)this.entryModifiableCallback);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new NotSerializableException(this.getClass().getCanonicalName());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new NotSerializableException(this.getClass().getCanonicalName());
        }

        class EntryModifiableCallback {
            EntryModifiableCallback() {
            }

            public void set(int segmentIndex, int pos) {
                long combine = ModificationIterator.this.combine(segmentIndex, pos);
                ModificationIterator.this.changes.set(combine);
            }
        }
    }

    class ModificationDelegator
    extends MapEventListener<K, V, ChronicleMap<K, V>> {
        private static final long serialVersionUID = 0L;
        private final ATSDirectBitSet modIterSet;
        private final MapEventListener<K, V, ChronicleMap<K, V>> nextListener;
        private final AtomicReferenceArray<ModificationIterator> modificationIterators = new AtomicReferenceArray(135);

        public ModificationDelegator(MapEventListener<K, V, ChronicleMap<K, V>> nextListener, Bytes bytes) {
            this.nextListener = nextListener;
            this.modIterSet = new ATSDirectBitSet(bytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModificationIterator acquireModificationIterator(short remoteIdentifier, @NotNull Replica.ModificationNotifier modificationNotifier) {
            ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            AtomicReferenceArray<ModificationIterator> atomicReferenceArray = this.modificationIterators;
            synchronized (atomicReferenceArray) {
                ModificationIterator modificationIterator0 = this.modificationIterators.get(remoteIdentifier);
                if (modificationIterator0 != null) {
                    return modificationIterator0;
                }
                Bytes bytes = ReplicatedChronicleMap.this.ms.bytes(ReplicatedChronicleMap.this.startOfModificationIterators + ReplicatedChronicleMap.this.modIterBitSetSizeInBytes() * (long)remoteIdentifier, ReplicatedChronicleMap.this.modIterBitSetSizeInBytes());
                ModificationIterator newModificationIterator = new ModificationIterator(bytes, modificationNotifier);
                this.modificationIterators.set(remoteIdentifier, newModificationIterator);
                this.modIterSet.set((long)remoteIdentifier);
                return newModificationIterator;
            }
        }

        @Override
        public void onPut(ChronicleMap<K, V> map, Bytes entry, int metaDataBytes, boolean added, K key, V value, long pos, SharedSegment segment) {
            assert (ReplicatedChronicleMap.this == map) : "ModificationIterator.onPut() is called from outside of the parent map";
            try {
                this.nextListener.onPut(map, entry, metaDataBytes, added, key, value, pos, segment);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            long next = this.modIterSet.nextSetBit(0L);
            while (next > 0L) {
                try {
                    ModificationIterator modificationIterator = this.modificationIterators.get((int)next);
                    modificationIterator.onPut(map, entry, metaDataBytes, added, key, value, pos, segment);
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
                next = this.modIterSet.nextSetBit(next + 1L);
            }
        }

        @Override
        public void onRemove(ChronicleMap<K, V> map, Bytes entry, int metaDataBytes, K key, V value, int pos, SharedSegment segment) {
            assert (ReplicatedChronicleMap.this == map) : "ModificationIterator.onRemove() is called from outside of the parent map";
            try {
                this.nextListener.onRemove(map, entry, metaDataBytes, key, value, pos, segment);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            long next = this.modIterSet.nextSetBit(0L);
            while (next > 0L) {
                try {
                    ModificationIterator modificationIterator = this.modificationIterators.get((int)next);
                    modificationIterator.onRemove(map, entry, metaDataBytes, key, value, pos, segment);
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
                next = this.modIterSet.nextSetBit(next + 1L);
            }
        }

        @Override
        void onRelocation(int pos, SharedSegment segment) {
            long next = this.modIterSet.nextSetBit(0L);
            while (next > 0L) {
                try {
                    ModificationIterator modificationIterator = this.modificationIterators.get((int)next);
                    modificationIterator.onRelocation(pos, segment);
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
                next = this.modIterSet.nextSetBit(next + 1L);
            }
        }

        @Override
        public void onGetFound(ChronicleMap<K, V> map, Bytes entry, int metaDataBytes, K key, V value) {
            this.nextListener.onGetFound(map, entry, metaDataBytes, key, value);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new NotSerializableException(this.getClass().getCanonicalName());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new NotSerializableException(this.getClass().getCanonicalName());
        }
    }

    class EntrySet
    extends VanillaChronicleMap.EntrySet {
        EntrySet() {
            super(ReplicatedChronicleMap.this);
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }
    }

    class EntryIterator
    extends VanillaChronicleMap.EntryIterator {
        EntryIterator() {
            super(ReplicatedChronicleMap.this);
        }

        @Override
        void removePresent(VanillaChronicleMap.Segment seg, int pos) {
            Segment segment = (Segment)seg;
            long offset = segment.offsetFromPos(pos);
            MultiStoreBytes entry = segment.entry(offset);
            long limit = entry.limit();
            long keySize = ReplicatedChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
            long keyPosition = entry.position();
            entry.skip(keySize);
            long timestamp = entry.readLong();
            entry.position(keyPosition);
            if (timestamp > ((TimestampTrackingEntry)this.returnedEntry).timestamp) {
                Object key = this.returnedEntry.getKey();
                ThreadLocalCopies copies = ReplicatedChronicleMap.this.keyInteropProvider.getCopies(null);
                Object keyWriter = ReplicatedChronicleMap.this.keyInteropProvider.get(copies, ReplicatedChronicleMap.this.originalKeyInterop);
                MetaBytesInterop metaKeyWriter = ReplicatedChronicleMap.this.metaKeyInteropProvider.get(copies = ReplicatedChronicleMap.this.metaKeyInteropProvider.getCopies(copies), ReplicatedChronicleMap.this.originalMetaKeyInterop, keyWriter, key);
                long returnedKeySize = metaKeyWriter.size(keyWriter, key);
                if (returnedKeySize != keySize || !metaKeyWriter.startsWith(keyWriter, (Bytes)entry, key)) {
                    ReplicatedChronicleMap.this.remove(key);
                    return;
                }
            }
            int segmentHash = ReplicatedChronicleMap.this.segmentHash(Hasher.hash((Bytes)entry, keyPosition, keyPosition + keySize));
            segment.hashLookupLiveOnly.remove(segmentHash, pos);
            segment.decrementSize();
            entry.skip(keySize);
            entry.writeLong(ReplicatedChronicleMap.this.timeProvider.currentTimeMillis());
            entry.writeByte((int)ReplicatedChronicleMap.this.localIdentifier);
            entry.writeBoolean(true);
            segment.notifyRemoved(offset, this.returnedEntry.getKey(), this.returnedEntry.getValue(), pos);
        }
    }

    class TimestampTrackingEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = 0L;
        transient long timestamp;

        public TimestampTrackingEntry(K key, V value, long timestamp) {
            super(key, value);
            this.timestamp = timestamp;
        }

        @Override
        public V setValue(V value) {
            long newTimestamp = this.timestamp = ReplicatedChronicleMap.this.timeProvider.currentTimeMillis();
            ReplicatedChronicleMap.this.put(this.getKey(), value, ReplicatedChronicleMap.this.localIdentifier, newTimestamp);
            return super.setValue(value);
        }
    }

    class Segment
    extends VanillaChronicleMap.Segment {
        private volatile IntIntMultiMap hashLookupLiveAndDeleted;
        private volatile IntIntMultiMap hashLookupLiveOnly;

        Segment(NativeBytes bytes, int index) {
            super(ReplicatedChronicleMap.this, bytes, index);
        }

        @Override
        void createHashLookups(long start) {
            this.hashLookupLiveAndDeleted = this.createMultiMap(start);
            this.hashLookupLiveOnly = this.createMultiMap(start += VanillaChronicleMap.align64(ReplicatedChronicleMap.this.sizeOfMultiMap() + ReplicatedChronicleMap.this.sizeOfMultiMapBitSet()));
        }

        @Override
        public IntIntMultiMap getHashLookup() {
            return this.hashLookupLiveOnly;
        }

        private long entrySize(long keySize, long valueSize) {
            long result = ReplicatedChronicleMap.this.alignment.alignAddr((long)(ReplicatedChronicleMap.this.metaDataBytes + ReplicatedChronicleMap.this.keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + 10L + (long)ReplicatedChronicleMap.this.valueSizeMarshaller.sizeEncodingSize(valueSize)) + valueSize;
            if (result > 65535L) {
                throw new IllegalStateException("ENTRY WRITE_BUFFER_SIZE TOO LARGE : Replicated ChronicleMap's are restricted to an entry size of 65535, your entry size=" + result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V acquire(ThreadLocalCopies copies, MKI metaKeyWriter, KI keyWriter, K key, V usingValue, int hash2, boolean create, long timestamp) {
            this.lock();
            try {
                long keySize = metaKeyWriter.size(keyWriter, key);
                MultiStoreBytes entry = this.tmpBytes;
                long offset = this.searchKey(keyWriter, metaKeyWriter, key, keySize, hash2, entry, this.hashLookupLiveOnly);
                if (offset >= 0L) {
                    entry.skip(10L);
                    Object v = this.onKeyPresentOnAcquire(copies, key, usingValue, offset, (NativeBytes)entry);
                    return v;
                }
                boolean usingValuePassed = usingValue != null;
                if ((usingValue = this.tryObtainUsingValueOnAcquire(key, usingValue, create)) != null) {
                    offset = this.putEntryOnAcquire(copies, metaKeyWriter, keyWriter, key, keySize, hash2, usingValue, create, timestamp);
                    this.incrementSize();
                    if (usingValuePassed || !create) {
                        this.notifyPut(offset, true, key, usingValue, this.posFromOffset(offset));
                    }
                    Object v = usingValue;
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        private long putEntryOnAcquire(ThreadLocalCopies copies, MKI metaKeyWriter, KI keyWriter, K key, long keySize, int hash2, V value, boolean usingValue, long timestamp) {
            return this.putEntry(copies, metaKeyWriter, keyWriter, key, keySize, hash2, value, usingValue, ReplicatedChronicleMap.this.localIdentifier, timestamp, this.hashLookupLiveOnly);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remoteRemove(Bytes keyBytes, int hash2, long timestamp, byte identifier) {
            this.lock();
            try {
                int pos;
                long keySize = keyBytes.remaining();
                this.hashLookupLiveAndDeleted.startSearch(hash2);
                while ((pos = this.hashLookupLiveAndDeleted.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.remoteKeyEquals(keyBytes, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long timeStampPos = entry.position();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        return;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    if (!wasDeleted) {
                        this.hashLookupLiveOnly.remove(hash2, pos);
                        this.decrementSize();
                    }
                    entry.position(timeStampPos);
                    entry.writeLong(timestamp);
                    assert (identifier > 0);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(true);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Segment.remoteRemove() : key=" + keyBytes.toString().trim() + " was not " + "found");
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remotePut(@NotNull Bytes inBytes, int hash2, byte identifier, long timestamp, long valuePos, long valueLimit) {
            this.lock();
            try {
                int pos;
                long keySize = inBytes.remaining();
                this.hashLookupLiveAndDeleted.startSearch(hash2);
                while ((pos = this.hashLookupLiveAndDeleted.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.remoteKeyEquals(inBytes, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long timeStampPos = entry.positionAddr();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        return;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    entry.positionAddr(timeStampPos);
                    entry.writeLong(timestamp);
                    assert (identifier > 0);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(false);
                    long valueSizePos = entry.position();
                    long valueSize = ReplicatedChronicleMap.this.readValueSize((Bytes)entry);
                    long entryEndAddr = entry.positionAddr() + valueSize;
                    inBytes.limit(valueLimit);
                    inBytes.position(valuePos);
                    this.putValue(pos, offset, (NativeBytes)entry, valueSizePos, entryEndAddr, null, null, inBytes, this.hashLookupLiveAndDeleted);
                    if (wasDeleted) {
                        this.hashLookupLiveOnly.put(hash2, pos);
                        this.incrementSize();
                    }
                    return;
                }
                long valueSize = valueLimit - valuePos;
                int pos2 = this.alloc(this.inBlocks(this.entrySize(keySize, valueSize)));
                long offset = this.offsetFromPos(pos2);
                this.clearMetaData(offset);
                MultiStoreBytes entry = this.entry(offset);
                ReplicatedChronicleMap.this.keySizeMarshaller.writeSize((Bytes)entry, keySize);
                entry.write((RandomDataInput)inBytes);
                entry.writeLong(timestamp);
                entry.writeByte((int)identifier);
                entry.writeBoolean(false);
                ReplicatedChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, valueSize);
                ReplicatedChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
                inBytes.limit(valueLimit);
                inBytes.position(valuePos);
                entry.write((RandomDataInput)inBytes);
                this.hashLookupLiveAndDeleted.putAfterFailedSearch(pos2);
                this.hashLookupLiveOnly.put(hash2, pos2);
                this.incrementSize();
            }
            finally {
                this.unlock();
            }
        }

        private boolean remoteKeyEquals(Bytes keyBytes, long keySize, Bytes entry) {
            return keySize == ReplicatedChronicleMap.this.keySizeMarshaller.readSize(entry) && entry.startsWith((RandomDataInput)keyBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(ThreadLocalCopies copies, MKI metaKeyWriter, KI keyWriter, K key, V value, int hash2, boolean replaceIfPresent, byte identifier, long timestamp) {
            this.lock();
            try {
                long offset;
                int pos;
                IntIntMultiMap hashLookup = this.hashLookupLiveAndDeleted;
                long keySize = metaKeyWriter.size(keyWriter, key);
                hashLookup.startSearch(hash2);
                while ((pos = hashLookup.nextPos()) >= 0) {
                    offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyWriter, metaKeyWriter, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long timeStampPos = entry.positionAddr();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        Object v = null;
                        return v;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    if (replaceIfPresent || wasDeleted) {
                        entry.positionAddr(timeStampPos);
                        entry.writeLong(timestamp);
                        entry.writeByte((int)identifier);
                        entry.writeBoolean(false);
                        Object prevValue = this.replaceValueOnPut(copies, key, value, (NativeBytes)entry, pos, offset, !wasDeleted && !ReplicatedChronicleMap.this.putReturnsNull, hashLookup);
                        if (wasDeleted) {
                            this.hashLookupLiveOnly.put(hash2, pos);
                            this.incrementSize();
                            Object v = null;
                            return v;
                        }
                        Object v = prevValue;
                        return v;
                    }
                    Object v = ReplicatedChronicleMap.this.putReturnsNull ? null : (Object)this.readValue(copies, (NativeBytes)entry, null);
                    return v;
                }
                offset = this.putEntry(copies, metaKeyWriter, keyWriter, key, keySize, hash2, value, false, identifier, timestamp, hashLookup);
                this.incrementSize();
                this.notifyPut(offset, true, key, value, this.posFromOffset(offset));
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        private boolean shouldIgnore(@NotNull NativeBytes entry, long timestamp, byte identifier) {
            long lastModifiedTimeStamp = entry.readLong();
            if (lastModifiedTimeStamp < timestamp) {
                entry.skip(1L);
                return false;
            }
            if (lastModifiedTimeStamp > timestamp) {
                return true;
            }
            return entry.readByte() > identifier;
        }

        private long putEntry(ThreadLocalCopies copies, MKI metaKeyWriter, KI keyWriter, K key, long keySize, int hash2, V value, boolean usingValue, int identifier, long timestamp, IntIntMultiMap searchedHashLookup) {
            long valueSize;
            boolean byteableValue = usingValue && value instanceof Byteable;
            MetaBytesWriter metaValueWriter = null;
            Object valueWriter = null;
            Byteable valueAsByteable = null;
            if (!byteableValue) {
                copies = ReplicatedChronicleMap.this.valueWriterProvider.getCopies(copies);
                valueWriter = ReplicatedChronicleMap.this.valueWriterProvider.get(copies, ReplicatedChronicleMap.this.originalValueWriter);
                copies = ReplicatedChronicleMap.this.metaValueWriterProvider.getCopies(copies);
                metaValueWriter = ReplicatedChronicleMap.this.metaValueWriterProvider.get(copies, ReplicatedChronicleMap.this.originalMetaValueWriter, valueWriter, value);
                valueSize = metaValueWriter.size(valueWriter, value);
            } else {
                valueAsByteable = (Byteable)value;
                valueSize = valueAsByteable.maxSize();
            }
            long entrySize = this.entrySize(keySize, valueSize);
            int pos = this.alloc(this.inBlocks(entrySize));
            long offset = this.offsetFromPos(pos);
            this.clearMetaData(offset);
            MultiStoreBytes entry = this.entry(offset);
            ReplicatedChronicleMap.this.keySizeMarshaller.writeSize((Bytes)entry, keySize);
            metaKeyWriter.write(keyWriter, (Bytes)entry, key);
            entry.writeLong(timestamp);
            entry.writeByte(identifier);
            entry.writeBoolean(false);
            this.writeValueOnPutEntry(valueSize, metaValueWriter, valueWriter, value, valueAsByteable, (NativeBytes)entry);
            if (searchedHashLookup == this.hashLookupLiveAndDeleted) {
                this.hashLookupLiveAndDeleted.putAfterFailedSearch(pos);
                this.hashLookupLiveOnly.put(hash2, pos);
            } else {
                this.hashLookupLiveOnly.putAfterFailedSearch(pos);
                this.hashLookupLiveAndDeleted.put(hash2, pos);
            }
            return offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(ThreadLocalCopies copies, MKI metaKeyWriter, KI keyWriter, K key, V expectedValue, int hash2, long timestamp, byte identifier) {
            assert (identifier > 0);
            this.lock();
            try {
                int pos;
                long keySize = metaKeyWriter.size(keyWriter, key);
                IntIntMultiMap multiMap = this.hashLookupLiveAndDeleted;
                multiMap.startSearch(hash2);
                while ((pos = multiMap.nextPos()) >= 0) {
                    Object valueRemoved;
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyWriter, metaKeyWriter, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long timeStampPos = entry.position();
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, identifier)) {
                        Object v = null;
                        return v;
                    }
                    boolean wasDeleted = entry.readBoolean();
                    if (wasDeleted) {
                        entry.position(timeStampPos);
                        entry.writeLong(timestamp);
                        entry.writeByte((int)identifier);
                        entry.skip(1L);
                        this.notifyRemoved(offset, key, null, pos);
                        Object v = null;
                        return v;
                    }
                    long valueSize = ReplicatedChronicleMap.this.readValueSize((Bytes)entry);
                    Object v = valueRemoved = expectedValue != null || !ReplicatedChronicleMap.this.removeReturnsNull ? (Object)this.readValue(copies, (NativeBytes)entry, null, valueSize) : null;
                    if (expectedValue != null && !expectedValue.equals(valueRemoved)) {
                        Object v2 = null;
                        return v2;
                    }
                    this.hashLookupLiveOnly.remove(hash2, pos);
                    this.decrementSize();
                    entry.position(timeStampPos);
                    entry.writeLong(timestamp);
                    entry.writeByte((int)identifier);
                    entry.writeBoolean(true);
                    this.notifyRemoved(offset, key, valueRemoved, pos);
                    Object v3 = valueRemoved;
                    return v3;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        IntIntMultiMap containsKeyHashLookup() {
            return this.hashLookupLiveOnly;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(ThreadLocalCopies copies, MKI metaKeyWriter, KI keyWriter, K key, V expectedValue, V newValue, int hash2, long timestamp) {
            this.lock();
            try {
                int pos;
                long keySize = metaKeyWriter.size(keyWriter, key);
                this.hashLookupLiveOnly.startSearch(hash2);
                while ((pos = this.hashLookupLiveOnly.nextPos()) >= 0) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyWriter, metaKeyWriter, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    if (this.shouldIgnore((NativeBytes)entry, timestamp, ReplicatedChronicleMap.this.localIdentifier)) {
                        Object v = null;
                        return v;
                    }
                    entry.skip(1L);
                    Object v = this.onKeyPresentOnReplace(copies, key, expectedValue, newValue, pos, offset, (NativeBytes)entry, this.hashLookupLiveOnly);
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        void replacePosInHashLookupOnRelocation(IntIntMultiMap searchedHashLookup, int prevPos, int pos) {
            searchedHashLookup.replacePrevPos(pos);
            int hash = searchedHashLookup.getSearchHash();
            IntIntMultiMap anotherLookup = searchedHashLookup == this.hashLookupLiveAndDeleted ? this.hashLookupLiveOnly : this.hashLookupLiveAndDeleted;
            anotherLookup.replace(hash, prevPos, pos);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dirtyEntries(final long timeStamp, final ModificationIterator.EntryModifiableCallback callback) {
            this.lock();
            try {
                final int index = this.getIndex();
                this.hashLookupLiveAndDeleted.forEach(new IntIntMultiMap.EntryConsumer(){

                    @Override
                    public void accept(int hash, int pos) {
                        MultiStoreBytes entry = Segment.this.entry(Segment.this.offsetFromPos(pos));
                        long keySize = ReplicatedChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
                        entry.skip(keySize);
                        long entryTimestamp = entry.readLong();
                        if (entryTimestamp >= timeStamp && entry.readByte() == ReplicatedChronicleMap.this.identifier()) {
                            callback.set(index, pos);
                        }
                    }
                });
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public Map.Entry<K, V> getEntry(long pos) {
            this.bytes.position(this.offsetFromPos(pos) + (long)ReplicatedChronicleMap.this.metaDataBytes);
            long keySize = ReplicatedChronicleMap.this.keySizeMarshaller.readSize((Bytes)this.bytes);
            ThreadLocalCopies copies = ReplicatedChronicleMap.this.keyReaderProvider.getCopies(null);
            Object key = ReplicatedChronicleMap.this.keyReaderProvider.get(copies, ReplicatedChronicleMap.this.originalKeyReader).read((Bytes)this.bytes, keySize);
            long timestamp = this.bytes.readLong();
            this.bytes.skip(2L);
            long valueSize = ReplicatedChronicleMap.this.valueSizeMarshaller.readSize((Bytes)this.bytes);
            ReplicatedChronicleMap.this.alignment.alignPositionAddr((Bytes)this.bytes);
            copies = ReplicatedChronicleMap.this.valueReaderProvider.getCopies(copies);
            Object value = ReplicatedChronicleMap.this.valueReaderProvider.get(copies, ReplicatedChronicleMap.this.originalValueReader).read((Bytes)this.bytes, valueSize);
            return new TimestampTrackingEntry(key, value, timestamp);
        }

        @Override
        void clear() {
            for (Object k : ReplicatedChronicleMap.this.keySet()) {
                ReplicatedChronicleMap.this.remove(k);
            }
        }
    }
}

