/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.serialization;

import net.openhft.chronicle.map.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;

public final class SizeMarshallers {
    public static SizeMarshaller stopBit() {
        return StopBit.INSTANCE;
    }

    private SizeMarshallers() {
    }

    private static enum StopBit implements SizeMarshaller
    {
        INSTANCE;


        @Override
        public int sizeEncodingSize(long size) {
            if (size <= 127L) {
                return 1;
            }
            return (70 - Long.numberOfLeadingZeros(size)) / 7;
        }

        @Override
        public void writeSize(Bytes bytes, long size) {
            bytes.writeStopBit(size);
        }

        @Override
        public long readSize(Bytes bytes) {
            return bytes.readStopBit();
        }
    }
}

