/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesWriter;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;

class Serializer<O> {
    final SizeMarshaller sizeMarshaller;
    final BytesReader<O> originalReader;
    transient Provider<BytesReader<O>> readerProvider;
    final Object originalWriter;
    transient Provider writerProvider;
    final MetaBytesInterop originalMetaValueWriter;
    final MetaProvider metaValueWriterProvider;

    Serializer(SerializationBuilder serializationBuilder) {
        this.sizeMarshaller = serializationBuilder.sizeMarshaller();
        this.originalMetaValueWriter = serializationBuilder.metaInterop();
        this.metaValueWriterProvider = serializationBuilder.metaInteropProvider();
        this.originalReader = serializationBuilder.reader();
        this.originalWriter = serializationBuilder.interop();
        this.readerProvider = Provider.of(this.originalReader.getClass());
        this.writerProvider = Provider.of(this.originalWriter.getClass());
    }

    public O readMarshallable(@NotNull Bytes in, ThreadLocalCopies local) throws IllegalStateException {
        ThreadLocalCopies copies = local == null ? this.threadLocalCopies() : local;
        BytesReader valueReader = (BytesReader)this.readerProvider.get(copies, this.originalReader);
        try {
            long valueSize = this.sizeMarshaller.readSize(in);
            return valueReader.read(in, valueSize, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThreadLocalCopies threadLocalCopies() {
        return this.readerProvider.getCopies(null);
    }

    ThreadLocalCopies writeMarshallable(O value, Bytes out, ThreadLocalCopies copies0) {
        long valueSize;
        ThreadLocalCopies copies = copies0 == null ? this.threadLocalCopies() : copies0;
        Object valueWriter = this.writerProvider.get(copies, this.originalWriter);
        copies = this.writerProvider.getCopies(copies);
        MetaBytesWriter metaValueWriter = null;
        if (value instanceof Byteable) {
            valueSize = ((Byteable)value).maxSize();
        } else {
            copies = this.writerProvider.getCopies(copies);
            valueWriter = this.writerProvider.get(copies, this.originalWriter);
            copies = this.metaValueWriterProvider.getCopies(copies);
            metaValueWriter = this.metaValueWriterProvider.get(copies, this.originalMetaValueWriter, valueWriter, value);
            valueSize = metaValueWriter.size(valueWriter, value);
        }
        this.sizeMarshaller.writeSize(out, valueSize);
        if (metaValueWriter != null) {
            assert (out.limit() == out.capacity());
        } else {
            throw new UnsupportedOperationException("");
        }
        metaValueWriter.write(valueWriter, out, value);
        return copies;
    }
}

