/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import com.sun.jdi.connect.spi.ClosedConnectionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import net.openhft.chronicle.hash.RemoteCallTimeoutException;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.map.AbstractChannelReplicator;
import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.CloseablesManager;
import net.openhft.chronicle.map.Function;
import net.openhft.chronicle.map.IORuntimeException;
import net.openhft.chronicle.map.ReadContext;
import net.openhft.chronicle.map.ReaderWithSize;
import net.openhft.chronicle.map.StatelessMapConfig;
import net.openhft.chronicle.map.UnaryOperator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.WriteContext;
import net.openhft.chronicle.map.WriterWithSize;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.thread.NamedThreadFactory;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatelessChronicleMap<K, V>
implements ChronicleMap<K, V>,
Closeable,
Cloneable {
    private static final String START_OF = "Attempt to write ";
    private static final Logger LOG = LoggerFactory.getLogger(StatelessChronicleMap.class);
    private static final byte STATELESS_CLIENT_IDENTIFIER = -127;
    private final byte[] connectionByte = new byte[1];
    private final ByteBuffer connectionOutBuffer = ByteBuffer.wrap(this.connectionByte);
    private final String name;
    @NotNull
    private final AbstractChronicleMapBuilder chronicleMapBuilder;
    private volatile ByteBuffer outBuffer;
    private volatile ByteBufferBytes outBytes;
    private volatile ByteBuffer inBuffer;
    private volatile ByteBufferBytes inBytes;
    @NotNull
    private final ReaderWithSize<K> keyReaderWithSize;
    @NotNull
    private final WriterWithSize<K> keyWriterWithSize;
    @NotNull
    private final ReaderWithSize<V> valueReaderWithSize;
    @NotNull
    private final WriterWithSize<V> valueWriterWithSize;
    private volatile SocketChannel clientChannel;
    @Nullable
    private CloseablesManager closeables;
    @NotNull
    private final StatelessMapConfig config;
    private int maxEntrySize;
    private final Class<K> kClass;
    private final Class<V> vClass;
    private final boolean putReturnsNull;
    private final boolean removeReturnsNull;
    private final ReentrantLock inBytesLock = new ReentrantLock();
    private final ReentrantLock outBytesLock = new ReentrantLock(true);
    private ExecutorService executorService;
    private int identifier;
    @NotNull
    private final AtomicLong transactionID = new AtomicLong(0L);
    private volatile long parkedTransactionId;
    private volatile int parkedRemainingBytes;
    private volatile long parkedTransactionTimeStamp;

    void identifier(int identifier) {
        this.identifier = identifier;
    }

    StatelessChronicleMap(@NotNull StatelessMapConfig config, @NotNull AbstractChronicleMapBuilder chronicleMapBuilder) throws IOException {
        this.chronicleMapBuilder = chronicleMapBuilder;
        this.config = config;
        this.keyReaderWithSize = new ReaderWithSize(chronicleMapBuilder.keyBuilder);
        this.keyWriterWithSize = new WriterWithSize(chronicleMapBuilder.keyBuilder);
        this.valueReaderWithSize = new ReaderWithSize(chronicleMapBuilder.valueBuilder);
        this.valueWriterWithSize = new WriterWithSize(chronicleMapBuilder.valueBuilder);
        this.putReturnsNull = chronicleMapBuilder.putReturnsNull();
        this.removeReturnsNull = chronicleMapBuilder.removeReturnsNull();
        this.maxEntrySize = chronicleMapBuilder.entrySize(true);
        if (this.maxEntrySize < 128) {
            this.maxEntrySize = 128;
        }
        this.vClass = chronicleMapBuilder.valueBuilder.eClass;
        this.kClass = chronicleMapBuilder.keyBuilder.eClass;
        this.name = chronicleMapBuilder.name();
        this.attemptConnect(config.remoteAddress());
        this.outBuffer = ByteBuffer.allocateDirect(this.maxEntrySize).order(ByteOrder.nativeOrder());
        this.outBytes = new ByteBufferBytes(this.outBuffer.slice());
        this.inBuffer = ByteBuffer.allocateDirect(this.maxEntrySize).order(ByteOrder.nativeOrder());
        this.inBytes = new ByteBufferBytes(this.outBuffer.slice());
    }

    @Override
    public void getAll(File toFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(File fromFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V newValueInstance() {
        return VanillaChronicleMap.newInstance(this.vClass, false);
    }

    @Override
    public K newKeyInstance() {
        return VanillaChronicleMap.newInstance(this.kClass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService lazyExecutorService() {
        if (this.executorService == null) {
            StatelessChronicleMap statelessChronicleMap = this;
            synchronized (statelessChronicleMap) {
                if (this.executorService == null) {
                    this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(this.chronicleMapBuilder.name() + "-stateless-client-async-" + this.name, Boolean.valueOf(true)));
                }
            }
        }
        return this.executorService;
    }

    private synchronized SocketChannel lazyConnect(long timeoutMs, InetSocketAddress remoteAddress) {
        SocketChannel result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("attempting to connect to " + remoteAddress);
        }
        long timeoutAt = System.currentTimeMillis() + timeoutMs;
        while (true) {
            this.checkTimeout(timeoutAt);
            this.closeExisting();
            try {
                result = AbstractChannelReplicator.openSocketChannel(this.closeables);
                result.connect(this.config.remoteAddress());
                result.socket().setTcpNoDelay(true);
                this.doHandShaking(result);
            }
            catch (IOException e) {
                if (this.closeables == null) continue;
                this.closeables.closeQuietly();
                continue;
            }
            catch (Exception e) {
                if (this.closeables != null) {
                    this.closeables.closeQuietly();
                }
                throw e;
            }
            break;
        }
        return result;
    }

    private synchronized void attemptConnect(InetSocketAddress remoteAddress) {
        block2: {
            this.closeExisting();
            try {
                this.clientChannel = AbstractChannelReplicator.openSocketChannel(this.closeables);
                this.clientChannel.connect(remoteAddress);
                this.doHandShaking(this.clientChannel);
            }
            catch (IOException e) {
                if (this.closeables == null) break block2;
                this.closeables.closeQuietly();
            }
        }
    }

    private void closeExisting() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = new CloseablesManager();
    }

    private synchronized void doHandShaking(@NotNull SocketChannel clientChannel) throws IOException {
        this.connectionByte[0] = -127;
        this.connectionOutBuffer.clear();
        long timeoutTime = System.currentTimeMillis() + this.config.timeoutMs();
        while (this.connectionOutBuffer.hasRemaining()) {
            clientChannel.write(this.connectionOutBuffer);
            this.checkTimeout(timeoutTime);
        }
        this.connectionOutBuffer.clear();
        if (!clientChannel.finishConnect() || !clientChannel.socket().isBound()) {
            return;
        }
        while (this.connectionOutBuffer.position() <= 0) {
            clientChannel.read(this.connectionOutBuffer);
            this.checkTimeout(timeoutTime);
        }
        byte remoteIdentifier = this.connectionByte[0];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attached to a map with a remote identifier=" + remoteIdentifier);
        }
    }

    @Override
    @NotNull
    public File file() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = null;
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(20L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private long nextUniqueTransaction(long time) {
        long old;
        long id = time * 10000L;
        do {
            if ((old = this.transactionID.get()) < id) continue;
            id = old + 1L;
        } while (!this.transactionID.compareAndSet(old, id));
        return id;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.fetchObject(this.vClass, EventId.PUT_IF_ABSENT, key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return value != null && this.fetchBoolean(EventId.REMOVE_WITH_VALUE, key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.fetchBoolean(EventId.REPLACE_WITH_OLD_AND_NEW_VALUE, key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.fetchObject(this.vClass, EventId.REPLACE, key, value);
    }

    @Override
    public int size() {
        return (int)this.longSize();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass().isAssignableFrom(Map.class)) {
            return false;
        }
        Map that = (Map)object;
        int size = this.size();
        if (that.size() != size) {
            return false;
        }
        Set<Map.Entry<K, V>> entries = this.entrySet();
        return that.entrySet().equals(entries);
    }

    @Override
    public int hashCode() {
        return this.fetchInt(EventId.HASH_CODE);
    }

    @NotNull
    public String toString() {
        return this.fetchObject(String.class, EventId.TO_STRING);
    }

    @Override
    public boolean isEmpty() {
        return this.fetchBoolean(EventId.IS_EMPTY);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fetchBooleanK(EventId.CONTAINS_KEY, key);
    }

    @NotNull
    private NullPointerException keyNotNullNPE() {
        return new NullPointerException("key can not be null");
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fetchBooleanV(EventId.CONTAINS_VALUE, value);
    }

    @Override
    public long longSize() {
        return this.fetchLong(EventId.LONG_SIZE);
    }

    @Override
    public V get(Object key) {
        return this.fetchObject(this.vClass, EventId.GET, key);
    }

    @Override
    @NotNull
    public V getUsing(K key, V usingValue) {
        throw new UnsupportedOperationException("getUsing() is not supported for stateless clients");
    }

    @Override
    @NotNull
    public V acquireUsing(@NotNull K key, V usingValue) {
        throw new UnsupportedOperationException("acquireUsing() is not supported for stateless clients");
    }

    @Override
    @NotNull
    public WriteContext<K, V> acquireUsingLocked(@NotNull K key, @NotNull V usingValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ReadContext<K, V> getUsingLocked(@NotNull K key, @NotNull V usingValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw this.keyNotNullNPE();
        }
        return this.fetchObject(this.vClass, this.removeReturnsNull ? EventId.REMOVE_WITHOUT_ACC : EventId.REMOVE, key);
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.fetchObject(this.vClass, this.putReturnsNull ? EventId.PUT_WITHOUT_ACC : EventId.PUT, key, value);
    }

    @Override
    @Nullable
    public <R> R getMapped(@Nullable K key, @NotNull Function<? super V, R> function) {
        if (key == null) {
            throw this.keyNotNullNPE();
        }
        return this.fetchObject(EventId.MAP_FOR_KEY, key, function);
    }

    @Override
    @Nullable
    public V putMapped(@Nullable K key, @NotNull UnaryOperator<V> unaryOperator) {
        if (key == null) {
            throw this.keyNotNullNPE();
        }
        return (V)this.fetchObject(EventId.PUT_MAPPED, key, unaryOperator);
    }

    private void resizeIfRequired(int numberOfEntries, int numberOfEntriesReadSoFar, long start) {
        long remaining = this.outBytes.remaining();
        if (remaining < (long)this.maxEntrySize) {
            long estimatedRequiredSize = this.estimateSize(numberOfEntries, numberOfEntriesReadSoFar);
            this.resizeBufferOutBuffer((int)(estimatedRequiredSize + (long)this.maxEntrySize), start);
        }
    }

    private long estimateSize(int numberOfEntries, int numberOfEntriesReadSoFar) {
        double percentageComplete = (double)numberOfEntriesReadSoFar / (double)numberOfEntries;
        return (long)((double)this.outBytes.position() / percentageComplete);
    }

    private void resizeBufferOutBuffer(int size, long start) {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("resizing buffer to size=" + size);
        }
        if (size < this.outBuffer.capacity()) {
            throw new IllegalStateException("it not possible to resize the buffer smaller");
        }
        assert (size < Integer.MAX_VALUE);
        ByteBuffer result = ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
        long bytesPosition = this.outBytes.position();
        this.outBytes = new ByteBufferBytes(result.slice());
        this.outBuffer.position(0);
        this.outBuffer.limit((int)bytesPosition);
        int numberOfLongs = (int)bytesPosition / 8;
        for (i = 0; i < numberOfLongs; ++i) {
            this.outBytes.writeLong(this.outBuffer.getLong());
        }
        i = numberOfLongs * 8;
        while ((long)i < bytesPosition) {
            this.outBytes.writeByte((int)this.outBuffer.get());
            ++i;
        }
        this.outBuffer = result;
        assert ((long)this.outBuffer.capacity() == this.outBytes.capacity());
        assert (this.outBuffer.capacity() == size);
        assert ((long)this.outBuffer.capacity() == this.outBytes.capacity());
        assert (this.outBytes.limit() == this.outBytes.capacity());
        this.outBytes.position(start);
    }

    private void resizeBufferInBuffer(int size, long start) {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("InBuffer resizing buffer to size=" + size);
        }
        if (size < this.inBuffer.capacity()) {
            throw new IllegalStateException("it not possible to resize the buffer smaller");
        }
        assert (size < Integer.MAX_VALUE);
        ByteBuffer result = ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
        long bytesPosition = this.inBytes.position();
        this.inBytes = new ByteBufferBytes(result.slice());
        this.inBuffer.position(0);
        this.inBuffer.limit((int)bytesPosition);
        int numberOfLongs = (int)bytesPosition / 8;
        for (i = 0; i < numberOfLongs; ++i) {
            this.inBytes.writeLong(this.inBuffer.getLong());
        }
        i = numberOfLongs * 8;
        while ((long)i < bytesPosition) {
            this.inBytes.writeByte((int)this.inBuffer.get());
            ++i;
        }
        this.inBuffer = result;
        assert ((long)this.inBuffer.capacity() == this.inBytes.capacity());
        assert (this.inBuffer.capacity() == size);
        assert ((long)this.inBuffer.capacity() == this.inBytes.capacity());
        assert (this.inBytes.limit() == this.inBytes.capacity());
        this.inBytes.position(start);
    }

    @Override
    public void clear() {
        this.fetchVoid(EventId.CLEAR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<V> values() {
        long sizeLocation = this.writeEventAnSkip(EventId.VALUES);
        long startTime = System.currentTimeMillis();
        long timeoutTime = System.currentTimeMillis() + this.config.timeoutMs();
        long transactionId = this.send(sizeLocation, startTime);
        ArrayList<V> result = new ArrayList<V>();
        BytesReader<V> valueReader = this.valueReaderWithSize.readerForLoop(null);
        while (true) {
            this.inBytesLock.lock();
            try {
                Bytes in = this.blockingFetchReadOnly(timeoutTime, transactionId);
                boolean hasMoreEntries = in.readBoolean();
                long size = in.readInt();
                int i = 0;
                while ((long)i < size) {
                    result.add(this.valueReaderWithSize.readInLoop(in, valueReader));
                    ++i;
                }
                if (hasMoreEntries) continue;
            }
            finally {
                this.inBytesLock.unlock();
                continue;
            }
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        long sizeLocation = this.writeEventAnSkip(EventId.ENTRY_SET);
        long startTime = System.currentTimeMillis();
        long timeoutTime = System.currentTimeMillis() + this.config.timeoutMs();
        long transactionId = this.send(sizeLocation, startTime);
        ThreadLocalCopies copies = this.keyReaderWithSize.getCopies(null);
        BytesReader<K> keyReader = this.keyReaderWithSize.readerForLoop(copies);
        copies = this.valueReaderWithSize.getCopies(copies);
        BytesReader<V> valueReader = this.valueReaderWithSize.readerForLoop(copies);
        HashMap<K, V> result = new HashMap<K, V>();
        while (true) {
            this.inBytesLock.lock();
            try {
                Bytes in = this.blockingFetchReadOnly(timeoutTime, transactionId);
                boolean hasMoreEntries = in.readBoolean();
                long size = in.readInt();
                int i = 0;
                while ((long)i < size) {
                    K k = this.keyReaderWithSize.readInLoop(in, keyReader);
                    V v = this.valueReaderWithSize.readInLoop(in, valueReader);
                    result.put(k, v);
                    ++i;
                }
                if (hasMoreEntries) continue;
            }
            finally {
                this.inBytesLock.unlock();
                continue;
            }
            break;
        }
        return result.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        long transactionId;
        long sizeLocation = this.putReturnsNull ? this.writeEventAnSkip(EventId.PUT_ALL_WITHOUT_ACC) : this.writeEventAnSkip(EventId.PUT_ALL);
        long startTime = System.currentTimeMillis();
        long timeoutTime = startTime + this.config.timeoutMs();
        int numberOfEntries = map.size();
        int numberOfEntriesReadSoFar = 0;
        this.outBytesLock.lock();
        try {
            this.outBytes.writeStopBit((long)numberOfEntries);
            assert (this.outBytes.limit() == this.outBytes.capacity());
            ThreadLocalCopies copies = this.keyWriterWithSize.getCopies(null);
            Object keyWriter = this.keyWriterWithSize.writerForLoop(copies);
            copies = this.valueWriterWithSize.getCopies(copies);
            Object valueWriter = this.valueWriterWithSize.writerForLoop(copies);
            for (Map.Entry<K, V> e : map.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (key == null || value == null) {
                    throw new NullPointerException();
                }
                long start = this.outBytes.position();
                this.resizeIfRequired(numberOfEntries, ++numberOfEntriesReadSoFar, start);
                Class<?> keyClass = key.getClass();
                if (!this.kClass.isAssignableFrom(keyClass)) {
                    throw new ClassCastException("key=" + key + " is of type=" + keyClass + " " + "and should" + " be of type=" + this.kClass);
                }
                this.writeKeyInLoop(key, keyWriter, copies);
                Class<?> valueClass = value.getClass();
                if (!this.vClass.isAssignableFrom(valueClass)) {
                    throw new ClassCastException("value=" + value + " is of type=" + valueClass + " and " + "should  be of type=" + this.vClass);
                }
                this.writeValueInLoop(value, valueWriter, copies);
                int len = (int)(this.outBytes.position() - start);
                if (len <= this.maxEntrySize) continue;
                this.maxEntrySize = len;
            }
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        if (!this.putReturnsNull) {
            this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<K> keySet() {
        long sizeLocation = this.writeEventAnSkip(EventId.KEY_SET);
        long startTime = System.currentTimeMillis();
        long timeoutTime = startTime + this.config.timeoutMs();
        long transactionId = this.send(sizeLocation, startTime);
        HashSet<K> result = new HashSet<K>();
        BytesReader<K> keyReader = this.keyReaderWithSize.readerForLoop(null);
        while (true) {
            this.inBytesLock.lock();
            try {
                Bytes in = this.blockingFetchReadOnly(timeoutTime, transactionId);
                boolean hasMoreEntries = in.readBoolean();
                long size = in.readInt();
                int i = 0;
                while ((long)i < size) {
                    result.add(this.keyReaderWithSize.readInLoop(in, keyReader));
                    ++i;
                }
                if (hasMoreEntries) continue;
            }
            finally {
                this.inBytesLock.unlock();
                continue;
            }
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLong(long transactionId, long startTime) {
        long timeoutTime = startTime + this.config.timeoutMs();
        this.inBytesLock.lock();
        try {
            long l = this.blockingFetchReadOnly(timeoutTime, transactionId).readLong();
            return l;
        }
        finally {
            this.inBytesLock.unlock();
        }
    }

    private long writeEvent(@NotNull EventId event) {
        this.outBuffer.clear();
        this.outBytes.clear();
        this.outBytes.write((int)((byte)event.ordinal()));
        return this.markSizeLocation();
    }

    private long writeEventAnSkip(@NotNull EventId event) {
        long sizeLocation = this.writeEvent(event);
        this.outBytes.skip(8L);
        this.outBytes.writeByte(this.identifier);
        this.outBytes.writeInt(0);
        return sizeLocation;
    }

    private long send(long sizeLocation, long startTime) {
        long transactionId = this.nextUniqueTransaction(startTime);
        long timeoutTime = startTime + this.config.timeoutMs();
        try {
            while (true) {
                if (this.clientChannel == null) {
                    this.clientChannel = this.lazyConnect(this.config.timeoutMs(), this.config.remoteAddress());
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("sending data with transactionId=" + transactionId);
                    }
                    this.writeSizeAndTransactionIdAt(sizeLocation, transactionId, startTime);
                    this.writeBytesToSocket((Bytes)this.outBytes, timeoutTime);
                    this.outBytes.clear();
                    this.outBytes.buffer().clear();
                }
                catch (ClosedConnectionException | ClosedChannelException e) {
                    this.checkTimeout(timeoutTime);
                    this.clientChannel = this.lazyConnect(this.config.timeoutMs(), this.config.remoteAddress());
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        return transactionId;
    }

    private Bytes blockingFetchReadOnly(long timeoutTime, long transactionId) {
        try {
            return this.blockingFetchThrowable(timeoutTime, transactionId);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        catch (AssertionError e) {
            LOG.error("", (Throwable)((Object)e));
            throw e;
        }
    }

    private Bytes blockingFetchThrowable(long timeoutTime, long transactionId) throws IOException, InterruptedException {
        int remainingBytes = this.nextEntry(timeoutTime, transactionId);
        if (this.inBytes.capacity() < (long)remainingBytes) {
            long pos = this.inBytes.position();
            long limit = this.inBytes.position();
            this.inBytes.position(limit);
            this.resizeBufferInBuffer(remainingBytes, pos);
        } else {
            this.inBytes.limit(this.inBytes.capacity());
        }
        this.receive(remainingBytes, timeoutTime);
        boolean isException = this.inBytes.readBoolean();
        if (isException) {
            Throwable throwable = (Throwable)this.inBytes.readObject();
            try {
                Field stackTrace = Throwable.class.getDeclaredField("stackTrace");
                stackTrace.setAccessible(true);
                ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>(Arrays.asList((StackTraceElement[])stackTrace.get(throwable)));
                for (int i = stes.size() - 1; i > 0 && ((StackTraceElement)stes.get(i)).getClassName().startsWith("Thread"); --i) {
                    stes.remove(i);
                }
                InetSocketAddress address = this.config.remoteAddress();
                stes.add(new StackTraceElement("~ remote", "tcp ~", address.getHostName(), address.getPort()));
                StackTraceElement[] stackTrace2 = Thread.currentThread().getStackTrace();
                for (int i = 4; i < stackTrace2.length; ++i) {
                    stes.add(stackTrace2[i]);
                }
                stackTrace.set(throwable, stes.toArray(new StackTraceElement[stes.size()]));
            }
            catch (Exception ignore) {
                // empty catch block
            }
            NativeBytes.UNSAFE.throwException(throwable);
        }
        return this.inBytes;
    }

    private int nextEntry(long timeoutTime, long transactionId) throws IOException {
        int remainingBytes;
        while (true) {
            if (this.parkedTransactionId == 0L) {
                assert (this.parkedTransactionTimeStamp == 0L);
                assert (this.parkedRemainingBytes == 0);
                this.receive(12, timeoutTime);
                int messageSize = this.inBytes.readInt();
                assert (messageSize > 0) : "Invalid message size " + messageSize;
                assert (messageSize < 0x1000000) : "Invalid message size " + messageSize;
                int remainingBytes0 = messageSize - 12;
                long transactionId0 = this.inBytes.readLong();
                assert (transactionId0 > 14100000000000000L) : "TransactionId too small " + transactionId0 + " messageSize " + messageSize;
                assert (transactionId0 < 21000000000000000L) : "TransactionId too large " + transactionId0 + " messageSize " + messageSize;
                if (transactionId0 == transactionId) {
                    this.parkedTransactionId = 0L;
                    remainingBytes = remainingBytes0;
                    assert (remainingBytes > 0);
                    this.clearParked();
                    break;
                }
                this.parkedTransactionTimeStamp = System.currentTimeMillis();
                this.parkedRemainingBytes = remainingBytes0;
                this.parkedTransactionId = transactionId0;
                this.pause();
                continue;
            }
            if (this.parkedTransactionId == transactionId) {
                remainingBytes = this.parkedRemainingBytes;
                this.clearParked();
                break;
            }
            if (System.currentTimeMillis() - timeoutTime > this.parkedTransactionTimeStamp) {
                LOG.error("", (Throwable)new IllegalStateException("Skipped Message with transaction-id=" + this.parkedTransactionTimeStamp + ", this can occur when you have another thread which has called the " + "stateless client and terminated abruptly before the message has been " + "returned from the server"));
                this.receive(this.parkedRemainingBytes, timeoutTime);
                this.clearParked();
            }
            this.pause();
        }
        return remainingBytes;
    }

    private void clearParked() {
        this.parkedTransactionId = 0L;
        this.parkedRemainingBytes = 0;
        this.parkedTransactionTimeStamp = 0L;
    }

    private void pause() {
        this.inBytesLock.unlock();
        this.inBytesLock.lock();
    }

    private Bytes receive(int requiredNumberOfBytes, long timeoutTime) throws IOException {
        this.inBytes.buffer().position(0);
        this.inBytes.buffer().limit(requiredNumberOfBytes);
        while (this.inBytes.buffer().remaining() > 0) {
            assert ((long)requiredNumberOfBytes <= this.inBytes.capacity());
            int len = this.clientChannel.read(this.inBytes.buffer());
            if (len == -1) {
                throw new IORuntimeException("Disconnected to remote server");
            }
            this.checkTimeout(timeoutTime);
        }
        this.inBytes.position(0L);
        this.inBytes.limit((long)requiredNumberOfBytes);
        return this.inBytes;
    }

    private void writeBytesToSocket(@NotNull Bytes out, long timeoutTime) throws IOException {
        this.outBuffer.limit((int)out.position());
        this.outBuffer.position(0);
        while (this.outBuffer.remaining() > 0) {
            this.clientChannel.write(this.outBuffer);
            this.checkTimeout(timeoutTime);
        }
        out.clear();
        this.outBuffer.clear();
    }

    private void checkTimeout(long timeoutTime) {
        if (timeoutTime < System.currentTimeMillis()) {
            throw new RemoteCallTimeoutException();
        }
    }

    private void writeSizeAndTransactionIdAt(long locationOfSize, long transactionId, long startTime) {
        long size = this.outBytes.position() - locationOfSize;
        long pos = this.outBytes.position();
        this.outBytes.position(locationOfSize);
        int size0 = (int)size - 4;
        assert (size0 > 0);
        this.outBytes.writeInt(size0);
        assert (transactionId != 0L);
        this.outBytes.writeLong(transactionId);
        this.outBytes.position(pos);
    }

    private long markSizeLocation() {
        long position = this.outBytes.position();
        this.outBytes.skip(4L);
        return position;
    }

    private ThreadLocalCopies writeKey(K key) {
        return this.writeKey(key, null);
    }

    private ThreadLocalCopies writeKey(K key, ThreadLocalCopies copies) {
        long start = this.outBytes.position();
        while (true) {
            try {
                return this.keyWriterWithSize.write((Bytes)this.outBytes, key, copies);
            }
            catch (IndexOutOfBoundsException e) {
                this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + (long)this.maxEntrySize), start);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private ThreadLocalCopies writeKeyInLoop(K key, Object writer, ThreadLocalCopies copies) {
        long start = this.outBytes.position();
        while (true) {
            try {
                return this.keyWriterWithSize.writeInLoop((Bytes)this.outBytes, key, writer, copies);
            }
            catch (IndexOutOfBoundsException e) {
                this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + (long)this.maxEntrySize), start);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private ThreadLocalCopies writeValue(V value, ThreadLocalCopies copies) {
        long start = this.outBytes.position();
        while (true) {
            try {
                assert (this.outBytes.position() == start);
                this.outBytes.limit(this.outBytes.capacity());
                return this.valueWriterWithSize.write((Bytes)this.outBytes, value, copies);
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private ThreadLocalCopies writeValueInLoop(V value, Object writer, ThreadLocalCopies copies) {
        long start = this.outBytes.position();
        while (true) {
            try {
                assert (this.outBytes.position() == start);
                this.outBytes.limit(this.outBytes.capacity());
                return this.valueWriterWithSize.writeInLoop((Bytes)this.outBytes, value, writer, copies);
            }
            catch (IllegalArgumentException e) {
                this.resizeToMessage(start, e);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Not enough available space")) {
                    this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + (long)this.maxEntrySize), start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void resizeToMessage(long start, @NotNull IllegalArgumentException e) {
        String message = e.getMessage();
        if (message.startsWith(START_OF)) {
            String substring = message.substring(START_OF.length(), message.length());
            int i = substring.indexOf(32);
            if (i != -1) {
                int size = Integer.parseInt(substring.substring(0, i));
                long requiresExtra = (long)size - this.outBytes.remaining();
                this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + requiresExtra), start);
            } else {
                this.resizeBufferOutBuffer((int)(this.outBytes.capacity() + (long)this.maxEntrySize), start);
            }
        } else {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V readValue(long transactionId, long startTime, ThreadLocalCopies copies) {
        long timeoutTime = startTime + this.config.timeoutMs();
        this.inBytesLock.lock();
        try {
            V v = this.readValue(copies, this.blockingFetchReadOnly(timeoutTime, transactionId));
            return v;
        }
        finally {
            this.inBytesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <O> O readObject(long transactionId, long startTime) {
        long timeoutTime = startTime + this.config.timeoutMs();
        this.inBytesLock.lock();
        try {
            Object object = this.blockingFetchReadOnly(timeoutTime, transactionId).readObject();
            return (O)object;
        }
        finally {
            this.inBytesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readBoolean(long transactionId, long startTime) {
        long timeoutTime = startTime + this.config.timeoutMs();
        this.inBytesLock.lock();
        try {
            boolean bl = this.blockingFetchReadOnly(timeoutTime, transactionId).readBoolean();
            return bl;
        }
        finally {
            this.inBytesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readInt(long transactionId, long startTime) {
        long timeoutTime = startTime + this.config.timeoutMs();
        this.inBytesLock.lock();
        try {
            int n = this.blockingFetchReadOnly(timeoutTime, transactionId).readInt();
            return n;
        }
        finally {
            this.inBytesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long send(@NotNull EventId eventId, long startTime) {
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            long l = this.send(sizeLocation, startTime);
            return l;
        }
        finally {
            this.outBytesLock.unlock();
        }
    }

    private V readValue(ThreadLocalCopies copies, Bytes in) {
        return this.valueReaderWithSize.readNullable(in, copies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchBoolean(@NotNull EventId eventId, K key, V value) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            ThreadLocalCopies copies = this.writeKey(key);
            this.writeValue(value, copies);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        return this.readBoolean(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchBoolean(@NotNull EventId eventId, K key, V value1, V value2) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            ThreadLocalCopies copies = this.writeKey(key);
            copies = this.writeValue(value1, copies);
            this.writeValue(value2, copies);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        return this.readBoolean(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchBooleanV(@NotNull EventId eventId, V value) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            this.writeValue(value, null);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        return this.readBoolean(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchBooleanK(@NotNull EventId eventId, K key) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            this.writeKey(key, null);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        return this.readBoolean(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long fetchLong(@NotNull EventId eventId) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        return this.readLong(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchBoolean(@NotNull EventId eventId) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        return this.readBoolean(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchVoid(@NotNull EventId eventId) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        this.readVoid(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readVoid(long transactionId, long startTime) {
        long timeoutTime = startTime + this.config.timeoutMs();
        this.inBytesLock.lock();
        try {
            this.blockingFetchReadOnly(timeoutTime, transactionId);
        }
        finally {
            this.inBytesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <O> O fetchObject(Class<O> tClass, @NotNull EventId eventId) {
        long startTime = System.currentTimeMillis();
        long transactionId = this.send(eventId, startTime);
        long timeoutTime = startTime + this.config.timeoutMs();
        this.inBytesLock.lock();
        try {
            Object object = this.blockingFetchReadOnly(timeoutTime, transactionId).readObject(tClass);
            return (O)object;
        }
        finally {
            this.inBytesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fetchInt(@NotNull EventId eventId) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        return this.readInt(transactionId, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <R> R fetchObject(Class<R> rClass, @NotNull EventId eventId, K key, V value) {
        long transactionId;
        ThreadLocalCopies copies;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            copies = this.writeKey(key);
            copies = this.writeValue(value, copies);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        if (this.eventReturnsNull(eventId)) {
            return null;
        }
        if (rClass == this.vClass) {
            return (R)this.readValue(transactionId, startTime, copies);
        }
        throw new UnsupportedOperationException("class of type class=" + rClass + " is not " + "supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <R> R fetchObject(Class<R> rClass, @NotNull EventId eventId, K key, V value1, V value2) {
        long transactionId;
        ThreadLocalCopies copies;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            copies = this.writeKey(key);
            copies = this.writeValue(value1, copies);
            copies = this.writeValue(value2, copies);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        if (this.eventReturnsNull(eventId)) {
            return null;
        }
        if (rClass == this.vClass) {
            return (R)this.readValue(transactionId, startTime, copies);
        }
        throw new UnsupportedOperationException("class of type class=" + rClass + " is not " + "supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <R> R fetchObject(Class<R> rClass, @NotNull EventId eventId, K key) {
        long transactionId;
        ThreadLocalCopies copies;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            copies = this.writeKey(key);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        if (this.eventReturnsNull(eventId)) {
            return null;
        }
        if (rClass == this.vClass) {
            return (R)this.readValue(transactionId, startTime, copies);
        }
        throw new UnsupportedOperationException("class of type class=" + rClass + " is not " + "supported");
    }

    private boolean eventReturnsNull(@NotNull EventId eventId) {
        switch (eventId) {
            case PUT_ALL_WITHOUT_ACC: 
            case PUT_WITHOUT_ACC: 
            case REMOVE_WITHOUT_ACC: {
                return true;
            }
        }
        return false;
    }

    private void writeObject(@NotNull Object function) {
        long start = this.outBytes.position();
        while (true) {
            try {
                this.outBytes.writeObject(function);
                return;
            }
            catch (IllegalStateException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException && cause.getMessage().contains("Not enough available space")) {
                    LOG.debug("resizing buffer");
                    this.resizeBufferOutBuffer(this.outBuffer.capacity() + this.maxEntrySize, start);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <R> R fetchObject(@NotNull EventId eventId, K key, @NotNull Object object) {
        long transactionId;
        long startTime = System.currentTimeMillis();
        this.outBytesLock.lock();
        try {
            long sizeLocation = this.writeEventAnSkip(eventId);
            this.writeKey(key);
            this.writeObject(object);
            transactionId = this.send(sizeLocation, startTime);
        }
        finally {
            this.outBytesLock.unlock();
        }
        if (this.eventReturnsNull(eventId)) {
            return null;
        }
        return (R)this.readObject(transactionId, startTime);
    }

    class Entry
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K k1, V v) {
            this.value = v;
            this.key = k1;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            StatelessChronicleMap.this.put(this.getKey(), newValue);
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @NotNull
        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    static enum EventId {
        HEARTBEAT,
        STATEFUL_UPDATE,
        LONG_SIZE,
        SIZE,
        IS_EMPTY,
        CONTAINS_KEY,
        CONTAINS_VALUE,
        GET,
        PUT,
        PUT_WITHOUT_ACC,
        REMOVE,
        REMOVE_WITHOUT_ACC,
        CLEAR,
        KEY_SET,
        VALUES,
        ENTRY_SET,
        REPLACE,
        REPLACE_WITH_OLD_AND_NEW_VALUE,
        PUT_IF_ABSENT,
        REMOVE_WITH_VALUE,
        TO_STRING,
        PUT_ALL,
        PUT_ALL_WITHOUT_ACC,
        HASH_CODE,
        MAP_FOR_KEY,
        PUT_MAPPED;

    }
}

