/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.Hasher;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;

public enum IntegerMarshaller implements BytesInterop<Integer>,
BytesReader<Integer>,
SizeMarshaller
{
    INSTANCE;


    @Override
    public long size(Integer e) {
        return 4L;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
    }

    @Override
    public boolean startsWith(Bytes bytes, Integer e) {
        return e.intValue() == bytes.readInt(bytes.position());
    }

    @Override
    public long hash(Integer e) {
        return Hasher.hash(e);
    }

    @Override
    public void write(Bytes bytes, Integer e) {
        bytes.writeInt(e.intValue());
    }

    @Override
    public long readSize(Bytes bytes) {
        return 4L;
    }

    @Override
    public Integer read(Bytes bytes, long size) {
        return bytes.readInt();
    }

    @Override
    public Integer read(Bytes bytes, long size, Integer toReuse) {
        return bytes.readInt();
    }
}

