/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import shaded.org.apache.maven.model.Model;
import shaded.org.apache.maven.model.io.xpp3.MavenXpp3Reader;

class BuildVersion {
    BuildVersion() {
    }

    public static String readVersion() {
        String version = BuildVersion.getVersionFromManifest();
        if (version != null) {
            return version;
        }
        return BuildVersion.getVersionFromPom();
    }

    private static String getVersionFromManifest() {
        return ChronicleMapBuilder.class.getPackage().getImplementationVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersionFromPom() {
        String absolutePath = new File(BuildVersion.class.getResource(BuildVersion.class.getSimpleName() + ".class").getPath()).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getAbsolutePath();
        File file = new File(absolutePath + "/pom.xml");
        try (FileReader reader = new FileReader(file);){
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            Model model = xpp3Reader.read((Reader)reader);
            String string = model.getVersion();
            return string;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

