/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.internal.CopyingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DataValueMetaBytesInterop;
import net.openhft.lang.io.BoundsCheckingNativeBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.threadlocal.StatefulCopyable;

class DirectBytesBuffer
implements StatefulCopyable<DirectBytesBuffer>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Serializable identity;
    transient DirectBytes buffer;
    transient BoundsCheckingNativeBytes checkingBuffer;
    transient ForBytesMarshaller forBytesMarshaller;
    transient ForBytesWriter forBytesWriter;
    transient ForDataValueWriter forDataValueWriter;

    DirectBytesBuffer(Serializable identity) {
        this.identity = identity;
        this.initTransients();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.forBytesMarshaller = new ForBytesMarshaller();
        this.forBytesWriter = new ForBytesWriter();
        this.forDataValueWriter = new ForDataValueWriter();
    }

    Bytes obtain(long maxSize, boolean boundsChecking) {
        DirectBytes buf = this.buffer;
        if (buf != null) {
            if (maxSize <= buf.capacity()) {
                if (!boundsChecking) {
                    return buf.clear();
                }
                BoundsCheckingNativeBytes checkingBuf = this.checkingBuffer;
                if (checkingBuf != null) {
                    return checkingBuf.clear();
                }
                this.checkingBuffer = new BoundsCheckingNativeBytes((NativeBytes)buf);
                return this.checkingBuffer.clear();
            }
            DirectStore store = (DirectStore)buf.store();
            store.resize(maxSize, true);
            buf = this.buffer = store.bytes();
            if (!boundsChecking) {
                return buf;
            }
            this.checkingBuffer = new BoundsCheckingNativeBytes((NativeBytes)buf);
            return this.checkingBuffer;
        }
        buf = this.buffer = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, Math.max(1L, maxSize), true).bytes();
        if (!boundsChecking) {
            return buf;
        }
        this.checkingBuffer = new BoundsCheckingNativeBytes((NativeBytes)buf);
        return this.checkingBuffer;
    }

    public Object stateIdentity() {
        return this.identity;
    }

    public DirectBytesBuffer copy() {
        return new DirectBytesBuffer(this.identity);
    }

    class ForDataValueWriter<E>
    extends DataValueMetaBytesInterop<E> {
        private ForDataValueWriter() {
            super(DirectBytesBuffer.this);
        }
    }

    class ForBytesWriter<E, W extends BytesWriter<E>>
    extends CopyingMetaBytesInterop<E, W> {
        private static final long serialVersionUID = 0L;

        private ForBytesWriter() {
            super(DirectBytesBuffer.this);
        }

        void init(W writer, E e, boolean mutable) {
            if (mutable || writer != this.writer || e != this.cur) {
                this.writer = writer;
                this.cur = e;
                long size = writer.size(e);
                Bytes buffer = this.buffer.obtain(size, false);
                writer.write(buffer, e);
                buffer.flip();
                this.size = size;
                assert (size == buffer.remaining());
                this.hash = 0L;
            }
        }
    }

    class ForBytesMarshaller<E, M extends BytesMarshaller<E>>
    extends CopyingMetaBytesInterop<E, M> {
        private static final long serialVersionUID = 0L;

        private ForBytesMarshaller() {
            super(DirectBytesBuffer.this);
        }

        void init(M writer, E e, boolean mutable, long maxSize) {
            if (mutable || writer != this.writer || e != this.cur) {
                this.writer = writer;
                this.cur = e;
                while (true) {
                    try {
                        Bytes buffer = this.buffer.obtain(maxSize, true);
                        writer.write(buffer, e);
                        buffer.flip();
                        long size = this.size = buffer.remaining();
                        this.buffer.buffer.position(0L);
                        this.buffer.buffer.limit(size);
                        this.hash = 0L;
                        return;
                    }
                    catch (Exception ex) {
                        ForBytesMarshaller.checkMaxSizeStillReasonable(maxSize, ex);
                        maxSize *= 2L;
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

