/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ChannelProvider;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.ChronicleHashErrorListeners;
import net.openhft.chronicle.hash.ReplicationConfig;
import net.openhft.chronicle.hash.StatelessBuilder;
import net.openhft.chronicle.hash.TcpReplicationConfig;
import net.openhft.chronicle.hash.TimeProvider;
import net.openhft.chronicle.hash.UdpReplicationConfig;
import net.openhft.chronicle.hash.serialization.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.MetaProvider;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.KeyValueSerializer;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapEventListeners;
import net.openhft.chronicle.map.NullValueProvider;
import net.openhft.chronicle.map.Objects;
import net.openhft.chronicle.map.PrepareValueBytes;
import net.openhft.chronicle.map.PrepareValueBytesAsWriter;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.Replicator;
import net.openhft.chronicle.map.Replicators;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.UdpReplicator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.lang.Maths;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChronicleMapBuilder<K, V, B extends AbstractChronicleMapBuilder<K, V, B>>
implements Cloneable,
ChronicleHashBuilder<K, ChronicleMap<K, V>, B> {
    private static final Bytes EMPTY_BYTES = new ByteBufferBytes(ByteBuffer.allocate(0));
    private static final int DEFAULT_KEY_OR_VALUE_SIZE = 120;
    private static final int MAX_SEGMENTS = 0x40000000;
    private static final int MAX_SEGMENTS_TO_CHAISE_COMPACT_MULTI_MAPS = 0x100000;
    static final short UDP_REPLICATION_MODIFICATION_ITERATOR_ID = 128;
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractChronicleMapBuilder.class.getName());
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    private Map<Class<? extends Replicator>, Replicator> replicators = new HashMap<Class<? extends Replicator>, Replicator>();
    private int minSegments = -1;
    private int actualSegments = -1;
    private long actualEntriesPerSegment = -1L;
    private int keySize = 0;
    private K sampleKey;
    private int valueSize = 0;
    private V sampleValue;
    private int entrySize = 0;
    private Alignment alignment = Alignment.NO_ALIGNMENT;
    private long entries = 0x100000L;
    private long lockTimeOut = 2000L;
    private TimeUnit lockTimeOutUnit = TimeUnit.MILLISECONDS;
    private int metaDataBytes = 0;
    private ChronicleHashErrorListener errorListener = ChronicleHashErrorListeners.logging();
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private TimeProvider timeProvider = TimeProvider.SYSTEM;
    private BytesMarshallerFactory bytesMarshallerFactory;
    private ObjectSerializer objectSerializer;
    private MapEventListener<K, V, ChronicleMap<K, V>> eventListener = MapEventListeners.nop();
    private V defaultValue = null;
    private DefaultValueProvider<K, V> defaultValueProvider = NullValueProvider.INSTANCE;
    private PrepareValueBytes<K> prepareValueBytes = null;
    private byte identifier = (byte)-1;
    private StatelessBuilder statelessBuilder;
    private File file;

    AbstractChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass, SerializationBuilder.Role.KEY);
        this.valueBuilder = new SerializationBuilder<V>(valueClass, SerializationBuilder.Role.VALUE);
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        long roundUp = headerSize + 127L & 0xFFFFFFFFFFFFFF80L;
        if (roundUp - headerSize < 64L) {
            roundUp += 128L;
        }
        return roundUp;
    }

    @Override
    public B clone() {
        try {
            AbstractChronicleMapBuilder result = (AbstractChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            return (B)result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    abstract B self();

    @Override
    public B keySize(int keySize) {
        if (keySize <= 0) {
            throw new IllegalArgumentException("Key size must be positive");
        }
        this.keySize = keySize;
        return this.self();
    }

    @Override
    public B constantKeySizeBySample(K sampleKey) {
        this.sampleKey = sampleKey;
        return this.self();
    }

    private int keySize() {
        return this.keyOrValueSize(this.keySize, this.keyBuilder);
    }

    B valueSize(int valueSize) {
        if (valueSize <= 0) {
            throw new IllegalArgumentException("Value size must be positive");
        }
        this.valueSize = valueSize;
        return this.self();
    }

    B constantValueSizeBySample(V sampleValue) {
        this.sampleValue = sampleValue;
        return this.self();
    }

    int valueSize() {
        return this.keyOrValueSize(this.valueSize, this.valueBuilder);
    }

    private int keyOrValueSize(int configuredSize, SerializationBuilder builder) {
        if (configuredSize > 0) {
            return configuredSize;
        }
        if (builder.sizeMarshaller().sizeEncodingSize(0L) == 0) {
            return (int)builder.sizeMarshaller().readSize(EMPTY_BYTES);
        }
        return 120;
    }

    @Override
    public B entrySize(int entrySize) {
        if (entrySize <= 0) {
            throw new IllegalArgumentException("Entry Size must be positive");
        }
        this.entrySize = entrySize;
        return this.self();
    }

    int entrySize() {
        if (this.entrySize > 0) {
            return this.entryAndValueAlignment().alignSize(this.entrySize);
        }
        int size = this.metaDataBytes;
        int keySize = this.keySize();
        size += this.keyBuilder.sizeMarshaller().sizeEncodingSize(keySize);
        size += keySize;
        if (this.useReplication()) {
            size += 10;
        }
        int valueSize = this.valueSize();
        size += this.valueBuilder.sizeMarshaller().sizeEncodingSize(valueSize);
        size = this.entryAndValueAlignment().alignSize(size);
        size += valueSize;
        for (int i = 1; i <= 4; ++i) {
            int bound = i * 64;
            if (size >= bound || bound - size > bound / 20) continue;
            size = bound;
            break;
        }
        return this.entryAndValueAlignment().alignSize(size);
    }

    B entryAndValueAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this.self();
    }

    Alignment entryAndValueAlignment() {
        return this.alignment;
    }

    @Override
    public B entries(long entries) {
        if (entries <= 0L) {
            throw new IllegalArgumentException("Entries should be positive, " + entries + " given");
        }
        this.entries = entries;
        return this.self();
    }

    long entries() {
        return this.entries;
    }

    @Override
    public B actualEntriesPerSegment(long actualEntriesPerSegment) {
        if (actualEntriesPerSegment <= 0L) {
            throw new IllegalArgumentException("entries per segment should be positive, " + actualEntriesPerSegment + " given");
        }
        if (this.tooManyEntriesPerSegment(actualEntriesPerSegment)) {
            throw new IllegalArgumentException("max entries per segment is 4294967296, " + actualEntriesPerSegment + " given");
        }
        this.actualEntriesPerSegment = actualEntriesPerSegment;
        return this.self();
    }

    private boolean tooManyEntriesPerSegment(long entriesPerSegment) {
        return entriesPerSegment > 0x100000000L;
    }

    long actualEntriesPerSegment() {
        if (this.actualEntriesPerSegment > 0L) {
            return this.actualEntriesPerSegment;
        }
        int actualSegments = this.actualSegments();
        long actualEntries = this.totalEntriesIfPoorDistribution(actualSegments);
        long actualEntriesPerSegment = AbstractChronicleMapBuilder.divideUpper(actualEntries, actualSegments);
        if (this.tooManyEntriesPerSegment(actualEntriesPerSegment)) {
            throw new IllegalStateException("max entries per segment is 4294967296 configured entries() and actualSegments() so that there should be " + actualEntriesPerSegment + " entries per segment");
        }
        return actualEntriesPerSegment;
    }

    private long totalEntriesIfPoorDistribution(int segments) {
        if (segments == 1) {
            return this.entries;
        }
        double poorDistEntriesScale = Math.log(segments) * (double)this.entries;
        if (segments <= 8) {
            return Math.min(this.entries * (long)segments, (long)((double)this.entries + poorDistEntriesScale * 0.08 + 64.0));
        }
        return (long)((double)this.entries + poorDistEntriesScale * 0.11 + 80.0);
    }

    @Override
    public B minSegments(int minSegments) {
        AbstractChronicleMapBuilder.checkSegments(minSegments);
        this.minSegments = minSegments;
        return this.self();
    }

    int minSegments() {
        return Math.max(this.estimateSegments(), this.minSegments);
    }

    private int estimateSegments() {
        for (int power = 0; power < 7; ++power) {
            if (this.entries >= 1L << 7 + 2 * power) continue;
            return 1 << power;
        }
        int maxSegments = 65536;
        for (int segments = 4; segments < maxSegments; segments <<= 1) {
            if ((long)segments * (long)segments * (long)segments < this.entries) continue;
            return segments;
        }
        return maxSegments;
    }

    @Override
    public B actualSegments(int actualSegments) {
        AbstractChronicleMapBuilder.checkSegments(actualSegments);
        this.actualSegments = actualSegments;
        return this.self();
    }

    private static void checkSegments(int segments) {
        if (segments <= 0 || segments > 0x40000000) {
            throw new IllegalArgumentException("segments should be positive, " + segments + " given");
        }
        if (segments > 0x40000000) {
            throw new IllegalArgumentException("Max segments is 1073741824, " + segments + " given");
        }
    }

    int actualSegments() {
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        long shortMMapSegments = this.trySegments(65536L, 0x100000);
        if (shortMMapSegments > 0L) {
            return (int)shortMMapSegments;
        }
        long intMMapSegments = this.trySegments(0x100000000L, 0x40000000);
        if (intMMapSegments > 0L) {
            return (int)intMMapSegments;
        }
        throw new IllegalStateException("Max segments is 1073741824, configured so much entries() that builder automatically decided to use " + -intMMapSegments + " segments");
    }

    private long trySegments(long maxSegmentCapacity, int maxSegments) {
        long segments = AbstractChronicleMapBuilder.divideUpper(this.totalEntriesIfPoorDistribution(this.minSegments()), maxSegmentCapacity);
        return (segments = Maths.nextPower2((long)Math.max(segments, (long)this.minSegments()), (long)1L)) <= (long)maxSegments ? segments : -segments;
    }

    private static long divideUpper(long dividend, long divisor) {
        return (dividend - 1L) / divisor + 1L;
    }

    private boolean canSupportShortShort() {
        return this.entries > (long)this.minSegments() << 15;
    }

    @Override
    public B lockTimeOut(long lockTimeOut, TimeUnit unit) {
        this.lockTimeOut = lockTimeOut;
        this.lockTimeOutUnit = unit;
        return this.self();
    }

    long lockTimeOut(TimeUnit unit) {
        return unit.convert(this.lockTimeOut, this.lockTimeOutUnit);
    }

    @Override
    public B errorListener(ChronicleHashErrorListener errorListener) {
        this.errorListener = errorListener;
        return this.self();
    }

    ChronicleHashErrorListener errorListener() {
        return this.errorListener;
    }

    public B putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this.self();
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public B removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this.self();
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public B metaDataBytes(int metaDataBytes) {
        if ((metaDataBytes & 0xFF) != metaDataBytes) {
            throw new IllegalArgumentException("MetaDataBytes must be [0..255] was " + metaDataBytes);
        }
        this.metaDataBytes = metaDataBytes;
        return this.self();
    }

    int metaDataBytes() {
        return this.metaDataBytes;
    }

    public String toString() {
        return "ChronicleMapBuilder{actualSegments=" + AbstractChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + AbstractChronicleMapBuilder.pretty(this.minSegments) + ", actualEntriesPerSegment=" + AbstractChronicleMapBuilder.pretty(this.actualEntriesPerSegment) + ", keySize=" + AbstractChronicleMapBuilder.pretty(this.keySize) + ", sampleKeyForConstantSizeComputation=" + AbstractChronicleMapBuilder.pretty(this.sampleKey) + ", valueSize=" + AbstractChronicleMapBuilder.pretty(this.valueSize) + ", sampleValueForConstantSizeComputation=" + AbstractChronicleMapBuilder.pretty(this.sampleValue) + ", entrySize=" + AbstractChronicleMapBuilder.pretty(this.entrySize) + ", entryAndValueAlignment=" + (Object)((Object)this.entryAndValueAlignment()) + ", entries=" + this.entries() + ", lockTimeOut=" + this.lockTimeOut + " " + (Object)((Object)this.lockTimeOutUnit) + ", metaDataBytes=" + this.metaDataBytes() + ", errorListener=" + this.errorListener() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", timeProvider=" + this.timeProvider() + ", bytesMarshallerFactory=" + AbstractChronicleMapBuilder.pretty(this.bytesMarshallerFactory) + ", objectSerializer=" + AbstractChronicleMapBuilder.pretty(this.objectSerializer) + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + ", eventListener=" + this.eventListener + ", defaultValue=" + this.defaultValue + ", defaultValueProvider=" + AbstractChronicleMapBuilder.pretty(this.defaultValueProvider) + ", prepareValueBytes=" + AbstractChronicleMapBuilder.pretty(this.prepareValueBytes) + '}';
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public B replicators(byte identifier, ReplicationConfig ... replicationConfigs) {
        this.identifier = identifier;
        this.replicators.clear();
        for (ReplicationConfig replicationConfig : replicationConfigs) {
            Replicator replicator;
            if (replicationConfig instanceof TcpReplicationConfig) {
                replicator = Replicators.tcp((TcpReplicationConfig)replicationConfig);
            } else if (replicationConfig instanceof UdpReplicationConfig) {
                replicator = Replicators.udp((UdpReplicationConfig)replicationConfig);
            } else {
                throw new UnsupportedOperationException();
            }
            this.replicators.put(replicator.getClass(), replicator);
        }
        return this.self();
    }

    @Override
    public B channel(ChannelProvider.ChronicleChannel chronicleChannel) {
        this.identifier = chronicleChannel.identifier();
        this.replicators.clear();
        this.replicators.put(chronicleChannel.getClass(), chronicleChannel);
        return this.self();
    }

    @Override
    public B disableReplication() {
        this.identifier = (byte)-1;
        this.replicators.clear();
        return this.self();
    }

    @Override
    public B timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return this.self();
    }

    TimeProvider timeProvider() {
        return this.timeProvider;
    }

    BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory == null ? (this.bytesMarshallerFactory = new VanillaBytesMarshallerFactory()) : this.bytesMarshallerFactory;
    }

    @Override
    public B bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        return this.self();
    }

    ObjectSerializer objectSerializer() {
        return this.objectSerializer == null ? (this.objectSerializer = BytesMarshallableSerializer.create((BytesMarshallerFactory)this.bytesMarshallerFactory(), (ObjectSerializer)JDKObjectSerializer.INSTANCE)) : this.objectSerializer;
    }

    @Override
    public B objectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
        return this.self();
    }

    @Override
    public B keyMarshaller(@NotNull BytesMarshaller<K> keyMarshaller) {
        this.keyBuilder.marshaller(keyMarshaller, null);
        return this.self();
    }

    @Override
    public B keyDeserializationFactory(@NotNull ObjectFactory<K> keyDeserializationFactory) {
        this.keyBuilder.factory(keyDeserializationFactory);
        return this.self();
    }

    @Override
    public B immutableKeys() {
        this.keyBuilder.instancesAreMutable(false);
        return this.self();
    }

    @Override
    public B stateless(@NotNull StatelessBuilder statelessBuilder) {
        this.statelessBuilder = statelessBuilder;
        return this.self();
    }

    @Override
    public B file(File file) throws IOException {
        this.file = file;
        return this.self();
    }

    public B valueDeserializationFactory(@NotNull ObjectFactory<V> valueDeserializationFactory) {
        this.valueBuilder.factory(valueDeserializationFactory);
        return this.self();
    }

    public B eventListener(MapEventListener<K, V, ChronicleMap<K, V>> eventListener) {
        this.eventListener = eventListener;
        return this.self();
    }

    MapEventListener<K, V, ChronicleMap<K, V>> eventListener() {
        return this.eventListener;
    }

    public B defaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
        this.defaultValueProvider = null;
        if (defaultValue == null) {
            this.defaultValueProvider = NullValueProvider.INSTANCE;
        }
        this.prepareValueBytes = null;
        return this.self();
    }

    public B defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        this.defaultValueProvider = defaultValueProvider;
        this.defaultValue = null;
        this.prepareValueBytes = null;
        return this.self();
    }

    B prepareValueBytesOnAcquire(@NotNull PrepareValueBytes<K> prepareValueBytes) {
        this.prepareValueBytes = prepareValueBytes;
        this.defaultValue = null;
        this.defaultValueProvider = null;
        return this.self();
    }

    PrepareValueBytesAsWriter<K> prepareValueBytesAsWriter() {
        return new PrepareValueBytesAsWriter<K>(this.prepareValueBytes, this.valueSize());
    }

    DefaultValueProvider<K, V> defaultValueProvider() {
        if (this.defaultValueProvider != null) {
            return this.defaultValueProvider;
        }
        if (this.defaultValue == null) {
            return null;
        }
        Object originalValueWriter = this.valueBuilder.interop();
        Provider writerProvider = Provider.of(originalValueWriter.getClass());
        ThreadLocalCopies copies = writerProvider.getCopies(null);
        Object valueWriter = writerProvider.get(copies, originalValueWriter);
        MetaProvider<V, ?, MetaBytesInterop<V, ?>> metaWriterProvider = this.valueBuilder.metaInteropProvider();
        copies = metaWriterProvider.getCopies(copies);
        MetaBytesInterop<V, ?> metaValueWriter = metaWriterProvider.get(copies, this.valueBuilder.metaInterop(), valueWriter, this.defaultValue);
        return new ConstantValueProvider(this.defaultValue, metaValueWriter, valueWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChronicleMap<K, V> createWithFile(File file) throws IOException {
        for (int i = 0; i < 10; ++i) {
            if (file.exists() && file.length() > 0L) {
                FileInputStream fis = new FileInputStream(file);
                try (ObjectInputStream ois = new ObjectInputStream(fis);){
                    VanillaChronicleMap map = (VanillaChronicleMap)ois.readObject();
                    map.headerSize = AbstractChronicleMapBuilder.roundUpMapHeaderSize(fis.getChannel().position());
                    map.createMappedStoreAndSegments(file);
                    ChronicleMap<K, V> chronicleMap = this.establishReplication(map);
                    return chronicleMap;
                }
            }
            if (file.createNewFile() || file.length() == 0L) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to create " + file);
        }
        VanillaChronicleMap<K, ?, ?, V, ?, ?> map = this.newMap();
        FileOutputStream fos = new FileOutputStream(file);
        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(map);
            oos.flush();
            map.headerSize = AbstractChronicleMapBuilder.roundUpMapHeaderSize(fos.getChannel().position());
            map.createMappedStoreAndSegments(file);
        }
        return this.establishReplication(map);
    }

    @Override
    public ChronicleMap<K, V> create() throws IOException {
        if (this.statelessBuilder != null) {
            return this.createStatelessMap(this.statelessBuilder);
        }
        return this.file != null ? this.createWithFile(this.file) : this.createWithoutFile();
    }

    private ChronicleMap<K, V> createWithoutFile() throws IOException {
        VanillaChronicleMap<K, ?, ?, V, ?, ?> map = this.newMap();
        DirectStore bytesStore = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, map.sizeInBytes(), true);
        map.createMappedStoreAndSegments((BytesStore)bytesStore);
        return this.establishReplication(map);
    }

    private ChronicleMap<K, V> createStatelessMap(StatelessBuilder statelessBuilder) throws IOException {
        this.preMapConstruction();
        KeyValueSerializer<K, V> keyValueSerializer = new KeyValueSerializer<K, V>(this.keyBuilder, this.valueBuilder);
        Class kClass = this.keyBuilder.eClass;
        Class vClass = this.valueBuilder.eClass;
        return new StatelessChronicleMap<K, V>(keyValueSerializer, statelessBuilder, this.entrySize(), kClass, vClass);
    }

    private VanillaChronicleMap<K, ?, ?, V, ?, ?> newMap() throws IOException {
        this.preMapConstruction();
        if (this.useReplication()) {
            return new ReplicatedChronicleMap(this);
        }
        return new VanillaChronicleMap(this);
    }

    private boolean useReplication() {
        return this.identifier != -1;
    }

    void preMapConstruction() {
        this.keyBuilder.objectSerializer(this.objectSerializer());
        this.valueBuilder.objectSerializer(this.objectSerializer());
        long maxSize = (long)this.entrySize() * (long)this.figureBufferAllocationFactor();
        this.keyBuilder.maxSize(maxSize);
        this.valueBuilder.maxSize(maxSize);
        if (this.sampleKey != null) {
            this.keyBuilder.constantSizeBySample(this.sampleKey);
        }
        if (this.sampleValue != null) {
            this.valueBuilder.constantSizeBySample(this.sampleValue);
        }
    }

    private ChronicleMap<K, V> establishReplication(VanillaChronicleMap<K, ?, ?, V, ?, ?> map) throws IOException {
        if (map instanceof ReplicatedChronicleMap) {
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            for (Replicator replicator : this.replicators.values()) {
                if (replicator instanceof ChannelProvider.ChronicleChannel) {
                    ChannelProvider.ChronicleChannel channel = (ChannelProvider.ChronicleChannel)replicator;
                    if (this.entrySize() > channel.provider().maxEntrySize()) {
                        throw new IllegalArgumentException("During ChannelProviderBuilder setup, maxEntrySize=" + channel.provider().maxEntrySize() + " was specified, but map with " + "entrySize=" + this.entrySize() + " is attempted to apply" + "to the replicator");
                    }
                }
                Closeable token = replicator.applyTo(this, result, result, map);
                if (this.replicators.size() == 1 && token.getClass() == UdpReplicator.class) {
                    LOG.warn("MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator");
                }
                result.addCloseable(token);
            }
        }
        return map;
    }

    private int figureBufferAllocationFactor() {
        return (int)Math.min(Math.max(2L, this.entries() >> 10), 64L);
    }

    public byte identifier() {
        return this.identifier;
    }
}

