/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.channels.FileChannel;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.ChronicleHashErrorListener;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.Hasher;
import net.openhft.chronicle.hash.serialization.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.MetaBytesWriter;
import net.openhft.chronicle.hash.serialization.MetaProvider;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.map.AbstractChronicleMapBuilder;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.HashSplitting;
import net.openhft.chronicle.map.MapEventListener;
import net.openhft.chronicle.map.MapEventListeners;
import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.PrepareValueBytesAsWriter;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.SharedSegment;
import net.openhft.chronicle.map.VanillaIntIntMultiMap;
import net.openhft.chronicle.map.VanillaShortShortMultiMap;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.MappedStore;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;

class VanillaChronicleMap<K, KI, MKI extends MetaBytesInterop<K, KI>, V, VW, MVW extends MetaBytesWriter<V, VW>>
extends AbstractMap<K, V>
implements ChronicleMap<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;
    static final int MAX_ENTRY_OVERSIZE_FACTOR = 64;
    private static final int SEGMENT_HEADER = 64;
    final Class<K> kClass;
    final SizeMarshaller keySizeMarshaller;
    final BytesReader<K> originalKeyReader;
    transient Provider<BytesReader<K>> keyReaderProvider;
    final KI originalKeyInterop;
    transient Provider<KI> keyInteropProvider;
    final MKI originalMetaKeyInterop;
    final MetaProvider<K, KI, MKI> metaKeyInteropProvider;
    final Class<V> vClass;
    final SizeMarshaller valueSizeMarshaller;
    final BytesReader<V> originalValueReader;
    transient Provider<BytesReader<V>> valueReaderProvider;
    final VW originalValueWriter;
    transient Provider<VW> valueWriterProvider;
    final MVW originalMetaValueWriter;
    final MetaProvider<V, VW, MVW> metaValueWriterProvider;
    final ObjectFactory<V> valueFactory;
    final DefaultValueProvider<K, V> defaultValueProvider;
    final PrepareValueBytesAsWriter<K> prepareValueBytesAsWriter;
    final int metaDataBytes;
    final long entrySize;
    final Alignment alignment;
    final int actualSegments;
    final long entriesPerSegment;
    final MapEventListener<K, V, ChronicleMap<K, V>> eventListener;
    final boolean putReturnsNull;
    final boolean removeReturnsNull;
    private final long lockTimeOutNS;
    private final ChronicleHashErrorListener errorListener;
    transient Segment[] segments;
    transient BytesStore ms;
    transient long headerSize;
    transient Set<Map.Entry<K, V>> entrySet;
    private final HashSplitting hashSplitting;
    static final ThreadLocal<MultiStoreBytes> tmpBytes = new ThreadLocal();

    public VanillaChronicleMap(AbstractChronicleMapBuilder<K, V, ?> builder) throws IOException {
        SerializationBuilder keyBuilder = builder.keyBuilder;
        this.kClass = keyBuilder.eClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.originalKeyReader = keyBuilder.reader();
        this.originalKeyInterop = keyBuilder.interop();
        this.originalMetaKeyInterop = keyBuilder.metaInterop();
        this.metaKeyInteropProvider = keyBuilder.metaInteropProvider();
        SerializationBuilder valueBuilder = builder.valueBuilder;
        this.vClass = valueBuilder.eClass;
        this.valueSizeMarshaller = valueBuilder.sizeMarshaller();
        this.originalValueReader = valueBuilder.reader();
        this.originalValueWriter = valueBuilder.interop();
        this.originalMetaValueWriter = valueBuilder.metaInterop();
        this.metaValueWriterProvider = valueBuilder.metaInteropProvider();
        this.valueFactory = valueBuilder.factory();
        this.defaultValueProvider = builder.defaultValueProvider();
        this.prepareValueBytesAsWriter = builder.prepareValueBytesAsWriter();
        this.lockTimeOutNS = builder.lockTimeOut(TimeUnit.NANOSECONDS);
        this.entrySize = builder.entrySize();
        this.alignment = builder.entryAndValueAlignment();
        this.errorListener = builder.errorListener();
        this.putReturnsNull = builder.putReturnsNull();
        this.removeReturnsNull = builder.removeReturnsNull();
        this.actualSegments = builder.actualSegments();
        this.entriesPerSegment = builder.actualEntriesPerSegment();
        this.metaDataBytes = builder.metaDataBytes();
        this.eventListener = builder.eventListener();
        this.hashSplitting = HashSplitting.Splitting.forSegments(this.actualSegments);
        this.initTransients();
    }

    long segmentHash(long hash) {
        return this.hashSplitting.segmentHash(hash);
    }

    int getSegment(long hash) {
        return this.hashSplitting.segmentIndex(hash);
    }

    void initTransients() {
        ConstantValueProvider constantValueProvider;
        this.keyReaderProvider = Provider.of(this.originalKeyReader.getClass());
        this.keyInteropProvider = Provider.of(this.originalKeyInterop.getClass());
        this.valueReaderProvider = Provider.of(this.originalValueReader.getClass());
        this.valueWriterProvider = Provider.of(this.originalValueWriter.getClass());
        if (this.defaultValueProvider instanceof ConstantValueProvider && (constantValueProvider = (ConstantValueProvider)this.defaultValueProvider).wasDeserialized()) {
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, this.originalValueReader);
            constantValueProvider.initTransients(valueReader);
        }
        Segment[] ss = (Segment[])Array.newInstance(this.segmentType(), this.actualSegments);
        this.segments = ss;
    }

    Class segmentType() {
        return Segment.class;
    }

    long createMappedStoreAndSegments(BytesStore bytesStore) throws IOException {
        this.ms = bytesStore;
        this.onHeaderCreated();
        long offset = this.getHeaderSize();
        long segmentSize = this.segmentSize();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment((NativeBytes)this.ms.bytes(offset, segmentSize), i);
            offset += segmentSize;
        }
        return offset;
    }

    long createMappedStoreAndSegments(File file) throws IOException {
        return this.createMappedStoreAndSegments((BytesStore)new MappedStore(file, FileChannel.MapMode.READ_WRITE, this.sizeInBytes(), (ObjectSerializer)JDKObjectSerializer.INSTANCE));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    void onHeaderCreated() {
    }

    long getHeaderSize() {
        return this.headerSize;
    }

    Segment createSegment(NativeBytes bytes, int index) {
        return new Segment(bytes, index);
    }

    @Override
    public File file() {
        return this.ms.file();
    }

    long sizeInBytes() {
        return this.getHeaderSize() + (long)this.segments.length * this.segmentSize();
    }

    long sizeOfMultiMap() {
        return this.useSmallMultiMaps() ? VanillaShortShortMultiMap.sizeInBytes(this.entriesPerSegment) : VanillaIntIntMultiMap.sizeInBytes(this.entriesPerSegment);
    }

    long sizeOfMultiMapBitSet() {
        return this.useSmallMultiMaps() ? VanillaShortShortMultiMap.sizeOfBitSetInBytes(this.entriesPerSegment) : VanillaIntIntMultiMap.sizeOfBitSetInBytes(this.entriesPerSegment);
    }

    boolean useSmallMultiMaps() {
        return this.entriesPerSegment <= 65536L;
    }

    long sizeOfBitSets() {
        return MemoryUnit.CACHE_LINES.align(MemoryUnit.BYTES.alignAndConvert(this.entriesPerSegment, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    int numberOfBitSets() {
        return 1;
    }

    long segmentSize() {
        long ss = 64L + MemoryUnit.CACHE_LINES.align(this.sizeOfMultiMap() + this.sizeOfMultiMapBitSet(), MemoryUnit.BYTES) * (long)this.multiMapsPerSegment() + (long)this.numberOfBitSets() * this.sizeOfBitSets() + this.sizeOfEntriesInSegment();
        if ((ss & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        return this.breakL1CacheAssociativityContention(ss);
    }

    private long breakL1CacheAssociativityContention(long segmentSize) {
        int alignmentToBreak = 2048;
        int eachNthSegmentFallIntoTheSameSet = Math.max(1, alignmentToBreak >> Long.numberOfTrailingZeros(segmentSize));
        if (eachNthSegmentFallIntoTheSameSet < this.actualSegments) {
            segmentSize |= 0x40L;
        }
        return segmentSize;
    }

    int multiMapsPerSegment() {
        return 1;
    }

    private long sizeOfEntriesInSegment() {
        return MemoryUnit.CACHE_LINES.align(this.entriesPerSegment * this.entrySize, MemoryUnit.BYTES);
    }

    @Override
    public void close() {
        if (this.ms == null) {
            return;
        }
        this.ms.free();
        this.segments = null;
        this.ms = null;
    }

    MapEventListener<K, V, ChronicleMap<K, V>> eventListener() {
        return this.eventListener;
    }

    void checkKey(Object key) {
        if (!this.kClass.isInstance(key)) {
            throw new ClassCastException("Key must be a " + this.kClass.getName() + " but was a " + key.getClass());
        }
    }

    void checkValue(Object value) {
        if (this.vClass != Void.class && !this.vClass.isInstance(value)) {
            throw new ClassCastException("Value must be a " + this.vClass.getName() + " but was a " + value.getClass());
        }
    }

    @Override
    public V put(K key, V value) {
        return this.put0(key, value, true);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put0(key, value, false);
    }

    private V put0(K key, V value, boolean replaceIfPresent) {
        this.checkKey(key);
        this.checkValue(value);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].put(copies, metaKeyInterop, keyInterop, key, value, segmentHash, replaceIfPresent);
    }

    @Override
    public V get(Object key) {
        return this.lookupUsing(key, null, false);
    }

    @Override
    public V getUsing(K key, V usingValue) {
        return this.lookupUsing(key, usingValue, false);
    }

    @Override
    public V acquireUsing(K key, V usingValue) {
        return this.lookupUsing(key, usingValue, true);
    }

    V lookupUsing(K key, V value, boolean create) {
        this.checkKey(key);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].acquire(copies, metaKeyInterop, keyInterop, key, value, segmentHash, create);
    }

    @Override
    public boolean containsKey(Object k) {
        this.checkKey(k);
        Object key = k;
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].containsKey(keyInterop, metaKeyInterop, key, segmentHash);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public V remove(Object key) {
        return this.removeIfValueIs(key, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        return this.removeIfValueIs(key, value) != null;
    }

    V removeIfValueIs(Object k, V expectedValue) {
        this.checkKey(k);
        Object key = k;
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].remove(copies, metaKeyInterop, keyInterop, key, expectedValue, segmentHash);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkValue(oldValue);
        return oldValue.equals(this.replaceIfValueIs(key, oldValue, newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.replaceIfValueIs(key, null, value);
    }

    @Override
    public long longSize() {
        long result = 0L;
        for (Segment segment : this.segments) {
            result += segment.getSize();
        }
        return result;
    }

    @Override
    public int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    V replaceIfValueIs(@net.openhft.lang.model.constraints.NotNull K key, V existingValue, V newValue) {
        this.checkKey(key);
        this.checkValue(newValue);
        ThreadLocalCopies copies = this.keyInteropProvider.getCopies(null);
        Object keyInterop = this.keyInteropProvider.get(copies, this.originalKeyInterop);
        copies = this.metaKeyInteropProvider.getCopies(copies);
        MetaBytesInterop metaKeyInterop = (MetaBytesInterop)this.metaKeyInteropProvider.get(copies, this.originalMetaKeyInterop, keyInterop, key);
        long hash = metaKeyInterop.hash(keyInterop, key);
        int segmentNum = this.getSegment(hash);
        long segmentHash = this.segmentHash(hash);
        return this.segments[segmentNum].replace(copies, metaKeyInterop, keyInterop, key, existingValue, newValue, segmentHash);
    }

    void checkConsistency() {
        for (Segment segment : this.segments) {
            segment.checkConsistency();
        }
    }

    long readValueSize(Bytes entry) {
        long valueSize = this.valueSizeMarshaller.readSize(entry);
        this.alignment.alignPositionAddr(entry);
        return valueSize;
    }

    protected MultiStoreBytes acquireTmpBytes() {
        MultiStoreBytes b = tmpBytes.get();
        if (b == null) {
            b = new MultiStoreBytes();
            tmpBytes.set(b);
        }
        return b;
    }

    @Override
    void replace(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void isEmpty(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void containsKey(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void containsValue(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void get(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void putAll(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    void put(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    void putIfAbsent(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void replaceKV(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void replaceWithOldAndNew(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    void removeWithValue(Bytes reader, Bytes writer) {
        throw new UnsupportedOperationException("todo");
    }

    long[] segmentSizes() {
        long[] sizes = new long[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            sizes[i] = this.segments[i].getSize();
        }
        return sizes;
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = 0L;

        WriteThroughEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            VanillaChronicleMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object v = VanillaChronicleMap.this.get(e.getKey());
                return v != null && v.equals(e.getValue());
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                Object key = e.getKey();
                Object value = e.getValue();
                return VanillaChronicleMap.this.remove(key, value);
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }

        @Override
        public int size() {
            return VanillaChronicleMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return VanillaChronicleMap.this.isEmpty();
        }

        @Override
        public void clear() {
            VanillaChronicleMap.this.clear();
        }
    }

    class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        Map.Entry<K, V> returnedEntry;
        private int returnedSeg = -1;
        private long returnedPos = -1L;
        private int nextSeg;
        private long nextPos;

        public EntryIterator() {
            this.nextSeg = VanillaChronicleMap.this.segments.length - 1;
            this.nextPos = -1L;
            this.advance(this.nextSeg, -1L);
        }

        private boolean advance(int segIndex, long pos) {
            while (segIndex >= 0) {
                pos = VanillaChronicleMap.this.segments[segIndex].getHashLookup().getPositions().nextSetBit(pos + 1L);
                if (pos >= 0L) {
                    this.nextSeg = segIndex;
                    this.nextPos = pos;
                    return true;
                }
                --segIndex;
                pos = -1L;
            }
            this.nextSeg = -1;
            this.nextPos = -1L;
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.nextSeg >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            while (true) {
                int segIndex = this.nextSeg;
                long pos = this.nextPos;
                if (segIndex < 0) {
                    throw new NoSuchElementException();
                }
                Segment segment = VanillaChronicleMap.this.segments[segIndex];
                try {
                    segment.readLock();
                    if (segment.getHashLookup().getPositions().isClear(pos)) {
                        this.advance(segIndex, pos);
                        continue;
                    }
                    this.returnedSeg = segIndex;
                    this.returnedPos = pos;
                    this.advance(this.returnedSeg, this.returnedPos);
                    this.returnedEntry = segment.getEntry(pos);
                    Map.Entry entry = this.returnedEntry;
                    return entry;
                }
                finally {
                    segment.readUnlock();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int segIndex = this.returnedSeg;
            if (segIndex < 0) {
                throw new IllegalStateException();
            }
            Segment segment = VanillaChronicleMap.this.segments[segIndex];
            long pos = this.returnedPos;
            try {
                segment.writeLock();
                if (segment.getHashLookup().getPositions().isClear(pos)) {
                    segment.writeUnlock();
                    VanillaChronicleMap.this.remove(this.returnedEntry.getKey());
                    segment.writeLock();
                } else {
                    this.removePresent(segment, pos);
                }
                this.returnedSeg = -1;
                this.returnedEntry = null;
            }
            finally {
                segment.writeUnlock();
            }
        }

        void removePresent(Segment segment, long pos) {
            long offset = segment.offsetFromPos(pos);
            MultiStoreBytes entry = segment.entry(offset);
            long limit = entry.limit();
            long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
            long position = entry.position();
            long segmentHash = VanillaChronicleMap.this.segmentHash(Hasher.hash((Bytes)entry, position, position + keySize));
            entry.skip(keySize);
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            segment.getHashLookup().remove(segmentHash, pos);
            segment.decrementSize();
            segment.free(pos, segment.inBlocks(entryEndAddr - segment.entryStartAddr(offset)));
            segment.notifyRemoved(offset, this.returnedEntry.getKey(), this.returnedEntry.getValue(), pos);
        }
    }

    class Segment
    implements SharedSegment {
        static final long LOCK_OFFSET = 0L;
        static final long SIZE_OFFSET = 8L;
        final NativeBytes bytes;
        final long entriesOffset;
        private final int index;
        private final SingleThreadedDirectBitSet freeList;
        private MultiMap hashLookup;
        private long nextPosToSearchFrom = 0L;

        Segment(NativeBytes bytes, int index) {
            this.bytes = bytes;
            this.index = index;
            long start = bytes.startAddr() + 64L;
            this.createHashLookups(start);
            NativeBytes bsBytes = new NativeBytes(VanillaChronicleMap.this.ms.objectSerializer(), start += MemoryUnit.CACHE_LINES.align(VanillaChronicleMap.this.sizeOfMultiMap() + VanillaChronicleMap.this.sizeOfMultiMapBitSet(), MemoryUnit.BYTES) * (long)VanillaChronicleMap.this.multiMapsPerSegment(), start + MemoryUnit.LONGS.align(MemoryUnit.BYTES.alignAndConvert(VanillaChronicleMap.this.entriesPerSegment, MemoryUnit.BITS), MemoryUnit.BYTES), null);
            this.freeList = new SingleThreadedDirectBitSet((Bytes)bsBytes);
            this.entriesOffset = (start += (long)VanillaChronicleMap.this.numberOfBitSets() * VanillaChronicleMap.this.sizeOfBitSets()) - bytes.startAddr();
            assert (bytes.capacity() >= this.entriesOffset + VanillaChronicleMap.this.entriesPerSegment * VanillaChronicleMap.this.entrySize);
        }

        void createHashLookups(long start) {
            this.hashLookup = this.createMultiMap(start);
        }

        public MultiMap getHashLookup() {
            return this.hashLookup;
        }

        MultiMap createMultiMap(long start) {
            NativeBytes multiMapBytes = new NativeBytes((BytesMarshallerFactory)new VanillaBytesMarshallerFactory(), start, start += VanillaChronicleMap.this.sizeOfMultiMap(), null);
            NativeBytes sizeOfMultiMapBitSetBytes = new NativeBytes((BytesMarshallerFactory)new VanillaBytesMarshallerFactory(), start, start + VanillaChronicleMap.this.sizeOfMultiMapBitSet(), null);
            multiMapBytes.load();
            return VanillaChronicleMap.this.useSmallMultiMaps() ? new VanillaShortShortMultiMap((Bytes)multiMapBytes, (Bytes)sizeOfMultiMapBitSetBytes) : new VanillaIntIntMultiMap((Bytes)multiMapBytes, (Bytes)sizeOfMultiMapBitSetBytes);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        void incrementSize() {
            this.bytes.addLong(8L, 1L);
        }

        void resetSize() {
            this.bytes.writeLong(8L, 0L);
        }

        void decrementSize() {
            this.bytes.addLong(8L, -1L);
        }

        long getSize() {
            return Math.max(0L, this.bytes.readVolatileLong(8L));
        }

        @Override
        public void readLock() throws IllegalStateException {
            boolean success;
            while (!(success = this.bytes.tryRWReadLock(0L, VanillaChronicleMap.this.lockTimeOutNS))) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IllegalStateException(new InterruptedException("Unable to obtain lock, interrupted"));
                }
                VanillaChronicleMap.this.errorListener.onLockTimeout(this.bytes.threadIdForLockLong(0L));
                this.bytes.resetLockLong(0L);
            }
            return;
        }

        @Override
        public void writeLock() throws IllegalStateException {
            boolean success;
            while (!(success = this.bytes.tryRWWriteLock(0L, VanillaChronicleMap.this.lockTimeOutNS))) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IllegalStateException(new InterruptedException("Unable to obtain lock, interrupted"));
                }
                VanillaChronicleMap.this.errorListener.onLockTimeout(this.bytes.threadIdForLockLong(0L));
                this.bytes.resetLockLong(0L);
            }
            return;
        }

        @Override
        public void readUnlock() {
            try {
                this.bytes.unlockRWReadLock(0L);
            }
            catch (IllegalMonitorStateException e) {
                VanillaChronicleMap.this.errorListener.errorOnUnlock(e);
            }
        }

        @Override
        public void writeUnlock() {
            try {
                this.bytes.unlockRWWriteLock(0L);
            }
            catch (IllegalMonitorStateException e) {
                VanillaChronicleMap.this.errorListener.errorOnUnlock(e);
            }
        }

        @Override
        public long offsetFromPos(long pos) {
            return this.entriesOffset + pos * VanillaChronicleMap.this.entrySize;
        }

        long posFromOffset(long offset) {
            return (offset - this.entriesOffset) / VanillaChronicleMap.this.entrySize;
        }

        public MultiStoreBytes entry(long offset) {
            return this.reuse(VanillaChronicleMap.this.acquireTmpBytes(), offset);
        }

        private MultiStoreBytes reuse(MultiStoreBytes entry, long offset) {
            entry.setBytesOffset((Bytes)this.bytes, offset += (long)VanillaChronicleMap.this.metaDataBytes);
            return entry;
        }

        long entryStartAddr(long offset) {
            return this.bytes.startAddr() + offset;
        }

        private long entrySize(long keySize, long valueSize) {
            return VanillaChronicleMap.this.alignment.alignAddr((long)(VanillaChronicleMap.this.metaDataBytes + VanillaChronicleMap.this.keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)VanillaChronicleMap.this.valueSizeMarshaller.sizeEncodingSize(valueSize)) + valueSize;
        }

        int inBlocks(long sizeInBytes) {
            if (sizeInBytes <= VanillaChronicleMap.this.entrySize) {
                return 1;
            }
            if (--sizeInBytes <= Integer.MAX_VALUE) {
                return (int)sizeInBytes / (int)VanillaChronicleMap.this.entrySize + 1;
            }
            return (int)(sizeInBytes / VanillaChronicleMap.this.entrySize) + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V acquire(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V usingValue, long hash2, boolean create) {
            if (create) {
                this.writeLock();
            } else {
                this.readLock();
            }
            try {
                long keySize = metaKeyInterop.size(keyInterop, key);
                MultiStoreBytes entry = VanillaChronicleMap.this.acquireTmpBytes();
                long offset = this.searchKey(keyInterop, metaKeyInterop, key, keySize, hash2, entry, this.hashLookup);
                if (offset >= 0L) {
                    Object v = this.onKeyPresentOnAcquire(copies, key, usingValue, offset, entry);
                    return v;
                }
                if (!create) {
                    Object v = null;
                    return v;
                }
                if (VanillaChronicleMap.this.defaultValueProvider != null) {
                    Object defaultValue = VanillaChronicleMap.this.defaultValueProvider.get(key);
                    copies = VanillaChronicleMap.this.valueWriterProvider.getCopies(copies);
                    Object valueWriter = VanillaChronicleMap.this.valueWriterProvider.get(copies, VanillaChronicleMap.this.originalValueWriter);
                    copies = VanillaChronicleMap.this.metaValueWriterProvider.getCopies(copies);
                    Object metaValueWriter = VanillaChronicleMap.this.metaValueWriterProvider.get(copies, VanillaChronicleMap.this.originalMetaValueWriter, valueWriter, defaultValue);
                    offset = this.putEntry(metaKeyInterop, keyInterop, key, keySize, (MetaBytesWriter)metaValueWriter, (Object)valueWriter, (Object)defaultValue);
                } else {
                    offset = this.putEntry(metaKeyInterop, keyInterop, key, keySize, VanillaChronicleMap.this.prepareValueBytesAsWriter, null, key);
                }
                Object v = this.onKeyAbsentOnAcquire(copies, key, keySize, usingValue, offset);
                return v;
            }
            finally {
                if (create) {
                    this.writeUnlock();
                } else {
                    this.readUnlock();
                }
            }
        }

        long searchKey(KI keyInterop, MKI metaKeyInterop, K key, long keySize, long hash2, MultiStoreBytes entry, MultiMap hashLookup) {
            long pos;
            hashLookup.startSearch(hash2);
            while ((pos = hashLookup.nextPos()) >= 0L) {
                long offset = this.offsetFromPos(pos);
                this.reuse(entry, offset);
                if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                entry.skip(keySize);
                return offset;
            }
            return -1L;
        }

        V onKeyPresentOnAcquire(ThreadLocalCopies copies, K key, V usingValue, long offset, MultiStoreBytes entry) {
            this.skipReplicationBytes((Bytes)entry);
            Object v = this.readValue(copies, entry, usingValue);
            this.notifyGet(offset, key, v);
            return v;
        }

        V onKeyAbsentOnAcquire(ThreadLocalCopies copies, K key, long keySize, V usingValue, long offset) {
            this.incrementSize();
            MultiStoreBytes entry = this.entry(offset);
            entry.skip((long)VanillaChronicleMap.this.keySizeMarshaller.sizeEncodingSize(keySize) + keySize);
            this.skipReplicationBytes((Bytes)entry);
            Object v = this.readValue(copies, entry, usingValue);
            this.notifyPut(offset, true, key, v, this.posFromOffset(offset));
            this.notifyGet(offset, key, v);
            return v;
        }

        void skipReplicationBytes(Bytes bytes) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V value, long hash2, boolean replaceIfPresent) {
            this.writeLock();
            try {
                long pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0L) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    if (replaceIfPresent) {
                        Object v = this.replaceValueOnPut(copies, key, value, entry, pos, offset, !VanillaChronicleMap.this.putReturnsNull, this.hashLookup);
                        return v;
                    }
                    Object v = VanillaChronicleMap.this.putReturnsNull ? null : (Object)this.readValue(copies, entry, null);
                    return v;
                }
                long offset = this.putEntry(copies, metaKeyInterop, keyInterop, key, keySize, value);
                this.incrementSize();
                this.notifyPut(offset, true, key, value, this.posFromOffset(offset));
                Object v = null;
                return v;
            }
            finally {
                this.writeUnlock();
            }
        }

        V replaceValueOnPut(ThreadLocalCopies copies, K key, V value, MultiStoreBytes entry, long pos, long offset, boolean readPrevValue, MultiMap searchedHashLookup) {
            long valueSizePos = entry.position();
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            Object prevValue = null;
            if (readPrevValue) {
                prevValue = this.readValue(copies, entry, null, valueSize);
            }
            offset = this.putValue(pos, offset, (NativeBytes)entry, valueSizePos, entryEndAddr, copies, value, null, searchedHashLookup);
            this.notifyPut(offset, false, key, value, this.posFromOffset(offset));
            return prevValue;
        }

        private long putEntry(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, long keySize, V value) {
            copies = VanillaChronicleMap.this.valueWriterProvider.getCopies(copies);
            Object valueWriter = VanillaChronicleMap.this.valueWriterProvider.get(copies, VanillaChronicleMap.this.originalValueWriter);
            copies = VanillaChronicleMap.this.metaValueWriterProvider.getCopies(copies);
            Object metaValueWriter = VanillaChronicleMap.this.metaValueWriterProvider.get(copies, VanillaChronicleMap.this.originalMetaValueWriter, valueWriter, value);
            return this.putEntry(metaKeyInterop, keyInterop, key, keySize, (MetaBytesWriter)metaValueWriter, (Object)valueWriter, (Object)value);
        }

        private <E, EW> long putEntry(MKI metaKeyInterop, KI keyInterop, K key, long keySize, MetaBytesWriter<E, EW> metaElemWriter, EW elemWriter, E elem) {
            long valueSize = metaElemWriter.size(elemWriter, elem);
            long entrySize = this.entrySize(keySize, valueSize);
            long pos = this.alloc(this.inBlocks(entrySize));
            long offset = this.offsetFromPos(pos);
            this.clearMetaData(offset);
            MultiStoreBytes entry = this.entry(offset);
            VanillaChronicleMap.this.keySizeMarshaller.writeSize((Bytes)entry, keySize);
            metaKeyInterop.write(keyInterop, (Bytes)entry, key);
            VanillaChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, valueSize);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            metaElemWriter.write(elemWriter, (Bytes)entry, elem);
            this.hashLookup.putAfterFailedSearch(pos);
            return offset;
        }

        void clearMetaData(long offset) {
            if (VanillaChronicleMap.this.metaDataBytes > 0) {
                this.bytes.zeroOut(offset, offset + (long)VanillaChronicleMap.this.metaDataBytes);
            }
        }

        long alloc(int blocks) {
            if (blocks > 64) {
                throw new IllegalArgumentException("Entry is too large: requires " + blocks + " entry size chucks, " + 64 + " is maximum.");
            }
            long ret = this.freeList.setNextNContinuousClearBits(this.nextPosToSearchFrom, blocks);
            if (ret == -1L || ret + (long)blocks > VanillaChronicleMap.this.entriesPerSegment) {
                if (ret + (long)blocks > VanillaChronicleMap.this.entriesPerSegment) {
                    this.freeList.clear(ret, ret + (long)blocks);
                }
                if ((ret = this.freeList.setNextNContinuousClearBits(0L, blocks)) == -1L || ret + (long)blocks > VanillaChronicleMap.this.entriesPerSegment) {
                    if (ret + (long)blocks > VanillaChronicleMap.this.entriesPerSegment) {
                        this.freeList.clear(ret, ret + (long)blocks);
                    }
                    if (blocks == 1) {
                        throw new IllegalStateException("Segment is full, no free entries found");
                    }
                    throw new IllegalStateException("Segment is full or has no ranges of " + blocks + " continuous free blocks");
                }
                this.updateNextPosToSearchFrom(ret, blocks);
            } else if (blocks == 1 || this.freeList.isSet(this.nextPosToSearchFrom)) {
                this.updateNextPosToSearchFrom(ret, blocks);
            }
            return ret;
        }

        private void updateNextPosToSearchFrom(long allocated, int blocks) {
            this.nextPosToSearchFrom = allocated + (long)blocks;
            if (this.nextPosToSearchFrom >= VanillaChronicleMap.this.entriesPerSegment) {
                this.nextPosToSearchFrom = 0L;
            }
        }

        private boolean realloc(long fromPos, int oldBlocks, int newBlocks) {
            if (this.freeList.allClear(fromPos + (long)oldBlocks, fromPos + (long)newBlocks)) {
                this.freeList.set(fromPos + (long)oldBlocks, fromPos + (long)newBlocks);
                return true;
            }
            return false;
        }

        void free(long fromPos, int blocks) {
            this.freeList.clear(fromPos, fromPos + (long)blocks);
            if (fromPos < this.nextPosToSearchFrom) {
                this.nextPosToSearchFrom = fromPos;
            }
        }

        V readValue(ThreadLocalCopies copies, MultiStoreBytes entry, V value) {
            return this.readValue(copies, entry, value, VanillaChronicleMap.this.readValueSize((Bytes)entry));
        }

        V readValue(ThreadLocalCopies copies, MultiStoreBytes entry, V value, long valueSize) {
            copies = VanillaChronicleMap.this.valueReaderProvider.getCopies(copies);
            BytesReader valueReader = (BytesReader)VanillaChronicleMap.this.valueReaderProvider.get(copies, VanillaChronicleMap.this.originalValueReader);
            return valueReader.read((Bytes)entry, valueSize, value);
        }

        boolean keyEquals(KI keyInterop, MKI metaKeyInterop, K key, long keySize, Bytes entry) {
            return keySize == VanillaChronicleMap.this.keySizeMarshaller.readSize(entry) && metaKeyInterop.startsWith(keyInterop, entry, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V expectedValue, long hash2) {
            this.writeLock();
            try {
                long pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0L) {
                    Object valueRemoved;
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
                    long entryEndAddr = entry.positionAddr() + valueSize;
                    Object v = valueRemoved = expectedValue != null || !VanillaChronicleMap.this.removeReturnsNull ? (Object)this.readValue(copies, entry, null, valueSize) : null;
                    if (expectedValue != null && !expectedValue.equals(valueRemoved)) {
                        Object v2 = null;
                        return v2;
                    }
                    this.hashLookup.removePrevPos();
                    this.decrementSize();
                    this.free(pos, this.inBlocks(entryEndAddr - this.entryStartAddr(offset)));
                    this.notifyRemoved(offset, key, valueRemoved, pos);
                    Object v3 = valueRemoved;
                    return v3;
                }
                Object v = null;
                return v;
            }
            finally {
                this.writeUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsKey(KI keyInterop, MKI metaKeyInterop, K key, long hash2) {
            this.readLock();
            try {
                long pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                MultiMap hashLookup = this.containsKeyHashLookup();
                hashLookup.startSearch(hash2);
                while ((pos = hashLookup.nextPos()) >= 0L) {
                    MultiStoreBytes entry = this.entry(this.offsetFromPos(pos));
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readUnlock();
            }
        }

        MultiMap containsKeyHashLookup() {
            return this.hashLookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(ThreadLocalCopies copies, MKI metaKeyInterop, KI keyInterop, K key, V expectedValue, V newValue, long hash2) {
            this.writeLock();
            try {
                long pos;
                long keySize = metaKeyInterop.size(keyInterop, key);
                this.hashLookup.startSearch(hash2);
                while ((pos = this.hashLookup.nextPos()) >= 0L) {
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    if (!this.keyEquals(keyInterop, metaKeyInterop, key, keySize, (Bytes)entry)) continue;
                    entry.skip(keySize);
                    Object v = this.onKeyPresentOnReplace(copies, key, expectedValue, newValue, pos, offset, entry, this.hashLookup);
                    return v;
                }
                Object v = null;
                return v;
            }
            finally {
                this.writeUnlock();
            }
        }

        V onKeyPresentOnReplace(ThreadLocalCopies copies, K key, V expectedValue, V newValue, long pos, long offset, MultiStoreBytes entry, MultiMap searchedHashLookup) {
            long valueSizePos = entry.position();
            long valueSize = VanillaChronicleMap.this.readValueSize((Bytes)entry);
            long entryEndAddr = entry.positionAddr() + valueSize;
            Object valueRead = this.readValue(copies, entry, null, valueSize);
            if (valueRead == null) {
                return null;
            }
            if (expectedValue == null || expectedValue.equals(valueRead)) {
                offset = this.putValue(pos, offset, (NativeBytes)entry, valueSizePos, entryEndAddr, copies, newValue, null, searchedHashLookup);
                this.notifyPut(offset, false, key, newValue, this.posFromOffset(offset));
                return valueRead;
            }
            return null;
        }

        void notifyPut(long offset, boolean added, K key, V value, long pos) {
            if (VanillaChronicleMap.this.eventListener() != MapEventListeners.NOP) {
                MultiStoreBytes b = VanillaChronicleMap.this.acquireTmpBytes();
                b.storePositionAndSize((BytesStore)this.bytes, offset, VanillaChronicleMap.this.entrySize);
                VanillaChronicleMap.this.eventListener().onPut(VanillaChronicleMap.this, (Bytes)b, VanillaChronicleMap.this.metaDataBytes, added, key, value, pos, this);
            }
        }

        void notifyGet(long offset, K key, V value) {
            if (VanillaChronicleMap.this.eventListener() != MapEventListeners.NOP) {
                MultiStoreBytes b = VanillaChronicleMap.this.acquireTmpBytes();
                b.storePositionAndSize((BytesStore)this.bytes, offset, VanillaChronicleMap.this.entrySize);
                VanillaChronicleMap.this.eventListener().onGetFound(VanillaChronicleMap.this, (Bytes)b, VanillaChronicleMap.this.metaDataBytes, key, value);
            }
        }

        void notifyRemoved(long offset, K key, V value, long pos) {
            if (VanillaChronicleMap.this.eventListener() != MapEventListeners.NOP) {
                MultiStoreBytes b = VanillaChronicleMap.this.acquireTmpBytes();
                b.storePositionAndSize((BytesStore)this.bytes, offset, VanillaChronicleMap.this.entrySize);
                VanillaChronicleMap.this.eventListener().onRemove(VanillaChronicleMap.this, (Bytes)b, VanillaChronicleMap.this.metaDataBytes, key, value, pos, this);
            }
        }

        long putValue(long pos, long offset, NativeBytes entry, long valueSizePos, long entryEndAddr, ThreadLocalCopies copies, V value, Bytes valueBytes, MultiMap searchedHashLookup) {
            long newValueSize;
            long valueSizeAddr = entry.address() + valueSizePos;
            Object valueWriter = null;
            MetaBytesWriter metaValueWriter = null;
            if (valueBytes != null) {
                newValueSize = valueBytes.remaining();
            } else {
                copies = VanillaChronicleMap.this.valueWriterProvider.getCopies(copies);
                valueWriter = VanillaChronicleMap.this.valueWriterProvider.get(copies, VanillaChronicleMap.this.originalValueWriter);
                copies = VanillaChronicleMap.this.metaValueWriterProvider.getCopies(copies);
                metaValueWriter = (MetaBytesWriter)VanillaChronicleMap.this.metaValueWriterProvider.get(copies, VanillaChronicleMap.this.originalMetaValueWriter, valueWriter, value);
                newValueSize = metaValueWriter.size(valueWriter, value);
            }
            long newValueAddr = VanillaChronicleMap.this.alignment.alignAddr(valueSizeAddr + (long)VanillaChronicleMap.this.valueSizeMarshaller.sizeEncodingSize(newValueSize));
            long newEntryEndAddr = newValueAddr + newValueSize;
            if (newEntryEndAddr != entryEndAddr) {
                long entryStartAddr = this.entryStartAddr(offset);
                long oldEntrySize = entryEndAddr - entryStartAddr;
                int oldSizeInBlocks = this.inBlocks(oldEntrySize);
                int newSizeInBlocks = this.inBlocks(newEntryEndAddr - entryStartAddr);
                if (newSizeInBlocks > oldSizeInBlocks) {
                    if (newSizeInBlocks > 64) {
                        throw new IllegalArgumentException("Value too large: entry takes " + newSizeInBlocks + " blocks, " + 64 + " is maximum.");
                    }
                    if (!this.realloc(pos, oldSizeInBlocks, newSizeInBlocks)) {
                        this.free(pos, oldSizeInBlocks);
                        VanillaChronicleMap.this.eventListener().onRelocation(pos, this);
                        long prevPos = pos;
                        pos = this.alloc(newSizeInBlocks);
                        this.replacePosInHashLookupOnRelocation(searchedHashLookup, prevPos, pos);
                        offset = this.offsetFromPos(pos);
                        long newEntryStartAddr = this.entryStartAddr(offset);
                        NativeBytes.UNSAFE.copyMemory(entryStartAddr, newEntryStartAddr, valueSizeAddr - entryStartAddr);
                        entry = this.entry(offset);
                    }
                } else if (newSizeInBlocks < oldSizeInBlocks) {
                    this.freeList.clear(pos + (long)newSizeInBlocks, pos + (long)oldSizeInBlocks);
                }
            }
            entry.position(valueSizePos);
            VanillaChronicleMap.this.valueSizeMarshaller.writeSize((Bytes)entry, newValueSize);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)entry);
            if (valueBytes != null) {
                entry.write((RandomDataInput)valueBytes);
            } else {
                metaValueWriter.write(valueWriter, (Bytes)entry, value);
            }
            return offset;
        }

        void replacePosInHashLookupOnRelocation(MultiMap searchedHashLookup, long prevPos, long pos) {
            searchedHashLookup.replacePrevPos(pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            this.writeLock();
            try {
                this.hashLookup.clear();
                this.freeList.clear();
                this.nextPosToSearchFrom = 0L;
                this.resetSize();
            }
            finally {
                this.writeUnlock();
            }
        }

        @Override
        public Map.Entry<K, V> getEntry(long pos) {
            this.bytes.position(this.offsetFromPos(pos) + (long)VanillaChronicleMap.this.metaDataBytes);
            long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)this.bytes);
            ThreadLocalCopies copies = VanillaChronicleMap.this.keyReaderProvider.getCopies(null);
            Object key = ((BytesReader)VanillaChronicleMap.this.keyReaderProvider.get(copies, VanillaChronicleMap.this.originalKeyReader)).read((Bytes)this.bytes, keySize);
            long valueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)this.bytes);
            VanillaChronicleMap.this.alignment.alignPositionAddr((Bytes)this.bytes);
            copies = VanillaChronicleMap.this.valueReaderProvider.getCopies(copies);
            Object value = ((BytesReader)VanillaChronicleMap.this.valueReaderProvider.get(copies, VanillaChronicleMap.this.originalValueReader)).read((Bytes)this.bytes, valueSize);
            return new WriteThroughEntry(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkConsistency() {
            this.readLock();
            try {
                MultiMap hashLookup = this.checkConsistencyHashLookup();
                long pos = 0L;
                while ((pos = this.freeList.nextSetBit(pos)) >= 0L) {
                    PosPresentOnce check = new PosPresentOnce(pos);
                    hashLookup.forEach(check);
                    if (check.count != 1) {
                        throw new AssertionError();
                    }
                    long offset = this.offsetFromPos(pos);
                    MultiStoreBytes entry = this.entry(offset);
                    long keySize = VanillaChronicleMap.this.keySizeMarshaller.readSize((Bytes)entry);
                    entry.skip(keySize);
                    this.afterKeyHookOnCheckConsistency((Bytes)entry);
                    long valueSize = VanillaChronicleMap.this.valueSizeMarshaller.readSize((Bytes)entry);
                    long sizeInBytes = this.entrySize(keySize, valueSize);
                    int entrySizeInBlocks = this.inBlocks(sizeInBytes);
                    if (!this.freeList.allSet(pos, pos + (long)entrySizeInBlocks)) {
                        throw new AssertionError();
                    }
                    pos += (long)entrySizeInBlocks;
                }
            }
            finally {
                this.readUnlock();
            }
        }

        void afterKeyHookOnCheckConsistency(Bytes entry) {
        }

        MultiMap checkConsistencyHashLookup() {
            return this.hashLookup;
        }

        private class PosPresentOnce
        implements MultiMap.EntryConsumer {
            long pos;
            int count = 0;

            PosPresentOnce(long pos) {
                this.pos = pos;
            }

            @Override
            public void accept(long hash, long pos) {
                if (this.pos == pos) {
                    ++this.count;
                }
            }
        }
    }
}

