/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization;

import java.nio.ByteOrder;
import net.openhft.lang.Maths;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import sun.misc.Unsafe;

public enum Hasher {

    private static final long LONG_LEVEL_PRIME_MULTIPLE = -7070675565921424023L;
    private static final short SHORT_LEVEL_PRIME_MULTIPLE = 16463;
    private static final byte BYTE_LEVEL_PRIME_MULTIPLE = 87;
    private static final int INT_HASH_LOW_SHORT_MULTIPLE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 16463 : 1;
    private static final int INT_HASH_HIGH_SHORT_MULTIPLE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 16463;

    public static long hash(Bytes bytes) {
        return Hasher.hash(bytes, bytes.position(), bytes.limit());
    }

    public static long hash(Bytes bytes, long offset, long limit) {
        long i;
        long h = 0L;
        for (i = offset; i < limit - 7L; i += 8L) {
            h = -7070675565921424023L * h + bytes.readLong(i);
        }
        while (i < limit - 1L) {
            h = 16463L * h + (long)bytes.readShort(i);
            i += 2L;
        }
        if (i < limit) {
            h = 87L * h + (long)bytes.readByte(i);
        }
        return Hasher.hash(h);
    }

    public static long hash(Object array, int length) {
        long i;
        Unsafe unsafe = NativeBytes.UNSAFE;
        long base = unsafe.arrayBaseOffset(array.getClass());
        long scale = unsafe.arrayIndexScale(array.getClass());
        long h = 0L;
        long limit = (long)length * scale;
        for (i = 0L; i < limit - 7L; i += 8L) {
            h = -7070675565921424023L * h + unsafe.getLong(array, base + i);
        }
        while (i < limit - 1L) {
            h = 16463L * h + (long)unsafe.getShort(array, base + i);
            i += 2L;
        }
        if (i < limit) {
            h = 87L * h + (long)unsafe.getByte(array, base + i);
        }
        return Hasher.hash(h);
    }

    public static long hash(int value) {
        return Hasher.hash((long)((short)(value >>> 16) * INT_HASH_HIGH_SHORT_MULTIPLE) + (long)((short)value * INT_HASH_LOW_SHORT_MULTIPLE));
    }

    public static long hash(long value) {
        return Maths.hash((long)value);
    }
}

