/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.nio.ByteBuffer;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.MetaBytesWriter;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;

final class ConstantValueProvider<K, V>
implements DefaultValueProvider<K, V> {
    private static final long serialVersionUID = 0L;
    private transient V value;
    private final int size;
    private final byte[] serializedValueBytes;

    <W> ConstantValueProvider(V value, MetaBytesWriter<V, W> metaValueWriter, W valueWriter) {
        this.value = value;
        this.size = (int)metaValueWriter.size(valueWriter, value);
        this.serializedValueBytes = new byte[this.size];
        ByteBufferBytes bytes = new ByteBufferBytes(ByteBuffer.wrap(this.serializedValueBytes));
        metaValueWriter.write(valueWriter, (Bytes)bytes, value);
    }

    boolean wasDeserialized() {
        return this.value == null;
    }

    void initTransients(BytesReader<V> reader) {
        this.value = reader.read((Bytes)new ByteBufferBytes(ByteBuffer.wrap(this.serializedValueBytes)), this.size);
    }

    @Override
    public V get(K key) {
        return this.value;
    }
}

