/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.net.InetAddress;
import java.net.NetworkInterface;
import net.openhft.chronicle.hash.replication.ThrottlingConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UdpConfig {
    private final InetAddress address;
    private final int port;
    private final NetworkInterface networkInterface;
    private final ThrottlingConfig throttlingConfig;

    private UdpConfig(InetAddress address, int port, NetworkInterface networkInterface, ThrottlingConfig throttlingConfig) {
        if (address == null) {
            throw new NullPointerException("Null address");
        }
        this.address = address;
        this.port = port;
        this.networkInterface = networkInterface;
        if (throttlingConfig == null) {
            throw new NullPointerException("Null throttlingConfig");
        }
        this.throttlingConfig = throttlingConfig;
    }

    public static UdpConfig simple(@NotNull InetAddress address, int port) {
        if (address.isMulticastAddress()) {
            throw new IllegalArgumentException();
        }
        return UdpConfig.create(address, port, null, ThrottlingConfig.noThrottling());
    }

    public static UdpConfig multiCast(@NotNull InetAddress address, int port, @NotNull NetworkInterface networkInterface) {
        if (!address.isMulticastAddress() || networkInterface == null) {
            throw new IllegalArgumentException();
        }
        return UdpConfig.create(address, port, networkInterface, ThrottlingConfig.noThrottling());
    }

    static UdpConfig create(InetAddress address, int port, NetworkInterface networkInterface, ThrottlingConfig throttlingConfig) {
        return new UdpConfig(address, port, networkInterface, throttlingConfig);
    }

    @NotNull
    public InetAddress address() {
        return this.address;
    }

    public int port() {
        return this.port;
    }

    @Nullable
    public NetworkInterface networkInterface() {
        return this.networkInterface;
    }

    @NotNull
    public ThrottlingConfig throttlingConfig() {
        return this.throttlingConfig;
    }

    public String toString() {
        return "UdpReplicationConfig{address=" + this.address + ", port=" + this.port + ", networkInterface=" + this.networkInterface + ", throttlingConfig=" + this.throttlingConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UdpConfig) {
            UdpConfig that = (UdpConfig)o;
            return this.address.equals(that.address()) && this.port == that.port() && this.networkInterface.equals(that.networkInterface()) && this.throttlingConfig.equals(that.throttlingConfig());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.address.hashCode();
        h *= 1000003;
        h ^= this.port;
        h *= 1000003;
        h ^= this.networkInterface.hashCode();
        h *= 1000003;
        return h ^= this.throttlingConfig.hashCode();
    }

    public UdpConfig throttlingConfig(@NotNull ThrottlingConfig throttlingConfig) {
        ThrottlingConfig.checkMillisecondBucketInterval(throttlingConfig, "UDP");
        return UdpConfig.create(this.address(), this.port(), this.networkInterface(), throttlingConfig);
    }
}

