/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.map.AddressAndPort;
import net.openhft.chronicle.map.ConcurrentExpiryMap;
import net.openhft.chronicle.map.KnownNodes;
import net.openhft.chronicle.map.NodeDiscoveryBroadcaster;
import net.openhft.chronicle.map.NodeDiscoveryEventListener;
import net.openhft.chronicle.map.Replica;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.constraints.NotNull;

class DiscoveryNodeBytesMarshallable
implements BytesMarshallable {
    final ConcurrentExpiryMap<AddressAndPort, ProposedNodes> proposedIdentifiersWithHost = new ConcurrentExpiryMap<AddressAndPort, ProposedNodes>(AddressAndPort.class, ProposedNodes.class);
    private final KnownNodes remoteNode;
    private final AtomicBoolean bootstrapRequired = new AtomicBoolean();
    private final AtomicReference<NodeDiscoveryEventListener> nodeDiscoveryEventListener;
    Replica.ModificationNotifier modificationNotifier;
    private AddressAndPort sourceAddressAndPort = new AddressAndPort();
    private ProposedNodes ourProposedIdentifier;
    private AddressAndPort ourAddressAndPort;

    public DiscoveryNodeBytesMarshallable(@org.jetbrains.annotations.NotNull KnownNodes remoteNode, @org.jetbrains.annotations.NotNull AtomicReference<NodeDiscoveryEventListener> nodeDiscoveryEventListener, @org.jetbrains.annotations.NotNull AddressAndPort ourAddressAndPort) {
        this.remoteNode = remoteNode;
        this.nodeDiscoveryEventListener = nodeDiscoveryEventListener;
        this.ourAddressAndPort = ourAddressAndPort;
    }

    public ProposedNodes getOurProposedIdentifier() {
        return this.ourProposedIdentifier;
    }

    private void setOurProposedIdentifier(ProposedNodes ourProposedIdentifier) {
        this.ourProposedIdentifier = ourProposedIdentifier;
    }

    public void setModificationNotifier(Replica.ModificationNotifier modificationNotifier) {
        this.modificationNotifier = modificationNotifier;
    }

    public KnownNodes getRemoteNodes() {
        return this.remoteNode;
    }

    public void writeMarshallable(@NotNull Bytes out) {
        if (this.bootstrapRequired.getAndSet(false)) {
            this.writeBootstrap(out);
            return;
        }
        this.ourAddressAndPort.writeMarshallable(out);
        this.remoteNode.writeMarshallable(out);
        this.proposedIdentifiersWithHost.expireEntries(System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(1L));
        this.proposedIdentifiersWithHost.writeMarshallable(out);
    }

    private boolean writeBootstrap(Bytes out) {
        ProposedNodes ourProposedIdentifier = this.getOurProposedIdentifier();
        if (ourProposedIdentifier == null || ourProposedIdentifier.addressAndPort == null) {
            return false;
        }
        NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.clear();
        out.write((RandomDataInput)NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES, NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.position(), NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.remaining());
        ourProposedIdentifier.writeMarshallable(out);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProposedNodes readBootstrapMessage(Bytes in) {
        long start = in.position();
        try {
            long size = NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.limit();
            if (size > in.remaining()) {
                ProposedNodes proposedNodes = null;
                return proposedNodes;
            }
            int i = 0;
            while ((long)i < size) {
                byte byteRead = in.readByte();
                byte expectedByte = NodeDiscoveryBroadcaster.BOOTSTRAP_BYTES.readByte((long)i);
                if (expectedByte != byteRead) {
                    ProposedNodes proposedNodes = null;
                    return proposedNodes;
                }
                ++i;
            }
            ProposedNodes result = new ProposedNodes();
            result.readMarshallable(in);
            ProposedNodes proposedNodes = result;
            return proposedNodes;
        }
        finally {
            in.position(start);
        }
    }

    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        ProposedNodes bootstrap = this.readBootstrapMessage(in);
        if (bootstrap != null) {
            if (bootstrap.addressAndPort().equals(this.ourAddressAndPort)) {
                return;
            }
            if (NodeDiscoveryBroadcaster.LOG.isDebugEnabled()) {
                NodeDiscoveryBroadcaster.LOG.debug("Received Bootstrap from " + bootstrap);
            }
            this.proposedIdentifiersWithHost.put(bootstrap.addressAndPort, bootstrap);
            this.onChange();
            return;
        }
        this.sourceAddressAndPort.readMarshallable(in);
        if (this.sourceAddressAndPort.equals(this.ourAddressAndPort)) {
            return;
        }
        NodeDiscoveryBroadcaster.LOG.debug("Received Proposal");
        this.remoteNode.readMarshallable(in);
        this.proposedIdentifiersWithHost.readMarshallable(in);
        NodeDiscoveryEventListener listener = this.nodeDiscoveryEventListener.get();
        if (listener != null) {
            listener.onRemoteNodeEvent(this.remoteNode, this.proposedIdentifiersWithHost);
        }
    }

    public void onChange() {
        if (this.modificationNotifier != null) {
            this.modificationNotifier.onChange();
        }
    }

    public void sendBootStrap(ProposedNodes proposedNodes) {
        this.setOurProposedIdentifier(proposedNodes);
        this.bootstrapRequired.set(true);
        this.onChange();
    }

    static class ProposedNodes
    implements BytesMarshallable {
        private byte identifier;
        private long timestamp;
        private AddressAndPort addressAndPort;

        public ProposedNodes() {
        }

        ProposedNodes(@org.jetbrains.annotations.NotNull AddressAndPort addressAndPort, byte identifier) {
            this.addressAndPort = addressAndPort;
            this.identifier = identifier;
            this.timestamp = System.currentTimeMillis();
        }

        public byte identifier() {
            return this.identifier;
        }

        AddressAndPort addressAndPort() {
            return this.addressAndPort;
        }

        public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
            this.addressAndPort = new AddressAndPort();
            this.addressAndPort.readMarshallable(in);
            this.timestamp = in.readLong();
            this.identifier = in.readByte();
        }

        public void writeMarshallable(@NotNull Bytes out) {
            this.addressAndPort.writeMarshallable(out);
            out.writeLong(this.timestamp);
            out.writeByte((int)this.identifier);
        }

        public String toString() {
            return "{identifier=" + this.identifier + ", timestamp=" + this.timestamp + ", addressAndPort=" + this.addressAndPort + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ProposedNodes.class != o.getClass()) {
                return false;
            }
            ProposedNodes that = (ProposedNodes)o;
            if (this.identifier != that.identifier) {
                return false;
            }
            return this.addressAndPort.equals(that.addressAndPort);
        }

        public int hashCode() {
            int result = this.identifier;
            result = 31 * result + this.addressAndPort.hashCode();
            return result;
        }
    }
}

