/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.hash.ChronicleHashInstanceBuilder;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;

final class MapInstanceBuilder<K, V>
implements ChronicleHashInstanceBuilder<ChronicleMap<K, V>>,
Serializable {
    final ChronicleMapBuilder<K, V> mapBuilder;
    final AtomicBoolean used;
    transient SingleChronicleHashReplication singleHashReplication;
    transient ReplicationChannel channel;
    transient File file;
    String name;

    MapInstanceBuilder(ChronicleMapBuilder<K, V> mapBuilder, SingleChronicleHashReplication singleHashReplication, ReplicationChannel channel, File file, String name, AtomicBoolean used) {
        this.mapBuilder = mapBuilder;
        this.singleHashReplication = singleHashReplication;
        this.channel = channel;
        this.file = file;
        this.name = name;
        this.used = used;
    }

    public MapInstanceBuilder<K, V> replicated(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return this.replicated(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    public MapInstanceBuilder<K, V> replicated(SingleChronicleHashReplication replication) {
        this.singleHashReplication = replication;
        this.channel = null;
        return this;
    }

    public MapInstanceBuilder<K, V> replicatedViaChannel(ReplicationChannel channel) {
        this.singleHashReplication = null;
        this.channel = channel;
        return this;
    }

    public MapInstanceBuilder<K, V> persistedTo(File file) {
        this.file = file;
        return this;
    }

    public MapInstanceBuilder<K, V> name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public synchronized ChronicleMap<K, V> create() throws IOException {
        if (!this.used.getAndSet(true)) {
            return this.mapBuilder.create(this);
        }
        throw new IllegalStateException("A ChronicleMap has already been created using this instance config chain. Create a new instance config (builder.instance()) to create a new ChronicleMap instance");
    }
}

