/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import net.openhft.chronicle.map.MultiMap;
import net.openhft.chronicle.map.MultiMapFactory;
import net.openhft.chronicle.map.SearchState;
import net.openhft.lang.Maths;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;

class Int24Int24MultiMap
implements MultiMap {
    static final long MAX_CAPACITY = 0x1000000L;
    private static final long ENTRY_SIZE = 6L;
    private static final int UNSET_KEY = 0;
    private static final long MASK = 0xFFFFFFL;
    private static final long HASH_INSTEAD_OF_UNSET_KEY = 0xFFFFFFL;
    private static final long UNSET_ENTRY = 0L;
    final DirectBitSet positions;
    private final int capacity;
    private final long capacityMask;
    private final long capacityInBytes;
    private final Bytes bytes;

    public Int24Int24MultiMap(long minCapacity) {
        long capacity = MultiMapFactory.multiMapCapacity(minCapacity);
        this.capacity = (int)capacity;
        this.capacityMask = capacity - 1L;
        this.capacityInBytes = Int24Int24MultiMap.indexToPos(capacity);
        this.bytes = DirectStore.allocateLazy((long)Int24Int24MultiMap.indexToPos(capacity)).bytes();
        this.positions = MultiMapFactory.newPositions(capacity);
        this.clear();
    }

    public Int24Int24MultiMap(Bytes multiMapBytes, Bytes multiMapBitSetBytes) {
        long capacity = multiMapBytes.capacity() / 6L;
        assert (Maths.isPowerOf2((long)capacity));
        assert (capacity / 2L <= 0x1000000L);
        this.capacity = (int)capacity;
        this.capacityMask = capacity - 1L;
        this.capacityInBytes = Int24Int24MultiMap.indexToPos(capacity);
        this.bytes = multiMapBytes;
        this.positions = ATSDirectBitSet.wrap((Bytes)multiMapBitSetBytes);
    }

    public static long sizeInBytes(long minCapacity) {
        return Int24Int24MultiMap.indexToPos(MultiMapFactory.multiMapCapacity(minCapacity));
    }

    private static long indexToPos(long index) {
        return index * 6L;
    }

    private static long maskUnsetKey(long key) {
        return (key &= 0xFFFFFFL) != 0L ? key : 0xFFFFFFL;
    }

    private static long key(long entry) {
        return entry >>> 24;
    }

    private static long value(long entry) {
        return entry & 0xFFFFFFL;
    }

    private static long entry(long key, long value) {
        return key << 24 | value & 0xFFFFFFL;
    }

    private void checkValueForPut(long value) {
        assert ((value & 0xFFFFFFFFFF000000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isClear(value)) : "Shouldn't put existing value";
    }

    private void checkValueForRemove(long value) {
        assert ((value & 0xFFFFFFFFFF000000L) == 0L) : "Value out of range, was " + value;
        assert (this.positions.isSet(value)) : "Shouldn't remove absent value";
    }

    private long pos(long key) {
        return Int24Int24MultiMap.indexToPos(key & this.capacityMask);
    }

    private long step(long pos) {
        long t = (pos += 6L) - this.capacityInBytes;
        return t < 0L ? pos : t;
    }

    private long stepBack(long pos) {
        return (pos -= 6L) >= 0L ? pos : pos + this.capacityInBytes;
    }

    @Override
    public void putPosition(long value) {
        this.checkValueForPut(value);
        this.positions.set(value);
    }

    @Override
    public void put(long key, long value) {
        key = Int24Int24MultiMap.maskUnsetKey(key);
        this.checkValueForPut(value);
        long pos = this.pos(key);
        while (true) {
            long entry;
            if ((entry = this.bytes.readInt48(pos)) == 0L) {
                this.bytes.writeInt48(pos, Int24Int24MultiMap.entry(key, value));
                this.positions.set(value);
                return;
            }
            pos = this.step(pos);
        }
    }

    @Override
    public void removePosition(long value) {
        this.checkValueForRemove(value);
        this.positions.clear(value);
    }

    @Override
    public void remove(long key, long value) {
        key = Int24Int24MultiMap.maskUnsetKey(key);
        this.checkValueForRemove(value);
        long pos = this.pos(key);
        while (true) {
            long entry;
            if (Int24Int24MultiMap.key(entry = this.bytes.readInt48(pos)) == key && Int24Int24MultiMap.value(entry) == value) break;
            pos = this.step(pos);
        }
        long posToRemove = pos;
        this.positions.clear(value);
        this.removePos(posToRemove);
    }

    @Override
    public void replace(long key, long oldValue, long newValue) {
        key = Int24Int24MultiMap.maskUnsetKey(key);
        this.checkValueForRemove(oldValue);
        this.checkValueForPut(newValue);
        long pos = this.pos(key);
        while (true) {
            long entry;
            if (Int24Int24MultiMap.key(entry = this.bytes.readInt48(pos)) == key && Int24Int24MultiMap.value(entry) == oldValue) {
                this.positions.clear(oldValue);
                this.positions.set(newValue);
                this.bytes.writeInt48(pos, Int24Int24MultiMap.entry(key, newValue));
                return;
            }
            pos = this.step(pos);
        }
    }

    private void removePos(long posToRemove) {
        long entryToShift;
        long posToShift = posToRemove;
        while ((entryToShift = this.bytes.readInt48(posToShift = this.step(posToShift))) != 0L) {
            boolean cond2;
            long insertPos = this.pos(Int24Int24MultiMap.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.bytes.writeInt48(posToRemove, entryToShift);
            posToRemove = posToShift;
        }
        this.bytes.writeInt48(posToRemove, 0L);
    }

    @Override
    public void startSearch(long key, SearchState searchStateToReuse) {
        key = Int24Int24MultiMap.maskUnsetKey(key);
        searchStateToReuse.searchPos = this.pos(key);
        searchStateToReuse.searchHash = key;
        searchStateToReuse.putAfterFailedSearch = false;
    }

    @Override
    public long nextPos(SearchState searchState) {
        long entry;
        long pos = searchState.searchPos;
        do {
            if ((entry = this.bytes.readInt48(pos)) == 0L) {
                searchState.searchPos = pos;
                return -1L;
            }
            pos = this.step(pos);
        } while (Int24Int24MultiMap.key(entry) != searchState.searchHash);
        searchState.searchPos = pos;
        return Int24Int24MultiMap.value(entry);
    }

    @Override
    public void removePrevPos(SearchState searchState) {
        long prevPos = this.stepBack(searchState.searchPos);
        long entry = this.bytes.readInt48(prevPos);
        this.positions.clear(Int24Int24MultiMap.value(entry));
        this.removePos(prevPos);
    }

    @Override
    public void replacePrevPos(SearchState searchState, long newValue, boolean oldValueInPositions) {
        this.checkValueForPut(newValue);
        long prevPos = searchState.searchPos;
        if (!searchState.putAfterFailedSearch) {
            prevPos = this.stepBack(prevPos);
        }
        if (oldValueInPositions) {
            long oldEntry = this.bytes.readInt48(prevPos);
            long oldValue = Int24Int24MultiMap.value(oldEntry);
            this.checkValueForRemove(oldValue);
            this.positions.clear(oldValue);
        }
        this.positions.set(newValue);
        this.bytes.writeInt48(prevPos, Int24Int24MultiMap.entry(searchState.searchHash, newValue));
    }

    @Override
    public void putAfterFailedSearch(SearchState searchState, long value) {
        this.checkValueForPut(value);
        this.positions.set(value);
        this.bytes.writeInt48(searchState.searchPos, Int24Int24MultiMap.entry(searchState.searchHash, value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        long pos = 0L;
        int i = 0;
        while (i < this.capacity) {
            long entry = this.bytes.readInt48(pos);
            if (entry != 0L) {
                sb.append(Int24Int24MultiMap.key(entry)).append('=').append(Int24Int24MultiMap.value(entry)).append(", ");
            }
            ++i;
            pos += 6L;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
            return sb.append(" }").toString();
        }
        return "{ }";
    }

    @Override
    public void forEach(MultiMap.EntryConsumer action) {
        long pos = 0L;
        int i = 0;
        while (i < this.capacity) {
            long entry = this.bytes.readInt48(pos);
            if (entry != 0L) {
                action.accept(Int24Int24MultiMap.key(entry), Int24Int24MultiMap.value(entry));
            }
            ++i;
            pos += 6L;
        }
    }

    @Override
    public long size() {
        long pos = 0L;
        int size = 0;
        for (int count = this.capacity; count > 0; --count) {
            long entry = this.bytes.readInt48(pos);
            pos = this.step(pos);
            if (entry == 0L) continue;
            ++size;
        }
        return size;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public DirectBitSet getPositions() {
        return this.positions;
    }

    @Override
    public void clear() {
        this.positions.clear();
        this.bytes.zeroOut();
    }
}

