package net.openhft.chronicle.map;

import net.openhft.chronicle.hash.function.SerializableFunction;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

/**
 * Created by daniel on 22/04/15.
 */
public class FilePerKeyChronicleMap implements ChronicleMap<String, String> {
    private final ChronicleMap<String, String> chMap;
    private final FilePerKeyMap fpMap;

    public FilePerKeyChronicleMap(String dir) {
        fpMap = new FilePerKeyMap(dir);
        chMap = ChronicleMapBuilder.of(String.class, String.class)
                .entries(500).averageValueSize(2_000_000).create();
    }

    @Override
    public int size() {
        return fpMap.size();
    }

    @Override
    public boolean isEmpty() {
        return fpMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return fpMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return fpMap.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return fpMap.get(key);
    }

    @Override
    public String put(String key, String value) {
        fpMap.put(key, value);
        return chMap.put(key,value);
    }

    @Override
    public String remove(Object key) {
        chMap.remove(key);
        return fpMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        fpMap.putAll(m);
        chMap.putAll(m);
    }

    @Override
    public void clear() {
        fpMap.clear();
    }

    @NotNull
    @Override
    public Set<String> keySet() {
        return fpMap.keySet();
    }

    @NotNull
    @Override
    public Collection<String> values() {
        return fpMap.values();
    }

    @NotNull
    @Override
    public Set<Entry<String, String>> entrySet() {
        return fpMap.entrySet();
    }

    @Override
    public String getUsing(String key, String usingValue) {
        return chMap.getUsing(key, usingValue);
    }

    @Override
    public String acquireUsing(@NotNull String key, String usingValue) {
        //@todo ADD THE LOGIC FOR FPMAP
        return chMap.acquireUsing(key, usingValue);
    }

    @NotNull
    @Override
    public MapKeyContext<String, String> acquireContext(@NotNull String key, @NotNull String usingValue) {
        return chMap.acquireContext(key,usingValue);
    }

    @Override
    public <R> R getMapped(String key, @NotNull SerializableFunction<? super String, R> function) {
        return chMap.getMapped(key, function);
    }

    @Override
    public String putMapped(String key, @NotNull UnaryOperator<String> unaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getAll(File toFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(File fromFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String newValueInstance() {
        return new String();
    }

    @Override
    public String newKeyInstance() {
        return new String();
    }

    @Override
    public Class<String> valueClass() {
        return String.class;
    }

    @Override
    public File file() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long longSize() {
        return size();
    }

    @Override
    public MapKeyContext<String, String> context(String key) {
        return chMap.context(key);
    }

    @Override
    public Class<String> keyClass() {
        return String.class;
    }

    @Override
    public boolean forEachEntryWhile(Predicate<? super MapKeyContext<String, String>> predicate) {
        return chMap.forEachEntryWhile(predicate);
    }

    @Override
    public void forEachEntry(Consumer<? super MapKeyContext<String, String>> action) {
        chMap.forEachEntry(action);
    }

    @Override
    public void close() {
        chMap.close();
    }

    @Override
    public String putIfAbsent(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String replace(String key, String value) {
        throw new UnsupportedOperationException();
    }
}
