/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.hash.function.SerializableFunction;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.FilePerKeyMap;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class FilePerKeyChronicleMap
implements ChronicleMap<String, String> {
    private final ChronicleMap<String, String> chMap;
    private final FilePerKeyMap fpMap;

    public FilePerKeyChronicleMap(String dir) {
        this.fpMap = new FilePerKeyMap(dir);
        this.chMap = ((ChronicleMapBuilder)ChronicleMapBuilder.of(String.class, String.class).entries(500L)).averageValueSize(2000000.0).create();
    }

    @Override
    public int size() {
        return this.fpMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fpMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fpMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fpMap.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.fpMap.get(key);
    }

    @Override
    public String put(String key, String value) {
        this.fpMap.put(key, value);
        return this.chMap.put(key, value);
    }

    @Override
    public String remove(Object key) {
        this.chMap.remove(key);
        return this.fpMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.fpMap.putAll(m);
        this.chMap.putAll(m);
    }

    @Override
    public void clear() {
        this.fpMap.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.fpMap.keySet();
    }

    @Override
    @NotNull
    public Collection<String> values() {
        return this.fpMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, String>> entrySet() {
        return this.fpMap.entrySet();
    }

    @Override
    public String getUsing(String key, String usingValue) {
        return this.chMap.getUsing(key, usingValue);
    }

    @Override
    public String acquireUsing(@NotNull String key, String usingValue) {
        return this.chMap.acquireUsing(key, usingValue);
    }

    @Override
    @NotNull
    public MapKeyContext<String, String> acquireContext(@NotNull String key, @NotNull String usingValue) {
        return this.chMap.acquireContext(key, usingValue);
    }

    @Override
    public <R> R getMapped(String key, @NotNull SerializableFunction<? super String, R> function) {
        return this.chMap.getMapped(key, function);
    }

    @Override
    public String putMapped(String key, @NotNull UnaryOperator<String> unaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getAll(File toFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(File fromFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String newValueInstance() {
        return new String();
    }

    @Override
    public String newKeyInstance() {
        return new String();
    }

    @Override
    public Class<String> valueClass() {
        return String.class;
    }

    @Override
    public File file() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long longSize() {
        return this.size();
    }

    @Override
    public MapKeyContext<String, String> context(String key) {
        return (MapKeyContext)this.chMap.context(key);
    }

    @Override
    public Class<String> keyClass() {
        return String.class;
    }

    @Override
    public boolean forEachEntryWhile(Predicate<? super MapKeyContext<String, String>> predicate) {
        return this.chMap.forEachEntryWhile(predicate);
    }

    @Override
    public void forEachEntry(Consumer<? super MapKeyContext<String, String>> action) {
        this.chMap.forEachEntry(action);
    }

    @Override
    public void close() {
        this.chMap.close();
    }

    @Override
    public String putIfAbsent(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(String key, String oldValue, String newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String replace(String key, String value) {
        throw new UnsupportedOperationException();
    }
}

