/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.hash.KeyContext;
import net.openhft.chronicle.hash.impl.ContextFactory;
import net.openhft.chronicle.hash.impl.HashContext;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.BytesBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DelegatingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.hash.serialization.internal.SerializationBuilder;
import net.openhft.chronicle.map.AbstractChronicleMap;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ConstantValueProvider;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.VanillaContext;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VanillaChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
extends VanillaChronicleHash<K, KI, MKI, MapKeyContext<K, V>>
implements AbstractChronicleMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaChronicleMap.class);
    private static final long serialVersionUID = 3L;
    final Class<V> vClass;
    final Class nativeValueClass;
    final SizeMarshaller valueSizeMarshaller;
    final BytesReader<V> originalValueReader;
    final VI originalValueInterop;
    final MVI originalMetaValueInterop;
    final MetaProvider<V, VI, MVI> metaValueInteropProvider;
    final DefaultValueProvider<K, V> defaultValueProvider;
    final boolean constantlySizedEntry;
    transient Provider<BytesReader<V>> valueReaderProvider;
    transient Provider<VI> valueInteropProvider;
    final int metaDataBytes;
    final boolean putReturnsNull;
    final boolean removeReturnsNull;
    final Alignment alignment;
    final int worstAlignment;
    final boolean couldNotDetermineAlignmentBeforeAllocation;
    transient Set<Map.Entry<K, V>> entrySet;

    public VanillaChronicleMap(ChronicleMapBuilder<K, V> builder, boolean replicated) throws IOException {
        super(builder, replicated);
        SerializationBuilder valueBuilder = builder.valueBuilder;
        this.vClass = valueBuilder.eClass;
        if (this.vClass.getName().endsWith("$$Native")) {
            this.nativeValueClass = this.vClass;
        } else if (this.vClass.isInterface()) {
            Class nativeValueClass = null;
            try {
                nativeValueClass = DataValueClasses.directClassFor(this.vClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.nativeValueClass = nativeValueClass;
        } else {
            this.nativeValueClass = null;
        }
        this.valueSizeMarshaller = valueBuilder.sizeMarshaller();
        this.originalValueReader = valueBuilder.reader();
        this.originalValueInterop = valueBuilder.interop();
        this.originalMetaValueInterop = valueBuilder.metaInterop();
        this.metaValueInteropProvider = valueBuilder.metaInteropProvider();
        this.defaultValueProvider = builder.defaultValueProvider();
        this.constantlySizedEntry = builder.constantlySizedEntries();
        this.metaDataBytes = builder.metaDataBytes();
        this.putReturnsNull = builder.putReturnsNull();
        this.removeReturnsNull = builder.removeReturnsNull();
        this.alignment = builder.valueAlignment();
        this.worstAlignment = builder.worstAlignment(replicated);
        int alignment = this.alignment.alignment();
        this.couldNotDetermineAlignmentBeforeAllocation = ChronicleMapBuilder.greatestCommonDivisor((int)this.chunkSize, alignment) != alignment;
        this.initTransients();
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.ownInitTransients();
    }

    private void ownInitTransients() {
        ConstantValueProvider constantValueProvider;
        this.valueReaderProvider = Provider.of(this.originalValueReader.getClass());
        this.valueInteropProvider = Provider.of(this.originalValueInterop.getClass());
        if (this.defaultValueProvider instanceof ConstantValueProvider && (constantValueProvider = (ConstantValueProvider)this.defaultValueProvider).wasDeserialized()) {
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, this.originalValueReader);
            constantValueProvider.initTransients(valueReader);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.ownInitTransients();
    }

    @Override
    public final void checkValue(Object value) {
        if (!this.vClass.isInstance(value)) {
            throw new ClassCastException("Value must be a " + this.vClass.getName() + " but was a " + value.getClass());
        }
    }

    @Override
    public VanillaContext<K, KI, MKI, V, VI, MVI> mapContext() {
        VanillaContext<K, KI, MKI, V, VI, MVI> context = this.rawContext();
        context.initHash(this);
        return context;
    }

    VanillaContext bytesMapContext() {
        VanillaContext context = this.rawBytesContext();
        context.initHash(this);
        return context;
    }

    @Override
    public VanillaContext<K, KI, MKI, V, VI, MVI> context(K key) {
        VanillaContext<K, KI, MKI, V, VI, MVI> context = this.mapContext();
        context.initKey(key);
        return context;
    }

    @Override
    public void putDefaultValue(VanillaContext context) {
        context.doPut(this.defaultValue(context));
    }

    @Override
    public int actualSegments() {
        return this.actualSegments;
    }

    VanillaContext<K, KI, MKI, V, VI, MVI> rawContext() {
        return VanillaContext.get(VanillaContext.VanillaChronicleMapContextFactory.INSTANCE);
    }

    VanillaContext rawBytesContext() {
        return HashContext.get(BytesContextFactory.INSTANCE);
    }

    V defaultValue(KeyContext keyContext) {
        if (this.defaultValueProvider != null) {
            return this.defaultValueProvider.get(keyContext);
        }
        throw new IllegalStateException("To call acquire*() methods, you should specify either default value or default value provider during map building");
    }

    @Override
    public V prevValueOnPut(MapKeyContext<K, V> context) {
        return this.putReturnsNull ? null : (V)AbstractChronicleMap.super.prevValueOnPut(context);
    }

    @Override
    public V prevValueOnRemove(MapKeyContext<K, V> context) {
        return this.removeReturnsNull ? null : (V)AbstractChronicleMap.super.prevValueOnRemove(context);
    }

    @Override
    public V newValueInstance() {
        if (this.vClass == CharSequence.class || this.vClass == StringBuilder.class) {
            return (V)new StringBuilder();
        }
        return VanillaChronicleMap.newInstance(this.vClass, false);
    }

    @Override
    public K newKeyInstance() {
        return (K)VanillaChronicleMap.newInstance(this.kClass, true);
    }

    @Override
    public Class<K> keyClass() {
        return this.kClass;
    }

    @Override
    public Class<V> valueClass() {
        return this.vClass;
    }

    static <T> T newInstance(Class<T> aClass, boolean isKey) {
        try {
            return (T)(isKey ? DataValueClasses.newInstance(aClass) : DataValueClasses.newDirectInstance(aClass));
        }
        catch (Exception e) {
            if (e.getCause() instanceof IllegalStateException) {
                throw e;
            }
            if (aClass.isInterface()) {
                throw new IllegalStateException("It not possible to create a instance from interface=" + aClass.getSimpleName() + " we recommend you create an " + "instance in the usual way.", e);
            }
            try {
                return aClass.newInstance();
            }
            catch (Exception e1) {
                throw new IllegalStateException("It has not been possible to create a instance of class=" + aClass.getSimpleName() + ", Note : its more efficient if your chronicle map is configured with " + "interface key " + "and value types rather than classes, as this method is able to use " + "interfaces to generate off heap proxies that point straight at your data. " + "In this case you have used a class and chronicle is unable to create an " + "instance of this class has it does not have a default constructor. " + "If your class is mutable, we " + "recommend you create and instance of your class=" + aClass.getSimpleName() + " in the usual way, rather than using this method.", e);
            }
        }
    }

    @Override
    @NotNull
    public final MapKeyContext<K, V> acquireContext(K key, V usingValue) {
        VanillaContext<K, KI, MKI, V, VI, MVI> c = this.acquireContext(key);
        c.writeLock().lock();
        try {
            V value;
            if (!c.containsKey()) {
                c.doPut(this.defaultValue(c));
            }
            if ((value = c.getUsing(usingValue)) != usingValue) {
                throw new IllegalArgumentException("acquireContext MUST reuse the given value. Given value" + usingValue + " cannot be reused to read " + value);
            }
            return c;
        }
        catch (Throwable e) {
            try {
                c.closeHash();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    VanillaContext<K, KI, MKI, V, VI, MVI> acquireContext(K key) {
        AcquireContext c = VanillaContext.get(AcquireContextFactory.INSTANCE);
        c.initHash(this);
        c.initKey(key);
        return c;
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = this.newEntrySet());
    }

    @Override
    public int hashCode() {
        return this.mapHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.mapEquals(obj);
    }

    public String toString() {
        return this.mapToString();
    }

    @Override
    public void clear() {
        VanillaContext<K, KI, MKI, V, VI, MVI> context = this.mapContext();
        int i = 0;
        while (i < this.actualSegments) {
            context.segmentIndex = i++;
            try {
                context.clear();
            }
            finally {
                context.closeSegmentIndex();
            }
        }
    }

    final long readValueSize(Bytes entry) {
        long valueSize = this.valueSizeMarshaller.readSize(entry);
        this.alignment.alignPositionAddr(entry);
        return valueSize;
    }

    static enum BytesContextFactory implements ContextFactory<BytesContext>
    {
        INSTANCE;


        @Override
        public BytesContext createContext(HashContext root, int indexInContextCache) {
            return new BytesContext(root, indexInContextCache);
        }

        @Override
        public BytesContext createRootContext() {
            return new BytesContext();
        }

        @Override
        public Class<BytesContext> contextClass() {
            return BytesContext.class;
        }
    }

    static class BytesContext
    extends VanillaContext<Bytes, BytesBytesInterop, DelegatingMetaBytesInterop<Bytes, BytesBytesInterop>, Bytes, BytesBytesInterop, DelegatingMetaBytesInterop<Bytes, BytesBytesInterop>> {
        BytesContext() {
        }

        BytesContext(HashContext contextCache, int indexInContextCache) {
            super(contextCache, indexInContextCache);
        }

        @Override
        public void initKeyModel0() {
            this.initBytesKeyModel0();
        }

        @Override
        public void initKey0(Bytes key) {
            this.initBytesKey0(key);
        }

        @Override
        void initValueModel0() {
            this.initBytesValueModel0();
        }

        @Override
        void initNewValue0(Bytes newValue) {
            this.initNewBytesValue0(newValue);
        }

        @Override
        void closeValue0() {
            this.closeBytesValue0();
        }

        @Override
        public Bytes get() {
            return this.getBytes();
        }

        @Override
        public Bytes getUsing(Bytes usingValue) {
            return this.getBytesUsing(usingValue);
        }
    }

    static enum AcquireContextFactory implements ContextFactory<AcquireContext>
    {
        INSTANCE;


        @Override
        public AcquireContext createContext(HashContext root, int indexInContextCache) {
            return new AcquireContext(root, indexInContextCache);
        }

        @Override
        public AcquireContext createRootContext() {
            return new AcquireContext();
        }

        @Override
        public Class<AcquireContext> contextClass() {
            return AcquireContext.class;
        }
    }

    static class AcquireContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    extends VanillaContext<K, KI, MKI, V, VI, MVI> {
        AcquireContext() {
        }

        AcquireContext(HashContext contextCache, int indexInContextCache) {
            super(contextCache, indexInContextCache);
        }

        @Override
        public boolean put(V newValue) {
            return this.acquirePut(newValue);
        }

        @Override
        public boolean remove() {
            return this.acquireRemove();
        }

        @Override
        public void close() {
            this.acquireClose();
        }
    }
}

