/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.KeyContext;
import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.ContextFactory;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.hashlookup.HashLookup;
import net.openhft.chronicle.hash.locks.IllegalInterProcessLockStateException;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.BytesBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DelegatingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;

public abstract class HashContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>>
implements KeyContext<K> {
    static final ThreadLocal<HashContext> threadLocalContextCache = new ThreadLocal();
    final ArrayList<HashContext> contexts;
    final ReferenceQueue<ChronicleHash> hashAndContextLocalsQueue;
    final Thread owner;
    public final ThreadLocalCopies copies;
    final HashContext<K, KI, MKI> contextCache;
    final int indexInContextCache;
    boolean used;
    public VanillaChronicleHash<K, KI, MKI, ?> h;
    final ArrayList<HashAndContextLocalsReference<K>> hashAndContextLocalsCache = new ArrayList(1);
    HashAndContextLocalsReference<K> hashAndContextLocalsReference;
    KI keyInterop;
    BytesReader<K> keyReader;
    K key;
    public MKI metaKeyInterop;
    public long keySize = -1L;
    long hash;
    public int segmentIndex = -1;
    long segmentHeaderAddress;
    public SegmentHeader segmentHeader;
    HashContext rootContextOnThisSegment;
    int readLockCount;
    int updateLockCount;
    public int writeLockCount;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    final InterProcessLock readLock = new ReadLock();
    final InterProcessLock updateLock = new UpdateLock();
    final InterProcessLock writeLock = new WriteLock();
    public final HashLookup hashLookup = new HashLookup();
    final MultiStoreBytes freeListBytes = new MultiStoreBytes();
    public final SingleThreadedDirectBitSet freeList = new SingleThreadedDirectBitSet();
    long entrySpaceOffset;
    final MultiStoreBytes entryCache = new MultiStoreBytes();
    public MultiStoreBytes entry;
    SearchState searchState;
    public long pos;
    long keyOffset;
    public int entrySizeInChunks;
    public boolean forEachEntry;
    public static final Bytes DUMMY_BYTES = new ByteBufferBytes(ByteBuffer.allocate(0));
    private final MultiStoreBytes keyCopy = new MultiStoreBytes();

    public static <T extends HashContext> T get(ContextFactory<T> contextFactory) {
        HashContext cache = threadLocalContextCache.get();
        if (cache != null) {
            return cache.getContext(contextFactory);
        }
        T rootContext = contextFactory.createRootContext();
        threadLocalContextCache.set((HashContext)rootContext);
        return rootContext;
    }

    public HashContext() {
        this.contexts = new ArrayList(1);
        this.contextCache = this;
        this.indexInContextCache = 0;
        this.contexts.add(this);
        this.hashAndContextLocalsQueue = new ReferenceQueue();
        this.owner = Thread.currentThread();
        this.copies = new ThreadLocalCopies();
        this.used = true;
    }

    public HashContext(HashContext contextCache, int indexInContextCache) {
        this.contexts = null;
        this.hashAndContextLocalsQueue = null;
        this.owner = Thread.currentThread();
        this.copies = new ThreadLocalCopies();
        this.contextCache = contextCache;
        this.indexInContextCache = indexInContextCache;
    }

    <T extends HashContext> T getContext(ContextFactory<T> contextFactory) {
        HashContext<K, KI, MKI> context2;
        for (HashContext<K, KI, MKI> context2 : this.contexts) {
            if (context2.getClass() != contextFactory.contextClass() || context2.used) continue;
            context2.used = true;
            return (T)context2;
        }
        int maxNestedContexts = 65536;
        if (this.contexts.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = contextFactory.createContext(this, this.contexts.size());
        context2.used = true;
        this.contexts.add(context2);
        return (T)context2;
    }

    public boolean used() {
        return this.used;
    }

    public void checkOnEachPublicOperation() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
        if (!this.used) {
            throw new IllegalStateException("Context shouldn't be accessed after close()");
        }
    }

    @Override
    public void close() {
        this.checkOnEachPublicOperation();
        this.doClose();
    }

    public void doClose() {
        this.closeHash();
        this.used = false;
        this.totalCheckClosed();
    }

    public void totalCheckClosed() {
        assert (!this.hashInit()) : "map not closed";
        assert (!this.hashAndContextLocalsInit()) : "map&context locals not closed";
        assert (!this.keyModelInit()) : "key model not closed";
        assert (!this.keyReaderInit()) : "key reader not closed";
        assert (!this.keyInit()) : "key not closed";
        assert (!this.keyHashInit()) : "key hash not closed";
        assert (!this.segmentIndexInit()) : "segment index not closed";
        assert (!this.segmentHeaderInit()) : "segment header not closed";
        assert (!this.locksInit()) : "locks not closed";
        assert (!this.segmentInit()) : "segment not closed";
        assert (!this.hashLookupInit()) : "hash lookup not closed";
        assert (!this.keySearchInit()) : "key search not closed";
        assert (!this.entrySizeInChunksInit()) : "entry size in chunks not closed";
    }

    public boolean hashInit() {
        return this.h != null;
    }

    public void initHash(VanillaChronicleHash hash) {
        this.initHashDependencies();
        this.initHash0(hash);
    }

    public void initHashDependencies() {
    }

    void initHash0(VanillaChronicleHash<K, KI, MKI, ?> hash) {
        this.h = hash;
    }

    public void checkHashInit() {
        if (!this.hashInit()) {
            throw new IllegalStateException("Hash should be init");
        }
    }

    public void closeHash() {
        if (!this.hashInit()) {
            return;
        }
        this.closeHashDependants();
        this.closeHash0();
    }

    public void closeHashDependants() {
        this.closeHashAndContextLocals();
        this.closeSegmentHeader();
        this.closeKeyModel();
        this.closeKey();
        this.closeKeyReader();
        this.closeSegmentIndex();
        this.closeLocks();
    }

    void closeHash0() {
        this.h = null;
    }

    public boolean hashAndContextLocalsInit() {
        return this.hashAndContextLocalsReference != null;
    }

    public void initHashAndContextLocals() {
        if (this.hashAndContextLocalsInit()) {
            return;
        }
        this.initHashAndContextLocalsDependencies();
        this.initHashAndContextLocals0();
    }

    public void initHashAndContextLocalsDependencies() {
        this.checkHashInit();
    }

    void initHashAndContextLocals0() {
        this.pollLocalsQueue();
        int firstEmptyIndex = -1;
        int cacheSize = this.hashAndContextLocalsCache.size();
        for (int i = 0; i < cacheSize; ++i) {
            ChronicleHash referencedHash;
            HashAndContextLocalsReference<K> ref = this.hashAndContextLocalsCache.get(i);
            if (ref == null || (referencedHash = (ChronicleHash)ref.get()) == null) {
                if (firstEmptyIndex < 0) {
                    firstEmptyIndex = i;
                }
                if (ref == null) continue;
                this.hashAndContextLocalsCache.set(i, null);
                continue;
            }
            if (referencedHash != this.h) continue;
            this.hashAndContextLocalsReference = ref;
            return;
        }
        HashAndContextLocals<K> hashAndContextLocals = this.newHashAndContextLocals();
        int indexToInsert = firstEmptyIndex < 0 ? cacheSize : firstEmptyIndex;
        HashAndContextLocalsReference<K> ref = new HashAndContextLocalsReference<K>(this.h, this.contextCache.hashAndContextLocalsQueue, hashAndContextLocals);
        this.hashAndContextLocalsReference = ref;
        this.hashAndContextLocalsCache.add(indexToInsert, ref);
    }

    public HashAndContextLocals<K> newHashAndContextLocals() {
        return new HashAndContextLocals(this.h);
    }

    public HashAndContextLocals<K> hashAndContextLocals() {
        return this.hashAndContextLocalsReference.hashAndContextLocals;
    }

    void pollLocalsQueue() {
        Reference<ChronicleHash> ref;
        while ((ref = this.contextCache.hashAndContextLocalsQueue.poll()) != null) {
            ((HashAndContextLocalsReference)ref).hashAndContextLocals = null;
        }
    }

    public void closeHashAndContextLocals() {
        if (!this.hashAndContextLocalsInit()) {
            return;
        }
        this.closeHashContextAndLocalsDependants();
        this.closeHashAndContextLocals0();
    }

    public void closeHashContextAndLocalsDependants() {
    }

    void closeHashAndContextLocals0() {
        this.hashAndContextLocalsReference = null;
    }

    public void initKeyModel() {
        if (this.keyModelInit()) {
            return;
        }
        this.initKeyModelDependencies();
        this.initKeyModel0();
    }

    public boolean keyModelInit() {
        return this.keyInterop != null;
    }

    public void initKeyModelDependencies() {
        this.checkHashInit();
    }

    public void initKeyModel0() {
        this.keyInterop = this.h.keyInteropProvider.get(this.copies, this.h.originalKeyInterop);
    }

    public void closeKeyModel() {
        if (!this.keyModelInit()) {
            return;
        }
        this.closeKeyModelDependants();
        this.closeKeyModel0();
    }

    public void closeKeyModelDependants() {
        this.closeKey();
    }

    void closeKeyModel0() {
        this.keyInterop = null;
    }

    public void initKeyReader() {
        if (this.keyReaderInit()) {
            return;
        }
        this.initKeyReaderDependencies();
        this.initKeyReader0();
    }

    public boolean keyReaderInit() {
        return this.keyReader != null;
    }

    public void initKeyReaderDependencies() {
        this.checkHashInit();
    }

    void initKeyReader0() {
        this.keyReader = (BytesReader)this.h.keyReaderProvider.get(this.copies, this.h.originalKeyReader);
    }

    public void closeKeyReader() {
        if (!this.keyReaderInit()) {
            return;
        }
        this.closeKeyReaderDependants();
        this.closeKeyReader0();
    }

    public void closeKeyReaderDependants() {
        this.closeKey();
    }

    void closeKeyReader0() {
        this.keyReader = null;
    }

    public void initKey(K key) {
        this.initKeyDependencies();
        this.initKey0(key);
    }

    public boolean keyInit() {
        return this.keySize >= 0L;
    }

    public void initKeyDependencies() {
        this.initKeyModel();
    }

    public void initKey0(K key) {
        this.h.checkKey(key);
        MetaBytesInterop mki = (MetaBytesInterop)this.h.metaKeyInteropProvider.get(this.copies, this.h.originalMetaKeyInterop, this.keyInterop, key);
        this.keySize = mki.size(this.keyInterop, key);
        this.metaKeyInterop = mki;
        this.key = key;
    }

    public void checkKeyInit() {
        if (!this.keyInit()) {
            throw new IllegalStateException("Key should be init");
        }
    }

    public void closeKey() {
        if (!this.keyInit()) {
            return;
        }
        this.closeKeyDependants();
        this.closeKey0();
    }

    public void closeKeyDependants() {
        this.closeKeyHash();
    }

    public void closeKey0() {
        this.keySize = -1L;
        this.metaKeyInterop = null;
        this.key = null;
    }

    @Override
    public long keySize() {
        this.checkOnEachPublicOperation();
        this.checkKeyInit();
        return this.keySize0();
    }

    public long keySize0() {
        return this.keySize;
    }

    @Override
    @NotNull
    public K key() {
        if (this.key != null) {
            return this.key;
        }
        this.initKeySearch();
        this.initHashAndContextLocals();
        this.hashAndContextLocals().reusableKey = this.key0(this.hashAndContextLocals().reusableKey);
        assert (this.key != null);
        return this.key;
    }

    public void initKeyHash() {
        if (this.keyHashInit()) {
            return;
        }
        this.initKeyHashDependencies();
        this.initKeyHash0();
    }

    public boolean keyHashInit() {
        return this.hash != 0L;
    }

    public void initKeyHashDependencies() {
        this.checkKeyInit();
        this.initKeyModel();
    }

    void initKeyHash0() {
        this.hash = this.metaKeyInterop.hash(this.keyInterop, LongHashFunction.city_1_1(), this.key);
    }

    public void closeKeyHash() {
        this.closeKeyHashDependants();
        this.closeKeyHash0();
    }

    public void closeKeyHashDependants() {
        this.closeSegmentIndex();
    }

    void closeKeyHash0() {
        this.hash = 0L;
    }

    public void initSegmentIndex() {
        if (this.segmentIndexInit()) {
            return;
        }
        this.initSegmentIndexDependencies();
        this.initSegmentIndex0();
    }

    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    public void initSegmentIndexDependencies() {
        this.initKeyHash();
    }

    void initSegmentIndex0() {
        this.segmentIndex = this.h.hashSplitting.segmentIndex(this.hash);
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.closeSegmentIndex0();
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
    }

    void closeSegmentIndex0() {
        this.segmentIndex = -1;
    }

    public void initSegmentHeader() {
        if (this.segmentHeaderInit()) {
            return;
        }
        this.initSegmentHeaderDependencies();
        this.initSegmentHeader0();
    }

    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    public void initSegmentHeaderDependencies() {
        this.initSegmentIndex();
    }

    void initSegmentHeader0() {
        this.segmentHeaderAddress = this.h.ms.address() + this.h.segmentHeaderOffset(this.segmentIndex);
        this.segmentHeader = BigSegmentHeader.INSTANCE;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.closeSegmentHeader0();
    }

    public void closeSegmentHeaderDependants() {
        this.closeLocks();
        this.closeSegment();
    }

    void closeSegmentHeader0() {
        this.segmentHeader = null;
    }

    public long entries() {
        this.initSegmentHeader();
        return this.segmentHeader.size(this.segmentHeaderAddress);
    }

    public void entries(long size) {
        this.segmentHeader.size(this.segmentHeaderAddress, size);
    }

    public long nextPosToSearchFrom() {
        return this.segmentHeader.nextPosToSearchFrom(this.segmentHeaderAddress);
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        this.segmentHeader.nextPosToSearchFrom(this.segmentHeaderAddress, nextPosToSearchFrom);
    }

    public long deleted() {
        this.initSegmentHeader();
        return this.segmentHeader.deleted(this.segmentHeaderAddress);
    }

    public void deleted(long deleted) {
        this.segmentHeader.deleted(this.segmentHeaderAddress, deleted);
    }

    public long size() {
        return this.entries() - this.deleted();
    }

    public void initLocks() {
        if (this.locksInit()) {
            return;
        }
        this.initLocksDependencies();
        this.initLocks0();
    }

    public boolean locksInit() {
        return this.rootContextOnThisSegment != null;
    }

    public void initLocksDependencies() {
        this.initSegmentHeader();
    }

    void initLocks0() {
        this.readLockCount = 0;
        this.updateLockCount = 0;
        this.writeLockCount = 0;
        for (int i = 0; i < this.indexInContextCache; ++i) {
            HashContext parentContext = this.contextCache.contexts.get(i);
            if (parentContext.segmentHeader == null || parentContext.segmentHeaderAddress != this.segmentHeaderAddress) continue;
            this.rootContextOnThisSegment = parentContext;
            return;
        }
        this.rootContextOnThisSegment = this;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
    }

    public void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        this.closeLocks0();
    }

    public void closeLocksDependants() {
        this.closeKeySearch();
    }

    void closeLocks0() {
        if (this.rootContextOnThisSegment == this) {
            if (this.totalWriteLockCount > 0) {
                this.segmentHeader.writeUnlock(this.segmentHeaderAddress);
                this.closeKeySearch();
            } else if (this.totalUpdateLockCount > 0) {
                this.segmentHeader.updateUnlock(this.segmentHeaderAddress);
                this.closeKeySearch();
            } else if (this.totalReadLockCount > 0) {
                this.segmentHeader.readUnlock(this.segmentHeaderAddress);
                this.closeKeySearch();
            }
        } else if (this.writeLockCount > 0 && this.rootContextOnThisSegment.totalReadLockCount == this.writeLockCount) {
            if (this.shouldUpdateUnlock()) {
                if (this.shouldReadUnlock()) {
                    this.segmentHeader.writeUnlock(this.segmentHeaderAddress);
                    this.closeKeySearch();
                } else {
                    this.segmentHeader.downgradeWriteToReadLock(this.segmentHeaderAddress);
                }
            } else {
                this.segmentHeader.downgradeWriteToUpdateLock(this.segmentHeaderAddress);
            }
        } else if (this.shouldUpdateUnlock()) {
            if (this.shouldReadUnlock()) {
                this.segmentHeader.updateUnlock(this.segmentHeaderAddress);
                this.closeKeySearch();
            } else {
                this.segmentHeader.downgradeUpdateToReadLock(this.segmentHeaderAddress);
            }
        } else if (this.shouldReadUnlock()) {
            this.segmentHeader.readUnlock(this.segmentHeaderAddress);
            this.closeKeySearch();
        }
        this.rootContextOnThisSegment.totalReadLockCount -= this.readLockCount;
        this.rootContextOnThisSegment.totalUpdateLockCount -= this.updateLockCount;
        this.rootContextOnThisSegment.totalWriteLockCount -= this.writeLockCount;
        this.writeLockCount = 0;
        this.updateLockCount = 0;
        this.readLockCount = 0;
        this.rootContextOnThisSegment = null;
    }

    public boolean isReadLocked() {
        return this.rootContextOnThisSegment.totalReadLockCount > 0;
    }

    public boolean isUpdateLocked() {
        return this.rootContextOnThisSegment.totalUpdateLockCount > 0;
    }

    public boolean isWriteLocked() {
        return this.rootContextOnThisSegment.totalWriteLockCount > 0;
    }

    public void upgradeToWriteLock() {
        if (!this.isWriteLocked()) {
            this.writeLock();
        }
    }

    boolean shouldReadUnlock() {
        return this.readLockCount > 0 && this.rootContextOnThisSegment.totalReadLockCount == this.readLockCount;
    }

    boolean shouldUpdateUnlock() {
        return this.updateLockCount > 0 && this.rootContextOnThisSegment.totalUpdateLockCount == this.updateLockCount;
    }

    void incrementReadCounts() {
        ++this.rootContextOnThisSegment.totalReadLockCount;
        ++this.readLockCount;
    }

    void decrementReadCounts() {
        --this.rootContextOnThisSegment.totalReadLockCount;
        --this.readLockCount;
    }

    void incrementUpdateCounts() {
        this.incrementReadCounts();
        ++this.rootContextOnThisSegment.totalUpdateLockCount;
        ++this.updateLockCount;
    }

    void decrementUpdateCounts() {
        this.decrementReadCounts();
        --this.rootContextOnThisSegment.totalUpdateLockCount;
        --this.updateLockCount;
    }

    void incrementWriteCounts() {
        this.incrementUpdateCounts();
        ++this.rootContextOnThisSegment.totalWriteLockCount;
        ++this.writeLockCount;
    }

    void decrementWriteCounts() {
        this.decrementUpdateCounts();
        --this.rootContextOnThisSegment.totalWriteLockCount;
        --this.writeLockCount;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        this.initLocks();
        return this.readLock;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        this.initLocks();
        return this.updateLock;
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        this.initLocks();
        return this.writeLock;
    }

    public void initSegment() {
        if (this.segmentInit()) {
            return;
        }
        this.initSegmentDependencies();
        this.initSegment0();
    }

    public boolean segmentInit() {
        return this.entrySpaceOffset != 0L;
    }

    public void initSegmentDependencies() {
        this.initSegmentHeader();
    }

    void initSegment0() {
        long hashLookupOffset = this.h.segmentOffset(this.segmentIndex);
        this.hashLookup.reuse(this.h.ms.address() + hashLookupOffset, this.h.segmentHashLookupCapacity, this.h.segmentHashLookupEntrySize, this.h.segmentHashLookupKeyBits, this.h.segmentHashLookupValueBits);
        long freeListOffset = hashLookupOffset + this.h.segmentHashLookupOuterSize;
        this.freeListBytes.storePositionAndSize(this.h.ms, freeListOffset, this.h.segmentFreeListInnerSize);
        this.freeList.reuse((Bytes)this.freeListBytes);
        this.entrySpaceOffset = freeListOffset + this.h.segmentFreeListOuterSize + (long)this.h.segmentEntrySpaceInnerOffset;
    }

    public void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.closeSegment0();
    }

    public void closeSegmentDependants() {
        this.closeHashLookup();
    }

    void closeSegment0() {
        this.entrySpaceOffset = 0L;
    }

    public void initHashLookup() {
        if (this.hashLookupInit()) {
            return;
        }
        this.initHashLookupDependencies();
        this.hashLookup.init0(this.h.hashSplitting.segmentHash(this.hash));
    }

    public boolean hashLookupInit() {
        return this.hashLookup.isInit();
    }

    public void initHashLookupDependencies() {
        this.initSegment();
    }

    public void closeHashLookup() {
        if (!this.hashLookupInit()) {
            return;
        }
        this.closeHashLookupDependants();
        this.hashLookup.close0();
    }

    public void closeHashLookupDependants() {
        this.closeKeySearch();
    }

    final MultiStoreBytes reuse(MultiStoreBytes entry, long pos) {
        long offsetWithinEntrySpace = pos * this.h.chunkSize;
        entry.setBytesOffset(this.h.bytes, this.entrySpaceOffset + offsetWithinEntrySpace);
        entry.limit(this.h.segmentEntrySpaceInnerSize - offsetWithinEntrySpace);
        return entry;
    }

    public final void reuse(long pos) {
        this.entry = this.reuse(this.entryCache, pos);
    }

    public void initKeySearch() {
        if (this.keySearchInit()) {
            return;
        }
        this.initKeySearchDependencies();
        this.initKeySearch0();
    }

    public boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearchDependencies() {
        this.initHashLookup();
        this.initLocks();
        if (!this.isReadLocked()) {
            this.readLock().lock();
        }
    }

    void initKeySearch0() {
        this.hashLookup.initSearch0();
        while ((this.pos = this.hashLookup.nextPos()) >= 0L) {
            this.reuse(this.pos);
            if (!this.keyEquals()) continue;
            this.hashLookup.found();
            this.initKeyOffset0();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
    }

    boolean keyEquals() {
        return this.keySize == this.h.keySizeMarshaller.readSize((Bytes)this.entry) && this.metaKeyInterop.startsWith(this.keyInterop, (Bytes)this.entry, this.key);
    }

    public void initKeyOffset0() {
        this.keyOffset = this.entry.position();
    }

    public void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.closeKeySearchDependants();
        this.closeKeySearch0();
    }

    public void closeKeySearchDependants() {
    }

    void closeKeySearch0() {
        this.searchState = null;
        this.pos = -1L;
        this.entry = null;
        this.hashLookup.closeSearch0();
    }

    @Override
    public boolean containsKey() {
        this.checkOnEachPublicOperation();
        this.initKeySearch();
        return this.containsKey0();
    }

    public boolean containsKey0() {
        return this.searchStatePresent();
    }

    public SearchState searchState0() {
        return this.searchState;
    }

    public boolean searchStatePresent() {
        return this.searchState == SearchState.PRESENT;
    }

    public void checkContainsKey() {
        if (!this.containsKey()) {
            throw new IllegalStateException("Key is absent");
        }
    }

    @Override
    public Bytes entry() {
        this.checkContainsKey();
        return this.entry;
    }

    @Override
    public long keyOffset() {
        this.checkContainsKey();
        return this.keyOffset0();
    }

    public long keyOffset0() {
        return this.keyOffset;
    }

    public void initEntrySizeInChunks() {
        if (this.entrySizeInChunksInit()) {
            return;
        }
        this.initEntrySizeInChunksDependencies();
        this.initEntrySizeInChunks0();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    public void initEntrySizeInChunksDependencies() {
    }

    public abstract void initEntrySizeInChunks0();

    public void closeEntrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            return;
        }
        this.closeEntrySizeInChunksDependants();
        this.closeEntrySizeInChunks0();
    }

    public void closeEntrySizeInChunksDependants() {
    }

    void closeEntrySizeInChunks0() {
        this.entrySizeInChunks = 0;
    }

    public void updateLockIfNeeded() {
        if (!this.isUpdateLocked()) {
            this.updateLock().lock();
        }
    }

    public int allocateEntry(long entrySize) {
        int allocatedChunks = this.h.inChunks(entrySize);
        this.pos = this.alloc(allocatedChunks);
        this.reuse(this.pos);
        return allocatedChunks;
    }

    public int allocateEntryAndWriteKey(long payloadSize) {
        int allocatedChunks = this.allocateEntry(this.keySize + payloadSize);
        this.h.keySizeMarshaller.writeSize((Bytes)this.entry, this.keySize);
        this.initKeyOffset0();
        this.metaKeyInterop.write(this.keyInterop, (Bytes)this.entry, this.key);
        if (!this.searchStatePresent()) {
            this.entries(this.entries() + 1L);
        }
        return allocatedChunks;
    }

    public void commitEntryAllocation() {
        this.searchState = SearchState.PRESENT;
        this.hashLookup.putVolatile(this.pos);
    }

    public final long alloc(int chunks) {
        if (chunks > this.h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + this.h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList.setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > this.h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > this.h.actualChunksPerSegment && ret < this.h.actualChunksPerSegment) {
                this.freeList.clear(ret, this.h.actualChunksPerSegment);
            }
            if ((ret = this.freeList.setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > this.h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > this.h.actualChunksPerSegment && ret < this.h.actualChunksPerSegment) {
                    this.freeList.clear(ret, this.h.actualChunksPerSegment);
                }
                if (chunks == 1) {
                    throw new IllegalStateException("Segment is full, no free entries found");
                }
                throw new IllegalStateException("Segment is full or has no ranges of " + chunks + " continuous free chunks");
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList.isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void free(long fromPos, int chunks) {
        this.freeList.clear(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h.actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    @Override
    public boolean remove() {
        this.checkOnEachPublicOperation();
        this.initRemoveDependencies();
        try {
            boolean bl = this.remove0();
            return bl;
        }
        finally {
            this.closeRemove();
        }
    }

    public boolean remove0() {
        if (this.containsKey()) {
            this.initEntrySizeInChunks();
            this.upgradeToWriteLock();
            this.hashLookupRemove();
            this.free(this.pos, this.entrySizeInChunks);
            this.entries(this.entries() - 1L);
            this.searchState = SearchState.DELETED;
            return true;
        }
        return false;
    }

    public void hashLookupRemove() {
        if (!this.forEachEntry) {
            this.hashLookup.remove();
        }
    }

    public void initRemoveDependencies() {
        this.initSegment();
        this.initLocks();
        this.updateLockIfNeeded();
    }

    public void closeRemove() {
    }

    public void clear() {
        this.writeLock();
        this.initSegment();
        this.hashLookup.clear();
        this.freeList.clear();
        this.nextPosToSearchFrom(0L);
        this.entries(0L);
    }

    public void initBytesKeyModel0() {
        this.keyInterop = BytesBytesInterop.INSTANCE;
    }

    public void initBytesKey0(Bytes key) {
        this.keySize = this.h.keySizeMarshaller.readSize(key);
        key.limit(key.position() + this.keySize);
        this.initBytesKey00(key);
        this.metaKeyInterop = DelegatingMetaBytesInterop.instance();
    }

    public void initBytesKey00(Bytes key) {
        this.keyCopy.setBytesOffset(key, key.position());
        this.keyCopy.limit(this.keySize);
        this.key = this.keyCopy;
    }

    public void initKeyFromPos() {
        this.reuse(this.pos);
        this.keySize = this.h.keySizeMarshaller.readSize((Bytes)this.entry);
        this.initKeyOffset0();
        this.keyFound();
    }

    public K immutableKey() {
        return this.key0(null);
    }

    K key0(K usingKey) {
        this.initKeyReader();
        this.entry.position(this.keyOffset);
        this.key = this.keyReader.read((Bytes)this.entry, this.keySize, usingKey);
        return this.key;
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    class WriteLock
    extends AbstractLock {
        WriteLock() {
        }

        @Override
        boolean fastLock() {
            if (HashContext.this.rootContextOnThisSegment.totalWriteLockCount == 0) {
                if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount == 0 && HashContext.this.rootContextOnThisSegment.totalReadLockCount != 0) {
                    throw new IllegalInterProcessLockStateException("Must not acquire write lock, while read lock is already held by this thread");
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return HashContext.this.isWriteLocked();
        }

        @Override
        void doLock() {
            if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                HashContext.this.segmentHeader.upgradeUpdateToWriteLock(HashContext.this.segmentHeaderAddress);
            } else {
                HashContext.this.segmentHeader.writeLock(HashContext.this.segmentHeaderAddress);
            }
        }

        @Override
        void doLockInterruptibly() {
            if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                HashContext.this.segmentHeader.upgradeUpdateToWriteLockInterruptibly(HashContext.this.segmentHeaderAddress);
            } else {
                HashContext.this.segmentHeader.writeLockInterruptibly(HashContext.this.segmentHeaderAddress);
            }
        }

        @Override
        public boolean tryLock() {
            HashContext.this.checkOnEachPublicOperation();
            if (this.doTryLock()) {
                this.incrementCounts();
                return true;
            }
            return false;
        }

        boolean doTryLock() {
            if (HashContext.this.rootContextOnThisSegment.totalWriteLockCount == 0) {
                if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                    return HashContext.this.segmentHeader.tryUpgradeUpdateToWriteLock(HashContext.this.segmentHeaderAddress);
                }
                if (HashContext.this.rootContextOnThisSegment.totalReadLockCount > 0) {
                    return HashContext.this.segmentHeader.tryUpgradeReadToWriteLock(HashContext.this.segmentHeaderAddress);
                }
                return HashContext.this.segmentHeader.tryWriteLock(HashContext.this.segmentHeaderAddress);
            }
            return true;
        }

        @Override
        boolean doTryLock(long time, TimeUnit unit) {
            if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                return HashContext.this.segmentHeader.tryUpgradeUpdateToWriteLock(HashContext.this.segmentHeaderAddress, time, unit);
            }
            return HashContext.this.segmentHeader.tryWriteLock(HashContext.this.segmentHeaderAddress, time, unit);
        }

        @Override
        void incrementCounts() {
            HashContext.this.incrementWriteCounts();
        }

        @Override
        public void unlock() {
            if (HashContext.this.writeLockCount == 0) {
                throw new IllegalInterProcessLockStateException("Write lock is not held");
            }
            if (HashContext.this.rootContextOnThisSegment.totalWriteLockCount == 1) {
                if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount == 1) {
                    if (HashContext.this.rootContextOnThisSegment.totalReadLockCount == 1) {
                        HashContext.this.segmentHeader.writeUnlock(HashContext.this.segmentHeaderAddress);
                        HashContext.this.closeKeySearch();
                    } else {
                        HashContext.this.segmentHeader.downgradeWriteToReadLock(HashContext.this.segmentHeaderAddress);
                    }
                } else {
                    HashContext.this.segmentHeader.downgradeWriteToUpdateLock(HashContext.this.segmentHeaderAddress);
                }
            }
            HashContext.this.decrementWriteCounts();
        }
    }

    class UpdateLock
    extends AbstractLock {
        UpdateLock() {
        }

        @Override
        boolean fastLock() {
            if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount == 0) {
                if (HashContext.this.rootContextOnThisSegment.totalReadLockCount != 0) {
                    throw new IllegalInterProcessLockStateException("Must not acquire update lock, while read lock is already held by this thread");
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return HashContext.this.isUpdateLocked();
        }

        @Override
        void doLock() {
            HashContext.this.segmentHeader.updateLock(HashContext.this.segmentHeaderAddress);
        }

        @Override
        void doLockInterruptibly() {
            HashContext.this.segmentHeader.updateLockInterruptibly(HashContext.this.segmentHeaderAddress);
        }

        @Override
        public boolean tryLock() {
            HashContext.this.checkOnEachPublicOperation();
            if (this.doTryLock()) {
                this.incrementCounts();
                return true;
            }
            return false;
        }

        boolean doTryLock() {
            if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount == 0) {
                if (HashContext.this.rootContextOnThisSegment.totalReadLockCount > 0) {
                    return HashContext.this.segmentHeader.tryUpgradeReadToUpdateLock(HashContext.this.segmentHeaderAddress);
                }
                return HashContext.this.segmentHeader.tryUpdateLock(HashContext.this.segmentHeaderAddress);
            }
            return true;
        }

        @Override
        boolean doTryLock(long time, TimeUnit unit) {
            return HashContext.this.segmentHeader.tryUpdateLock(HashContext.this.segmentHeaderAddress, time, unit);
        }

        @Override
        void incrementCounts() {
            HashContext.this.incrementUpdateCounts();
        }

        @Override
        public void unlock() {
            if (HashContext.this.updateLockCount == 0) {
                throw new IllegalInterProcessLockStateException("Update lock is not held");
            }
            if (HashContext.this.rootContextOnThisSegment.totalUpdateLockCount == 1) {
                if (HashContext.this.rootContextOnThisSegment.totalReadLockCount == 1) {
                    HashContext.this.segmentHeader.updateUnlock(HashContext.this.segmentHeaderAddress);
                    HashContext.this.closeKeySearch();
                } else {
                    HashContext.this.segmentHeader.downgradeUpdateToReadLock(HashContext.this.segmentHeaderAddress);
                }
            }
            HashContext.this.decrementUpdateCounts();
        }
    }

    class ReadLock
    extends AbstractLock {
        ReadLock() {
        }

        @Override
        boolean fastLock() {
            return HashContext.this.isReadLocked();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return this.fastLock();
        }

        @Override
        void doLock() {
            HashContext.this.segmentHeader.readLock(HashContext.this.segmentHeaderAddress);
        }

        @Override
        void doLockInterruptibly() {
            HashContext.this.segmentHeader.readLockInterruptibly(HashContext.this.segmentHeaderAddress);
        }

        @Override
        public boolean tryLock() {
            HashContext.this.checkOnEachPublicOperation();
            if (this.fastLock() || HashContext.this.segmentHeader.tryReadLock(HashContext.this.segmentHeaderAddress)) {
                this.incrementCounts();
                return true;
            }
            return false;
        }

        @Override
        boolean doTryLock(long time, TimeUnit unit) {
            return HashContext.this.segmentHeader.tryReadLock(HashContext.this.segmentHeaderAddress, time, unit);
        }

        @Override
        void incrementCounts() {
            HashContext.this.incrementReadCounts();
        }

        @Override
        public void unlock() {
            if (HashContext.this.readLockCount == 0) {
                throw new IllegalInterProcessLockStateException("Read lock is not held");
            }
            if (HashContext.this.rootContextOnThisSegment.totalReadLockCount == 1) {
                HashContext.this.segmentHeader.readUnlock(HashContext.this.segmentHeaderAddress);
                HashContext.this.closeKeySearch();
            }
            HashContext.this.decrementReadCounts();
        }
    }

    abstract class AbstractLock
    implements InterProcessLock {
        AbstractLock() {
        }

        abstract boolean fastLock();

        abstract void doLock();

        abstract void doLockInterruptibly();

        abstract boolean doTryLock(long var1, TimeUnit var3);

        abstract void incrementCounts();

        @Override
        public void lock() {
            HashContext.this.checkOnEachPublicOperation();
            if (!this.fastLock()) {
                this.doLock();
            }
            this.incrementCounts();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            HashContext.this.checkOnEachPublicOperation();
            if (!this.fastLock()) {
                this.doLockInterruptibly();
            }
            this.incrementCounts();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            HashContext.this.checkOnEachPublicOperation();
            if (this.fastLock() || this.doTryLock(time, unit)) {
                this.incrementCounts();
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    static class HashAndContextLocalsReference<K>
    extends WeakReference<ChronicleHash<K, ?>> {
        HashAndContextLocals<K> hashAndContextLocals;

        public HashAndContextLocalsReference(ChronicleHash<K, ?> hash, ReferenceQueue<ChronicleHash> hashAndContextLocalsQueue, HashAndContextLocals<K> hashAndContextLocals) {
            super(hash, hashAndContextLocalsQueue);
            this.hashAndContextLocals = hashAndContextLocals;
        }
    }

    public static class HashAndContextLocals<K> {
        K reusableKey;

        public HashAndContextLocals(ChronicleHash<K, ?> hash) {
            if (hash.keyClass() == CharSequence.class) {
                this.reusableKey = new StringBuilder();
            }
        }
    }
}

