/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.DeserializationFactoryConfigurableBytesReader;
import net.openhft.chronicle.hash.serialization.internal.ByteableMarshaller;
import net.openhft.compiler.CompilerUtils;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.DataValueGenerator;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.DataValueModels;
import net.openhft.lang.model.FieldModel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public final class DataValueBytesMarshallers {
    private static final boolean dumpCode = Boolean.getBoolean("dvg.dumpCode");
    private static final Map<Class, Class> readersClassMap = new ConcurrentHashMap<Class, Class>();
    private static final Map<Class, Class> readersWithCustomFactoriesClassMap = new ConcurrentHashMap<Class, Class>();
    private static final Map<Class, Class> writerClassMap = new ConcurrentHashMap<Class, Class>();

    public static <T> BytesReader<T> acquireBytesReader(Class<T> tClass) {
        if (tClass == CharSequence.class) {
            throw new IllegalArgumentException("CharSequence not supported as a Data Value model");
        }
        Class readerClass = DataValueBytesMarshallers.acquireReaderClass(tClass);
        try {
            Field instanceField = readerClass.getDeclaredField("INSTANCE");
            Object reader = instanceField.get(null);
            return (BytesReader)reader;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> BytesWriter<T> acquireBytesWriter(Class<T> tClass) {
        Class readerClass = DataValueBytesMarshallers.acquireWriterClass(tClass);
        try {
            Field instanceField = readerClass.getDeclaredField("INSTANCE");
            Object reader = instanceField.get(null);
            return (BytesWriter)reader;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> Class acquireReaderClass(Class<T> tClass) {
        DataValueClasses.directClassFor(tClass);
        Class readerClass = readersClassMap.get(tClass);
        if (readerClass != null) {
            return readerClass;
        }
        DataValueModel dvmodel = DataValueModels.acquireModel(tClass);
        for (Class clazz : dvmodel.nestedModels()) {
            Class clazz2 = DataValueBytesMarshallers.acquireReaderClass(clazz);
        }
        String actual = DataValueBytesMarshallers.generateBytesReader(tClass);
        if (dumpCode) {
            LoggerFactory.getLogger(DataValueGenerator.class).info(actual);
        }
        ClassLoader classLoader = tClass.getClassLoader();
        String className = DataValueBytesMarshallers.bytesReaderName(tClass, false);
        try {
            readerClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            try {
                readerClass = CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, actual);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        readersClassMap.put(tClass, readerClass);
        DataValueBytesMarshallers.acquireReaderWithCustomFactory(tClass);
        return readerClass;
    }

    public static <T> Class acquireWriterClass(Class<T> tClass) {
        Class writerClass = writerClassMap.get(tClass);
        if (writerClass != null) {
            return writerClass;
        }
        DataValueModel dvmodel = DataValueModels.acquireModel(tClass);
        for (Class clazz : dvmodel.nestedModels()) {
            Class clazz2 = DataValueBytesMarshallers.acquireWriterClass(clazz);
        }
        String actual = DataValueBytesMarshallers.generateBytesWriter(tClass);
        if (dumpCode) {
            LoggerFactory.getLogger(DataValueGenerator.class).info(actual);
        }
        ClassLoader classLoader = tClass.getClassLoader();
        String className = DataValueBytesMarshallers.bytesWriterName(tClass, false);
        try {
            writerClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            try {
                writerClass = CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, actual);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        writerClassMap.put(tClass, writerClass);
        return writerClass;
    }

    public static <T> Class acquireReaderWithCustomFactory(Class<T> tClass) {
        Class c = readersWithCustomFactoriesClassMap.get(tClass);
        if (c != null) {
            return c;
        }
        DataValueBytesMarshallers.acquireReaderClass(tClass);
        String actual = DataValueBytesMarshallers.generateWithCustomFactoryClass(tClass);
        if (dumpCode) {
            LoggerFactory.getLogger(DataValueGenerator.class).info(actual);
        }
        ClassLoader classLoader = tClass.getClassLoader();
        String className = DataValueBytesMarshallers.withCustomFactoryName(tClass);
        try {
            c = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            try {
                c = CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, actual);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        readersWithCustomFactoriesClassMap.put(tClass, c);
        return c;
    }

    private static <T> String withCustomFactoryName(Class<T> tClass) {
        return DataValueBytesMarshallers.bytesReaderName(tClass, false) + "$WithCustomFactory";
    }

    private static String generateWithCustomFactoryClass(Class tClass) {
        DataValueModel dvModel = DataValueModels.acquireModel((Class)tClass);
        TreeSet imported = DataValueGenerator.newImported();
        imported.add(ObjectFactory.class);
        imported.add(NotNull.class);
        imported.add(dvModel.type());
        String simpleName = tClass.getSimpleName();
        String bytesReaderName = DataValueBytesMarshallers.bytesReaderName(DataValueGenerator.simpleName((Class)tClass));
        String name = bytesReaderName + "$WithCustomFactory";
        String withCustomFactoryClass = "public final class " + name + " extends " + bytesReaderName + " {\n" + "    private static final long serialVersionUID = 0L;\n" + "\n" + "    @NotNull\n" + "    private final ObjectFactory<" + simpleName + "> factory;\n" + "\n" + "    " + name + "(@NotNull ObjectFactory<" + simpleName + "> factory) {\n" + "        this.factory = factory;\n" + "    }\n" + "\n" + "    @Override\n" + "    " + simpleName + " getInstance() throws Exception {\n" + "        return factory.create();\n" + "    }\n" + "}\n";
        StringBuilder sb = new StringBuilder();
        DataValueGenerator.appendPackage((DataValueModel)dvModel, (StringBuilder)sb);
        DataValueGenerator.appendImported((SortedSet)imported, (StringBuilder)sb);
        sb.append(withCustomFactoryClass);
        return sb.toString();
    }

    private static String bytesReaderName(Class type, boolean simple) {
        return (simple ? type.getSimpleName() : type.getName()) + "$$BytesReader";
    }

    private static String bytesReaderName(String className) {
        return className + "$$BytesReader";
    }

    public static String bytesWriterName(Class type, boolean simple) {
        return (simple ? DataValueGenerator.simpleName((Class)type) : type.getName()) + "$$BytesWriter";
    }

    private static String generateBytesReader(Class<?> tClass) {
        DataValueModel dvModel = DataValueModels.acquireModel(tClass);
        TreeSet imported = DataValueGenerator.newImported();
        imported.add(BytesReader.class);
        imported.add(DeserializationFactoryConfigurableBytesReader.class);
        imported.add(ObjectFactory.class);
        imported.add(Bytes.class);
        imported.add(ByteableMarshaller.class);
        imported.add(Byteable.class);
        imported.add(dvModel.type());
        imported.add(InvocationTargetException.class);
        imported.add(Constructor.class);
        StringBuilder read = DataValueBytesMarshallers.generateReadBody(dvModel, imported);
        StringBuilder sb = new StringBuilder();
        DataValueGenerator.appendPackage((DataValueModel)dvModel, (StringBuilder)sb);
        DataValueGenerator.appendImported((SortedSet)imported, (StringBuilder)sb);
        String simpleName = tClass.getSimpleName();
        String bytesReaderName = DataValueBytesMarshallers.bytesReaderName(tClass, false);
        String simpleReaderName = DataValueBytesMarshallers.bytesReaderName(DataValueGenerator.simpleName(tClass));
        sb.append("\n@SuppressWarnings(\"unchecked\") public class ").append(simpleReaderName).append(" implements DeserializationFactoryConfigurableBytesReader<").append(simpleName).append(", ").append(simpleReaderName).append("> {\n");
        DataValueBytesMarshallers.declareSerialVersionUID(sb);
        DataValueBytesMarshallers.declareStaticInstance(sb, tClass);
        DataValueBytesMarshallers.generatePrivateConstructor(sb, simpleReaderName);
        DataValueBytesMarshallers.generateWithDeserializationFactory(tClass, dvModel, sb, simpleName, simpleReaderName);
        DataValueBytesMarshallers.generateGetInstance(sb, tClass);
        DataValueBytesMarshallers.generateDelegatingRead(sb, simpleName);
        DataValueBytesMarshallers.generateRead(read, sb, simpleName, tClass);
        sb.append("}\n");
        return sb.toString();
    }

    private static void generateWithDeserializationFactory(Class<?> tClass, DataValueModel<?> dvModel, StringBuilder sb, String simpleName, String simpleReaderName) {
        DataValueBytesMarshallers.appendOverride(sb);
        sb.append("    public ").append(simpleReaderName).append(" withDeserializationFactory(ObjectFactory<").append(simpleName).append("> factory) {\n");
        sb.append("        try {\n");
        sb.append("            ").append("Class cfc = Class.forName(\"").append(DataValueGenerator.getPackage(dvModel)).append(".").append(DataValueBytesMarshallers.withCustomFactoryName(tClass)).append("\");\n");
        sb.append("            Constructor constructor = cfc.getConstructor(ObjectFactory.class);\n            Object reader = constructor.newInstance(factory);\n            return (" + simpleReaderName + ") reader;\n" + "        } catch (ClassNotFoundException | IllegalAccessException | " + "NoSuchMethodException | InstantiationException |\n" + "                InvocationTargetException e) {\n" + "            throw new AssertionError(e);\n" + "        }\n");
        sb.append("    }\n\n");
    }

    private static StringBuilder generateReadBody(DataValueModel<?> dvModel, SortedSet<Class> imported) {
        Map.Entry[] entries;
        StringBuilder read = new StringBuilder();
        for (Map.Entry entry : entries = DataValueGenerator.heapSizeOrderedFieldsGrouped(dvModel)) {
            Method defaultGetter;
            String name = (String)entry.getKey();
            FieldModel model = (FieldModel)entry.getValue();
            Class type = model.type();
            if (DataValueGenerator.shouldImport((Class)type)) {
                imported.add(type);
            }
            Method setter = DataValueGenerator.getSetter((FieldModel)model);
            Method getter = DataValueGenerator.getGetter((FieldModel)model);
            Method orderedSetter = DataValueGenerator.getOrderedSetter((FieldModel)model);
            Method volatileGetter = DataValueGenerator.getVolatileGetter((FieldModel)model);
            Method defaultSetter = setter != null ? setter : orderedSetter;
            Method method = defaultGetter = getter != null ? getter : volatileGetter;
            if (!dvModel.isScalar(type)) {
                if (model.isArray()) {
                    read.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++) {\n");
                    read.append("            toReuse.").append(defaultSetter.getName()).append("(i, ").append(DataValueBytesMarshallers.bytesReaderName(type, false)).append(".INSTANCE").append(".read(bytes, ").append(DataValueGenerator.computeNonScalarOffset(dvModel, (Class)type)).append(", ").append("toReuse.").append(defaultGetter.getName()).append("(i)));\n");
                    read.append("        }\n");
                    continue;
                }
                read.append("        toReuse.").append(defaultSetter.getName()).append("(").append(DataValueBytesMarshallers.bytesReaderName(type, false)).append(".INSTANCE").append(".read(bytes, ").append(DataValueGenerator.computeNonScalarOffset(dvModel, (Class)type)).append(", ").append("toReuse.").append(defaultGetter.getName()).append("()));\n");
                continue;
            }
            if (model.isArray()) {
                read.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++) {\n");
                DataValueBytesMarshallers.saveCharSequencePosition(read, type);
                read.append("            toReuse.").append(defaultSetter.getName()).append("(i, bytes.read").append(DataValueGenerator.bytesType((Class)type)).append("());\n");
                DataValueBytesMarshallers.updateCharSequencePosition(read, model, type);
                read.append("        }\n");
                continue;
            }
            read.append("        {\n");
            DataValueBytesMarshallers.saveCharSequencePosition(read, type);
            read.append("            toReuse.").append(defaultSetter.getName()).append("(bytes.read").append(DataValueGenerator.bytesType((Class)type)).append("());\n");
            DataValueBytesMarshallers.updateCharSequencePosition(read, model, type);
            read.append("        }\n");
        }
        return read;
    }

    private static void updateCharSequencePosition(StringBuilder read, FieldModel model, Class type) {
        if (CharSequence.class.isAssignableFrom(type)) {
            read.append("            bytes.position(pos + ").append(DataValueGenerator.fieldSize((FieldModel)model)).append(");\n");
        }
    }

    private static String generateBytesWriter(Class<?> tClass) {
        DataValueModel dvModel = DataValueModels.acquireModel(tClass);
        TreeSet imported = DataValueGenerator.newImported();
        imported.add(BytesWriter.class);
        imported.add(Bytes.class);
        imported.add(Byteable.class);
        imported.add(dvModel.type());
        String write = DataValueBytesMarshallers.generateWriteBody(dvModel, imported);
        StringBuilder sb = new StringBuilder();
        DataValueGenerator.appendPackage((DataValueModel)dvModel, (StringBuilder)sb);
        DataValueGenerator.appendImported((SortedSet)imported, (StringBuilder)sb);
        sb.append("public enum ").append(DataValueBytesMarshallers.bytesWriterName(tClass, true)).append(" implements BytesWriter<").append(tClass.getSimpleName()).append("> {\n");
        sb.append("    INSTANCE;\n\n");
        DataValueBytesMarshallers.generateSize(tClass, dvModel, sb);
        DataValueBytesMarshallers.generateWrite(tClass, dvModel, write, sb);
        DataValueBytesMarshallers.generateShouldNotBeNull(tClass, sb);
        sb.append("}\n");
        return sb.toString();
    }

    private static void generateShouldNotBeNull(Class<?> tClass, StringBuilder sb) {
        sb.append("    private static void shouldNotBeNull() {\n");
        sb.append("        throw new NullPointerException(\"Sub-members of " + tClass.getSimpleName() + " shouldn't be null for this writer. You should specify" + " custom writer (e. g. using keyMarshallers()/valueMarshallers() methods of" + "ChronicleMapBuilder, if you want to support null fields/array elements.\");\n");
        sb.append("    }\n");
    }

    private static void generateWrite(Class<?> tClass, DataValueModel<?> dvModel, String write, StringBuilder sb) {
        DataValueBytesMarshallers.appendOverride(sb);
        sb.append("    public void write(Bytes bytes, ").append(tClass.getSimpleName()).append(" e) {\n");
        int size = DataValueGenerator.computeNonScalarOffset(dvModel, tClass);
        if (size > 16) {
            sb.append("        if (e instanceof Byteable) {\n");
            sb.append("            Bytes eBytes = ((Byteable) e).bytes();\n            if (eBytes != null) {\n                bytes.write(eBytes, ((Byteable) e).offset(), " + size + ");\n" + "            } else {\n" + "                throw new NullPointerException(" + "\"You are trying to write a byteable object of \" +\n" + "                        e.getClass() + \", \" +\n" + "                        \"which bytes are not assigned. I. e. most likely " + "the object is uninitialized.\");\n" + "            }\n");
            sb.append("            return;\n");
            sb.append("        }\n");
        }
        sb.append(write);
        sb.append("    }\n\n");
    }

    private static void generateSize(Class<?> tClass, DataValueModel<?> dvModel, StringBuilder sb) {
        DataValueBytesMarshallers.appendOverride(sb);
        sb.append("    public long size(").append(tClass.getSimpleName()).append(" e) {\n");
        sb.append("        return ").append(DataValueGenerator.computeNonScalarOffset(dvModel, tClass)).append(";\n");
        sb.append("    }\n\n");
    }

    private static String generateWriteBody(DataValueModel<?> dvModel, SortedSet<Class> imported) {
        Map.Entry[] entries;
        StringBuilder write = new StringBuilder();
        for (Map.Entry entry : entries = DataValueGenerator.heapSizeOrderedFieldsGrouped(dvModel)) {
            Method defaultGetter;
            String name = (String)entry.getKey();
            FieldModel model = (FieldModel)entry.getValue();
            Class type = model.type();
            if (DataValueGenerator.shouldImport((Class)type)) {
                imported.add(type);
            }
            Method setter = DataValueGenerator.getSetter((FieldModel)model);
            Method getter = DataValueGenerator.getGetter((FieldModel)model);
            Method orderedSetter = DataValueGenerator.getOrderedSetter((FieldModel)model);
            Method volatileGetter = DataValueGenerator.getVolatileGetter((FieldModel)model);
            Method defaultSetter = setter != null ? setter : orderedSetter;
            Method method = defaultGetter = getter != null ? getter : volatileGetter;
            if (!dvModel.isScalar(type)) {
                if (model.isArray()) {
                    write.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++) {\n");
                    write.append("            ").append(DataValueGenerator.normalize((Class)type)).append(" $ = e.").append(defaultGetter.getName()).append("(i);\n");
                    write.append("            ").append("if ($ == null) shouldNotBeNull();\n");
                    write.append("            ").append(DataValueBytesMarshallers.bytesWriterName(type, false)).append(".INSTANCE").append(".write(bytes, $);\n");
                    write.append("        }\n");
                    continue;
                }
                write.append("        {").append(DataValueGenerator.normalize((Class)type)).append(" $ = e.").append(defaultGetter.getName()).append("();\n");
                write.append("        ").append("if ($ == null) shouldNotBeNull();\n");
                write.append("        ").append(DataValueBytesMarshallers.bytesWriterName(type, false)).append(".INSTANCE").append(".write(bytes, $);}\n");
                continue;
            }
            if (model.isArray()) {
                write.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++) {\n");
                DataValueBytesMarshallers.saveCharSequencePosition(write, type);
                write.append("            bytes.write").append(DataValueGenerator.bytesType((Class)type)).append("(e.").append(defaultGetter.getName()).append("(i));\n");
                DataValueBytesMarshallers.zeroOutRemainingCharSequenceBytesAndUpdatePosition(write, model, type);
                write.append("        }\n");
                continue;
            }
            write.append("        {\n");
            DataValueBytesMarshallers.saveCharSequencePosition(write, type);
            write.append("            bytes.write").append(DataValueGenerator.bytesType((Class)type)).append("(e.").append(defaultGetter.getName()).append("());\n");
            DataValueBytesMarshallers.zeroOutRemainingCharSequenceBytesAndUpdatePosition(write, model, type);
            write.append("        }\n");
        }
        return write.toString();
    }

    private static void saveCharSequencePosition(StringBuilder write, Class type) {
        if (CharSequence.class.isAssignableFrom(type)) {
            write.append("            long pos = bytes.position();\n");
        }
    }

    private static void zeroOutRemainingCharSequenceBytesAndUpdatePosition(StringBuilder write, FieldModel model, Class type) {
        if (CharSequence.class.isAssignableFrom(type)) {
            write.append("            long newPos = pos + ").append(DataValueGenerator.fieldSize((FieldModel)model)).append(";\n");
            write.append("            bytes.zeroOut(bytes.position(), newPos);\n");
            write.append("            bytes.position(newPos);\n");
        }
    }

    private static void generateRead(StringBuilder read, StringBuilder sb, String simpleName, Class cl) {
        DataValueBytesMarshallers.appendOverride(sb);
        sb.append("    public ").append(simpleName).append(" read(Bytes bytes, long size, ").append(simpleName).append(" toReuse) {\n");
        sb.append("    try {\n");
        sb.append("        if (toReuse == null)\n");
        sb.append("            toReuse = getInstance();\n");
        sb.append("        if (toReuse instanceof Byteable) {\n");
        sb.append("            ByteableMarshaller.setBytesAndOffset(((Byteable) toReuse), bytes);\n");
        sb.append("            bytes.skip(size);\n");
        sb.append("            return toReuse;\n");
        sb.append("        }\n");
        sb.append((CharSequence)read);
        sb.append("        return toReuse;\n");
        sb.append("    } catch (Exception e) {\n");
        sb.append("        throw new IllegalStateException(e);\n");
        sb.append("    }\n");
        sb.append("}\n\n");
    }

    private static void generateDelegatingRead(StringBuilder sb, String simpleName) {
        DataValueBytesMarshallers.appendOverride(sb);
        sb.append("    public ").append(simpleName).append(" read(Bytes bytes, long size) {\n");
        sb.append("        return read(bytes, size, null);\n");
        sb.append("    }\n\n");
    }

    private static void appendOverride(StringBuilder sb) {
        sb.append("    @Override\n");
    }

    private static void generatePrivateConstructor(StringBuilder sb, String bytesReaderName) {
        sb.append("    ").append(bytesReaderName).append("() {}\n\n");
    }

    private static void declareStaticInstance(StringBuilder sb, Class cl) {
        String bytesReaderName = DataValueBytesMarshallers.bytesReaderName(DataValueGenerator.simpleName((Class)cl));
        sb.append("    public static final ").append(bytesReaderName).append(" INSTANCE = new ").append(bytesReaderName).append("();\n\n");
    }

    private static StringBuilder declareSerialVersionUID(StringBuilder sb) {
        return sb.append("    private static final long serialVersionUID = 0L;\n\n");
    }

    private static void generateGetInstance(StringBuilder sb, Class cl) {
        sb.append("    ").append(cl.getCanonicalName()).append(" getInstance() throws Exception {\n");
        sb.append("        ").append("return new ").append(cl.getName()).append("$$Native();\n");
        sb.append("    ").append("}\n\n");
    }
}

