/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.client.ClientWiredStatelessTcpConnectionHub;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstactStatelessClient<E extends ParameterizeWireKey> {
    final ClientWiredStatelessTcpConnectionHub hub;
    private final long cid;
    protected final String channelName;
    protected String csp;
    StringBuilder eventName = new StringBuilder();

    public AbstactStatelessClient(@NotNull String channelName, @NotNull ClientWiredStatelessTcpConnectionHub hub, @NotNull String type, long cid) {
        this.cid = cid;
        this.csp = "//" + channelName + "?view=" + type;
        this.hub = hub;
        this.channelName = channelName;
    }

    protected long proxyReturnLong(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, f -> f.int64());
    }

    protected int proxyReturnInt(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, f -> f.int32());
    }

    protected int proxyReturnUint16(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, f -> f.uint16());
    }

    public <T> T proxyReturnWireConsumer(@NotNull WireKey eventId, @NotNull Function<ValueIn, T> consumer) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, null);
        return this.readWire(tid, startTime, (WireKey)CoreFields.reply, consumer);
    }

    public <T> T proxyReturnWireConsumerInOut(@NotNull WireKey eventId, @NotNull CoreFields reply, @Nullable Consumer<ValueOut> consumerOut, @NotNull Function<ValueIn, T> consumerIn) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, consumerOut);
        return this.readWire(tid, startTime, (WireKey)reply, consumerIn);
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, consumer);
        this.readWire(tid, startTime, (WireKey)CoreFields.reply, v -> v.marshallable(wireIn -> {}));
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId) {
        this.proxyReturnVoid(eventId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sendEvent(long startTime, @NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        long tid;
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        this.hub.outBytesLock().lock();
        try {
            tid = this.writeMetaData(startTime);
            this.hub.outWire().writeDocument(false, wireOut -> {
                ValueOut valueOut = wireOut.writeEventName(eventId);
                if (consumer == null) {
                    valueOut.marshallable(WireOut.EMPTY);
                } else {
                    consumer.accept(valueOut);
                }
            });
            this.hub.writeSocket(this.hub.outWire());
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
        return tid;
    }

    protected void sendEventAsync(@NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        this.hub.outBytesLock().lock();
        try {
            this.writeAsyncMetaData(System.currentTimeMillis());
            this.hub.outWire().writeDocument(false, wireOut -> {
                ValueOut valueOut = wireOut.writeEventName(eventId);
                if (consumer == null) {
                    valueOut.marshallable(WireOut.EMPTY);
                } else {
                    consumer.accept(valueOut);
                }
            });
            this.hub.writeSocket(this.hub.outWire());
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
    }

    protected long writeMetaData(long startTime) {
        return this.hub.writeMetaData(startTime, this.hub.outWire(), this.csp, this.cid);
    }

    protected void writeAsyncMetaData(long startTime) {
        this.hub.startTime(startTime);
        this.hub.writeAsyncHeader(this.hub.outWire(), this.csp, this.cid);
    }

    protected void checkIsData(Wire wireIn) {
        int datalen = wireIn.bytes().readVolatileInt();
        if (!Wires.isData((long)datalen)) {
            throw new IllegalStateException("expecting a data blob, from ->" + Bytes.toDebugString((Bytes)wireIn.bytes(), (long)0L, (long)wireIn.bytes().limit()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readBoolean(long tid, long startTime) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        this.hub.inBytesLock().lock();
        try {
            Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
            this.checkIsData(wireIn);
            boolean bl = this.readReply((WireIn)wireIn, (WireKey)CoreFields.reply, v -> v.bool());
            return bl;
        }
        finally {
            this.hub.inBytesLock().unlock();
        }
    }

    <R> R readReply(WireIn wireIn, WireKey replyId, Function<ValueIn, R> function) {
        ValueIn event = wireIn.read(this.eventName);
        if (replyId.contentEquals((CharSequence)this.eventName)) {
            return function.apply(event);
        }
        if (CoreFields.exception.contentEquals((CharSequence)this.eventName)) {
            throw Jvm.rethrow((Throwable)event.throwable(true));
        }
        throw new UnsupportedOperationException("unknown event=" + this.eventName);
    }

    protected boolean proxyReturnBooleanWithArgs(@NotNull E eventId, Object ... args) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, (WireKey)eventId, AbstactStatelessClient.toParameters(eventId, args));
        return this.readBoolean(tid, startTime);
    }

    protected boolean proxyReturnBooleanWithSequence(@NotNull E eventId, @NotNull Collection sequence) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, (WireKey)eventId, out -> sequence.forEach(arg_0 -> ((ValueOut)out).object(arg_0)));
        return this.readBoolean(tid, startTime);
    }

    protected boolean proxyReturnBoolean(@NotNull WireKey eventId) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, null);
        return this.readBoolean(tid, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readWire(long tid, long startTime, WireKey reply, Function<ValueIn, T> c) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        this.hub.inBytesLock().lock();
        try {
            Wire wire = this.hub.proxyReply(timeoutTime, tid);
            this.checkIsData(wire);
            T t = this.readReply((WireIn)wire, reply, c);
            return t;
        }
        finally {
            this.hub.inBytesLock().unlock();
        }
    }

    public static <E extends ParameterizeWireKey> Consumer<ValueOut> toParameters(@NotNull E eventId, Object ... args) {
        return out -> {
            WireKey[] paramNames = eventId.params();
            assert (args != null);
            assert (args.length == paramNames.length) : "methodName=" + eventId + ", args.length=" + args.length + ", paramNames.length=" + paramNames.length;
            if (paramNames.length == 1) {
                out.object(args[0]);
                return;
            }
            out.marshallable(m -> {
                for (int i = 0; i < paramNames.length; ++i) {
                    ValueOut vo = m.write(paramNames[i]);
                    vo.object(args[i]);
                }
            });
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readInt(long tid, long startTime) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        this.hub.inBytesLock().lock();
        try {
            Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
            this.checkIsData(wireIn);
            int n = wireIn.read((WireKey)CoreFields.reply).int32();
            return n;
        }
        finally {
            this.hub.inBytesLock().unlock();
        }
    }

    void identifier(int localIdentifier) {
        this.hub.localIdentifier = localIdentifier;
    }
}

