/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.hash.KeyContext;
import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.impl.ContextFactory;
import net.openhft.chronicle.hash.impl.HashContext;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.BytesBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DelegatingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.VanillaContext;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicatedChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
extends VanillaChronicleMap<K, KI, MKI, V, VI, MVI>
implements Replica,
Replica.EntryExternalizable,
Replica.EntryResolver<K, V> {
    public static final int RESERVED_MOD_ITER = 8;
    public static final int ADDITIONAL_ENTRY_BYTES = 10;
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedChronicleMap.class);
    private static final long LAST_UPDATED_HEADER_SIZE = 1024L;
    private final TimeProvider timeProvider;
    private final byte localIdentifier;
    transient Set<Closeable> closeables;
    private transient Bytes identifierUpdatedBytes;
    private transient ATSDirectBitSet modIterSet;
    private transient AtomicReferenceArray<ModificationIterator> modificationIterators;
    private transient long startOfModificationIterators;
    private boolean bootstrapOnlyLocalEntries;

    public ReplicatedChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder, AbstractReplication replication) throws IOException {
        super(builder, true);
        this.timeProvider = builder.timeProvider();
        this.localIdentifier = replication.identifier();
        this.bootstrapOnlyLocalEntries = replication.bootstrapOnlyLocalEntries();
        if (this.localIdentifier == -1) {
            throw new IllegalStateException("localIdentifier should not be -1");
        }
    }

    private int assignedModIterBitSetSizeInBytes() {
        return (int)MemoryUnit.CACHE_LINES.align(MemoryUnit.BYTES.alignAndConvert(135L, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.ownInitTransients();
    }

    private void ownInitTransients() {
        this.modificationIterators = new AtomicReferenceArray(135);
        this.closeables = new CopyOnWriteArraySet<Closeable>();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.ownInitTransients();
    }

    long modIterBitSetSizeInBytes() {
        long bytes = MemoryUnit.BITS.toBytes(this.bitsPerSegmentInModIterBitSet() * (long)this.actualSegments);
        return MemoryUnit.CACHE_LINES.align(bytes, MemoryUnit.BYTES);
    }

    private long bitsPerSegmentInModIterBitSet() {
        return Maths.nextPower2((long)this.actualChunksPerSegment, (long)1024L);
    }

    @Override
    public long mapHeaderInnerSize() {
        return super.mapHeaderInnerSize() + 1024L + this.modIterBitSetSizeInBytes() * 136L + (long)this.assignedModIterBitSetSizeInBytes();
    }

    void setLastModificationTime(byte identifier, long timestamp) {
        long offset = (long)identifier * 8L;
        if (this.identifierUpdatedBytes.readLong(offset) < timestamp) {
            this.identifierUpdatedBytes.writeLong(offset, timestamp);
        }
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        assert (remoteIdentifier != this.identifier());
        return this.identifierUpdatedBytes.readLong((long)remoteIdentifier * 8L);
    }

    @Override
    public void onHeaderCreated() {
        long offset = super.mapHeaderInnerSize();
        this.identifierUpdatedBytes = this.ms.bytes(offset, 1024L).zeroOut();
        Bytes modDelBytes = this.ms.bytes(offset += 1024L, (long)this.assignedModIterBitSetSizeInBytes()).zeroOut();
        this.startOfModificationIterators = offset += (long)this.assignedModIterBitSetSizeInBytes();
        this.modIterSet = new ATSDirectBitSet(modDelBytes);
    }

    @Override
    public void clear() {
        this.forEachEntry(KeyContext::remove);
    }

    void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        super.close();
    }

    @Override
    public byte identifier() {
        return this.localIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Replica.ModificationIterator acquireModificationIterator(byte remoteIdentifier, @NotNull Replica.ModificationNotifier modificationNotifier) {
        ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        AtomicReferenceArray<ModificationIterator> atomicReferenceArray = this.modificationIterators;
        synchronized (atomicReferenceArray) {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            Bytes bytes = this.ms.bytes(this.startOfModificationIterators + this.modIterBitSetSizeInBytes() * (long)remoteIdentifier, this.modIterBitSetSizeInBytes());
            ModificationIterator newModificationIterator = new ModificationIterator(bytes, modificationNotifier);
            this.modificationIterators.set(remoteIdentifier, newModificationIterator);
            this.modIterSet.set((long)remoteIdentifier);
            return newModificationIterator;
        }
    }

    void raiseChange(long segmentIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.modificationIterators.get((int)next).raiseChange(segmentIndex, pos);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    void dropChange(long segmentIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.modificationIterators.get((int)next).dropChange(segmentIndex, pos);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean identifierCheck(@NotNull Bytes entry, int chronicleId) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            entry.skip(keySize + 8L);
            byte identifier = entry.readByte();
            boolean bl = identifier == this.localIdentifier;
            return bl;
        }
        finally {
            entry.position(start);
        }
    }

    @Override
    ReplicatedContext<K, KI, MKI, V, VI, MVI> rawContext() {
        return VanillaContext.get(ReplicatedContextFactory.INSTANCE);
    }

    @Override
    VanillaContext rawBytesContext() {
        return VanillaContext.get(BytesReplicatedContextFactory.INSTANCE);
    }

    @Override
    VanillaContext<K, KI, MKI, V, VI, MVI> acquireContext(K key) {
        ReplicatedAcquireContext c = VanillaContext.get(ReplicatedAcquireContextFactory.INSTANCE);
        c.initHash(this);
        c.initKey(key);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeOfEntry(@NotNull Bytes entry, int chronicleId) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            entry.skip(keySize + 8L);
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                int n = 0;
                return n;
            }
            entry.skip(1L);
            long valueSize = this.valueSizeMarshaller.readSize(entry);
            this.alignment.alignPositionAddr(entry);
            long result = entry.position() + valueSize - start;
            assert (result < Integer.MAX_VALUE);
            int n = (int)result;
            return n;
        }
        finally {
            entry.position(start);
        }
    }

    @Override
    public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int chronicleId) {
        long initialLimit = entry.limit();
        long keySize = this.keySizeMarshaller.readSize(entry);
        long keyPosition = entry.position();
        entry.skip(keySize);
        long keyLimit = entry.position();
        long timeStamp = entry.readLong();
        byte identifier = entry.readByte();
        if (identifier != this.localIdentifier) {
            return;
        }
        boolean isDeleted = entry.readBoolean();
        long valueSize = !isDeleted ? this.valueSizeMarshaller.readSize(entry) : this.valueSizeMarshaller.minEncodableSize();
        long valuePosition = entry.position();
        this.keySizeMarshaller.writeSize(destination, keySize);
        this.valueSizeMarshaller.writeSize(destination, valueSize);
        destination.writeStopBit(timeStamp);
        destination.writeByte((int)identifier);
        destination.writeBoolean(isDeleted);
        entry.position(keyPosition);
        entry.limit(keyLimit);
        destination.write((RandomDataInput)entry, entry.position(), entry.remaining());
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.localIdentifier, (Object)entry.toString().trim());
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.localIdentifier, entry.toString().trim());
            }
        }
        if (isDeleted) {
            return;
        }
        entry.limit(initialLimit);
        entry.position(valuePosition);
        this.alignment.alignPositionAddr(entry);
        entry.limit(entry.position() + valueSize);
        destination.write((RandomDataInput)entry, entry.position(), entry.remaining());
        if (debugEnabled) {
            LOG.debug(message + "value=" + entry.toString().trim() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternalEntry(@NotNull BytesReplicatedContext context, @NotNull Bytes source) {
        context.initHash(this);
        try {
            long keySize = this.keySizeMarshaller.readSize(source);
            long valueSize = this.valueSizeMarshaller.readSize(source);
            long timeStamp = source.readStopBit();
            byte id = source.readByte();
            boolean isDeleted = source.readBoolean();
            if (id == 0) {
                throw new IllegalStateException("identifier can't be 0");
            }
            byte remoteIdentifier = id;
            if (remoteIdentifier == this.identifier()) {
                return;
            }
            context.newTimestamp = timeStamp;
            context.newIdentifier = remoteIdentifier;
            long keyPosition = source.position();
            long keyLimit = keyPosition + keySize;
            source.limit(keyLimit);
            context.metaKeyInterop = DelegatingMetaBytesInterop.instance();
            context.keySize = keySize;
            context.initBytesKey00(source);
            boolean debugEnabled = LOG.isDebugEnabled();
            context.updateLock().lock();
            if (isDeleted) {
                if (debugEnabled) {
                    LOG.debug("READING FROM SOURCE -  into local-id={}, remote={}, remove(key={})", new Object[]{this.localIdentifier, remoteIdentifier, source.toString().trim()});
                }
                context.remove();
                this.setLastModificationTime(remoteIdentifier, timeStamp);
                return;
            }
            String message = null;
            if (debugEnabled) {
                message = String.format("READING FROM SOURCE -  into local-id=%d, remote-id=%d, put(key=%s,", this.localIdentifier, remoteIdentifier, source.toString().trim());
            }
            long valuePosition = keyLimit;
            long valueLimit = valuePosition + valueSize;
            context.containsKey();
            context.metaValueInterop = DelegatingMetaBytesInterop.instance();
            context.newValueSize = valueSize;
            source.limit(valueLimit);
            source.position(valuePosition);
            context.initNewBytesValue00(source);
            context.initPutDependencies();
            context.put0();
            this.setLastModificationTime(remoteIdentifier, timeStamp);
            if (debugEnabled) {
                LOG.debug(message + "value=" + source.toString().trim() + ")");
            }
        }
        finally {
            context.closeHash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K key(@NotNull Bytes entry, K usingKey) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            ThreadLocalCopies copies = this.keyReaderProvider.getCopies(null);
            Object e = ((BytesReader)this.keyReaderProvider.get(copies, (Object)this.originalKeyReader)).read(entry, keySize);
            return (K)e;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V value(@NotNull Bytes entry, V usingValue) {
        long start = entry.position();
        try {
            long valueSize;
            entry.skip(this.keySizeMarshaller.readSize(entry));
            entry.readLong();
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                V v = null;
                return v;
            }
            boolean isDeleted = entry.readBoolean();
            if (!isDeleted) {
                valueSize = this.valueSizeMarshaller.readSize(entry);
                assert (valueSize > 0L);
            } else {
                V v = null;
                return v;
            }
            this.alignment.alignPositionAddr(entry);
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, (Object)this.originalValueReader);
            V v = valueReader.read(entry, valueSize, usingValue);
            return v;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasRemoved(@NotNull Bytes entry) {
        long start = entry.position();
        try {
            boolean bl = entry.readBoolean(this.keySizeMarshaller.readSize(entry) + 9L);
            return bl;
        }
        finally {
            entry.position(start);
        }
    }

    class ModificationIterator
    implements Replica.ModificationIterator {
        private final Replica.ModificationNotifier modificationNotifier;
        private final SingleThreadedDirectBitSet changesForUpdates;
        private final ATSDirectBitSet changesForIteration;
        private final int segmentIndexShift;
        private final long posMask;
        private final ReplicatedContext<K, KI, MKI, V, VI, MVI> context;
        private volatile long position;

        public ModificationIterator(@NotNull Bytes bytes, Replica.ModificationNotifier modificationNotifier) {
            this.context = (ReplicatedContext)ReplicatedChronicleMap.this.mapContext();
            this.position = -1L;
            this.modificationNotifier = modificationNotifier;
            long bitsPerSegment = ReplicatedChronicleMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.changesForUpdates = new SingleThreadedDirectBitSet(bytes);
            this.changesForIteration = new ATSDirectBitSet(bytes);
        }

        private long combine(long segmentIndex, long pos) {
            return segmentIndex << this.segmentIndexShift | pos;
        }

        void raiseChange(long segmentIndex, long pos) {
            this.changesForUpdates.set(this.combine(segmentIndex, pos));
            this.modificationNotifier.onChange();
        }

        void dropChange(long segmentIndex, long pos) {
            this.changesForUpdates.clear(this.combine(segmentIndex, pos));
        }

        @Override
        public boolean hasNext() {
            long position = this.position;
            return this.changesForIteration.nextSetBit(position == -1L ? 0L : position) != -1L || position > 0L && this.changesForIteration.nextSetBit(0L) != -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean nextEntry(@NotNull Replica.EntryCallback entryCallback, int chronicleId) {
            long position = this.position;
            while (true) {
                long oldPosition;
                if ((position = this.changesForIteration.nextSetBit((oldPosition = position) + 1L)) == -1L) {
                    if (oldPosition != -1L) continue;
                    this.position = -1L;
                    return false;
                }
                this.position = position;
                int segmentIndex = (int)(position >>> this.segmentIndexShift);
                if (this.context.segmentIndex != segmentIndex) {
                    this.context.closeSegmentIndex();
                    this.context.segmentIndex = segmentIndex;
                    this.context.initLocks();
                    this.context.initSegment();
                }
                this.context.updateLock().lock();
                try {
                    if (!this.changesForUpdates.get(position)) continue;
                    entryCallback.onBeforeEntry();
                    long segmentPos = position & this.posMask;
                    this.context.reuse(segmentPos);
                    if (entryCallback.shouldBeIgnored((Bytes)this.context.entry, chronicleId)) {
                        this.changesForUpdates.clear(position);
                        continue;
                    }
                    boolean success = entryCallback.onEntry((Bytes)this.context.entry, chronicleId);
                    entryCallback.onAfterEntry();
                    if (success) {
                        this.changesForUpdates.clear(position);
                    }
                    boolean bl = success;
                    return bl;
                }
                finally {
                    this.context.updateLock().unlock();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dirtyEntries(long fromTimeStamp) {
            try (ReplicatedContext context = (ReplicatedContext)ReplicatedChronicleMap.this.mapContext();){
                int i = 0;
                while (i < ReplicatedChronicleMap.this.actualSegments) {
                    context.segmentIndex = i++;
                    context.initSegment();
                    try {
                        context.dirtyEntries(fromTimeStamp, this, ReplicatedChronicleMap.this.bootstrapOnlyLocalEntries);
                    }
                    finally {
                        context.closeSegmentIndex();
                    }
                }
            }
        }
    }

    static enum ReplicatedAcquireContextFactory implements ContextFactory<ReplicatedAcquireContext>
    {
        INSTANCE;


        @Override
        public ReplicatedAcquireContext createContext(HashContext root, int indexInContextCache) {
            return new ReplicatedAcquireContext(root, indexInContextCache);
        }

        @Override
        public ReplicatedAcquireContext createRootContext() {
            return new ReplicatedAcquireContext();
        }

        @Override
        public Class<ReplicatedAcquireContext> contextClass() {
            return ReplicatedAcquireContext.class;
        }
    }

    static class ReplicatedAcquireContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    extends ReplicatedContext<K, KI, MKI, V, VI, MVI> {
        ReplicatedAcquireContext() {
        }

        ReplicatedAcquireContext(HashContext contextCache, int indexInContextCache) {
            super(contextCache, indexInContextCache);
        }

        @Override
        public boolean put(V newValue) {
            return this.acquirePut(newValue);
        }

        @Override
        public boolean remove() {
            return this.acquireRemove();
        }

        @Override
        public void close() {
            this.acquireClose();
        }
    }

    static enum BytesReplicatedContextFactory implements ContextFactory<BytesReplicatedContext>
    {
        INSTANCE;


        @Override
        public BytesReplicatedContext createContext(HashContext root, int indexInContextCache) {
            return new BytesReplicatedContext(root, indexInContextCache);
        }

        @Override
        public BytesReplicatedContext createRootContext() {
            return new BytesReplicatedContext();
        }

        @Override
        public Class<BytesReplicatedContext> contextClass() {
            return BytesReplicatedContext.class;
        }
    }

    static class BytesReplicatedContext
    extends ReplicatedContext<Bytes, BytesBytesInterop, DelegatingMetaBytesInterop<Bytes, BytesBytesInterop>, Bytes, BytesBytesInterop, DelegatingMetaBytesInterop<Bytes, BytesBytesInterop>> {
        BytesReplicatedContext() {
        }

        BytesReplicatedContext(HashContext contextCache, int indexInContextCache) {
            super(contextCache, indexInContextCache);
        }

        @Override
        public void initKeyModel0() {
            this.initBytesKeyModel0();
        }

        @Override
        public void initKey0(Bytes key) {
            this.initBytesKey0(key);
        }

        @Override
        void initValueModel0() {
            this.initBytesValueModel0();
        }

        @Override
        void initNewValue0(Bytes newValue) {
            this.initNewBytesValue0(newValue);
        }

        @Override
        void closeValue0() {
            this.closeBytesValue0();
        }

        @Override
        public Bytes get() {
            return this.getBytes();
        }

        @Override
        public Bytes getUsing(Bytes usingValue) {
            return this.getBytesUsing(usingValue);
        }
    }

    static enum ReplicatedContextFactory implements ContextFactory<ReplicatedContext>
    {
        INSTANCE;


        @Override
        public ReplicatedContext createContext(HashContext root, int indexInContextCache) {
            return new ReplicatedContext(root, indexInContextCache);
        }

        @Override
        public ReplicatedContext createRootContext() {
            return new ReplicatedContext();
        }

        @Override
        public Class<ReplicatedContext> contextClass() {
            return ReplicatedContext.class;
        }
    }

    static class ReplicatedContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>>
    extends VanillaContext<K, KI, MKI, V, VI, MVI> {
        long replicationBytesOffset;
        long timestamp;
        byte identifier;
        long newTimestamp;
        byte newIdentifier;
        final MetaBytesInterop<V, VI> pseudoMetaValueInterop = new PseudoMetaBytesInterop();

        ReplicatedContext() {
        }

        ReplicatedContext(HashContext contextCache, int indexInContextCache) {
            super(contextCache, indexInContextCache);
        }

        ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI> rm() {
            return (ReplicatedChronicleMap)this.m();
        }

        @Override
        public void totalCheckClosed() {
            super.totalCheckClosed();
            assert (!this.replicationStateInit()) : "replication state not closed";
            assert (!this.replicationUpdateInit()) : "replication update not closed";
        }

        @Override
        public boolean containsKey0() {
            return this.searchStatePresent() && !this.isDeleted();
        }

        @Override
        public void keyFound() {
            super.keyFound();
            this.initReplicationBytesOffset0();
            this.timestamp = this.entry.readLong(this.replicationBytesOffset);
            this.identifier = this.entry.readByte(this.replicationBytesOffset + 8L);
        }

        boolean isDeleted() {
            return this.entry.readBoolean(this.replicationBytesOffset + 9L);
        }

        void initReplicationBytesOffset0() {
            this.replicationBytesOffset = this.keyOffset0() + this.keySize0();
        }

        @Override
        public void initKeyOffset0() {
            super.initKeyOffset0();
            this.initReplicationBytesOffset0();
        }

        void closeReplicationState() {
            if (!this.replicationStateInit()) {
                return;
            }
            this.closeReplicationState0();
        }

        boolean replicationStateInit() {
            return this.replicationBytesOffset != 0L;
        }

        void closeReplicationState0() {
            this.replicationBytesOffset = 0L;
            this.timestamp = 0L;
            this.identifier = 0;
        }

        @Override
        public void closeKeySearchDependants() {
            super.closeKeySearchDependants();
            this.closeReplicationState();
        }

        @Override
        void initValueSizeOffset0() {
            this.valueSizeOffset = this.replicationBytesOffset + 10L;
        }

        void initReplicationUpdate() {
            if (this.replicationUpdateInit()) {
                return;
            }
            this.checkHashInit();
            this.initReplicationUpdate0();
        }

        boolean replicationUpdateInit() {
            return this.newIdentifier != 0;
        }

        void initReplicationUpdate0() {
            this.newTimestamp = ((ReplicatedChronicleMap)this.rm()).timeProvider.currentTime();
            this.newIdentifier = this.rm().identifier();
        }

        boolean remoteUpdate() {
            return this.newIdentifier != this.rm().identifier();
        }

        void closeReplicationUpdate() {
            if (!this.replicationUpdateInit()) {
                return;
            }
            this.closeReplicationUpdate0();
        }

        void closeReplicationUpdate0() {
            this.newTimestamp = 0L;
            this.newIdentifier = 0;
        }

        @Override
        public void initRemoveDependencies() {
            super.initRemoveDependencies();
            this.initReplicationUpdate();
        }

        void writeReplicationBytes() {
            this.entry.writeLong(this.replicationBytesOffset, this.newTimestamp);
            this.entry.writeByte(this.replicationBytesOffset + 8L, (int)this.newIdentifier);
        }

        void writeDeleted() {
            this.entry.writeBoolean(this.replicationBytesOffset + 9L, true);
        }

        void writePresent() {
            this.entry.writeBoolean(this.replicationBytesOffset + 9L, false);
        }

        @Override
        long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
            return super.sizeOfEverythingBeforeValue(keySize, valueSize) + 10L;
        }

        @Override
        boolean put0() {
            try {
                if (!this.searchStatePresent()) {
                    this.putEntry();
                    this.writePresent();
                } else if (!this.shouldIgnore()) {
                    boolean deleted = this.isDeleted();
                    this.initValueBytes();
                    this.putValue();
                    if (deleted) {
                        this.deleted(this.deleted() - 1L);
                        this.writePresent();
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.closeReplicationUpdate();
            }
        }

        @Override
        void beforeRelocation() {
            this.rm().dropChange(this.segmentIndex, this.pos);
        }

        @Override
        void initPutDependencies() {
            super.initPutDependencies();
            this.initReplicationUpdate();
        }

        @Override
        void writeNewValueAndSwitch() {
            super.writeNewValueAndSwitch();
            this.writeReplicationBytes();
            this.updateChange();
            this.timestamp = this.newTimestamp;
            this.identifier = this.newIdentifier;
        }

        @Override
        public boolean remove0() {
            if (this.containsKey()) {
                if (!this.shouldIgnore()) {
                    this.writeReplicationBytes();
                    this.writeDeleted();
                    this.updateChange();
                    this.deleted(this.deleted() + 1L);
                    return true;
                }
                return false;
            }
            if (this.pos >= 0L) {
                if (!this.shouldIgnore()) {
                    this.writeReplicationBytes();
                    this.updateChange();
                }
            } else {
                this.newValue = this.pseudoMetaValueInterop;
                this.metaValueInterop = this.pseudoMetaValueInterop;
                this.newValueSize = this.m().valueSizeMarshaller.minEncodableSize();
                this.put0();
                this.deleted(this.deleted() + 1L);
                this.writeDeleted();
                this.closeNewValue();
            }
            return false;
        }

        void updateChange() {
            if (this.remoteUpdate()) {
                this.rm().dropChange(this.segmentIndex, this.pos);
            } else {
                this.rm().raiseChange(this.segmentIndex, this.pos);
            }
        }

        @Override
        public void closeRemove() {
            this.closeReplicationUpdate();
        }

        private boolean testTimeStampInSensibleRange() {
            if (((ReplicatedChronicleMap)this.rm()).timeProvider == TimeProvider.SYSTEM) {
                long currentTime = TimeProvider.SYSTEM.currentTime();
                assert (Math.abs(currentTime - this.timestamp) <= 100000000L) : "unrealistic timestamp: " + this.timestamp;
                assert (Math.abs(currentTime - this.newTimestamp) <= 100000000L) : "unrealistic newTimestamp: " + this.newTimestamp;
            }
            return true;
        }

        boolean shouldIgnore() {
            assert (this.replicationStateInit()) : "replication state not init";
            assert (this.replicationUpdateInit()) : "replication update not init";
            assert (this.testTimeStampInSensibleRange());
            if (!this.remoteUpdate()) {
                this.newTimestamp = this.timestamp + 1L;
                return false;
            }
            return this.timestamp > this.newTimestamp || this.timestamp == this.newTimestamp && this.identifier > this.newIdentifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dirtyEntries(long dirtyFromTimeStamp, ModificationIterator modIter, boolean bootstrapOnlyLocalEntries) {
            this.readLock().lock();
            try {
                this.hashLookup.forEach((hash, pos) -> {
                    this.pos = pos;
                    this.initKeyFromPos();
                    this.keyFound();
                    assert (this.timestamp > 0L);
                    if (!(this.timestamp < dirtyFromTimeStamp || bootstrapOnlyLocalEntries && this.identifier != this.rm().identifier())) {
                        modIter.raiseChange(this.segmentIndex, pos);
                    }
                });
            }
            finally {
                this.readLock().unlock();
            }
        }

        class PseudoMetaBytesInterop
        implements MetaBytesInterop<Object, Object> {
            PseudoMetaBytesInterop() {
            }

            @Override
            public boolean startsWith(Object interop, Bytes bytes, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <I2> boolean equivalent(Object interop, Object o, MetaBytesInterop<Object, I2> otherMetaInterop, I2 otherInterop, Object other) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long hash(Object interop, LongHashFunction hashFunction, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size(Object writer, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void write(Object writer, Bytes bytes, Object o) {
                bytes.skip(ReplicatedContext.this.newValueSize);
            }
        }
    }
}

