/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import net.openhft.chronicle.hash.AcceptanceDecision;
import net.openhft.chronicle.hash.replication.HashReplicableEntry;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;

public final class DefaultEventualConsistencyStrategy {
    public static AcceptanceDecision decideOnRemoteModification(HashReplicableEntry<?> entry, RemoteOperationContext<?> context) {
        long originTimestamp;
        long remoteTimestamp = context.remoteTimestamp();
        boolean shouldAccept = remoteTimestamp > (originTimestamp = entry.originTimestamp()) || remoteTimestamp == originTimestamp && context.remoteIdentifier() <= entry.originIdentifier();
        return shouldAccept ? AcceptanceDecision.ACCEPT : AcceptanceDecision.DISCARD;
    }

    private DefaultEventualConsistencyStrategy() {
    }
}

