/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.util.Arrays;
import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public enum CharArrayMarshaller implements BytesInterop<char[]>,
BytesReader<char[]>
{
    INSTANCE;


    @Override
    public boolean startsWith(@NotNull Bytes bytes, @NotNull char[] chars) {
        if (bytes.capacity() - bytes.position() < (long)chars.length * 2L) {
            return false;
        }
        long pos = bytes.position();
        for (int i = 0; i < chars.length; ++i) {
            if (bytes.readChar(pos + (long)i * 2L) == chars[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equivalent(@NotNull char[] a, @NotNull char[] b) {
        return Arrays.equals(a, b);
    }

    @Override
    public long hash(@NotNull LongHashFunction hashFunction, @NotNull char[] chars) {
        return hashFunction.hashChars(chars);
    }

    @Override
    @NotNull
    public char[] read(@NotNull Bytes bytes, long size) {
        char[] chars = new char[this.resLen(size)];
        bytes.readFully(chars);
        return chars;
    }

    @Override
    @NotNull
    public char[] read(@NotNull Bytes bytes, long size, char[] toReuse) {
        int resLen = this.resLen(size);
        if (toReuse == null || toReuse.length != resLen) {
            toReuse = new char[resLen];
        }
        bytes.readFully(toReuse);
        return toReuse;
    }

    private int resLen(long size) {
        long resLen = size / 2L;
        if (resLen < 0L || resLen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("char[] size should be non-negative int, " + resLen + " given. Memory corruption?");
        }
        return (int)resLen;
    }

    @Override
    public long size(@NotNull char[] chars) {
        return (long)chars.length * 2L;
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull char[] chars) {
        bytes.write(chars);
    }
}

