/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.hash.AbstractValue;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.Value;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CopyingInstanceValue;
import net.openhft.chronicle.hash.impl.JavaLangBytesAccessors;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.hashlookup.EntryConsumer;
import net.openhft.chronicle.hash.impl.value.instance.KeyInitableValue;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.locks.InterProcessReadWriteUpdateLock;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapKeyContext;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.map.impl.ret.UsableReturnValue;
import net.openhft.chronicle.map.impl.value.instance.ValueInitableValue;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompiledMapQueryContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R, T>
implements AutoCloseable,
HashEntry<K>,
InterProcessReadWriteUpdateLock,
ExternalMapQueryContext<K, V, R>,
MapAbsentEntry<K, V>,
MapContext<K, V, R>,
MapEntry<K, V>,
QueryContextInterface<K, V, R>,
VanillaChronicleMapHolder<K, KI, MKI, V, VI, MVI, R> {
    final Thread owner;
    public final int indexInContextChain;
    public final Bytes entryBytes;
    public static final int MAX_SEGMENT_CHUNKS = 0x40000000;
    public static final int MAX_SEGMENT_ENTRIES = 0x20000000;
    public static final long UNSET_KEY = 0L;
    public static final long UNSET_ENTRY = 0L;
    public final ReadLock innerReadLock;
    public final WriteLock innerWriteLock;
    public final List<CompiledMapQueryContext> contextChain;
    public final UpdateLock innerUpdateLock;
    public final ThreadLocalCopies copies;
    final EntryKeyBytesValue entryKey;
    public final UsingReturnValue usingReturnValue;
    public final DefaultReturnValue defaultReturnValue;
    public final InputKeyBytesValue inputKeyBytesValue;
    public final EntryValueBytesValue entryValue;
    final WrappedValueInstanceValue wrappedValueInstanceValue;
    public final InputFirstValueBytesValue inputFirstValueBytesValue;
    public final InputSecondValueBytesValue inputSecondValueBytesValue;
    public final InputKeyInstanceValue inputKeyInstanceValue;
    public final InputValueInstanceValue inputValueInstanceValue;
    public final DeprecatedMapKeyContextOnQuery deprecatedMapKeyContext;
    public final DeprecatedMapAcquireContextOnQuery deprecatedMapAcquireContext;
    private final VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m;
    public final VI valueInterop;
    final Accessor.Full<Bytes, ?> entryBytesAccessor;
    public final T entryBytesAccessHandle;
    public final BytesReader<V> valueReader;
    public final KI keyInterop;
    public final Access<T> entryBytesAccess;
    public final BytesReader<K> keyReader;
    boolean used;
    public Bytes inputBytes = null;
    public long inputKeySize = -1L;
    public long inputKeyOffset;
    public long firstInputValueSize = -1L;
    public long firstInputValueOffset;
    public long secondInputValueSize = -1L;
    public long secondInputValueOffset;
    public Value<K, ?> inputKey = null;
    public long hashOfKey = 0L;
    public int segmentIndex = -1;
    int hashLookupEntrySize;
    int keyBits;
    long address = -1L;
    long capacityMask;
    long capacityMask2;
    long keyMask;
    long valueMask;
    long entryMask;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    CompiledMapQueryContext nextNode;
    public boolean concurrentSameThreadContexts;
    LocalLockState localLockState;
    public CompiledMapQueryContext rootContextOnThisSegment = null;
    long entrySpaceOffset = 0L;
    MultiStoreBytes freeListBytes = new MultiStoreBytes();
    public SingleThreadedDirectBitSet freeList = new SingleThreadedDirectBitSet();
    public long pos = -1L;
    public long keySizeOffset;
    public long keySize;
    public long keyOffset;
    public long valueSizeOffset;
    public long valueSize;
    public long valueOffset = -1L;
    public int entrySizeInChunks = 0;
    long searchKey = 0L;
    long searchStartPos;
    public long hashLookupPos = -1L;
    protected SearchState searchState = null;
    public int allocatedChunks = 0;

    @Override
    public void close() {
        this.defaultReturnValue.closeDefaultReturnedValue();
        this.closeAllocatedChunks();
        this.closeInputKey();
        this.wrappedValueInstanceValue.closeValue();
        this.usingReturnValue.closeUsingReturnValue();
        this.wrappedValueInstanceValue.closeNext();
        this.closeInputBytes();
        this.closeUsed();
        this.inputKeyInstanceValue.closeKey();
        this.inputValueInstanceValue.closeValue();
        this.closeValueBytesInteropValueMetaInteropDependants();
        this.closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeKeyBytesInteropKeyMetaInteropDependants();
        this.closeMapEntryStagesEntryBytesAccessOffsetDependants();
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public void setSearchStateGuarded(SearchState newSearchState) {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        this.setSearchState(newSearchState);
    }

    public void writeValueGuarded(Value<?, ?> value) {
        if (!this.valueInit()) {
            this.initValue();
        }
        this.writeValue(value);
    }

    void initKeySizeOffset(long pos) {
        this.keySizeOffset = this.entrySpaceOffset() + pos * this.h().chunkSize;
        this.entryBytes.limit(this.entryBytes.capacity());
    }

    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public CompiledMapQueryContext(VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        this.contextChain = new ArrayList<CompiledMapQueryContext>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.m = m;
        this.deprecatedMapKeyContext = new DeprecatedMapKeyContextOnQuery();
        this.inputKeyBytesValue = new InputKeyBytesValue();
        this.innerUpdateLock = new UpdateLock();
        this.inputKeyInstanceValue = new InputKeyInstanceValue();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.wrappedValueInstanceValue = new WrappedValueInstanceValue();
        this.innerWriteLock = new WriteLock();
        this.owner = Thread.currentThread();
        this.usingReturnValue = new UsingReturnValue();
        this.deprecatedMapAcquireContext = new DeprecatedMapAcquireContextOnQuery();
        this.entryValue = new EntryValueBytesValue();
        this.innerReadLock = new ReadLock();
        this.inputSecondValueBytesValue = new InputSecondValueBytesValue();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputValueInstanceValue = new InputValueInstanceValue();
        this.entryBytes = this.h().ms.bytes();
        this.entryBytesAccessor = JavaLangBytesAccessors.uncheckedBytesAccessor(this.entryBytes);
        this.entryBytesAccessHandle = this.entryBytesAccessor.handle((Object)this.entryBytes);
        this.entryBytesAccess = (Access)this.entryBytesAccessor.access((Object)this.entryBytes);
        this.entryKey = new EntryKeyBytesValue();
        this.inputFirstValueBytesValue = new InputFirstValueBytesValue();
    }

    public CompiledMapQueryContext(CompiledMapQueryContext c) {
        this.contextChain = c.contextChain;
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.m = c.m;
        this.deprecatedMapKeyContext = new DeprecatedMapKeyContextOnQuery();
        this.inputKeyBytesValue = new InputKeyBytesValue();
        this.innerUpdateLock = new UpdateLock();
        this.inputKeyInstanceValue = new InputKeyInstanceValue();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = (BytesReader)this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = (BytesReader)this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.wrappedValueInstanceValue = new WrappedValueInstanceValue();
        this.innerWriteLock = new WriteLock();
        this.owner = Thread.currentThread();
        this.usingReturnValue = new UsingReturnValue();
        this.deprecatedMapAcquireContext = new DeprecatedMapAcquireContextOnQuery();
        this.entryValue = new EntryValueBytesValue();
        this.innerReadLock = new ReadLock();
        this.inputSecondValueBytesValue = new InputSecondValueBytesValue();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputValueInstanceValue = new InputValueInstanceValue();
        this.entryBytes = this.h().ms.bytes();
        this.entryBytesAccessor = JavaLangBytesAccessors.uncheckedBytesAccessor(this.entryBytes);
        this.entryBytesAccessHandle = this.entryBytesAccessor.handle((Object)this.entryBytes);
        this.entryBytesAccess = (Access)this.entryBytesAccessor.access((Object)this.entryBytes);
        this.entryKey = new EntryKeyBytesValue();
        this.inputFirstValueBytesValue = new InputFirstValueBytesValue();
    }

    public void incrementModCount() {
        this.contextModCount = ++this.rootContextOnThisSegment.latestSameThreadSegmentModCount;
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        this.localLockState = newState;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public void writeValue(Value<?, ?> value) {
        value.writeTo(this.entryBytesAccess, this.entryBytesAccessHandle, this.entryBytesAccessOffset(this.valueOffset));
    }

    public Thread owner() {
        return this.owner;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        switch (this.localLockState) {
            case UNLOCKED: {
                break;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = --this.rootContextOnThisSegment.totalReadLockCount;
                if (newTotalReadLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalUpdateLockCount != 0 || this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalReadLockCount >= 0) break;
                throw new IllegalStateException("read underflow");
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = --this.rootContextOnThisSegment.totalUpdateLockCount;
                if (newTotalUpdateLockCount == 0) {
                    if (this.rootContextOnThisSegment.totalWriteLockCount != 0) break;
                    if (this.rootContextOnThisSegment.totalReadLockCount == 0) {
                        this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                    break;
                }
                if (newTotalUpdateLockCount >= 0) break;
                throw new IllegalStateException("update underflow");
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = --this.rootContextOnThisSegment.totalWriteLockCount;
                if (newTotalWriteLockCount != 0) break;
                if (this.rootContextOnThisSegment.totalUpdateLockCount > 0) {
                    this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                    break;
                }
                if (this.rootContextOnThisSegment.totalReadLockCount > 0) {
                    this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                    break;
                }
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void closeRootLocks() {
        assert (this.nextNode == null);
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void innerInitSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.address = address;
        this.capacityMask = capacity - 1L;
        this.hashLookupEntrySize = entrySize;
        this.capacityMask2 = this.capacityMask * (long)entrySize;
        this.keyBits = keyBits;
        this.keyMask = CompiledMapQueryContext.mask(keyBits);
        this.valueMask = CompiledMapQueryContext.mask(valueBits);
        this.entryMask = CompiledMapQueryContext.mask(keyBits + valueBits);
    }

    private void innerInitValue(Value<?, ?> value) {
        this.entryBytes.position(this.valueSizeOffset);
        this.valueSize = value.size();
        this.m().valueSizeMarshaller.writeSize(this.entryBytes, this.valueSize);
        this.m().alignment.alignPositionAddr(this.entryBytes);
        this.valueOffset = this.entryBytes.position();
        this.writeValue(value);
    }

    private void unlinkFromSegmentContextsChain() {
        CompiledMapQueryContext prevContext = this.rootContextOnThisSegment;
        while (true) {
            assert (prevContext.nextNode != null);
            if (prevContext.nextNode == this) break;
            prevContext = prevContext.nextNode;
        }
        assert (this.nextNode == null);
        prevContext.nextNode = null;
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public static int entrySize(int keyBits, int valueBits) {
        return (int)MemoryUnit.BYTES.alignAndConvert((long)(keyBits + valueBits), MemoryUnit.BITS);
    }

    public static int keyBits(long entriesPerSegment, int valueBits) {
        int minKeyBits = 64 - Long.numberOfLeadingZeros(entriesPerSegment - 1L);
        int actualEntryBits = (int)MemoryUnit.BYTES.align((long)((minKeyBits += 3) + valueBits), MemoryUnit.BITS);
        return actualEntryBits - valueBits;
    }

    public static int valueBits(long actualChunksPerSegment) {
        return 64 - Long.numberOfLeadingZeros(actualChunksPerSegment - 1L);
    }

    public Bytes entryBytes() {
        return this.entryBytes;
    }

    public static long capacityFor(long entriesPerSegment) {
        if (entriesPerSegment < 0L) {
            throw new IllegalArgumentException("entriesPerSegment should be positive");
        }
        long capacity = Maths.nextPower2((long)entriesPerSegment, (long)64L);
        if ((double)entriesPerSegment / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    public static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    public int MAX_SEGMENT_ENTRIES() {
        return 0x20000000;
    }

    public int MAX_SEGMENT_CHUNKS() {
        return 0x40000000;
    }

    public long UNSET_ENTRY() {
        return 0L;
    }

    public long UNSET_KEY() {
        return 0L;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public List<CompiledMapQueryContext> contextChain() {
        return this.contextChain;
    }

    public ThreadLocalCopies copies() {
        return this.copies;
    }

    public EntryKeyBytesValue entryKey() {
        return this.entryKey;
    }

    public UsingReturnValue usingReturnValue() {
        return this.usingReturnValue;
    }

    public DefaultReturnValue defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public InputKeyBytesValue inputKeyBytesValue() {
        return this.inputKeyBytesValue;
    }

    public EntryValueBytesValue entryValue() {
        return this.entryValue;
    }

    public WrappedValueInstanceValue wrappedValueInstanceValue() {
        return this.wrappedValueInstanceValue;
    }

    public InputFirstValueBytesValue inputFirstValueBytesValue() {
        return this.inputFirstValueBytesValue;
    }

    public InputSecondValueBytesValue inputSecondValueBytesValue() {
        return this.inputSecondValueBytesValue;
    }

    public InputKeyInstanceValue inputKeyInstanceValue() {
        return this.inputKeyInstanceValue;
    }

    public InputValueInstanceValue inputValueInstanceValue() {
        return this.inputValueInstanceValue;
    }

    public DeprecatedMapKeyContextOnQuery deprecatedMapKeyContext() {
        return this.deprecatedMapKeyContext;
    }

    public DeprecatedMapAcquireContextOnQuery deprecatedMapAcquireContext() {
        return this.deprecatedMapAcquireContext;
    }

    public VI valueInterop() {
        return this.valueInterop;
    }

    public Accessor.Full<Bytes, ?> entryBytesAccessor() {
        return this.entryBytesAccessor;
    }

    public T entryBytesAccessHandle() {
        return this.entryBytesAccessHandle;
    }

    public BytesReader<V> valueReader() {
        return this.valueReader;
    }

    public KI keyInterop() {
        return this.keyInterop;
    }

    public Access<T> entryBytesAccess() {
        return this.entryBytesAccess;
    }

    public BytesReader<K> keyReader() {
        return this.keyReader;
    }

    public long entryBytesAccessOffset(long offset) {
        return this.entryBytesAccessor.offset((Object)this.entryBytes, offset);
    }

    public void closeMapEntryStagesEntryBytesAccessOffsetDependants() {
        this.closeEntry();
        this.closeValue();
        this.closeMapQueryKeyEqualsDependants();
    }

    public MKI keyMetaInterop(K key) {
        return (MKI)((MetaBytesInterop)this.h().metaKeyInteropProvider.get(this.copies, this.h().originalMetaKeyInterop, this.keyInterop, key));
    }

    public void closeKeyBytesInteropKeyMetaInteropDependants() {
        this.inputKeyInstanceValue.closeBuffer();
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (this.m().constantlySizedEntry) {
            return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue + valueSize);
        }
        if (this.m().couldNotDetermineAlignmentBeforeAllocation) {
            return sizeOfEverythingBeforeValue + (long)this.m().worstAlignment + valueSize;
        }
        return this.m().alignment.alignAddr(sizeOfEverythingBeforeValue) + valueSize;
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        return this;
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeQuerySegmentStagesTryFindInitLocksOfThisSegmentDependants();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)(this.m().metaDataBytes + this.m().keySizeMarshaller.sizeEncodingSize(keySize)) + keySize + (long)this.m().valueSizeMarshaller.sizeEncodingSize(valueSize);
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public MVI valueMetaInterop(V value) {
        return (MVI)((MetaBytesInterop)this.m().metaValueInteropProvider.get(this.copies, this.m().originalMetaValueInterop, this.valueInterop, value));
    }

    public void closeValueBytesInteropValueMetaInteropDependants() {
        this.inputValueInstanceValue.closeBuffer();
        this.wrappedValueInstanceValue.closeBuffer();
    }

    @Override
    public VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m() {
        return this.m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    private CompiledMapQueryContext _Chaining_createChaining() {
        return new CompiledMapQueryContext<K, KI, MKI, V, VI, MVI, R, T>(this);
    }

    public CompiledMapQueryContext createChaining() {
        return new CompiledMapQueryContext<K, KI, MKI, V, VI, MVI, R, T>(this);
    }

    public <T> T getContext() {
        for (CompiledMapQueryContext context : this.contextChain) {
            if (context.usedInit()) continue;
            return (T)context;
        }
        int maxNestedContexts = 65536;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        return (T)this.createChaining();
    }

    public boolean usedInit() {
        return this.used;
    }

    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    public boolean inputBytesInit() {
        return this.inputBytes != null;
    }

    public void initInputBytes(Bytes inputBytes) {
        this.inputBytes = inputBytes;
        this.closeInputBytesDependants();
    }

    public Bytes inputBytes() {
        assert (this.inputBytesInit()) : "InputBytes should be init";
        return this.inputBytes;
    }

    public void closeInputBytes() {
        if (!this.inputBytesInit()) {
            return;
        }
        this.closeInputBytesDependants();
        this.inputBytes = null;
    }

    public void closeInputBytesDependants() {
        this.closeInputKeyOffsets();
        this.closeFirstInputValueOffsets();
        this.inputKeyBytesValue.closeInputKeyBytesValueGetUsingDependants();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesValueGetUsingDependants();
        this.closeSecondInputValueOffsets();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesValueGetUsingDependants();
    }

    public boolean inputKeyOffsetsInit() {
        return this.inputKeySize >= 0L;
    }

    private void initInputKeyOffsets() {
        this.inputKeySize = this.h().keySizeMarshaller.readSize(this.inputBytes());
        this.inputKeyOffset = this.inputBytes().position();
        this.closeInputKeyOffsetsDependants();
    }

    public long inputKeyOffset() {
        if (!this.inputKeyOffsetsInit()) {
            this.initInputKeyOffsets();
        }
        return this.inputKeyOffset;
    }

    public long inputKeySize() {
        if (!this.inputKeyOffsetsInit()) {
            this.initInputKeyOffsets();
        }
        return this.inputKeySize;
    }

    public void closeInputKeyOffsets() {
        if (!this.inputKeyOffsetsInit()) {
            return;
        }
        this.closeInputKeyOffsetsDependants();
        this.inputKeySize = -1L;
    }

    public void closeInputKeyOffsetsDependants() {
        this.closeFirstInputValueOffsets();
        this.inputKeyBytesValue.closeInputKeyBytesValueSizeDependants();
        this.inputKeyBytesValue.closeInputKeyBytesValueGetUsingDependants();
    }

    public boolean firstInputValueOffsetsInit() {
        return this.firstInputValueSize >= 0L;
    }

    private void initFirstInputValueOffsets() {
        this.inputBytes().position(this.inputKeyOffset() + this.inputKeySize());
        this.firstInputValueSize = this.m().valueSizeMarshaller.readSize(this.inputBytes());
        this.firstInputValueOffset = this.inputBytes().position();
        this.closeFirstInputValueOffsetsDependants();
    }

    public long firstInputValueOffset() {
        if (!this.firstInputValueOffsetsInit()) {
            this.initFirstInputValueOffsets();
        }
        return this.firstInputValueOffset;
    }

    public long firstInputValueSize() {
        if (!this.firstInputValueOffsetsInit()) {
            this.initFirstInputValueOffsets();
        }
        return this.firstInputValueSize;
    }

    public void closeFirstInputValueOffsets() {
        if (!this.firstInputValueOffsetsInit()) {
            return;
        }
        this.closeFirstInputValueOffsetsDependants();
        this.firstInputValueSize = -1L;
    }

    public void closeFirstInputValueOffsetsDependants() {
        this.closeSecondInputValueOffsets();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesValueSizeDependants();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesValueGetUsingDependants();
    }

    public boolean secondInputValueOffsetsInit() {
        return this.secondInputValueSize >= 0L;
    }

    private void initSecondInputValueOffsets() {
        this.inputBytes().position(this.firstInputValueOffset() + this.firstInputValueSize());
        this.secondInputValueSize = this.m().valueSizeMarshaller.readSize(this.inputBytes());
        this.secondInputValueOffset = this.inputBytes().position();
        this.closeSecondInputValueOffsetsDependants();
    }

    public long secondInputValueOffset() {
        if (!this.secondInputValueOffsetsInit()) {
            this.initSecondInputValueOffsets();
        }
        return this.secondInputValueOffset;
    }

    public long secondInputValueSize() {
        if (!this.secondInputValueOffsetsInit()) {
            this.initSecondInputValueOffsets();
        }
        return this.secondInputValueSize;
    }

    public void closeSecondInputValueOffsets() {
        if (!this.secondInputValueOffsetsInit()) {
            return;
        }
        this.closeSecondInputValueOffsetsDependants();
        this.secondInputValueSize = -1L;
    }

    public void closeSecondInputValueOffsetsDependants() {
        this.inputSecondValueBytesValue.closeInputSecondValueBytesValueSizeDependants();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesValueGetUsingDependants();
    }

    public boolean inputKeyInit() {
        return this.inputKey != null;
    }

    @Override
    public void initInputKey(Value<K, ?> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Value<K, ?> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeHashOfKey();
        this.closeMapQueryKeyEqualsDependants();
    }

    public boolean hashOfKeyInit() {
        return this.hashOfKey != 0L;
    }

    void initHashOfKey() {
        this.hashOfKey = this.inputKey().hash(LongHashFunction.city_1_1());
        this.closeHashOfKeyDependants();
    }

    public long hashOfKey() {
        if (!this.hashOfKeyInit()) {
            this.initHashOfKey();
        }
        return this.hashOfKey;
    }

    public void closeHashOfKey() {
        if (!this.hashOfKeyInit()) {
            return;
        }
        this.closeHashOfKeyDependants();
        this.hashOfKey = 0L;
    }

    public void closeHashOfKeyDependants() {
        this.closeTheSegmentIndex();
        this.closeSearchKey();
    }

    @Override
    public boolean theSegmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    void initTheSegmentIndex() {
        this.segmentIndex = this.h().hashSplitting.segmentIndex(this.hashOfKey());
        this.closeTheSegmentIndexDependants();
    }

    @Override
    public void initTheSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeTheSegmentIndexDependants();
    }

    public int segmentIndex() {
        if (!this.theSegmentIndexInit()) {
            this.initTheSegmentIndex();
        }
        return this.segmentIndex;
    }

    public void closeTheSegmentIndex() {
        if (!this.theSegmentIndexInit()) {
            return;
        }
        this.closeTheSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeTheSegmentIndexDependants() {
        this.closeSegmentHashLookup();
        this.closeSegHeader();
        this.closeSegment();
    }

    public boolean segmentHashLookupInit() {
        return this.address >= 0L;
    }

    public void initSegmentHashLookup() {
        long hashLookupOffset = this.h().segmentOffset(this.segmentIndex());
        this.innerInitSegmentHashLookup(this.h().ms.address() + hashLookupOffset, this.h().segmentHashLookupCapacity, this.h().segmentHashLookupEntrySize, this.h().segmentHashLookupKeyBits, this.h().segmentHashLookupValueBits);
        this.closeSegmentHashLookupDependants();
    }

    public void initSegmentHashLookup(long address, long capacity, int entrySize, int keyBits, int valueBits) {
        this.innerInitSegmentHashLookup(address, capacity, entrySize, keyBits, valueBits);
        this.closeSegmentHashLookupDependants();
    }

    public int hashLookupEntrySize() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.hashLookupEntrySize;
    }

    public int keyBits() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyBits;
    }

    public long address() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.address;
    }

    public long capacityMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask;
    }

    public long capacityMask2() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.capacityMask2;
    }

    public long entryMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.entryMask;
    }

    public long keyMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.keyMask;
    }

    public long valueMask() {
        if (!this.segmentHashLookupInit()) {
            this.initSegmentHashLookup();
        }
        return this.valueMask;
    }

    public void closeSegmentHashLookup() {
        if (!this.segmentHashLookupInit()) {
            return;
        }
        this.closeSegmentHashLookupDependants();
        this.address = -1L;
    }

    public void closeSegmentHashLookupDependants() {
        this.closeHashLookupKeyDependants();
        this.closeHashLookupStepBackDependants();
        this.closeHashLookupEmptyDependants();
        this.closeHashLookupIndexToPosDependants();
        this.closeHashLookupHlPosDependants();
        this.closeHashLookupReadEntryDependants();
        this.closeHashLookupMaskUnsetKeyDependants();
        this.closeHashLookupValueDependants();
        this.closeHashLookupStepDependants();
    }

    void clearEntry(long pos, long prevEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public long key(long entry) {
        return entry & this.keyMask();
    }

    public void closeHashLookupKeyDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long stepBack(long pos) {
        return (pos -= (long)this.hashLookupEntrySize()) >= 0L ? pos : this.capacityMask2();
    }

    public void closeHashLookupStepBackDependants() {
        this.closeHashLookupSearchFoundDependants();
    }

    void writeEntry(long pos, long prevEntry, long anotherEntry) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | anotherEntry & this.entryMask();
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public boolean empty(long entry) {
        return (entry & this.entryMask()) == 0L;
    }

    public void closeHashLookupEmptyDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    long indexToPos(long index) {
        return index * (long)this.hashLookupEntrySize();
    }

    public void closeHashLookupIndexToPosDependants() {
        this.closeHashLookupHlPosDependants();
    }

    public long hlPos(long key) {
        return this.indexToPos(key & this.capacityMask());
    }

    public void closeHashLookupHlPosDependants() {
        this.closeSearchKey();
    }

    public long readEntry(long pos) {
        return NativeBytes.UNSAFE.getLong(this.address() + pos);
    }

    public void closeHashLookupReadEntryDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long maskUnsetKey(long key) {
        return (key &= this.keyMask()) != 0L ? key : this.keyMask();
    }

    public void closeHashLookupMaskUnsetKeyDependants() {
        this.closeSearchKey();
    }

    public long value(long entry) {
        return entry >>> this.keyBits() & this.valueMask();
    }

    public void closeHashLookupValueDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    void forEach(EntryConsumer action) {
        for (long pos = 0L; pos <= this.capacityMask2(); pos += (long)this.hashLookupEntrySize()) {
            long entry = this.readEntry(pos);
            if (this.empty(entry)) continue;
            action.accept(this.key(entry), this.value(entry));
        }
    }

    String hashLookupToString() {
        StringBuilder sb = new StringBuilder("{");
        this.forEach((key, value) -> sb.append(key).append('=').append(value).append(','));
        sb.append('}');
        return sb.toString();
    }

    public void checkValueForPut(long value) {
        assert ((value & (this.valueMask() ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "Value out of range, was " + value;
    }

    public long step(long pos) {
        return (pos += (long)this.hashLookupEntrySize()) <= this.capacityMask2() ? pos : 0L;
    }

    public void closeHashLookupStepDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    public long remove(long posToRemove) {
        long entryToShift;
        long entryToRemove = this.readEntry(posToRemove);
        long posToShift = posToRemove;
        while (!this.empty(entryToShift = this.readEntry(posToShift = this.step(posToShift)))) {
            boolean cond2;
            long insertPos = this.hlPos(this.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.writeEntry(posToRemove, entryToRemove, entryToShift);
            posToRemove = posToShift;
            entryToRemove = entryToShift;
        }
        this.clearEntry(posToRemove, entryToRemove);
        return posToRemove;
    }

    public void clearHashLookup() {
        NativeBytes.UNSAFE.setMemory(this.address(), this.capacityMask2() + (long)this.hashLookupEntrySize(), (byte)0);
    }

    long entry(long key, long value) {
        return key | value << this.keyBits();
    }

    public void writeEntryVolatile(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLongVolatile(null, this.address() + pos, entry);
    }

    public void putValueVolatile(long pos, long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(pos);
        this.writeEntryVolatile(pos, currentEntry, this.key(currentEntry), value);
    }

    public void writeEntry(long pos, long prevEntry, long key, long value) {
        long entry = prevEntry & (this.entryMask() ^ 0xFFFFFFFFFFFFFFFFL) | this.entry(key, value);
        NativeBytes.UNSAFE.putLong(this.address() + pos, entry);
    }

    public boolean segHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegHeader() {
        this.segmentHeaderAddress = this.h().ms.address() + this.h().segmentHeaderOffset(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegHeaderDependants();
    }

    public long segmentHeaderAddress() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segHeaderInit()) {
            this.initSegHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegHeader() {
        if (!this.segHeaderInit()) {
            return;
        }
        this.closeSegHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegHeaderDependants() {
        this.closeQuerySegmentStagesTryFindInitLocksOfThisSegmentDependants();
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
    }

    long nextPosToSearchFrom() {
        return this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress());
    }

    public void entries(long size) {
        this.segmentHeader().size(this.segmentHeaderAddress(), size);
    }

    public long deleted() {
        return this.segmentHeader().deleted(this.segmentHeaderAddress());
    }

    boolean tryFindInitLocksOfThisSegment(Object thisContext, int index) {
        CompiledMapQueryContext c = (CompiledMapQueryContext)this.contextAtIndexInChain(index);
        if (c.segmentHeader() != null && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.rootContextOnThisSegment() != null) {
            throw new IllegalStateException("Nested context not implemented yet");
        }
        return false;
    }

    public void closeQuerySegmentStagesTryFindInitLocksOfThisSegmentDependants() {
        this.closeLocks();
    }

    public boolean locksInit() {
        return this.rootContextOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(this, i)) continue;
            return;
        }
        this.rootContextOnThisSegment = this;
        this.concurrentSameThreadContexts = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.nextNode = null;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean concurrentSameThreadContexts() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.concurrentSameThreadContexts;
    }

    public int contextModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.contextModCount;
    }

    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    public CompiledMapQueryContext rootContextOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.localLockState = null;
        this.rootContextOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void deleted(long deleted) {
        this.segmentHeader().deleted(this.segmentHeaderAddress(), deleted);
    }

    public long entries() {
        return this.segmentHeader().size(this.segmentHeaderAddress());
    }

    public long size() {
        return this.entries() - this.deleted();
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress(), nextPosToSearchFrom);
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        long hashLookupOffset = h.segmentOffset(this.segmentIndex());
        long freeListOffset = hashLookupOffset + h.segmentHashLookupOuterSize;
        this.freeListBytes.storePositionAndSize(h.ms, freeListOffset, h.segmentFreeListInnerSize);
        this.freeList.reuse((Bytes)this.freeListBytes);
        this.entrySpaceOffset = freeListOffset + h.segmentFreeListOuterSize + (long)h.segmentEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public SingleThreadedDirectBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeEntry();
    }

    public void clearSegment() {
        this.innerWriteLock.lock();
        this.clearHashLookup();
        this.freeList().clear();
        this.nextPosToSearchFrom(0L);
        this.entries(0L);
    }

    @Override
    public void clear() {
        this.clearSegment();
    }

    public void free(long fromPos, int chunks) {
        this.freeList().clear(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    public long alloc(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " entry size chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList().setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList().clear(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList().setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList().clear(ret, h.actualChunksPerSegment);
                }
                if (chunks == 1) {
                    throw new IllegalStateException("Segment is full, no free entries found");
                }
                throw new IllegalStateException("Segment is full or has no ranges of " + chunks + " continuous free chunks");
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList().isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public boolean entryInit() {
        return this.pos >= 0L;
    }

    @Override
    public void initEntry(long pos) {
        this.initKeySizeOffset(pos);
        this.entryBytes.position(this.keySizeOffset);
        this.keySize = this.h().keySizeMarshaller.readSize(this.entryBytes);
        this.keyOffset = this.entryBytes.position();
        this.pos = pos;
        this.closeEntryDependants();
    }

    public void initEntry(long pos, Value<?, ?> key) {
        this.initKeySizeOffset(pos);
        this.entryBytes.position(this.keySizeOffset);
        this.keySize = key.size();
        this.h().keySizeMarshaller.writeSize(this.entryBytes, this.keySize);
        this.keyOffset = this.entryBytes.position();
        key.writeTo(this.entryBytesAccessor, this.entryBytes, this.keyOffset);
        this.pos = pos;
        this.closeEntryDependants();
    }

    public void initEntryCopying(long newPos, long bytesToCopy) {
        long oldKeySizeOffset = this.keySizeOffset;
        this.initKeySizeOffset(newPos);
        long oldKeyOffset = this.keyOffset;
        this.keyOffset = this.keySizeOffset + (oldKeyOffset - oldKeySizeOffset);
        Access.copy(this.entryBytesAccess, this.entryBytesAccessHandle, (long)this.entryBytesAccessOffset(oldKeySizeOffset), this.entryBytesAccess, this.entryBytesAccessHandle, (long)this.entryBytesAccessOffset(this.keySizeOffset), (long)bytesToCopy);
        this.pos = newPos;
        this.closeEntryDependants();
    }

    public long keyOffset() {
        assert (this.entryInit()) : "Entry should be init";
        return this.keyOffset;
    }

    public long keySize() {
        assert (this.entryInit()) : "Entry should be init";
        return this.keySize;
    }

    public long keySizeOffset() {
        assert (this.entryInit()) : "Entry should be init";
        return this.keySizeOffset;
    }

    public long pos() {
        assert (this.entryInit()) : "Entry should be init";
        return this.pos;
    }

    public void closeEntry() {
        if (!this.entryInit()) {
            return;
        }
        this.closeEntryDependants();
        this.pos = -1L;
    }

    public void closeEntryDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.closeMapEntryStagesEntrySizeDependants();
        this.closeMapQueryKeyEqualsDependants();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
        this.entryKey.closeEntryKeyBytesValueSizeDependants();
        this.entryKey.closeEntryKeyBytesValueInnerGetUsingDependants();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeMapEntryStagesKeyEndDependants() {
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapEntryStagesEntryEndDependants();
    }

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    public void closeMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValue();
    }

    boolean valueInit() {
        return this.valueOffset >= 0L;
    }

    void initValue() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.entryBytes.position(this.valueSizeOffset);
        this.valueSize = this.m().readValueSize(this.entryBytes);
        this.m().alignment.alignPositionAddr(this.entryBytes);
        this.valueOffset = this.entryBytes.position();
        this.closeValueDependants();
    }

    public void initValue(Value<?, ?> value) {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.innerInitValue(value);
        this.closeValueDependants();
    }

    public void initValueAgain(Value<?, ?> value) {
        assert (this.valueInit());
        this.innerInitValue(value);
        this.closeValueDependants();
    }

    public void initValueWithoutSize(Value<?, ?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSizeOffset = this.countValueSizeOffset();
        assert (oldValueSize == value.size());
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset + (oldValueOffset - oldValueSizeOffset);
        this.writeValue(value);
        this.closeValueDependants();
    }

    public long valueOffset() {
        if (!this.valueInit()) {
            this.initValue();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueInit()) {
            this.initValue();
        }
        return this.valueSize;
    }

    public long valueSizeOffset() {
        if (!this.valueInit()) {
            this.initValue();
        }
        return this.valueSizeOffset;
    }

    public void closeValue() {
        if (!this.valueInit()) {
            return;
        }
        this.closeValueDependants();
        this.valueOffset = -1L;
    }

    public void closeValueDependants() {
        this.closeMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesValueSizeDependants();
        this.entryValue.closeEntryValueBytesValueInnerGetUsingDependants();
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeMapEntryStagesEntryEndDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
    }

    long entrySize() {
        return this.entryEnd() - this.keySizeOffset();
    }

    public void closeMapEntryStagesEntrySizeDependants() {
        this.closeTheEntrySizeInChunks();
    }

    public boolean theEntrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initTheEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initTheEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            this.initTheEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeTheEntrySizeInChunks() {
        if (!this.theEntrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public long newSizeOfEverythingBeforeValue(Value<V, ?> newValue) {
        return this.valueSizeOffset() + (long)this.m().valueSizeMarshaller.sizeEncodingSize(newValue.size()) - this.keySizeOffset();
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(this.pos(), this.entrySizeInChunks());
        this.entries(this.entries() - 1L);
        this.incrementModCountGuarded();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    void initSearchKey() {
        this.searchKey = this.maskUnsetKey(this.h().hashSplitting.segmentHash(this.hashOfKey()));
        this.searchStartPos = this.hlPos(this.searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchKey;
    }

    public long searchStartPos() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos >= 0L;
    }

    public void initHashLookupPos() {
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.remove(this.hashLookupPos()));
    }

    public void putNewVolatile(long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(this.hashLookupPos());
        this.writeEntryVolatile(this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            do {
                if (this.empty(entry = this.readEntry(pos))) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                if ((pos = this.step(pos)) == this.searchStartPos()) break block2;
            } while (this.key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return this.value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void closeHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public void putVolatile(long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(this.hashLookupPos());
        assert (this.key(currentEntry) == this.searchKey());
        this.writeEntryVolatile(this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.readEntry(this.hashLookupPos());
        return this.key(entry) == this.searchKey() && this.value(entry) == value;
    }

    public void closeHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants() {
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public boolean checkSlotIsEmpty() {
        return this.empty(this.readEntry(this.hashLookupPos()));
    }

    public void found() {
        this.setHashLookupPosGuarded(this.stepBack(this.hashLookupPos()));
    }

    public void closeHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    void put(long value) {
        this.checkValueForPut(value);
        this.writeEntry(this.hashLookupPos(), this.readEntry(this.hashLookupPos()), this.searchKey(), value);
    }

    boolean keyEquals() {
        return this.inputKey().size() == this.keySize() && this.inputKey().equivalent(this.entryBytesAccess, this.entryBytesAccessHandle, this.entryBytesAccessOffset(this.keyOffset()));
    }

    public void closeMapQueryKeyEqualsDependants() {
        this.closeKeySearch();
    }

    boolean keySearchInit() {
        return this.searchState != null;
    }

    void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            this.initEntry(pos);
            if (!this.keyEquals()) continue;
            this.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
        this.closeKeySearchDependants();
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.closeKeySearchDependants();
        this.searchState = null;
    }

    public void closeKeySearchDependants() {
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    private void _AllocatedChunks_incrementSegmentEntriesIfNeeded() {
    }

    public void incrementSegmentEntriesIfNeeded() {
        if (this.searchState() != SearchState.PRESENT) {
            this.entries(this.entries() + 1L);
        }
    }

    protected boolean searchStateDeleted() {
        return this.searchState() == SearchState.DELETED && !this.concurrentSameThreadContexts() && this.innerUpdateLock.isHeldByCurrentThread();
    }

    protected boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    protected boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    protected boolean entryPresent() {
        return this.searchStatePresent();
    }

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.locksInit() && this.concurrentSameThreadContexts() && this.rootContextOnThisSegment().latestSameThreadSegmentModCount() != this.contextModCount() && this.keySearchInit() && this.searchState() == SearchState.PRESENT && !this.checkSlotContainsExpectedKeyAndValue(this.pos())) {
            this.closeHashLookupPos();
        }
    }

    public void closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed();
    }

    public void closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesValueSizeDependants();
        this.entryKey.closeEntryKeyBytesValueSizeDependants();
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    @NotNull
    public Value<V, ?> defaultValue() {
        this.checkOnEachPublicOperation();
        return this.wrapValueAsValue(this.m().defaultValue(this.deprecatedMapKeyContext));
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Value<V, ?> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Value<V, ?> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    public Value<V, ?> wrapValueAsValue(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceValue wrapped = this.wrappedValueInstanceValue;
        wrapped = wrapped.getUnusedWrappedValueGuarded();
        wrapped.initValue(value);
        return wrapped;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    @NotNull
    public Value<V, ?> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public Value<V, ?> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.defaultValue(absentEntry);
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public Value<K, ?> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public Value<K, ?> queriedKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public MapEntry<K, V> entry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? this : null;
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    private void putPrefix() {
        boolean searchResultsNotTrusted;
        boolean underUpdatedLockIsHeld;
        this.checkOnEachPublicOperation();
        boolean bl = underUpdatedLockIsHeld = !this.innerUpdateLock.isHeldByCurrentThread();
        if (underUpdatedLockIsHeld) {
            this.innerUpdateLock.lock();
        }
        boolean bl2 = searchResultsNotTrusted = underUpdatedLockIsHeld || this.concurrentSameThreadContexts();
        if (this.hashLookupPosInit() && this.searchStateAbsent() && searchResultsNotTrusted) {
            this.closeHashLookupPos();
        }
    }

    @Override
    @Nullable
    public MapAbsentEntry<K, V> absentEntry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? null : this;
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        if (!this.searchStatePresent()) {
            throw new IllegalStateException("Entry is absent when doRemove() is called");
        }
        this.innerWriteLock.lock();
        this.remove();
        this.innerRemoveEntryExceptHashLookupUpdate();
        this.setSearchStateGuarded(SearchState.DELETED);
    }

    @Override
    @NotNull
    public Value<K, ?> absentKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.free(this.pos() + (long)this.entrySizeInChunks(), this.allocatedChunks() - this.entrySizeInChunks());
        } else {
            this.initTheEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public void writeValueAndPutPos(Value<V, ?> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    public void initEntryAndKey(long entrySize) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.initEntry(this.alloc(this.allocatedChunks()), this.inputKey());
        this.incrementSegmentEntriesIfNeeded();
    }

    void putEntry(Value<V, ?> value) {
        assert (this.searchStateAbsent());
        long entrySize = this.entrySize(this.inputKey().size(), value.size());
        this.initEntryAndKey(entrySize);
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putNewVolatile(this.pos());
    }

    public void initEntryAndKeyCopying(long entrySize, long bytesToCopy) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.initEntryCopying(this.alloc(this.allocatedChunks()), bytesToCopy);
        this.incrementSegmentEntriesIfNeeded();
    }

    protected void relocation(Value<V, ?> newValue, long newSizeOfEverythingBeforeValue) {
        this.free(this.pos(), this.entrySizeInChunks());
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset());
        this.writeValueAndPutPos(newValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Value<V, ?> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R> m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = (newValueOffset = m.alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue)) + newValue.size() - entryStartOffset);
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.freeList().allClear(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.freeList().set(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeList().clear(this.pos() + (long)newSizeInChunks, this.pos() + (long)this.entrySizeInChunks());
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValueAgain(newValue);
        } else {
            this.writeValueGuarded(newValue);
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    @Override
    public void doReplaceValue(Value<V, ?> newValue) {
        this.putPrefix();
        if (!this.searchStatePresent()) {
            throw new IllegalStateException("Entry is absent in the map when doReplaceValue() is called");
        }
        this.innerDefaultReplaceValue(newValue);
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
    }

    public void putValueDeletedEntry(Value<V, ?> newValue) {
        int newSizeInChunks;
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        long entryStartOffset = this.keySizeOffset();
        long newSizeOfEverythingBeforeValue = -1L;
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long newValueOffset = this.m().alignment.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue);
            long newEntrySize = newValueOffset + newValue.size() - entryStartOffset;
            newSizeInChunks = this.m().inChunks(newEntrySize);
        } else {
            newSizeInChunks = this.entrySizeInChunks();
        }
        if (this.pos() + (long)newSizeInChunks < this.freeList().size() && this.freeList().allClear(this.pos(), this.pos() + (long)newSizeInChunks)) {
            this.freeList().set(this.pos(), this.pos() + (long)newSizeInChunks);
            this.innerWriteLock.lock();
            this.incrementSegmentEntriesIfNeeded();
            if (newValueSizeIsDifferent) {
                this.initValueAgain(newValue);
            } else {
                this.writeValueGuarded(newValue);
            }
        } else {
            if (newValueSizeIsDifferent) {
                assert (newSizeOfEverythingBeforeValue >= 0L);
            } else {
                newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            }
            long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
            if (newValueSizeIsDifferent) {
                this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - entryStartOffset);
                this.initValue(newValue);
            } else {
                long oldValueSizeOffset = this.valueSizeOffset();
                long oldValueSize = this.valueSize();
                long oldValueOffset = this.valueOffset();
                this.initEntryAndKeyCopying(entrySize, this.valueOffset() - entryStartOffset);
                this.initValueWithoutSize(newValue, oldValueSizeOffset, oldValueSize, oldValueOffset);
            }
            this.freeExtraAllocatedChunks();
        }
        this.putValueVolatile(this.hashLookupPos(), this.pos());
    }

    @Override
    public void doInsert(Value<V, ?> value) {
        this.putPrefix();
        if (!this.searchStatePresent()) {
            if (this.searchStateDeleted()) {
                this.putValueDeletedEntry(value);
            } else {
                this.putEntry(value);
            }
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
    }

    public class UsingReturnValue
    implements UsableReturnValue<V> {
        private V usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINT;
        private V returnedValue = null;

        @Override
        public void returnValue(@NotNull Value<V, ?> value) {
            this.initReturnedValue(value);
        }

        public boolean usingReturnValueInit() {
            return this.usingReturnValue != UsableReturnValue.USING_RETURN_VALUE_UNINT;
        }

        @Override
        public void initUsingReturnValue(V usingReturnValue) {
            this.usingReturnValue = usingReturnValue;
            this.closeUsingReturnValueDependants();
        }

        public V usingReturnValue() {
            assert (this.usingReturnValueInit()) : "UsingReturnValue should be init";
            return this.usingReturnValue;
        }

        public void closeUsingReturnValue() {
            if (!this.usingReturnValueInit()) {
                return;
            }
            this.closeUsingReturnValueDependants();
            this.usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINT;
        }

        public void closeUsingReturnValueDependants() {
            this.closeReturnedValue();
        }

        boolean returnedValueInit() {
            return this.returnedValue != null;
        }

        private void initReturnedValue(@NotNull Value<V, ?> value) {
            this.returnedValue = value.getUsing(this.usingReturnValue());
        }

        public V returnedValue() {
            assert (this.returnedValueInit()) : "ReturnedValue should be init";
            return this.returnedValue;
        }

        public void closeReturnedValue() {
            if (!this.returnedValueInit()) {
                return;
            }
            this.returnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.returnedValueInit()) {
                return this.returnedValue();
            }
            return null;
        }
    }

    public class DefaultReturnValue
    implements InstanceReturnValue<V> {
        private V defaultReturnedValue = null;

        @Override
        public void returnValue(@NotNull Value<V, ?> value) {
            this.initDefaultReturnedValue(value);
        }

        boolean defaultReturnedValueInit() {
            return this.defaultReturnedValue != null;
        }

        private void initDefaultReturnedValue(@NotNull Value<V, ?> value) {
            this.defaultReturnedValue = value.getUsing(null);
        }

        public V defaultReturnedValue() {
            assert (this.defaultReturnedValueInit()) : "DefaultReturnedValue should be init";
            return this.defaultReturnedValue;
        }

        public void closeDefaultReturnedValue() {
            if (!this.defaultReturnedValueInit()) {
                return;
            }
            this.defaultReturnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.defaultReturnedValueInit()) {
                return this.defaultReturnedValue();
            }
            return null;
        }
    }

    public class InputValueInstanceValue
    extends CopyingInstanceValue<V, T>
    implements ValueInitableValue<V, T> {
        private V value = null;
        private boolean marshalled = false;
        private DirectBytes buffer;

        public boolean valueInit() {
            return this.value != null;
        }

        @Override
        public void initValue(V value) {
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledMapQueryContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledMapQueryContext.this.valueInterop, this.value());
            this.buffer = CopyingInstanceValue.getBuffer(this.buffer, size);
            mvi.write(CompiledMapQueryContext.this.valueInterop, (Bytes)this.buffer, this.value());
            this.buffer.flip();
            this.marshalled = true;
        }

        @Override
        public DirectBytes buffer() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buffer;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            this.buffer().position(0L);
            return CompiledMapQueryContext.this.valueReader.read((Bytes)this.buffer(), this.buffer().limit(), usingValue);
        }

        @Override
        public V instance() {
            return this.value();
        }
    }

    public class InputKeyInstanceValue
    extends CopyingInstanceValue<K, T>
    implements KeyInitableValue<K, T> {
        private K key = null;
        private boolean marshalled = false;
        private DirectBytes buffer;

        public boolean keyInit() {
            return this.key != null;
        }

        @Override
        public void initKey(K key) {
            this.key = key;
            this.closeKeyDependants();
        }

        public K key() {
            assert (this.keyInit()) : "Key should be init";
            return this.key;
        }

        public void closeKey() {
            if (!this.keyInit()) {
                return;
            }
            this.closeKeyDependants();
            this.key = null;
        }

        public void closeKeyDependants() {
            this.closeBuffer();
        }

        @Override
        public K instance() {
            return this.key();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mki = CompiledMapQueryContext.this.keyMetaInterop(this.key());
            long size = mki.size(CompiledMapQueryContext.this.keyInterop, this.key());
            this.buffer = CopyingInstanceValue.getBuffer(this.buffer, size);
            mki.write(CompiledMapQueryContext.this.keyInterop, (Bytes)this.buffer, this.key());
            this.buffer.flip();
            this.marshalled = true;
        }

        @Override
        public DirectBytes buffer() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buffer;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public K getUsing(K usingKey) {
            this.buffer().position(0L);
            return CompiledMapQueryContext.this.keyReader.read((Bytes)this.buffer(), this.buffer().limit(), usingKey);
        }
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    public class DeprecatedMapAcquireContextOnQuery
    implements MapKeyContext<K, V> {
        @Override
        @NotNull
        public InterProcessLock readLock() {
            return CompiledMapQueryContext.this.readLock();
        }

        @Override
        @NotNull
        public InterProcessLock updateLock() {
            return CompiledMapQueryContext.this.updateLock();
        }

        @Override
        @NotNull
        public InterProcessLock writeLock() {
            return CompiledMapQueryContext.this.writeLock();
        }

        @Override
        public long keySize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        @Override
        public long valueOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueOffset();
        }

        @Override
        public boolean valueEqualTo(V value) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return Value.bytesEquivalent(CompiledMapQueryContext.this.entryValue, CompiledMapQueryContext.this.wrapValueAsValue(value));
        }

        @Override
        public long valueSize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }

        @Override
        @NotNull
        public Bytes entry() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytes;
        }

        @Override
        public boolean containsKey() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entry() != null;
        }

        @Override
        public V getUsing(V usingValue) {
            return this.containsKey() ? (Object)CompiledMapQueryContext.this.value().getUsing(usingValue) : null;
        }

        @Override
        public V get() {
            assert (this.containsKey());
            return CompiledMapQueryContext.this.usingReturnValue.returnValue();
        }

        @Override
        public long keyOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keyOffset();
        }

        @Override
        public boolean put(V newValue) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.replaceValue(entry, CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            } else {
                CompiledMapQueryContext.this.insert(CompiledMapQueryContext.this.absentEntry(), CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            }
            return true;
        }

        @Override
        public void close() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.put(CompiledMapQueryContext.this.usingReturnValue.returnValue());
            CompiledMapQueryContext.this.close();
        }

        @Override
        public boolean remove() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.remove(entry);
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public K key() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.queriedKey().get();
        }
    }

    public class DeprecatedMapKeyContextOnQuery
    implements MapKeyContext<K, V> {
        @Override
        @NotNull
        public InterProcessLock writeLock() {
            return CompiledMapQueryContext.this.writeLock();
        }

        @Override
        @NotNull
        public InterProcessLock readLock() {
            return CompiledMapQueryContext.this.readLock();
        }

        @Override
        @NotNull
        public InterProcessLock updateLock() {
            return CompiledMapQueryContext.this.updateLock();
        }

        @Override
        public void close() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            CompiledMapQueryContext.this.close();
        }

        @Override
        public long keySize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        @Override
        public long valueOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueOffset();
        }

        @Override
        public boolean valueEqualTo(V value) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return Value.bytesEquivalent(CompiledMapQueryContext.this.entryValue, CompiledMapQueryContext.this.wrapValueAsValue(value));
        }

        @Override
        @NotNull
        public K key() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.queriedKey().get();
        }

        @Override
        @NotNull
        public Bytes entry() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytes;
        }

        @Override
        public boolean remove() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.remove(entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsKey() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entry() != null;
        }

        @Override
        public V getUsing(V usingValue) {
            return this.containsKey() ? (Object)CompiledMapQueryContext.this.value().getUsing(usingValue) : null;
        }

        @Override
        public V get() {
            return this.containsKey() ? (Object)CompiledMapQueryContext.this.value().get() : null;
        }

        @Override
        public boolean put(V newValue) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.updateLock().lock();
            HashEntry entry = CompiledMapQueryContext.this.entry();
            if (entry != null) {
                CompiledMapQueryContext.this.replaceValue(entry, CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            } else {
                CompiledMapQueryContext.this.insert(CompiledMapQueryContext.this.absentEntry(), CompiledMapQueryContext.this.wrapValueAsValue(newValue));
            }
            return true;
        }

        @Override
        public long keyOffset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keyOffset();
        }

        @Override
        public long valueSize() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }
    }

    public class WrappedValueInstanceValue
    extends CopyingInstanceValue<V, T> {
        private WrappedValueInstanceValue next;
        private V value;
        private boolean marshalled = false;
        private DirectBytes buf;

        public WrappedValueInstanceValue getUnusedWrappedValueGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValue();
        }

        public WrappedValueInstanceValue getUnusedWrappedValue() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceValue();
            }
            return this.next.getUnusedWrappedValue();
        }

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledMapQueryContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return this.value();
        }

        public boolean bufferInit() {
            return this.marshalled;
        }

        private void initBuffer() {
            Object mvi = CompiledMapQueryContext.this.valueMetaInterop(this.value());
            long size = mvi.size(CompiledMapQueryContext.this.valueInterop, this.value());
            this.buf = CopyingInstanceValue.getBuffer(this.buf, size);
            mvi.write(CompiledMapQueryContext.this.valueInterop, (Bytes)this.buf, this.value());
            this.buf.flip();
            this.marshalled = true;
        }

        public DirectBytes buf() {
            if (!this.bufferInit()) {
                this.initBuffer();
            }
            return this.buf;
        }

        public void closeBuffer() {
            if (!this.bufferInit()) {
                return;
            }
            this.marshalled = false;
        }

        @Override
        public DirectBytes buffer() {
            return this.buf();
        }

        @Override
        public V getUsing(V usingValue) {
            this.buf().position(0L);
            return CompiledMapQueryContext.this.valueReader.read((Bytes)this.buf(), this.buf().limit(), usingValue);
        }
    }

    public class InputSecondValueBytesValue
    extends AbstractValue<V, T> {
        private V cachedBytesInputSecondValue;
        private boolean cachedBytesInputSecondValueRead = false;

        @Override
        public ReadAccess<T> access() {
            return (ReadAccess)JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).access((Object)CompiledMapQueryContext.this.inputBytes());
        }

        @Override
        public T handle() {
            return JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).handle((Object)CompiledMapQueryContext.this.inputBytes());
        }

        @Override
        public long size() {
            return CompiledMapQueryContext.this.secondInputValueSize();
        }

        public void closeInputSecondValueBytesValueSizeDependants() {
            this.closeInputSecondValueBytesValueGetUsingDependants();
        }

        @Override
        public long offset() {
            return JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).offset((Object)CompiledMapQueryContext.this.inputBytes(), CompiledMapQueryContext.this.secondInputValueOffset());
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapQueryContext.this.inputBytes().position(CompiledMapQueryContext.this.secondInputValueOffset());
            return CompiledMapQueryContext.this.valueReader.read(CompiledMapQueryContext.this.inputBytes(), this.size(), usingValue);
        }

        public void closeInputSecondValueBytesValueGetUsingDependants() {
            this.closeCachedBytesInputSecondValue();
        }

        public boolean cachedBytesInputSecondValueInit() {
            return this.cachedBytesInputSecondValueRead;
        }

        private void initCachedBytesInputSecondValue() {
            this.cachedBytesInputSecondValue = this.getUsing(this.cachedBytesInputSecondValue);
            this.cachedBytesInputSecondValueRead = true;
        }

        public V cachedBytesInputSecondValue() {
            if (!this.cachedBytesInputSecondValueInit()) {
                this.initCachedBytesInputSecondValue();
            }
            return this.cachedBytesInputSecondValue;
        }

        public void closeCachedBytesInputSecondValue() {
            if (!this.cachedBytesInputSecondValueInit()) {
                return;
            }
            this.cachedBytesInputSecondValueRead = false;
        }

        @Override
        public V get() {
            return this.cachedBytesInputSecondValue();
        }
    }

    public class InputFirstValueBytesValue
    extends AbstractValue<V, T> {
        private V cachedBytesInputFirstValue;
        private boolean cachedBytesInputFirstValueRead = false;

        @Override
        public ReadAccess<T> access() {
            return (ReadAccess)JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).access((Object)CompiledMapQueryContext.this.inputBytes());
        }

        @Override
        public long offset() {
            return JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).offset((Object)CompiledMapQueryContext.this.inputBytes(), CompiledMapQueryContext.this.firstInputValueOffset());
        }

        @Override
        public long size() {
            return CompiledMapQueryContext.this.firstInputValueSize();
        }

        public void closeInputFirstValueBytesValueSizeDependants() {
            this.closeInputFirstValueBytesValueGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapQueryContext.this.inputBytes().position(CompiledMapQueryContext.this.firstInputValueOffset());
            return CompiledMapQueryContext.this.valueReader.read(CompiledMapQueryContext.this.inputBytes(), this.size(), usingValue);
        }

        public void closeInputFirstValueBytesValueGetUsingDependants() {
            this.closeCachedBytesInputFirstValue();
        }

        public boolean cachedBytesInputFirstValueInit() {
            return this.cachedBytesInputFirstValueRead;
        }

        private void initCachedBytesInputFirstValue() {
            this.cachedBytesInputFirstValue = this.getUsing(this.cachedBytesInputFirstValue);
            this.cachedBytesInputFirstValueRead = true;
        }

        public V cachedBytesInputFirstValue() {
            if (!this.cachedBytesInputFirstValueInit()) {
                this.initCachedBytesInputFirstValue();
            }
            return this.cachedBytesInputFirstValue;
        }

        public void closeCachedBytesInputFirstValue() {
            if (!this.cachedBytesInputFirstValueInit()) {
                return;
            }
            this.cachedBytesInputFirstValueRead = false;
        }

        @Override
        public V get() {
            return this.cachedBytesInputFirstValue();
        }

        @Override
        public T handle() {
            return JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).handle((Object)CompiledMapQueryContext.this.inputBytes());
        }
    }

    public class EntryValueBytesValue
    extends AbstractValue<V, T> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead = false;

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }

        public void closeEntryValueBytesValueSizeDependants() {
            this.closeEntryValueBytesValueInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            CompiledMapQueryContext.this.entryBytes.position(CompiledMapQueryContext.this.valueOffset());
            return CompiledMapQueryContext.this.valueReader.read(CompiledMapQueryContext.this.entryBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesValueInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytesAccessOffset(CompiledMapQueryContext.this.valueOffset());
        }

        @Override
        public ReadAccess<T> access() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytesAccess;
        }

        @Override
        public T handle() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytesAccessHandle;
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingValue);
        }

        @Override
        public V get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public void lock() {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledMapQueryContext.this.segmentHeader().readLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledMapQueryContext.this.closeHashLookupPos();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    return;
                }
                case READ_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().readUnlock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    break;
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().updateUnlock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().writeUnlock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledMapQueryContext.this.closeHashLookupPos();
            CompiledMapQueryContext.this.closeEntry();
        }

        @Override
        public boolean tryLock() {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().read;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                CompiledMapQueryContext.this.segmentHeader().readLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().updateLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().update;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().updateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }
    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @Override
        public void lock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().writeLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().writeLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    CompiledMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                        CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().write;
        }
    }

    public class EntryKeyBytesValue
    extends AbstractValue<K, T> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        public void closeEntryKeyBytesValueSizeDependants() {
            this.closeEntryKeyBytesValueInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            CompiledMapQueryContext.this.entryBytes.position(CompiledMapQueryContext.this.keyOffset());
            return CompiledMapQueryContext.this.keyReader.read(CompiledMapQueryContext.this.entryBytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesValueInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K getUsing(K usingKey) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(usingKey);
        }

        @Override
        public K get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytesAccessOffset(CompiledMapQueryContext.this.keyOffset());
        }

        @Override
        public ReadAccess<T> access() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytesAccess;
        }

        @Override
        public T handle() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.entryBytesAccessHandle;
        }
    }

    public class InputKeyBytesValue
    extends AbstractValue<K, T> {
        private K cachedBytesInputKey;
        private boolean cachedBytesInputKeyRead = false;

        @Override
        public T handle() {
            return JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).handle((Object)CompiledMapQueryContext.this.inputBytes());
        }

        @Override
        public ReadAccess<T> access() {
            return (ReadAccess)JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).access((Object)CompiledMapQueryContext.this.inputBytes());
        }

        @Override
        public long offset() {
            return JavaLangBytesAccessors.uncheckedBytesAccessor(CompiledMapQueryContext.this.inputBytes()).offset((Object)CompiledMapQueryContext.this.inputBytes(), CompiledMapQueryContext.this.inputKeyOffset());
        }

        @Override
        public long size() {
            return CompiledMapQueryContext.this.inputKeySize();
        }

        public void closeInputKeyBytesValueSizeDependants() {
            this.closeInputKeyBytesValueGetUsingDependants();
        }

        @Override
        public K getUsing(K usingKey) {
            Bytes inputBytes = CompiledMapQueryContext.this.inputBytes();
            inputBytes.position(CompiledMapQueryContext.this.inputKeyOffset());
            return CompiledMapQueryContext.this.keyReader.read(inputBytes, this.size(), usingKey);
        }

        public void closeInputKeyBytesValueGetUsingDependants() {
            this.closeCachedBytesInputKey();
        }

        public boolean cachedBytesInputKeyInit() {
            return this.cachedBytesInputKeyRead;
        }

        private void initCachedBytesInputKey() {
            this.cachedBytesInputKey = this.getUsing((K)this.cachedBytesInputKey);
            this.cachedBytesInputKeyRead = true;
        }

        public K cachedBytesInputKey() {
            if (!this.cachedBytesInputKeyInit()) {
                this.initCachedBytesInputKey();
            }
            return this.cachedBytesInputKey;
        }

        public void closeCachedBytesInputKey() {
            if (!this.cachedBytesInputKeyInit()) {
                return;
            }
            this.cachedBytesInputKeyRead = false;
        }

        @Override
        public K get() {
            return this.cachedBytesInputKey();
        }
    }
}

