/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set.replication;

import net.openhft.chronicle.hash.AcceptanceDecision;
import net.openhft.chronicle.hash.HashAbsentEntry;
import net.openhft.chronicle.hash.replication.DefaultEventualConsistencyStrategy;
import net.openhft.chronicle.hash.replication.HashReplicableEntry;
import net.openhft.chronicle.set.SetAbsentEntry;
import net.openhft.chronicle.set.SetEntry;
import net.openhft.chronicle.set.replication.SetRemoteQueryContext;

public interface SetRemoteOperations<K, R> {
    default public AcceptanceDecision remove(SetRemoteQueryContext<K, R> q) {
        SetEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification(entry, q) == AcceptanceDecision.ACCEPT) {
                q.remove(entry);
                return AcceptanceDecision.ACCEPT;
            }
            return AcceptanceDecision.DISCARD;
        }
        HashAbsentEntry absentEntry = q.absentEntry();
        if (!1.$assertionsDisabled && absentEntry == null) {
            throw new AssertionError();
        }
        if (absentEntry instanceof HashReplicableEntry) {
            return DefaultEventualConsistencyStrategy.decideOnRemoteModification((HashReplicableEntry)((Object)absentEntry), q);
        }
        return AcceptanceDecision.ACCEPT;
    }

    default public AcceptanceDecision insert(SetRemoteQueryContext<K, R> q) {
        SetEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification(entry, q) == AcceptanceDecision.ACCEPT) {
                return AcceptanceDecision.ACCEPT;
            }
            return AcceptanceDecision.DISCARD;
        }
        HashAbsentEntry absentEntry = q.absentEntry();
        if (!1.$assertionsDisabled && absentEntry == null) {
            throw new AssertionError();
        }
        if (!(absentEntry instanceof HashReplicableEntry) || DefaultEventualConsistencyStrategy.decideOnRemoteModification((HashReplicableEntry)((Object)absentEntry), q) == AcceptanceDecision.ACCEPT) {
            q.insert((SetAbsentEntry<K>)absentEntry);
            return AcceptanceDecision.ACCEPT;
        }
        return AcceptanceDecision.DISCARD;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

