/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class HashLookupSearch {
    @StageRef
    SegmentStages s;
    @StageRef
    public VanillaChronicleHashHolder<?, ?, ?> hh;
    @StageRef
    HashLookupPos hlp;
    @StageRef
    KeySearch<?> ks;
    @Stage(value="SearchKey")
    long searchKey = 0L;
    @Stage(value="SearchKey")
    public long searchStartPos;

    public CompactOffHeapLinearHashTable hl() {
        return this.hh.h().hashLookup;
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
    }

    private long addr() {
        return this.s.segmentBaseAddr;
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hlp.hashLookupPos;
            do {
                entry = this.hl().readEntry(this.addr(), pos);
                if (this.hl().empty(entry)) {
                    this.hlp.setHashLookupPos(pos);
                    return -1L;
                }
                pos = this.hl().step(pos);
                if (pos == this.searchStartPos) break block2;
            } while (this.hl().key(entry) != this.searchKey);
            this.hlp.setHashLookupPos(pos);
            return this.hl().value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void found() {
        this.hlp.setHashLookupPos(this.hl().stepBack(this.hlp.hashLookupPos));
    }

    public void remove() {
        this.hlp.setHashLookupPos(this.hl().remove(this.addr(), this.hlp.hashLookupPos));
    }

    public void putNewVolatile(long value) {
        assert (!this.ks.searchStatePresent());
        this.hl().checkValueForPut(value);
        long currentEntry = this.hl().readEntry(this.addr(), this.hlp.hashLookupPos);
        this.hl().writeEntryVolatile(this.addr(), this.hlp.hashLookupPos, currentEntry, this.searchKey, value);
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hlp.hashLookupPos);
        return this.hl().key(entry) == this.searchKey && this.hl().value(entry) == value;
    }
}

