/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public class WriteLock
implements InterProcessLock {
    @StageRef
    SegmentStages s;

    @Override
    public boolean isHeldByCurrentThread() {
        return this.s.localLockState.write;
    }

    @Override
    public void lock() {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        this.s.segmentHeader.upgradeUpdateToWriteLock(this.s.segmentHeaderAddress);
                    } else {
                        if (!this.s.readZero()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        this.s.segmentHeader.writeLock(this.s.segmentHeaderAddress);
                    }
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    this.s.segmentHeader.upgradeUpdateToWriteLock(this.s.segmentHeaderAddress);
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
            }
        }
    }

    @NotNull
    private IllegalMonitorStateException forbiddenUpgrade() {
        return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
    }

    @NotNull
    private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
        return new IllegalStateException("Cannot acquire write lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        this.s.segmentHeader.upgradeUpdateToWriteLockInterruptibly(this.s.segmentHeaderAddress);
                    } else {
                        if (!this.s.readZero()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        this.s.segmentHeader.writeLockInterruptibly(this.s.segmentHeaderAddress);
                    }
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    this.s.segmentHeader.upgradeUpdateToWriteLockInterruptibly(this.s.segmentHeaderAddress);
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
            }
        }
    }

    @Override
    public boolean tryLock() {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress)) {
                            this.s.incrementWrite();
                            this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    if (!this.s.readZero()) {
                        throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryWriteLock(this.s.segmentHeaderAddress)) {
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress)) {
                        this.s.decrementUpdate();
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        switch (this.s.localLockState) {
            case UNLOCKED: {
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress, time, unit)) {
                            this.s.incrementWrite();
                            this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    if (!this.s.readZero()) {
                        throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryWriteLock(this.s.segmentHeaderAddress, time, unit)) {
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress, time, unit)) {
                        this.s.decrementUpdate();
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void unlock() {
        switch (this.s.localLockState) {
            case UNLOCKED: 
            case READ_LOCKED: 
            case UPDATE_LOCKED: {
                return;
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = this.s.decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    this.s.segmentHeader.downgradeWriteToUpdateLock(this.s.segmentHeaderAddress);
                    break;
                }
                assert (newTotalWriteLockCount > 0) : "write underflow";
                break;
            }
        }
        this.s.incrementUpdate();
        this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
    }
}

