/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.iter;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.iter.IterationSegmentStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class HashSegmentIteration<K, E extends HashEntry<K>>
implements HashEntry<K>,
HashSegmentContext<K, E> {
    @StageRef
    public IterationSegmentStages s;
    @StageRef
    HashEntryStages<K> e;
    @StageRef
    VanillaChronicleHashHolder<?, ?, ?> hh;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    protected HashLookupPos hlp;
    public boolean entryRemovedOnThisIteration = false;
    public long hashLookupEntry = 0L;

    public boolean entryIsPresent() {
        return true;
    }

    abstract boolean entryRemovedOnThisIterationInit();

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public abstract boolean hashLookupEntryInit();

    public void initHashLookupEntry(long entry) {
        this.hashLookupEntry = entry;
    }

    abstract void closeHashLookupEntry();

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super E> action) {
        this.s.innerUpdateLock.lock();
        try {
            long size = this.s.size();
            if (size == 0L) {
                boolean bl = true;
                return bl;
            }
            this.s.goToLastTier();
            while (true) {
                long currentTierIndex;
                long currentTierBaseAddr;
                int currentTier;
                if ((size = this.forEachTierWhile(action, size, currentTier = this.s.segmentTier, currentTierBaseAddr = this.s.segmentBaseAddr, currentTierIndex = this.s.tierIndex)) < 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (size == 0L) {
                    boolean bl = true;
                    return bl;
                }
                if (currentTier == 0) {
                    throw new IllegalStateException("We iterated all tiers without interruption, but according to size counter there should be " + size + " more " + "entries. Size diverged?");
                }
                this.s.prevTier();
            }
        }
        finally {
            this.closeHashLookupEntry();
            this.s.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long forEachTierWhile(Predicate<? super E> action, long size, int currentTier, long currentTierBaseAddr, long tierIndex) {
        long currentHashLookupPos;
        boolean interrupted = false;
        long startPos = 0L;
        CompactOffHeapLinearHashTable hashLookup = this.hh.h().hashLookup;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startPos))) {
            startPos = hashLookup.step(startPos);
        }
        this.hlp.initHashLookupPos(startPos);
        do {
            currentHashLookupPos = hashLookup.step(this.hlp.hashLookupPos);
            this.hlp.setHashLookupPos(currentHashLookupPos);
            long entry = hashLookup.readEntry(currentTierBaseAddr, currentHashLookupPos);
            this.initHashLookupEntry(entry);
            if (hashLookup.empty(entry)) continue;
            this.e.readExistingEntry(hashLookup.value(entry));
            if (!this.entryIsPresent()) continue;
            this.initEntryRemovedOnThisIteration(false);
            try {
                if (!action.test(this)) {
                    interrupted = true;
                    break;
                }
                if (--size != 0L) continue;
                break;
            }
            finally {
                if (this.s.segmentTier != currentTier) {
                    this.s.initSegmentTier_WithBaseAddr(currentTier, currentTierBaseAddr, tierIndex);
                    currentHashLookupPos = hashLookup.stepBack(currentHashLookupPos);
                    this.hlp.initHashLookupPos(currentHashLookupPos);
                }
            }
        } while (currentHashLookupPos != startPos);
        return interrupted ? size ^ 0xFFFFFFFFFFFFFFFFL : size;
    }

    @Override
    public void forEachSegmentEntry(Consumer<? super E> action) {
        this.forEachSegmentEntryWhile(e -> {
            action.accept((Object)e);
            return true;
        });
    }

    public void checkEntryNotRemovedOnThisIteration() {
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException("Entry was already removed on this iteration");
        }
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerWriteLock.lock();
        try {
            this.iterationRemove();
        }
        finally {
            this.s.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    public void iterationRemove() {
        if (this.hh.h().hashLookup.remove(this.s.segmentBaseAddr, this.hlp.hashLookupPos) != this.hlp.hashLookupPos) {
            this.hlp.setHashLookupPos(this.hh.h().hashLookup.stepBack(this.hlp.hashLookupPos));
        }
        this.e.innerRemoveEntryExceptHashLookupUpdate();
    }
}

