/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashInstanceBuilder;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.FindByName;
import net.openhft.chronicle.map.MapInstanceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicationHubFindByName<K>
implements FindByName {
    public static final Logger LOG = LoggerFactory.getLogger((String)ReplicationHubFindByName.class.getName());
    public static final int MAP_BY_NAME_CHANNEL = 1;
    private final AtomicInteger nextFreeChannel = new AtomicInteger(2);
    private final ChronicleMap<CharSequence, MapInstanceBuilder> map;
    private final ReplicationHub replicationHub;

    public ReplicationHubFindByName(ReplicationHub replicationHub) throws IOException {
        LOG.info("connecting to replicationHub=" + replicationHub);
        this.replicationHub = replicationHub;
        ReplicationChannel channel = replicationHub.createChannel(1);
        this.map = ((ChronicleMapBuilder)((ChronicleMapBuilder)ChronicleMapBuilder.of(CharSequence.class, MapInstanceBuilder.class).averageKeySize(10.0)).averageValueSize(4000.0).entries(128L)).instance().replicatedViaChannel(channel).create();
        if (LOG.isDebugEnabled()) {
            LOG.debug("map=" + this.map);
        }
    }

    public <T extends ChronicleHash> T create(MapInstanceBuilder<CharSequence, CharSequence> config) throws IOException, TimeoutException, InterruptedException {
        int withChannelId = this.nextFreeChannel.incrementAndGet();
        try (ExternalMapQueryContext c = (ExternalMapQueryContext)this.map.queryContext(config.name);){
            boolean added;
            c.updateLock().lock();
            ChronicleHashInstanceBuilder value = config.replicatedViaChannel(this.replicationHub.createChannel(withChannelId));
            HashEntry entry = c.entry();
            if (entry != null) {
                c.replaceValue(entry, c.wrapValueAsData(value));
                added = false;
            } else {
                c.insert(c.absentEntry(), c.wrapValueAsData(value));
                added = true;
            }
            if (added) {
                LOG.info("create new map for name=" + ((MapInstanceBuilder)value).name + ",channelId=" + ((MapInstanceBuilder)value).channel.channelId());
                try {
                    this.toReplicatedViaChannel(((MapInstanceBuilder)value).mapBuilder, ((MapInstanceBuilder)value).channel.channelId()).create();
                }
                catch (IllegalStateException e) {
                    LOG.debug("while creating channel for name=" + ((MapInstanceBuilder)value).name + ",channelId=" + ((MapInstanceBuilder)value).channel.channelId(), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
        return (T)this.get((String)config.name).mapBuilder.create();
    }

    @Override
    public <T extends ChronicleHash> T from(String name) throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        return (T)this.get(name).create();
    }

    MapInstanceBuilder get(String name) throws IllegalArgumentException, TimeoutException, InterruptedException {
        MapInstanceBuilder config = this.waitTillEntryReceived(5000, name);
        if (config == null) {
            throw new IllegalArgumentException("A map name=" + name + " can not be found.");
        }
        return config;
    }

    private MapInstanceBuilder waitTillEntryReceived(int timeOutMs, String name) throws TimeoutException, InterruptedException {
        for (int t = 0; t < timeOutMs; ++t) {
            MapInstanceBuilder config = this.map.get(name);
            if (config != null) {
                return config;
            }
            Thread.sleep(1L);
        }
        throw new TimeoutException("timed out wait for map name=" + name);
    }

    public <T extends ChronicleHash> T createPersistedTo(String name, File file) throws IllegalArgumentException, IOException, TimeoutException, InterruptedException {
        return (T)((MapInstanceBuilder)this.get(name).persistedTo(file)).create();
    }

    private ChronicleHashInstanceBuilder toReplicatedViaChannel(ChronicleMapBuilder builder) {
        int channelId = this.nextFreeChannel.incrementAndGet();
        if (channelId > this.replicationHub.maxNumberOfChannels()) {
            throw new IllegalStateException("There are no more free channels, you can increase the number of changes in the replicationHub by calling replicationHub.maxNumberOfChannels(..);");
        }
        return builder.instance().replicatedViaChannel(this.replicationHub.createChannel((short)channelId));
    }

    private ChronicleHashInstanceBuilder toReplicatedViaChannel(ChronicleHashBuilder<K, ?, ?> builder, int withChannelId) {
        return builder.instance().replicatedViaChannel(this.replicationHub.createChannel((short)withChannelId));
    }
}

