package net.openhft.chronicle.map.impl;

import net.openhft.lang.io.AbstractBytes;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.map.Alignment;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import java.util.ArrayList;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.algo.bitset.BitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesCommon;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import java.util.ConcurrentModificationException;
import net.openhft.chronicle.map.ConstantValueProvider;
import java.util.function.Consumer;
import net.openhft.chronicle.hash.impl.CopyingInstanceData;
import net.openhft.chronicle.hash.impl.stage.entry.Crc32;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.DirectBytes;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import java.util.function.Function;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.impl.JavaLangBytesReusableBytesStore;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.value.instance.KeyInitableData;
import java.util.List;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.chronicle.map.replication.MapRemoteQueryContext;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.chronicle.map.MapSegmentContext;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesWriter;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.lang.io.MultiStoreBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.Objects;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.chronicle.hash.impl.PublicMultiStoreBytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.RandomDataOutput;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.map.ReturnValue;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import net.openhft.chronicle.hash.impl.stage.hash.ThreadLocalState;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.replication.TimeProvider;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.map.impl.ret.UsableReturnValue;
import net.openhft.chronicle.map.impl.data.instance.ValueInitializableData;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.stage.data.ZeroRandomDataInput;

public class CompiledReplicatedMapQueryContext<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R> extends ChainingInterface implements AutoCloseable , ChecksumEntry , HashEntry<K> , SegmentLock , Alloc , KeyHashCode , LocksInterface , RemoteOperationContext<K> , ReplicableEntry , ExternalMapQueryContext<K, V, R> , MapAbsentEntry<K, V> , MapContext<K, V, R> , MapEntry<K, V> , MapAbsentEntryHolder<K, V> , QueryContextInterface<K, V, R> , ReplicatedChronicleMapHolder<K, KI, MKI, V, VI, MVI, R> , MapRemoteQueryContext<K, V, R> , MapReplicableEntry<K, V> {
    public boolean readZeroGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return readZero();
    }

    public boolean updateZeroGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return decrementWrite();
    }

    public String debugContextsAndLocksGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return debugContextsAndLocks();
    }

    public void close() {
        this.closeInputBytes();
        this.closeReplicationInput();
        this.closeReplicationUpdate();
        this.usingReturnValue.closeUsingReturnValue();
        this.bytesReturnValue.closeOutput();
        this.defaultReturnValue.closeDefaultReturnedValue();
        this.closeAllocatedChunks();
        this.closeKeyOffset();
        this.inputKeyInstanceValue.closeKey();
        this.closePos();
        this.wrappedValueInstanceValue.closeNext();
        this.closeInputKey();
        this.closeReplicatedInputBytes();
        this.closeUsed();
        this.closeSegmentIndex();
        this.wrappedValueInstanceValue.closeValue();
        this.inputValueInstanceValue.closeValue();
        this.closeKeySize();
        this.closeQuerySegmentStagesDeregisterIterationContextLockedInThisThreadDependants();
        this.closeQueryHashLookupSearchHlDependants();
        this.closeQuerySegmentStagesRegisterIterationContextLockedInThisThreadDependants();
        this.closeKeyBytesInteropKeyMetaInteropDependants();
        this.closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeValueBytesInteropValueMetaInteropDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants();
    }

    public void incrementModCountGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!(this.hashLookupPosInit()))
            this.initHashLookupPos();
        
        setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!(this.locksInit()))
            this.initLocks();
        
        setLocalLockState(newState);
    }

    public void setSearchStateGuarded(CompiledReplicatedMapQueryContext.SearchState newSearchState) {
        if (!(this.keySearchInit()))
            this.initKeySearch();
        
        setSearchState(newSearchState);
    }

    private long _MapEntryStages_countValueSizeOffset() {
        return keyEnd();
    }

    private long _MapEntryStages_sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return ((this.m().keySizeMarshaller.sizeEncodingSize(keySize)) + keySize) + (this.m().valueSizeMarshaller.sizeEncodingSize(valueSize));
    }

    void keyFound() {
        searchState = CompiledReplicatedMapQueryContext.SearchState.PRESENT;
    }

    public CompiledReplicatedMapQueryContext(ChainingInterface c ,ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        contextChain = c.getContextChain();
        indexInContextChain = contextChain.size();
        contextChain.add(this);
        this.rootContextInThisThread = c;
        this.m = m;
        this.absentDelegating = new ReplicatedMapAbsentDelegating();
        this.dummyValue = new DummyValueZeroData();
        this.inputSecondValueBytesValue = new InputSecondValueBytesData();
        this.replicatedInputKeyBytesValue = new ReplicatedInputKeyBytesData();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.inputValueInstanceValue = new InputValueInstanceData();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputStore = new JavaLangBytesReusableBytesStore();
        this.inputFirstValueBytesValue = new InputFirstValueBytesData();
        this.replicatedInputStore = new JavaLangBytesReusableBytesStore();
        this.owner = Thread.currentThread();
        this.entryKey = new EntryKeyBytesData();
        this.bytesReturnValue = new BytesReturnValue();
        this.usingReturnValue = new UsingReturnValue();
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.inputKeyInstanceValue = new InputKeyInstanceData();
        this.innerWriteLock = new WriteLock();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.replicatedInputValueBytesValue = new ReplicatedInputValueBytesData();
        this.inputKeyBytesValue = new InputKeyBytesData();
        this.cleanupAction = new CompiledReplicatedMapQueryContext.CleanupAction();
        this.segmentBytes = new PublicMultiStoreBytes();
        this.segmentBS = new PointerBytesStore();
        this.freeList = new ReusableBitSet(new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)) , Access.nativeAccess() , null , 0);
        this.innerUpdateLock = new UpdateLock();
    }

    public CompiledReplicatedMapQueryContext(ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m) {
        contextChain = new ArrayList<>();
        contextChain.add(this);
        indexInContextChain = 0;
        rootContextInThisThread = this;
        this.m = m;
        this.absentDelegating = new ReplicatedMapAbsentDelegating();
        this.dummyValue = new DummyValueZeroData();
        this.inputSecondValueBytesValue = new InputSecondValueBytesData();
        this.replicatedInputKeyBytesValue = new ReplicatedInputKeyBytesData();
        this.wrappedValueInstanceValue = new WrappedValueInstanceData();
        this.inputValueInstanceValue = new InputValueInstanceData();
        this.defaultReturnValue = new DefaultReturnValue();
        this.inputStore = new JavaLangBytesReusableBytesStore();
        this.inputFirstValueBytesValue = new InputFirstValueBytesData();
        this.replicatedInputStore = new JavaLangBytesReusableBytesStore();
        this.owner = Thread.currentThread();
        this.entryKey = new EntryKeyBytesData();
        this.bytesReturnValue = new BytesReturnValue();
        this.usingReturnValue = new UsingReturnValue();
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.inputKeyInstanceValue = new InputKeyInstanceData();
        this.innerWriteLock = new WriteLock();
        this.copies = ThreadLocalCopies.get();
        this.valueInterop = this.m().valueInteropProvider.get(this.copies, this.m().originalValueInterop);
        this.valueReader = this.m().valueReaderProvider.get(this.copies, this.m().originalValueReader);
        this.keyInterop = this.h().keyInteropProvider.get(this.copies, this.h().originalKeyInterop);
        this.keyReader = this.h().keyReaderProvider.get(this.copies, this.h().originalKeyReader);
        this.replicatedInputValueBytesValue = new ReplicatedInputValueBytesData();
        this.inputKeyBytesValue = new InputKeyBytesData();
        this.cleanupAction = new CompiledReplicatedMapQueryContext.CleanupAction();
        this.segmentBytes = new PublicMultiStoreBytes();
        this.segmentBS = new PointerBytesStore();
        this.freeList = new ReusableBitSet(new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)) , Access.nativeAccess() , null , 0);
        this.innerUpdateLock = new UpdateLock();
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = this.contextAtIndexInChain(index);
        if (((c.segmentHeaderInit()) && ((c.segmentHeaderAddress()) == (segmentHeaderAddress()))) && (c.locksInit())) {
            LocksInterface root = c.rootContextLockedOnThisSegment();
            this.rootContextLockedOnThisSegment = root;
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            linkToSegmentContextsChain();
            return true;
        } else {
            return false;
        }
    }

    public class AcquireHandle implements Closeable {
        @Override
        public void close() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            CompiledReplicatedMapQueryContext.this.replaceValue(CompiledReplicatedMapQueryContext.this.entry(), CompiledReplicatedMapQueryContext.this.wrapValueAsData(CompiledReplicatedMapQueryContext.this.usingReturnValue.returnValue()));
            CompiledReplicatedMapQueryContext.this.close();
        }
    }

    public class BytesReturnValue implements AutoCloseable , ReturnValue<V> {
        public BytesReturnValue() {
            this.outputStore = new JavaLangBytesReusableBytesStore();
        }

        private final JavaLangBytesReusableBytesStore outputStore;

        public JavaLangBytesReusableBytesStore outputStore() {
            return this.outputStore;
        }

        long startOutputPos;

        TcpReplicator.TcpSocketChannelEntryWriter output = null;

        public boolean outputInit() {
            return (this.output) != null;
        }

        public void initOutput(TcpReplicator.TcpSocketChannelEntryWriter output) {
            this.output = output;
            startOutputPos = output.in().position();
        }

        public long startOutputPos() {
            assert this.outputInit() : "Output should be init";
            return this.startOutputPos;
        }

        public TcpReplicator.TcpSocketChannelEntryWriter output() {
            assert this.outputInit() : "Output should be init";
            return this.output;
        }

        public void closeOutput() {
            if (!(this.outputInit()))
                return ;
            
            this.output = null;
        }

        @Override
        public void returnValue(@NotNull
        Data<V> value) {
            long valueSize = value.size();
            long totalSize = (1L + (CompiledReplicatedMapQueryContext.this.m().valueSizeMarshaller.sizeEncodingSize(valueSize))) + valueSize;
            output().ensureBufferSize(totalSize);
            Bytes out = output().in();
            out.writeBoolean(false);
            CompiledReplicatedMapQueryContext.this.m().valueSizeMarshaller.writeSize(out, valueSize);
            long outPosition = out.position();
            out.skip(valueSize);
            outputStore.setBytes(out);
            value.writeTo(outputStore, outPosition);
        }

        @Override
        public void close() {
            if ((output().in().position()) == (startOutputPos())) {
                output().ensureBufferSize(1L);
                output().in().writeBoolean(true);
            } 
        }
    }

    public class DummyValueZeroData extends AbstractData<V> {
        @Override
        public long offset() {
            return 0;
        }

        @Override
        public V get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getUsing(V usingInstance) {
            throw new UnsupportedOperationException();
        }

        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            return ZeroRandomDataInput.INSTANCE;
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.m().valueSizeMarshaller.minEncodableSize();
        }
    }

    public class EntryKeyBytesData extends AbstractData<K> {
        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.segmentBS();
        }

        @Override
        public long size() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            CompiledReplicatedMapQueryContext.this.segmentBytes().position(CompiledReplicatedMapQueryContext.this.keyOffset());
            return CompiledReplicatedMapQueryContext.this.keyReader.read(CompiledReplicatedMapQueryContext.this.segmentBytes(), size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        private K cachedEntryKey;

        private boolean cachedEntryKeyRead = false;

        public boolean cachedEntryKeyInit() {
            return (this.cachedEntryKeyRead) != false;
        }

        private void initCachedEntryKey() {
            cachedEntryKey = innerGetUsing(cachedEntryKey);
            cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!(this.cachedEntryKeyInit()))
                this.initCachedEntryKey();
            
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!(this.cachedEntryKeyInit()))
                return ;
            
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return cachedEntryKey();
        }

        @Override
        public K getUsing(K usingKey) {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return innerGetUsing(usingKey);
        }

        @Override
        public long offset() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.keyOffset();
        }
    }

    public class EntryValueBytesData extends AbstractData<V> {
        @Override
        public long offset() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.segmentBytes().position(CompiledReplicatedMapQueryContext.this.valueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read(CompiledReplicatedMapQueryContext.this.segmentBytes(), size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return innerGetUsing(usingValue);
        }

        private V cachedEntryValue;

        private boolean cachedEntryValueRead = false;

        public boolean cachedEntryValueInit() {
            return (this.cachedEntryValueRead) != false;
        }

        private void initCachedEntryValue() {
            cachedEntryValue = innerGetUsing(cachedEntryValue);
            cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!(this.cachedEntryValueInit()))
                this.initCachedEntryValue();
            
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!(this.cachedEntryValueInit()))
                return ;
            
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return cachedEntryValue();
        }

        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapQueryContext.this.segmentBS();
        }
    }

    public class HashKeyCrc32PayloadChecksumStrategy implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return ChecksumStrategy.CHECKSUM_STORED_BYTES;
        }

        private int computeChecksum() {
            long keyHashCode = CompiledReplicatedMapQueryContext.this.keyHashCode();
            long keyEnd = CompiledReplicatedMapQueryContext.this.keyEnd();
            long len = (CompiledReplicatedMapQueryContext.this.entryEnd()) - keyEnd;
            long checksum;
            if (len > 0) {
                long addr = (CompiledReplicatedMapQueryContext.this.segmentBaseAddr()) + keyEnd;
                int payloadCrc = Crc32.compute(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapQueryContext.this.keySize(), keyHashCode, payloadCrc);
            } else {
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapQueryContext.this.keySize(), keyHashCode, keyHashCode);
            }
            return ((int)((checksum >>> 32) ^ checksum));
        }

        @Override
        public boolean innerCheckSum() {
            int oldChecksum = CompiledReplicatedMapQueryContext.this.segmentBS().readInt(CompiledReplicatedMapQueryContext.this.entryEnd());
            int crc = computeChecksum();
            return oldChecksum == crc;
        }

        @Override
        public void computeAndStoreChecksum() {
            int crc = computeChecksum();
            CompiledReplicatedMapQueryContext.this.segmentBS().writeInt(CompiledReplicatedMapQueryContext.this.entryEnd(), crc);
        }

        @Override
        public boolean checkSum() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            return innerCheckSum();
        }

        @Override
        public void updateChecksum() {
            CompiledReplicatedMapQueryContext.this.checkOnEachPublicOperation();
            computeAndStoreChecksum();
        }
    }

    public class InputFirstValueBytesData extends AbstractData<V> {
        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.firstInputValueOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.firstInputValueSize();
        }

        public void closeInputFirstValueBytesDataSizeDependants() {
            this.closeInputFirstValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.inputBytes().position(CompiledReplicatedMapQueryContext.this.firstInputValueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read(CompiledReplicatedMapQueryContext.this.inputBytes(), size(), usingValue);
        }

        public void closeInputFirstValueBytesDataGetUsingDependants() {
            this.closeCachedBytesInputFirstValue();
        }

        private V cachedBytesInputFirstValue;

        private boolean cachedBytesInputFirstValueRead = false;

        public boolean cachedBytesInputFirstValueInit() {
            return (this.cachedBytesInputFirstValueRead) != false;
        }

        private void initCachedBytesInputFirstValue() {
            cachedBytesInputFirstValue = getUsing(cachedBytesInputFirstValue);
            cachedBytesInputFirstValueRead = true;
        }

        public V cachedBytesInputFirstValue() {
            if (!(this.cachedBytesInputFirstValueInit()))
                this.initCachedBytesInputFirstValue();
            
            return this.cachedBytesInputFirstValue;
        }

        public void closeCachedBytesInputFirstValue() {
            if (!(this.cachedBytesInputFirstValueInit()))
                return ;
            
            this.cachedBytesInputFirstValueRead = false;
        }

        @Override
        public V get() {
            return cachedBytesInputFirstValue();
        }
    }

    public class InputKeyBytesData extends AbstractData<K> {
        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.inputKeyOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.inputKeySize();
        }

        public void closeInputKeyBytesDataSizeDependants() {
            this.closeInputKeyBytesDataGetUsingDependants();
        }

        @Override
        public K getUsing(K usingKey) {
            Bytes inputBytes = CompiledReplicatedMapQueryContext.this.inputBytes();
            inputBytes.position(CompiledReplicatedMapQueryContext.this.inputKeyOffset());
            return CompiledReplicatedMapQueryContext.this.keyReader.read(inputBytes, size(), usingKey);
        }

        public void closeInputKeyBytesDataGetUsingDependants() {
            this.closeCachedBytesInputKey();
        }

        private K cachedBytesInputKey;

        private boolean cachedBytesInputKeyRead = false;

        public boolean cachedBytesInputKeyInit() {
            return (this.cachedBytesInputKeyRead) != false;
        }

        private void initCachedBytesInputKey() {
            cachedBytesInputKey = getUsing(cachedBytesInputKey);
            cachedBytesInputKeyRead = true;
        }

        public K cachedBytesInputKey() {
            if (!(this.cachedBytesInputKeyInit()))
                this.initCachedBytesInputKey();
            
            return this.cachedBytesInputKey;
        }

        public void closeCachedBytesInputKey() {
            if (!(this.cachedBytesInputKeyInit()))
                return ;
            
            this.cachedBytesInputKeyRead = false;
        }

        @Override
        public K get() {
            return cachedBytesInputKey();
        }
    }

    public class InputSecondValueBytesData extends AbstractData<V> {
        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.inputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.secondInputValueOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.secondInputValueSize();
        }

        public void closeInputSecondValueBytesDataSizeDependants() {
            this.closeInputSecondValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            CompiledReplicatedMapQueryContext.this.inputBytes().position(CompiledReplicatedMapQueryContext.this.secondInputValueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read(CompiledReplicatedMapQueryContext.this.inputBytes(), size(), usingValue);
        }

        public void closeInputSecondValueBytesDataGetUsingDependants() {
            this.closeCachedBytesInputSecondValue();
        }

        private V cachedBytesInputSecondValue;

        private boolean cachedBytesInputSecondValueRead = false;

        public boolean cachedBytesInputSecondValueInit() {
            return (this.cachedBytesInputSecondValueRead) != false;
        }

        private void initCachedBytesInputSecondValue() {
            cachedBytesInputSecondValue = getUsing(cachedBytesInputSecondValue);
            cachedBytesInputSecondValueRead = true;
        }

        public V cachedBytesInputSecondValue() {
            if (!(this.cachedBytesInputSecondValueInit()))
                this.initCachedBytesInputSecondValue();
            
            return this.cachedBytesInputSecondValue;
        }

        public void closeCachedBytesInputSecondValue() {
            if (!(this.cachedBytesInputSecondValueInit()))
                return ;
            
            this.cachedBytesInputSecondValueRead = false;
        }

        @Override
        public V get() {
            return cachedBytesInputSecondValue();
        }
    }

    public class ReadLock implements InterProcessLock {
        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapQueryContext.this.localLockState().read;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if ((CompiledReplicatedMapQueryContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if (((CompiledReplicatedMapQueryContext.this.readZeroGuarded()) && (CompiledReplicatedMapQueryContext.this.updateZeroGuarded())) && (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()))
                    CompiledReplicatedMapQueryContext.this.segmentHeader().readLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                
                CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            } 
        }

        @Override
        public void lock() {
            if ((CompiledReplicatedMapQueryContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if (((CompiledReplicatedMapQueryContext.this.readZeroGuarded()) && (CompiledReplicatedMapQueryContext.this.updateZeroGuarded())) && (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()))
                    CompiledReplicatedMapQueryContext.this.segmentHeader().readLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                
                CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            } 
        }

        public void closeReadLockLockDependants() {
            CompiledReplicatedMapQueryContext.this.closeHashLookupPos();
        }

        @Override
        public void unlock() {
            CompiledReplicatedMapQueryContext.this.readUnlockAndDecrementCountGuarded();
            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledReplicatedMapQueryContext.this.closeHashLookupPos();
            CompiledReplicatedMapQueryContext.this.closePos();
        }

        @Override
        public boolean tryLock() {
            if ((CompiledReplicatedMapQueryContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if ((((!(CompiledReplicatedMapQueryContext.this.readZeroGuarded())) || (!(CompiledReplicatedMapQueryContext.this.updateZeroGuarded()))) || (!(CompiledReplicatedMapQueryContext.this.writeZeroGuarded()))) || (CompiledReplicatedMapQueryContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress()))) {
                    CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }

        @Override
        public boolean tryLock(long time, @NotNull
        TimeUnit unit) throws InterruptedException {
            if ((CompiledReplicatedMapQueryContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if ((((!(CompiledReplicatedMapQueryContext.this.readZeroGuarded())) || (!(CompiledReplicatedMapQueryContext.this.updateZeroGuarded()))) || (!(CompiledReplicatedMapQueryContext.this.writeZeroGuarded()))) || (CompiledReplicatedMapQueryContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit))) {
                    CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }
    }

    public class ReplicatedInputKeyBytesData extends AbstractData<K> {
        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.replicatedInputStore;
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.riKeyOffset();
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.riKeySize();
        }

        public void closeReplicatedInputKeyBytesDataSizeDependants() {
            this.closeReplicatedInputKeyBytesDataGetUsingDependants();
        }

        @Override
        public K getUsing(K usingKey) {
            Bytes inputBytes = CompiledReplicatedMapQueryContext.this.replicatedInputBytes();
            inputBytes.position(CompiledReplicatedMapQueryContext.this.riKeyOffset());
            return CompiledReplicatedMapQueryContext.this.keyReader.read(inputBytes, size(), usingKey);
        }

        public void closeReplicatedInputKeyBytesDataGetUsingDependants() {
            this.closeCachedBytesReplicatedInputKey();
        }

        private K cachedBytesReplicatedInputKey;

        private boolean cachedBytesReplicatedInputKeyRead = false;

        public boolean cachedBytesReplicatedInputKeyInit() {
            return (this.cachedBytesReplicatedInputKeyRead) != false;
        }

        private void initCachedBytesReplicatedInputKey() {
            cachedBytesReplicatedInputKey = getUsing(cachedBytesReplicatedInputKey);
            cachedBytesReplicatedInputKeyRead = true;
        }

        public K cachedBytesReplicatedInputKey() {
            if (!(this.cachedBytesReplicatedInputKeyInit()))
                this.initCachedBytesReplicatedInputKey();
            
            return this.cachedBytesReplicatedInputKey;
        }

        public void closeCachedBytesReplicatedInputKey() {
            if (!(this.cachedBytesReplicatedInputKeyInit()))
                return ;
            
            this.cachedBytesReplicatedInputKeyRead = false;
        }

        @Override
        public K get() {
            return cachedBytesReplicatedInputKey();
        }
    }

    public class ReplicatedInputValueBytesData extends AbstractData<V> {
        @Override
        public net.openhft.chronicle.bytes.RandomDataInput bytes() {
            return CompiledReplicatedMapQueryContext.this.replicatedInputStore;
        }

        @Override
        public long size() {
            return CompiledReplicatedMapQueryContext.this.riValueSize();
        }

        public void closeReplicatedInputValueBytesDataSizeDependants() {
            this.closeReplicatedInputValueBytesDataGetUsingDependants();
        }

        @Override
        public V getUsing(V usingValue) {
            Bytes inputBytes = CompiledReplicatedMapQueryContext.this.replicatedInputBytes();
            inputBytes.position(CompiledReplicatedMapQueryContext.this.riValueOffset());
            return CompiledReplicatedMapQueryContext.this.valueReader.read(inputBytes, size(), usingValue);
        }

        public void closeReplicatedInputValueBytesDataGetUsingDependants() {
            this.closeCachedBytesReplicatedInputValue();
        }

        private V cachedBytesReplicatedInputValue;

        private boolean cachedBytesReplicatedInputValueRead = false;

        public boolean cachedBytesReplicatedInputValueInit() {
            return (this.cachedBytesReplicatedInputValueRead) != false;
        }

        private void initCachedBytesReplicatedInputValue() {
            cachedBytesReplicatedInputValue = getUsing(cachedBytesReplicatedInputValue);
            cachedBytesReplicatedInputValueRead = true;
        }

        public V cachedBytesReplicatedInputValue() {
            if (!(this.cachedBytesReplicatedInputValueInit()))
                this.initCachedBytesReplicatedInputValue();
            
            return this.cachedBytesReplicatedInputValue;
        }

        public void closeCachedBytesReplicatedInputValue() {
            if (!(this.cachedBytesReplicatedInputValueInit()))
                return ;
            
            this.cachedBytesReplicatedInputValueRead = false;
        }

        @Override
        public V get() {
            return cachedBytesReplicatedInputValue();
        }

        @Override
        public long offset() {
            return CompiledReplicatedMapQueryContext.this.riValueOffset();
        }
    }

    public class ReplicatedMapAbsentDelegating implements MapAbsentEntry<K, V> {
        @NotNull
        @Override
        public Data<V> defaultValue() {
            return CompiledReplicatedMapQueryContext.this.defaultValue();
        }

        @NotNull
        @Override
        public Data<K> absentKey() {
            return CompiledReplicatedMapQueryContext.this.absentKey();
        }

        @NotNull
        @Override
        public MapContext<K, V, ?> context() {
            return CompiledReplicatedMapQueryContext.this.context();
        }

        @Override
        public void doInsert(Data<V> value) {
            CompiledReplicatedMapQueryContext.this.doInsert(value);
        }
    }

    public class UpdateLock implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException(("Cannot acquire update lock, because outer context " + ("holds read lock. In this case you should acquire update lock in the outer " + "context up front")));
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapQueryContext.this.localLockState().update;
        }

        @Override
        public boolean tryLock(long time, @NotNull
        TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) && (CompiledReplicatedMapQueryContext.this.writeZeroGuarded())) {
                        if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                        CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) && (CompiledReplicatedMapQueryContext.this.writeZeroGuarded())) {
                        if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                        CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) && (CompiledReplicatedMapQueryContext.this.writeZeroGuarded())) {
                        if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        CompiledReplicatedMapQueryContext.this.segmentHeader().updateLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                    } 
                    CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
            }
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                case READ_LOCKED :
                    return ;
                case UPDATE_LOCKED :
                    int newTotalUpdateLockCount = CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    if (newTotalUpdateLockCount == 0) {
                        if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded())
                            CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        
                    } else {
                        assert newTotalUpdateLockCount > 0 : "update underflow";
                    }
                    break;
                case WRITE_LOCKED :
                    int newTotalWriteLockCount = CompiledReplicatedMapQueryContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        if (!(CompiledReplicatedMapQueryContext.this.updateZeroGuarded())) {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeWriteToReadLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        }
                    } else {
                        assert newTotalWriteLockCount > 0 : "write underflow";
                    }
            }
            CompiledReplicatedMapQueryContext.this.incrementReadGuarded();
            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledReplicatedMapQueryContext.this.updateZeroGuarded()) && (CompiledReplicatedMapQueryContext.this.writeZeroGuarded())) {
                        if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        try {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().updateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        } catch (RuntimeException e) {
                            CompiledReplicatedMapQueryContext.this.LOG.error(CompiledReplicatedMapQueryContext.this.debugContextsAndLocksGuarded());
                            throw e;
                        }
                    } 
                    CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
            }
        }
    }

    public class WrappedValueInstanceData extends CopyingInstanceData<V> {
        public WrappedValueInstanceData getUnusedWrappedValueGuarded() {
            assert this.nextInit() : "Next should be init";
            return getUnusedWrappedValue();
        }

        public WrappedValueInstanceData getUnusedWrappedValue() {
            if (!(valueInit()))
                return this;
            
            if ((next) == null)
                next = new WrappedValueInstanceData();
            
            return next.getUnusedWrappedValue();
        }

        private V value;

        public boolean valueInit() {
            return (value) != null;
        }

        public void initValue(V value) {
            CompiledReplicatedMapQueryContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert this.valueInit() : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!(this.valueInit()))
                return ;
            
            this.closeValueDependants();
            value = null;
            if ((next) != null)
                next.closeValue();
            
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return value();
        }

        private boolean marshalled = false;

        private DirectBytes buf;

        public boolean bufferInit() {
            return (this.marshalled) != false;
        }

        private void initBuffer() {
            MVI mvi = CompiledReplicatedMapQueryContext.this.valueMetaInterop(value());
            long size = mvi.size(CompiledReplicatedMapQueryContext.this.valueInterop, value());
            buf = getBuffer(this.buf, size);
            mvi.write(CompiledReplicatedMapQueryContext.this.valueInterop, buf, value());
            buf.flip();
            marshalled = true;
        }

        public DirectBytes buf() {
            if (!(this.bufferInit()))
                this.initBuffer();
            
            return this.buf;
        }

        public void closeBuffer() {
            if (!(this.bufferInit()))
                return ;
            
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            buf().position(0);
            return CompiledReplicatedMapQueryContext.this.valueReader.read(buf(), buf().limit(), usingValue);
        }

        @Override
        public DirectBytes buffer() {
            return buf();
        }

        private WrappedValueInstanceData next;

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!(this.nextInit()))
                return ;
            
        }
    }

    public class WriteLock implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException(("Cannot acquire write lock, because outer context " + ("holds read lock. In this case you should acquire update lock in the outer " + "context up front")));
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!(CompiledReplicatedMapQueryContext.this.updateZeroGuarded())) {
                            if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                                CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        } else {
                            if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                                CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        }
                    } else {
                        CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                        CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert !(CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                        CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                        CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull
        TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!(CompiledReplicatedMapQueryContext.this.updateZeroGuarded())) {
                            if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        } else {
                            if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        }
                    } else {
                        CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                        CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert !(CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                        CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                        CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapQueryContext.this.localLockState().write;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!(CompiledReplicatedMapQueryContext.this.updateZeroGuarded())) {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            CompiledReplicatedMapQueryContext.this.segmentHeader().writeLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        }
                    } 
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert !(CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                    } 
                    CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                case WRITE_LOCKED :
            }
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                case READ_LOCKED :
                case UPDATE_LOCKED :
                    return ;
                case WRITE_LOCKED :
                    int newTotalWriteLockCount = CompiledReplicatedMapQueryContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        CompiledReplicatedMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                    } else {
                        assert newTotalWriteLockCount > 0 : "write underflow";
                    }
            }
            CompiledReplicatedMapQueryContext.this.incrementUpdateGuarded();
            CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapQueryContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledReplicatedMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        if (!(CompiledReplicatedMapQueryContext.this.updateZeroGuarded())) {
                            CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!(CompiledReplicatedMapQueryContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            CompiledReplicatedMapQueryContext.this.segmentHeader().writeLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                        }
                    } 
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledReplicatedMapQueryContext.this.writeZeroGuarded()) {
                        assert !(CompiledReplicatedMapQueryContext.this.updateZeroGuarded());
                        CompiledReplicatedMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapQueryContext.this.segmentHeaderAddress());
                    } 
                    CompiledReplicatedMapQueryContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapQueryContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                case WRITE_LOCKED :
            }
        }
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        return totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        return totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        return totalWriteLockCount += change;
    }

    public int decrementRead() {
        return rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    public enum EntryPresence {
PRESENT, ABSENT;    }

    public enum SearchState {
PRESENT, DELETED, ABSENT;    }

    private long _QueryAlloc_alloc(int chunks) {
        long ret = this.allocReturnCode(chunks);
        if (ret >= 0)
            return ret;
        
        int alreadyAttemptedTier = this.segmentTier();
        this.goToFirstTier();
        while (true) {
            if ((this.segmentTier()) != alreadyAttemptedTier) {
                ret = this.allocReturnCode(chunks);
                if (ret >= 0)
                    return ret;
                
            } 
            this.nextTier();
        }
    }

    private void _AllocatedChunks_incrementSegmentEntriesIfNeeded() {
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
        if (!(this.h().isOpen()))
            throw new IllegalStateException("Access to Chronicle Hash after close()");
        
    }

    private void _MapAbsent_doInsert(Data<V> value) {
        this.putPrefix();
        if (!(this.entryPresent())) {
            if (this.searchStateDeleted()) {
                this.putValueDeletedEntry(value);
            } else {
                putEntry(value);
            }
            this.incrementModCountGuarded();
            this.setSearchStateGuarded(CompiledReplicatedMapQueryContext.SearchState.PRESENT);
            this.initPresenceOfEntry(CompiledReplicatedMapQueryContext.EntryPresence.PRESENT);
            this.checksumStrategy.computeAndStoreChecksum();
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
    }

    private void _MapQuery_doRemove() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        if (this.searchStatePresent()) {
            this.innerWriteLock.lock();
            this.remove();
            this.innerRemoveEntryExceptHashLookupUpdate();
            this.setSearchStateGuarded(CompiledReplicatedMapQueryContext.SearchState.DELETED);
            initPresenceOfEntry(CompiledReplicatedMapQueryContext.EntryPresence.ABSENT);
        } else {
            throw new IllegalStateException("Entry is absent when doRemove() is called");
        }
    }

    private void _MapQuery_doReplaceValue(Data<V> newValue) {
        doReplaceValueWithoutChecksum(newValue);
        this.checksumStrategy.computeAndStoreChecksum();
    }

    public void incrementModCount() {
        contextModCount = rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (localLockState) {
            case UNLOCKED :
                return ;
            case READ_LOCKED :
                int newTotalReadLockCount = decrementRead();
                if (newTotalReadLockCount == 0) {
                    if ((updateZero()) && (writeZero()))
                        segmentHeader().readUnlock(segmentHeaderAddress());
                    
                } else {
                    assert newTotalReadLockCount > 0 : "read underflow";
                }
                return ;
            case UPDATE_LOCKED :
                int newTotalUpdateLockCount = decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (writeZero()) {
                        if (readZero()) {
                            segmentHeader().updateUnlock(segmentHeaderAddress());
                        } else {
                            segmentHeader().downgradeUpdateToReadLock(segmentHeaderAddress());
                        }
                    } 
                } else {
                    assert newTotalUpdateLockCount > 0 : "update underflow";
                }
                return ;
            case WRITE_LOCKED :
                int newTotalWriteLockCount = decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!(updateZero())) {
                        segmentHeader().downgradeWriteToUpdateLock(segmentHeaderAddress());
                    } else {
                        if (!(readZero())) {
                            segmentHeader().downgradeWriteToReadLock(segmentHeaderAddress());
                        } else {
                            segmentHeader().writeUnlock(segmentHeaderAddress());
                        }
                    }
                } else {
                    assert newTotalWriteLockCount > 0 : "write underflow";
                }
        }
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        boolean isLocked = ((localLockState) != (LocalLockState.UNLOCKED)) && ((localLockState) != null);
        boolean goingToLock = (newState != (LocalLockState.UNLOCKED)) && (newState != null);
        if (isLocked) {
            if (!goingToLock)
                deregisterIterationContextLockedInThisThread();
            
        } else if (goingToLock) {
            registerIterationContextLockedInThisThread();
        } 
        localLockState = newState;
    }

    @Override
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(CompiledReplicatedMapQueryContext.SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    final Thread owner;

    public Thread owner() {
        return this.owner;
    }

    private void closeNestedLocks() {
        unlinkFromSegmentContextsChain();
        readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        verifyInnermostContext();
        switch (localLockState) {
            case UNLOCKED :
                return ;
            case READ_LOCKED :
                segmentHeader().readUnlock(segmentHeaderAddress());
                return ;
            case UPDATE_LOCKED :
                segmentHeader().updateUnlock(segmentHeaderAddress());
                return ;
            case WRITE_LOCKED :
                segmentHeader().writeUnlock(segmentHeaderAddress());
        }
    }

    private void countValueOffset() {
        this.m().alignment.alignPositionAddr(this.segmentBytes());
        valueOffset = this.segmentBytes().position();
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = rootContextLockedOnThisSegment;
        while (true) {
            checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if ((innermostContextOnThisSegment.nextNode()) == null)
                break;
            
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface prevContext = rootContextLockedOnThisSegment;
        while (true) {
            assert (prevContext.nextNode()) != null;
            if ((prevContext.nextNode()) == (this))
                break;
            
            prevContext = prevContext.nextNode();
        }
        verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if ((nextNode) != null)
            throw new IllegalStateException("Attempt to close contexts not structurally");
        
    }

    private class CleanupAction implements Consumer<ReplicableEntry> {
        int removedCompletely;

        @Override
        public void accept(ReplicableEntry e) {
            ReplicatedChronicleMap<?, ?, ?, ?, ?, ?, ?> map = CompiledReplicatedMapQueryContext.this.m();
            if (e instanceof MapAbsentEntry) {
                long deleteTimeout = (map.timeProvider.currentTime()) - (e.originTimestamp());
                map.timeProvider.systemTimeIntervalBetween(e.originTimestamp(), map.timeProvider.currentTime(), map.cleanupTimeoutUnit);
                if ((deleteTimeout > (map.cleanupTimeout)) && (!(e.isChanged()))) {
                    e.doRemoveCompletely();
                    (removedCompletely)++;
                } 
            } 
        }
    }

    public String debugContextsAndLocks() {
        String message = "";
        message += "Contexts locked on this segment:\n";
        for (LocksInterface cxt = rootContextLockedOnThisSegment ; cxt != null ; cxt = cxt.nextNode()) {
            message += (cxt.debugLocksState()) + "\n";
        }
        message += "Current thread contexts:\n";
        for (int i = 0, size = this.contextChain.size() ; i < size ; i++) {
            LocksInterface cxt = this.contextAtIndexInChain(i);
            message += (cxt.debugLocksState()) + "\n";
        }
        return message;
    }

    private boolean _MapQuery_entryPresent() {
        return (entryPresence()) == (CompiledReplicatedMapQueryContext.EntryPresence.PRESENT);
    }

    public boolean readZero() {
        return (rootContextLockedOnThisSegment.totalReadLockCount()) == 0;
    }

    public boolean updateZero() {
        return (rootContextLockedOnThisSegment.totalUpdateLockCount()) == 0;
    }

    public boolean writeZero() {
        return (rootContextLockedOnThisSegment.totalWriteLockCount()) == 0;
    }

    private long _HashEntryStages_entryEnd() {
        return keyEnd();
    }

    private void _MapEntryStages_relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.innerWriteLock.lock();
        this.free(pos(), entrySizeInChunks());
        long entrySize = innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.segmentBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, ((valueSizeOffset()) - (keySizeOffset())));
        if (tierHasChanged) {
            if (!(this.searchStateAbsent()))
                throw new AssertionError();
            
        } 
        initValue(newValue);
        freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(pos());
        hl.writeEntryVolatile(this.segmentBaseAddr(), this.hashLookupPos(), oldEntry, hl.key(oldEntry), pos());
        if (tierHasChanged)
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        
    }

    public final int indexInContextChain;

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public class DefaultReturnValue implements InstanceReturnValue<V> {
        @Override
        public void returnValue(@NotNull
        Data<V> value) {
            initDefaultReturnedValue(value);
        }

        private V defaultReturnedValue = null;

        boolean defaultReturnedValueInit() {
            return (this.defaultReturnedValue) != null;
        }

        private void initDefaultReturnedValue(@NotNull
        Data<V> value) {
            defaultReturnedValue = value.getUsing(null);
        }

        public V defaultReturnedValue() {
            assert this.defaultReturnedValueInit() : "DefaultReturnedValue should be init";
            return this.defaultReturnedValue;
        }

        public void closeDefaultReturnedValue() {
            if (!(this.defaultReturnedValueInit()))
                return ;
            
            this.defaultReturnedValue = null;
        }

        @Override
        public V returnValue() {
            if (defaultReturnedValueInit()) {
                return defaultReturnedValue();
            } else {
                return null;
            }
        }
    }

    public class InputKeyInstanceData extends CopyingInstanceData<K> implements KeyInitableData<K> {
        private K key = null;

        public boolean keyInit() {
            return (this.key) != null;
        }

        @Override
        public void initKey(K key) {
            this.key = key;
            this.closeKeyDependants();
        }

        public K key() {
            assert this.keyInit() : "Key should be init";
            return this.key;
        }

        public void closeKey() {
            if (!(this.keyInit()))
                return ;
            
            this.closeKeyDependants();
            this.key = null;
        }

        public void closeKeyDependants() {
            this.closeBuffer();
        }

        @Override
        public K instance() {
            return key();
        }

        private boolean marshalled = false;

        private DirectBytes buffer;

        public boolean bufferInit() {
            return (this.marshalled) != false;
        }

        private void initBuffer() {
            MKI mki = CompiledReplicatedMapQueryContext.this.keyMetaInterop(key());
            long size = mki.size(CompiledReplicatedMapQueryContext.this.keyInterop, key());
            buffer = getBuffer(this.buffer, size);
            mki.write(CompiledReplicatedMapQueryContext.this.keyInterop, buffer, key());
            buffer.flip();
            marshalled = true;
        }

        public DirectBytes buffer() {
            if (!(this.bufferInit()))
                this.initBuffer();
            
            return this.buffer;
        }

        public void closeBuffer() {
            if (!(this.bufferInit()))
                return ;
            
            this.marshalled = false;
        }

        @Override
        public K getUsing(K usingKey) {
            buffer().position(0);
            return CompiledReplicatedMapQueryContext.this.keyReader.read(buffer(), buffer().limit(), usingKey);
        }
    }

    public class InputValueInstanceData extends CopyingInstanceData<V> implements ValueInitializableData<V> {
        private V value = null;

        public boolean valueInit() {
            return (this.value) != null;
        }

        @Override
        public void initValue(V value) {
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert this.valueInit() : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!(this.valueInit()))
                return ;
            
            this.closeValueDependants();
            this.value = null;
        }

        public void closeValueDependants() {
            this.closeBuffer();
        }

        @Override
        public V instance() {
            return value();
        }

        private boolean marshalled = false;

        private DirectBytes buffer;

        public boolean bufferInit() {
            return (this.marshalled) != false;
        }

        private void initBuffer() {
            MVI mvi = CompiledReplicatedMapQueryContext.this.valueMetaInterop(value());
            long size = mvi.size(CompiledReplicatedMapQueryContext.this.valueInterop, value());
            buffer = getBuffer(this.buffer, size);
            mvi.write(CompiledReplicatedMapQueryContext.this.valueInterop, buffer, value());
            buffer.flip();
            marshalled = true;
        }

        public DirectBytes buffer() {
            if (!(this.bufferInit()))
                this.initBuffer();
            
            return this.buffer;
        }

        public void closeBuffer() {
            if (!(this.bufferInit()))
                return ;
            
            this.marshalled = false;
        }

        @Override
        public V getUsing(V usingValue) {
            buffer().position(0);
            return CompiledReplicatedMapQueryContext.this.valueReader.read(buffer(), buffer().limit(), usingValue);
        }
    }

    public class UsingReturnValue implements UsableReturnValue<V> {
        @Override
        public void returnValue(@NotNull
        Data<V> value) {
            initReturnedValue(value);
        }

        private V usingReturnValue = ((V)(UsableReturnValue.USING_RETURN_VALUE_UNINT));

        public boolean usingReturnValueInit() {
            return (this.usingReturnValue) != ((V)(UsableReturnValue.USING_RETURN_VALUE_UNINT));
        }

        @Override
        public void initUsingReturnValue(V usingReturnValue) {
            this.usingReturnValue = usingReturnValue;
            this.closeUsingReturnValueDependants();
        }

        public V usingReturnValue() {
            assert this.usingReturnValueInit() : "UsingReturnValue should be init";
            return this.usingReturnValue;
        }

        public void closeUsingReturnValue() {
            if (!(this.usingReturnValueInit()))
                return ;
            
            this.closeUsingReturnValueDependants();
            this.usingReturnValue = ((V)(UsableReturnValue.USING_RETURN_VALUE_UNINT));
        }

        public void closeUsingReturnValueDependants() {
            this.closeReturnedValue();
        }

        private V returnedValue = null;

        boolean returnedValueInit() {
            return (this.returnedValue) != null;
        }

        private void initReturnedValue(@NotNull
        Data<V> value) {
            returnedValue = value.getUsing(usingReturnValue());
        }

        public V returnedValue() {
            assert this.returnedValueInit() : "ReturnedValue should be init";
            return this.returnedValue;
        }

        public void closeReturnedValue() {
            if (!(this.returnedValueInit()))
                return ;
            
            this.returnedValue = null;
        }

        @Override
        public V returnValue() {
            if (returnedValueInit()) {
                return returnedValue();
            } else {
                return null;
            }
        }
    }

    final CompiledReplicatedMapQueryContext.CleanupAction cleanupAction;

    public CompiledReplicatedMapQueryContext.CleanupAction cleanupAction() {
        return this.cleanupAction;
    }

    private MapEntry<K, V> _MapQuery_entry() {
        this.checkOnEachPublicOperation();
        return entryPresent() ? this : null;
    }

    public final ReadLock innerReadLock;

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public static final Logger LOG = LoggerFactory.getLogger(CompiledReplicatedMapQueryContext.class);

    public final WriteLock innerWriteLock;

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public final UpdateLock innerUpdateLock;

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    @Nullable
    private MapAbsentEntry<K, V> _MapQuery_absentEntry() {
        this.checkOnEachPublicOperation();
        return entryPresent() ? null : this.absent();
    }

    final BytesReturnValue bytesReturnValue;

    public BytesReturnValue bytesReturnValue() {
        return this.bytesReturnValue;
    }

    public final ThreadLocalCopies copies;

    public final ChainingInterface rootContextInThisThread;

    final EntryKeyBytesData entryKey;

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ChainingInterface rootContextInThisThread() {
        return this.rootContextInThisThread;
    }

    public ThreadLocalCopies copies() {
        return this.copies;
    }

    final DummyValueZeroData dummyValue;

    public DummyValueZeroData dummyValue() {
        return this.dummyValue;
    }

    public final List<ChainingInterface> contextChain;

    public final AcquireHandle acquireHandle;

    public final UsingReturnValue usingReturnValue;

    public UsingReturnValue usingReturnValue() {
        return this.usingReturnValue;
    }

    public AcquireHandle acquireHandle() {
        return this.acquireHandle;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    public final InputKeyBytesData inputKeyBytesValue;

    public InputKeyBytesData inputKeyBytesValue() {
        return this.inputKeyBytesValue;
    }

    public final DefaultReturnValue defaultReturnValue;

    public DefaultReturnValue defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public final EntryValueBytesData entryValue;

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    final ReplicatedInputKeyBytesData replicatedInputKeyBytesValue;

    public ReplicatedInputKeyBytesData replicatedInputKeyBytesValue() {
        return this.replicatedInputKeyBytesValue;
    }

    final ReplicatedInputValueBytesData replicatedInputValueBytesValue;

    public ReplicatedInputValueBytesData replicatedInputValueBytesValue() {
        return this.replicatedInputValueBytesValue;
    }

    final WrappedValueInstanceData wrappedValueInstanceValue;

    public WrappedValueInstanceData wrappedValueInstanceValue() {
        return this.wrappedValueInstanceValue;
    }

    public final InputFirstValueBytesData inputFirstValueBytesValue;

    public final JavaLangBytesReusableBytesStore replicatedInputStore;

    public final JavaLangBytesReusableBytesStore inputStore;

    public JavaLangBytesReusableBytesStore inputStore() {
        return this.inputStore;
    }

    public JavaLangBytesReusableBytesStore replicatedInputStore() {
        return this.replicatedInputStore;
    }

    public InputFirstValueBytesData inputFirstValueBytesValue() {
        return this.inputFirstValueBytesValue;
    }

    public final ReusableBitSet freeList;

    final HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy;

    final ReplicatedMapAbsentDelegating absentDelegating;

    public final InputSecondValueBytesData inputSecondValueBytesValue;

    public InputSecondValueBytesData inputSecondValueBytesValue() {
        return this.inputSecondValueBytesValue;
    }

    public ReplicatedMapAbsentDelegating absentDelegating() {
        return this.absentDelegating;
    }

    public HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy() {
        return this.hashKeyCrc32PayloadChecksumStrategy;
    }

    public final InputKeyInstanceData inputKeyInstanceValue;

    public InputKeyInstanceData inputKeyInstanceValue() {
        return this.inputKeyInstanceValue;
    }

    public final PointerBytesStore segmentBS;

    public final InputValueInstanceData inputValueInstanceValue;

    public InputValueInstanceData inputValueInstanceValue() {
        return this.inputValueInstanceValue;
    }

    public final PublicMultiStoreBytes segmentBytes;

    private final ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m;

    public final VI valueInterop;

    public VI valueInterop() {
        return this.valueInterop;
    }

    public final ChecksumStrategy checksumStrategy;

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public final BytesReader<V> valueReader;

    public BytesReader<V> valueReader() {
        return this.valueReader;
    }

    public final KI keyInterop;

    public KI keyInterop() {
        return this.keyInterop;
    }

    public final BytesReader<K> keyReader;

    public BytesReader<K> keyReader() {
        return this.keyReader;
    }

    @Override
    public void updateChecksum() {
        checksumStrategy.updateChecksum();
    }

    @Override
    public boolean checkSum() {
        return checksumStrategy.checkSum();
    }

    public <T>T contextAtIndexInChain(int index) {
        return ((T)(contextChain.get(index)));
    }

    public void closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    public void checkAccessingFromOwnerThread() {
        if ((owner) != (Thread.currentThread())) {
            throw new ConcurrentModificationException("Context shouldn\'t be accessed from multiple threads");
        } 
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    @Override
    public MapAbsentEntry<K, V> absent() {
        return this;
    }

    @Override
    public ReplicatedChronicleMap<K, KI, MKI, V, VI, MVI, R> m() {
        return m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return m();
    }

    public MVI valueMetaInterop(V value) {
        return this.m().metaValueInteropProvider.get(this.copies, this.m().originalMetaValueInterop, valueInterop, value, false);
    }

    public void closeValueBytesInteropValueMetaInteropDependants() {
        this.wrappedValueInstanceValue.closeBuffer();
        this.inputValueInstanceValue.closeBuffer();
    }

    @Override
    public <T extends ChainingInterface>T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        for (ChainingInterface context : contextChain) {
            if (((context.getClass()) == contextClass) && (!(context.usedInit()))) {
                context.initUsed(true);
                return ((T)(context));
            } 
        }
        int maxNestedContexts = 1 << 10;
        if ((contextChain.size()) > maxNestedContexts) {
            throw new IllegalStateException((((((("More than " + maxNestedContexts) + " nested ChronicleHash contexts are not supported. Very probable that ") + "you simply forgot to close context somewhere (recommended to use ") + "try-with-resources statement). ") + "Otherwise this is a bug, please report with this ") + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues"));
        } 
        T context = createChaining.apply(this);
        context.initUsed(true);
        return context;
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        if ((innermostContextOnThisSegment.getClass()) == (getClass())) {
            Data key = ((CompiledReplicatedMapQueryContext)(innermostContextOnThisSegment)).inputKey();
            if (Objects.equals(key, ((CompiledReplicatedMapQueryContext)((Object)(this))).inputKey())) {
                throw new IllegalStateException((("Nested same-thread contexts cannot access " + "the same key ") + key));
            } 
        } 
    }

    public void closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException(("Update or Write locking is forbidden in the context" + "of locked iteration context"));
        } 
    }

    public MKI keyMetaInterop(K key) {
        return this.h().metaKeyInteropProvider.get(this.copies, this.h().originalMetaKeyInterop, keyInterop, key, false);
    }

    public void closeKeyBytesInteropKeyMetaInteropDependants() {
        this.inputKeyInstanceValue.closeBuffer();
    }

    private void registerIterationContextLockedInThisThread() {
        if ((this) instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = true;
        } 
    }

    public void closeQuerySegmentStagesRegisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeQueryHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    long searchKey = CompactOffHeapLinearHashTable.UNSET_KEY;

    public long searchStartPos;

    public boolean searchKeyInit() {
        return (this.searchKey) != (CompactOffHeapLinearHashTable.UNSET_KEY);
    }

    void initSearchKey() {
        initSearchKey(hl().maskUnsetKey(this.h().hashSplitting.segmentHash(this.keyHashCode())));
        this.closeSearchKeyDependants();
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        searchStartPos = hl().hlPos(searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        if (!(this.searchKeyInit()))
            this.initSearchKey();
        
        return this.searchKey;
    }

    public long searchStartPos() {
        if (!(this.searchKeyInit()))
            this.initSearchKey();
        
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!(this.searchKeyInit()))
            return ;
        
        this.closeSearchKeyDependants();
        this.searchKey = CompactOffHeapLinearHashTable.UNSET_KEY;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (_MapEntryStages_sizeOfEverythingBeforeValue(keySize, valueSize)) + (ReplicatedChronicleMap.ADDITIONAL_ENTRY_BYTES);
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (this.m().constantlySizedEntry) {
            return this.m().alignment.alignAddr((sizeOfEverythingBeforeValue + valueSize));
        } else if (this.m().couldNotDetermineAlignmentBeforeAllocation) {
            return (sizeOfEverythingBeforeValue + (this.m().worstAlignment)) + valueSize;
        } else {
            return (this.m().alignment.alignAddr(sizeOfEverythingBeforeValue)) + valueSize;
        }
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = sizeOfEverythingBeforeValue(keySize, valueSize);
        return innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError(("putValueDeletedEntry() might be called only from " + "non-Replicated Map query context"));
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return contextChain;
    }

    @Override
    public Data<V> dummyZeroValue() {
        return this.dummyValue;
    }

    private void deregisterIterationContextLockedInThisThread() {
        if ((this) instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = false;
        } 
    }

    public void closeQuerySegmentStagesDeregisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public long keySize = -1;

    public boolean keySizeInit() {
        return (this.keySize) != (-1);
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert this.keySizeInit() : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!(this.keySizeInit()))
            return ;
        
        this.closeKeySizeDependants();
        this.keySize = -1;
    }

    public void closeKeySizeDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    public int segmentIndex = -1;

    public boolean segmentIndexInit() {
        return (this.segmentIndex) >= 0;
    }

    void initSegmentIndex() {
        segmentIndex = this.h().hashSplitting.segmentIndex(this.keyHashCode());
        this.closeSegmentIndexDependants();
    }

    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeSegmentIndexDependants();
    }

    public int segmentIndex() {
        if (!(this.segmentIndexInit()))
            this.initSegmentIndex();
        
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!(this.segmentIndexInit()))
            return ;
        
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
        this.closeSegmentTier();
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public boolean forcedOldDeletedEntriesCleanup() {
        ReplicatedChronicleMap<?, ?, ?, ?, ?, ?, ?> map = this.m();
        try (MapSegmentContext<?, ?, ?> sc = map.segmentContext(this.segmentIndex())) {
            cleanupAction.removedCompletely = 0;
            ((ReplicatedHashSegmentContext<?, ?>)(sc)).forEachSegmentReplicableEntry(cleanupAction);
            return (cleanupAction.removedCompletely) > 0;
        }
    }

    long segmentHeaderAddress;

    SegmentHeader segmentHeader = null;

    public boolean segmentHeaderInit() {
        return (this.segmentHeader) != null;
    }

    private void initSegmentHeader() {
        segmentHeaderAddress = this.h().segmentHeaderAddress(segmentIndex());
        segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegmentHeaderDependants();
    }

    public long segmentHeaderAddress() {
        if (!(this.segmentHeaderInit()))
            this.initSegmentHeader();
        
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!(this.segmentHeaderInit()))
            this.initSegmentHeader();
        
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!(this.segmentHeaderInit()))
            return ;
        
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
    }

    public void entries(long size) {
        segmentHeader().size(segmentHeaderAddress(), size);
    }

    public long entries() {
        return segmentHeader().size(segmentHeaderAddress());
    }

    public void deleted(long deleted) {
        segmentHeader().deleted(segmentHeaderAddress(), deleted);
    }

    public long deleted() {
        return segmentHeader().deleted(segmentHeaderAddress());
    }

    public long size() {
        return (entries()) - (deleted());
    }

    int totalReadLockCount;

    int totalUpdateLockCount;

    int totalWriteLockCount;

    public int latestSameThreadSegmentModCount;

    public int contextModCount;

    public boolean nestedContextsLockedOnSameSegment;

    LocksInterface nextNode;

    LocalLockState localLockState;

    public LocksInterface rootContextLockedOnThisSegment = null;

    public boolean locksInit() {
        return (this.rootContextLockedOnThisSegment) != null;
    }

    void initLocks() {
        localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (int i = indexOfThisContext - 1 ; i >= 0 ; i--) {
            if (tryFindInitLocksOfThisSegment(i))
                return ;
            
        }
        for (int i = indexOfThisContext + 1, size = this.contextChain.size() ; i < size ; i++) {
            if (tryFindInitLocksOfThisSegment(i))
                return ;
            
        }
        rootContextLockedOnThisSegment = this;
        nestedContextsLockedOnSameSegment = false;
        latestSameThreadSegmentModCount = 0;
        contextModCount = 0;
        totalReadLockCount = 0;
        totalUpdateLockCount = 0;
        totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean nestedContextsLockedOnSameSegment() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.nestedContextsLockedOnSameSegment;
    }

    public int contextModCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.contextModCount;
    }

    public int latestSameThreadSegmentModCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.latestSameThreadSegmentModCount;
    }

    public int totalReadLockCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.totalReadLockCount;
    }

    public int totalUpdateLockCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.totalUpdateLockCount;
    }

    public int totalWriteLockCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.localLockState;
    }

    public LocksInterface nextNode() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.nextNode;
    }

    public LocksInterface rootContextLockedOnThisSegment() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.rootContextLockedOnThisSegment;
    }

    void closeLocks() {
        if (!(this.locksInit()))
            return ;
        
        this.closeLocksDependants();
        if ((rootContextLockedOnThisSegment) == (this)) {
            closeRootLocks();
        } else {
            closeNestedLocks();
        }
        deregisterIterationContextLockedInThisThread();
        localLockState = null;
        rootContextLockedOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    @Override
    public String debugLocksState() {
        String s = (this) + ": ";
        if (!(this.usedInit())) {
            s += "unused";
            return s;
        } 
        s += "used, ";
        if (!(segmentIndexInit())) {
            s += "segment uninitialized";
            return s;
        } 
        s += ("segment " + (segmentIndex())) + ", ";
        if (!(locksInit())) {
            s += "locks uninitialized";
            return s;
        } 
        s += ("local state: " + (localLockState())) + ", ";
        s += ("read lock count: " + (rootContextLockedOnThisSegment().totalReadLockCount())) + ", ";
        s += ("update lock count: " + (rootContextLockedOnThisSegment().totalUpdateLockCount())) + ", ";
        s += "write lock count: " + (rootContextLockedOnThisSegment().totalWriteLockCount());
        return s;
    }

    public int segmentTier = -1;

    public long tierIndex;

    public long segmentBaseAddr;

    public boolean segmentTierInit() {
        return (this.segmentTier) >= 0;
    }

    public void initSegmentTier() {
        tierIndex = (segmentIndex()) + 1;
        segmentBaseAddr = this.h().segmentBaseAddr(segmentIndex());
        segmentTier = 0;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        segmentTier = tier;
        this.tierIndex = tierIndex;
        this.segmentBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    private void initSegmentTier(int tier, long tierIndex) {
        segmentTier = tier;
        this.tierIndex = tierIndex;
        assert tierIndex > 0;
        this.segmentBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        this.closeSegmentTierDependants();
    }

    public int segmentTier() {
        if (!(this.segmentTierInit()))
            this.initSegmentTier();
        
        return this.segmentTier;
    }

    public long segmentBaseAddr() {
        if (!(this.segmentTierInit()))
            this.initSegmentTier();
        
        return this.segmentBaseAddr;
    }

    public long tierIndex() {
        if (!(this.segmentTierInit()))
            this.initSegmentTier();
        
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!(this.segmentTierInit()))
            return ;
        
        this.closeSegmentTierDependants();
        this.segmentTier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeQueryHashLookupSearchAddrDependants();
        this.closeQuerySegmentStagesTierCountersAreaAddrDependants();
        this.closeQuerySegmentStagesNextTierDependants();
        this.closeHashLookupPos();
        this.closeSegment();
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
    }

    private long addr() {
        return this.segmentBaseAddr();
    }

    public void closeQueryHashLookupSearchAddrDependants() {
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long tierCountersAreaAddr() {
        return (segmentBaseAddr()) + (this.h().segmentHashLookupOuterSize);
    }

    public void closeQuerySegmentStagesTierCountersAreaAddrDependants() {
        this.closeQuerySegmentStagesPrevTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(tierCountersAreaAddr(), prevTierIndex);
    }

    public void closeQuerySegmentStagesPrevTierIndexDependants() {
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(tierCountersAreaAddr());
    }

    public void nextPosToSearchFromTiered(long nextPosToSearchFrom) {
        TierCountersArea.nextPosToSearchFromTiered(tierCountersAreaAddr(), nextPosToSearchFrom);
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        if ((segmentTier()) == 0) {
            segmentHeader().nextPosToSearchFrom(segmentHeaderAddress(), nextPosToSearchFrom);
        } else {
            nextPosToSearchFromTiered(nextPosToSearchFrom);
        }
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + chunks;
        if (nextPosToSearchFrom >= (this.h().actualChunksPerSegment))
            nextPosToSearchFrom = 0L;
        
        nextPosToSearchFrom(nextPosToSearchFrom);
    }

    public long nextPosToSearchFromTiered() {
        return TierCountersArea.nextPosToSearchFromTiered(tierCountersAreaAddr());
    }

    long nextPosToSearchFrom() {
        if ((segmentTier()) == 0) {
            return segmentHeader().nextPosToSearchFrom(segmentHeaderAddress());
        } else {
            return nextPosToSearchFromTiered();
        }
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(tierCountersAreaAddr(), nextTierIndex);
    }

    public void closeQuerySegmentStagesNextTierIndexDependants() {
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return (nextTierIndex()) != 0;
    }

    public void closeQuerySegmentStagesHasNextTierDependants() {
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
    }

    public void nextTier() {
        VanillaChronicleHash<?, ?, ? extends MetaBytesInterop<?, ?>, ?, ?, ?> h = this.h();
        long nextTierIndex = nextTierIndex();
        if (nextTierIndex == 0) {
            nextTierIndex = h.allocateTier(segmentIndex(), ((segmentTier()) + 1));
            nextTierIndex(nextTierIndex);
            long currentTierIndex = tierIndex();
            initSegmentTier(((segmentTier()) + 1), nextTierIndex);
            prevTierIndex(currentTierIndex);
        } else {
            initSegmentTier(((segmentTier()) + 1), nextTierIndex);
        }
    }

    public void closeQuerySegmentStagesNextTierDependants() {
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
    }

    public void goToLastTier() {
        while (hasNextTier()) {
            nextTier();
        }
    }

    public long hashLookupPos = -1;

    public boolean hashLookupPosInit() {
        return (this.hashLookupPos) != (-1);
    }

    public void initHashLookupPos() {
        assert (this.segmentTier()) >= 0;
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!(this.hashLookupPosInit()))
            this.initHashLookupPos();
        
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!(this.hashLookupPosInit()))
            return ;
        
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1;
    }

    public void closeHashLookupPosDependants() {
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public void found() {
        this.setHashLookupPosGuarded(hl().stepBack(this.hashLookupPos()));
    }

    public void closeQueryHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public long nextPos() {
        long pos = this.hashLookupPos();
        while (true) {
            long entry = hl().readEntry(addr(), pos);
            if (hl().empty(entry)) {
                this.setHashLookupPosGuarded(pos);
                return -1L;
            } 
            pos = hl().step(pos);
            if (pos == (searchStartPos()))
                break;
            
            if ((hl().key(entry)) == (searchKey())) {
                this.setHashLookupPosGuarded(pos);
                return hl().value(entry);
            } 
        }
        throw new IllegalStateException(("MultiMap is full, that most likely means you " + ("misconfigured entrySize/chunkSize, and entries tend to take less chunks than " + "expected")));
    }

    public void closeQueryHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = hl().readEntry(addr(), this.hashLookupPos());
        return ((hl().key(entry)) == (searchKey())) && ((hl().value(entry)) == value);
    }

    public void closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants() {
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void putValueVolatile(long newValue) {
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        hashLookup.checkValueForPut(newValue);
        hashLookup.putValueVolatile(this.segmentBaseAddr(), hashLookupPos(), newValue);
    }

    public void remove() {
        this.setHashLookupPosGuarded(hl().remove(addr(), this.hashLookupPos()));
    }

    long entrySpaceOffset = 0;

    boolean segmentInit() {
        return (entrySpaceOffset) > 0;
    }

    void initSegment() {
        VanillaChronicleHash<?, ?, ?, ?, ?, ?> h = this.h();
        PublicMultiStoreBytes segmentBytes = this.segmentBytes;
        segmentBytes.setBytesOffset(h.tierBytes(tierIndex()), h.tierBytesOffset(tierIndex()));
        long segmentBaseAddr = this.segmentBaseAddr();
        segmentBS.set(segmentBaseAddr, h.segmentSize);
        long freeListOffset = (h.segmentHashLookupOuterSize) + (VanillaChronicleHash.TIER_COUNTERS_AREA_SIZE);
        freeList.setOffset((segmentBaseAddr + freeListOffset));
        entrySpaceOffset = (freeListOffset + (h.segmentFreeListOuterSize)) + (h.segmentEntrySpaceInnerOffset);
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return this.entrySpaceOffset;
    }

    public ReusableBitSet freeList() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return this.freeList;
    }

    public PointerBytesStore segmentBS() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return this.segmentBS;
    }

    public PublicMultiStoreBytes segmentBytes() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return this.segmentBytes;
    }

    void closeSegment() {
        if (!(this.segmentInit()))
            return ;
        
        this.closeSegmentDependants();
        entrySpaceOffset = 0;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.closeEntryOffset();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public void free(long fromPos, int chunks) {
        freeList().clearRange(fromPos, (fromPos + chunks));
        if (fromPos < (nextPosToSearchFrom()))
            nextPosToSearchFrom(fromPos);
        
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash<?, ?, ?, ?, ?, ?> h = this.h();
        if (chunks > (h.maxChunksPerEntry)) {
            throw new IllegalArgumentException((((("Entry is too large: requires " + chunks) + " chucks, ") + (h.maxChunksPerEntry)) + " is maximum."));
        } 
        long ret = freeList().setNextNContinuousClearBits(nextPosToSearchFrom(), chunks);
        if ((ret == (DirectBitSet.NOT_FOUND)) || ((ret + chunks) > (h.actualChunksPerSegment))) {
            if (((ret != (DirectBitSet.NOT_FOUND)) && ((ret + chunks) > (h.actualChunksPerSegment))) && (ret < (h.actualChunksPerSegment))) {
                freeList().clearRange(ret, h.actualChunksPerSegment);
            } 
            ret = freeList().setNextNContinuousClearBits(0L, chunks);
            if ((ret == (DirectBitSet.NOT_FOUND)) || ((ret + chunks) > (h.actualChunksPerSegment))) {
                if (((ret != (DirectBitSet.NOT_FOUND)) && ((ret + chunks) > (h.actualChunksPerSegment))) && (ret < (h.actualChunksPerSegment))) {
                    freeList().clearRange(ret, h.actualChunksPerSegment);
                } 
                return -1;
            } 
            updateNextPosToSearchFrom(ret, chunks);
        } else {
            if ((chunks == 1) || (freeList().isSet(nextPosToSearchFrom()))) {
                updateNextPosToSearchFrom(ret, chunks);
            } 
        }
        return ret;
    }

    public void prevTier() {
        if ((segmentTier()) == 0)
            throw new IllegalStateException("first tier doesn\'t have previous");
        
        initSegmentTier(((segmentTier()) - 1), prevTierIndex());
    }

    public void goToFirstTier() {
        while ((segmentTier()) != 0) {
            prevTier();
        }
    }

    @Override
    public long alloc(int chunks) {
        long ret = this.allocReturnCode(chunks);
        if (ret >= 0)
            return ret;
        
        int alreadyAttemptedTier;
        if (!(forcedOldDeletedEntriesCleanup())) {
            alreadyAttemptedTier = this.segmentTier();
        } else {
            alreadyAttemptedTier = -1;
        }
        this.goToFirstTier();
        while (true) {
            if ((this.segmentTier()) != alreadyAttemptedTier) {
                ret = this.allocReturnCode(chunks);
                if (ret >= 0)
                    return ret;
                
            } 
            this.nextTier();
        }
    }

    boolean used;

    @Override
    public boolean usedInit() {
        return used;
    }

    @Override
    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!(this.usedInit()))
            return ;
        
        used = false;
    }

    public Bytes replicatedInputBytes = null;

    public boolean replicatedInputBytesInit() {
        return (this.replicatedInputBytes) != null;
    }

    public void initReplicatedInputBytes(Bytes replicatedInputBytes) {
        this.replicatedInputBytes = replicatedInputBytes;
        replicatedInputStore.setBytes(replicatedInputBytes);
        this.closeReplicatedInputBytesDependants();
    }

    public Bytes replicatedInputBytes() {
        assert this.replicatedInputBytesInit() : "ReplicatedInputBytes should be init";
        return this.replicatedInputBytes;
    }

    public void closeReplicatedInputBytes() {
        if (!(this.replicatedInputBytesInit()))
            return ;
        
        this.closeReplicatedInputBytesDependants();
        this.replicatedInputBytes = null;
    }

    public void closeReplicatedInputBytesDependants() {
        this.replicatedInputKeyBytesValue.closeReplicatedInputKeyBytesDataGetUsingDependants();
        this.replicatedInputValueBytesValue.closeReplicatedInputValueBytesDataGetUsingDependants();
    }

    public Data<K> inputKey = null;

    boolean inputKeyInit() {
        return (this.inputKey) != null;
    }

    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Data<K> inputKey() {
        assert this.inputKeyInit() : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!(this.inputKeyInit()))
            return ;
        
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public long keyHash = 0;

    public boolean keyHashInit() {
        return (this.keyHash) != 0;
    }

    void initKeyHash() {
        keyHash = this.inputKey().hash(LongHashFunction.city_1_1());
    }

    public long keyHash() {
        if (!(this.keyHashInit()))
            this.initKeyHash();
        
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!(this.keyHashInit()))
            return ;
        
        this.keyHash = 0;
    }

    @Override
    public long keyHashCode() {
        return keyHash();
    }

    public long pos = -1;

    public boolean posInit() {
        return (this.pos) != (-1);
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    public long pos() {
        assert this.posInit() : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!(this.posInit()))
            return ;
        
        this.closePosDependants();
        this.pos = -1;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void dropChange() {
        this.m().dropChange(this.tierIndex(), this.pos());
    }

    public boolean changed() {
        return this.m().isChanged(this.tierIndex(), this.pos());
    }

    public long keySizeOffset = -1;

    public boolean entryOffsetInit() {
        return (this.keySizeOffset) != (-1);
    }

    public void initEntryOffset() {
        keySizeOffset = (this.entrySpaceOffset()) + ((pos()) * (this.h().chunkSize));
        this.segmentBytes().limit(this.segmentBytes().capacity());
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!(this.entryOffsetInit()))
            this.initEntryOffset();
        
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!(this.entryOffsetInit()))
            return ;
        
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1;
    }

    public void closeEntryOffsetDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
    }

    public void readExistingEntry(long pos) {
        initPos(pos);
        this.segmentBytes().position(keySizeOffset());
        initKeySize(this.h().keySizeMarshaller.readSize(this.segmentBytes()));
        initKeyOffset(this.segmentBytes().position());
    }

    public void closeReplicatedMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        initPos(newPos);
        initKeyOffset(((keySizeOffset()) + (oldKeyAddr - oldKeySizeAddr)));
        Access.copy(Access.nativeAccess(), null, oldKeySizeAddr, Access.checkedBytesStoreAccess(), this.segmentBS(), keySizeOffset(), bytesToCopy);
    }

    public long keyOffset = -1;

    public boolean keyOffsetInit() {
        return (this.keyOffset) != (-1);
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert this.keyOffsetInit() : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!(this.keyOffsetInit()))
            return ;
        
        this.closeKeyOffsetDependants();
        this.keyOffset = -1;
    }

    public void closeKeyOffsetDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public long keyEnd() {
        return (keyOffset()) + (keySize());
    }

    public void closeReplicatedMapEntryStagesKeyEndDependants() {
        this.closeReplicatedMapEntryStagesCountValueSizeOffsetDependants();
        this.closeReplicationState();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
    }

    long countValueSizeOffset() {
        return (_MapEntryStages_countValueSizeOffset()) + (ReplicatedChronicleMap.ADDITIONAL_ENTRY_BYTES);
    }

    public void closeReplicatedMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public long valueSizeOffset = -1;

    public boolean valueSizeOffsetInit() {
        return (this.valueSizeOffset) != (-1);
    }

    void initValueSizeOffset() {
        valueSizeOffset = countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!(this.valueSizeOffsetInit()))
            this.initValueSizeOffset();
        
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!(this.valueSizeOffsetInit()))
            return ;
        
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public long valueSize = -1;

    public long valueOffset;

    public boolean valueSizeInit() {
        return (this.valueSize) != (-1);
    }

    void initValueSize() {
        this.segmentBytes().position(valueSizeOffset());
        valueSize = this.m().readValueSize(this.segmentBytes());
        countValueOffset();
        this.closeValueSizeDependants();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        this.segmentBytes().position(valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize(this.segmentBytes(), valueSize);
        countValueOffset();
        this.closeValueSizeDependants();
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        valueSize = oldValueSize;
        valueOffset = (valueSizeOffset()) + (oldValueOffset - oldValueSizeOffset);
        this.closeValueSizeDependants();
    }

    public long valueOffset() {
        if (!(this.valueSizeInit()))
            this.initValueSize();
        
        return this.valueOffset;
    }

    public long valueSize() {
        if (!(this.valueSizeInit()))
            this.initValueSize();
        
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!(this.valueSizeInit()))
            return ;
        
        this.closeValueSizeDependants();
        this.valueSize = -1;
    }

    public void closeValueSizeDependants() {
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    public void writeValue(Data<?> value) {
        value.writeTo(this.segmentBS(), valueOffset());
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert oldValueSize == (value.size());
        initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        writeValue(value);
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return ((valueSizeOffset()) + (this.m().valueSizeMarshaller.sizeEncodingSize(newValue.size()))) - (keySizeOffset());
    }

    public void initValue(Data<?> value) {
        this.segmentBytes().position(valueSizeOffset());
        initValueSize(value.size());
        writeValue(value);
    }

    long replicationBytesOffset = -1;

    public boolean replicationStateInit() {
        return (this.replicationBytesOffset) != (-1);
    }

    void initReplicationState() {
        replicationBytesOffset = keyEnd();
    }

    public long replicationBytesOffset() {
        if (!(this.replicationStateInit()))
            this.initReplicationState();
        
        return this.replicationBytesOffset;
    }

    public void closeReplicationState() {
        if (!(this.replicationStateInit()))
            return ;
        
        this.replicationBytesOffset = -1;
    }

    void updateReplicationState(long timestamp, byte identifier) {
        this.segmentBytes().position(replicationBytesOffset());
        this.segmentBytes().writeLong(timestamp);
        this.segmentBytes().writeByte(identifier);
    }

    public void updatedReplicationStateOnAbsentEntry() {
        if (!(this.replicationUpdateInit())) {
            this.innerWriteLock.lock();
            updateReplicationState(this.m().timeProvider.currentTime(), this.m().identifier());
        } 
    }

    public long timestamp() {
        return this.segmentBS().readLong(replicationBytesOffset());
    }

    public void raiseChange() {
        this.m().raiseChange(this.tierIndex(), this.pos(), this.timestamp());
    }

    public void updateChange() {
        if (!(replicationUpdateInit())) {
            raiseChange();
        } 
    }

    public void moveChange(long oldTierIndex, long oldPos, long newPos) {
        this.m().moveChange(oldTierIndex, oldPos, this.tierIndex(), newPos, this.timestamp());
    }

    private long entryDeletedOffset() {
        return (replicationBytesOffset()) + 9L;
    }

    public void writeEntryDeleted() {
        this.segmentBS().writeBoolean(entryDeletedOffset(), true);
    }

    public void writeEntryPresent() {
        this.segmentBS().writeBoolean(entryDeletedOffset(), false);
    }

    public boolean entryDeleted() {
        return this.segmentBS().readBoolean(entryDeletedOffset());
    }

    @Override
    public void doRemoveCompletely() {
        boolean wasDeleted = this.entryDeleted();
        _MapQuery_doRemove();
        if (wasDeleted)
            this.deleted(((this.deleted()) - 1L));
        
    }

    private long timestampOffset() {
        return replicationBytesOffset();
    }

    private long identifierOffset() {
        return (replicationBytesOffset()) + 8L;
    }

    byte identifier() {
        return this.segmentBS().readByte(identifierOffset());
    }

    public void updatedReplicationStateOnPresentEntry() {
        if (!(this.replicationUpdateInit())) {
            this.innerWriteLock.lock();
            long timestamp;
            if ((identifier()) != (this.m().identifier())) {
                timestamp = Math.max(((timestamp()) + 1), this.m().timeProvider.currentTime());
            } else {
                timestamp = this.m().timeProvider.currentTime();
            }
            updateReplicationState(timestamp, this.m().identifier());
        } 
    }

    protected long entryEnd() {
        return (valueOffset()) + (valueSize());
    }

    public void closeReplicatedMapEntryStagesEntryEndDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
    }

    long entrySize() {
        return ((checksumStrategy.extraEntryBytes()) + (entryEnd())) - (keySizeOffset());
    }

    public void closeReplicatedMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public int entrySizeInChunks = 0;

    public boolean entrySizeInChunksInit() {
        return (this.entrySizeInChunks) != 0;
    }

    void initEntrySizeInChunks() {
        entrySizeInChunks = this.h().inChunks(entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!(this.entrySizeInChunksInit()))
            this.initEntrySizeInChunks();
        
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        if (!(this.entrySizeInChunksInit()))
            return ;
        
        this.entrySizeInChunks = 0;
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(pos(), entrySizeInChunks());
        this.entries(((this.entries()) - 1L));
        this.incrementModCountGuarded();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        initPos(pos);
        initKeySize(key.size());
        this.segmentBytes().position(keySizeOffset());
        this.h().keySizeMarshaller.writeSize(this.segmentBytes(), keySize());
        initKeyOffset(this.segmentBytes().position());
        key.writeTo(this.segmentBS(), keyOffset());
    }

    boolean keyEquals() {
        return ((inputKey().size()) == (this.keySize())) && (BytesUtil.bytesEqual(this.segmentBS(), this.keyOffset(), inputKey().bytes(), inputKey().offset(), this.keySize()));
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    protected CompiledReplicatedMapQueryContext.SearchState searchState = null;

    boolean keySearchInit() {
        return (this.searchState) != null;
    }

    public void initKeySearch() {
        for (long pos ; (pos = this.nextPos()) >= 0L ; ) {
            if (inputKeyInit()) {
                this.readExistingEntry(pos);
                if (!(keyEquals()))
                    continue;
                
                this.found();
                keyFound();
                return ;
            } 
        }
        searchState = CompiledReplicatedMapQueryContext.SearchState.ABSENT;
        this.closeKeySearchDependants();
    }

    public CompiledReplicatedMapQueryContext.SearchState searchState() {
        if (!(this.keySearchInit()))
            this.initKeySearch();
        
        return this.searchState;
    }

    void closeKeySearch() {
        if (!(this.keySearchInit()))
            return ;
        
        this.closeKeySearchDependants();
        this.searchState = null;
    }

    public void closeKeySearchDependants() {
        this.closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
        this.closeKeySearchSearchStatePresentDependants();
    }

    public void incrementSegmentEntriesIfNeeded() {
        if ((this.searchState()) != (CompiledReplicatedMapQueryContext.SearchState.PRESENT)) {
            this.entries(((this.entries()) + 1L));
        } 
    }

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.locksInit()) {
            if ((this.nestedContextsLockedOnSameSegment()) && ((this.rootContextLockedOnThisSegment().latestSameThreadSegmentModCount()) != (this.contextModCount()))) {
                if (this.keySearchInit()) {
                    if ((this.searchState()) == (CompiledReplicatedMapQueryContext.SearchState.PRESENT)) {
                        if (!(this.checkSlotContainsExpectedKeyAndValue(this.pos())))
                            this.closeHashLookupPos();
                        
                    } 
                } 
            } 
        } 
    }

    public void closeReplicatedMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        _CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed();
    }

    public void closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public void dropChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.dropChange();
    }

    @Override
    public R replaceValue(@NotNull
    MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @NotNull
    @Override
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @NotNull
    @Override
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    public Data<K> queriedKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceData wrapped = this.wrappedValueInstanceValue;
        wrapped = wrapped.getUnusedWrappedValueGuarded();
        wrapped.initValue(value);
        return wrapped;
    }

    @NotNull
    @Override
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public void raiseChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.raiseChange();
    }

    @NotNull
    @Override
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public boolean isChanged() {
        this.checkOnEachPublicOperation();
        this.innerReadLock.lock();
        return this.changed();
    }

    @NotNull
    @Override
    public MapContext<K, V, ?> context() {
        this.checkOnEachPublicOperation();
        return this;
    }

    @Override
    public Data<V> defaultValue(@NotNull
    MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    public long originTimestamp() {
        this.checkOnEachPublicOperation();
        return timestamp();
    }

    @Override
    public byte originIdentifier() {
        this.checkOnEachPublicOperation();
        return identifier();
    }

    @Override
    public R remove(@NotNull
    MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @NotNull
    @Override
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @NotNull
    @Override
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public void updateOrigin(byte newIdentifier, long newTimestamp) {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        updateReplicationState(newTimestamp, newIdentifier);
    }

    @NotNull
    @Override
    public Data<V> defaultValue() {
        this.checkOnEachPublicOperation();
        if ((this.m().constantValueProvider) == null) {
            throw new IllegalStateException(("to call acquireUsing(), " + ("or defaultValue() on AbsentEntry, you should configure " + ("ChronicleMapBuilder.defaultValue(), or use one of the \'known\' value types: " + "boxed primitives, or so-called data-value-generated interface as a value"))));
        } 
        return context().wrapValueAsData(this.m().constantValueProvider.defaultValue());
    }

    @Override
    public R insert(@NotNull
    MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    public boolean searchStateDeleted() {
        return (((searchState()) == (CompiledReplicatedMapQueryContext.SearchState.DELETED)) && (!(this.nestedContextsLockedOnSameSegment()))) && (this.innerUpdateLock.isHeldByCurrentThread());
    }

    public boolean searchStatePresent() {
        return (searchState()) == (CompiledReplicatedMapQueryContext.SearchState.PRESENT);
    }

    public void closeKeySearchSearchStatePresentDependants() {
        this.closeReplicatedMapQueryTieredEntryPresentDependants();
        this.closePresenceOfEntry();
    }

    private boolean tieredEntryPresent() {
        int firstTier = this.segmentTier();
        long firstTierBaseAddr = this.segmentBaseAddr();
        while (true) {
            if (this.hasNextTier()) {
                this.nextTier();
            } else {
                if ((this.segmentTier()) != 0)
                    this.initSegmentTier();
                
            }
            if ((this.segmentBaseAddr()) == firstTierBaseAddr)
                break;
            
            if (this.searchStatePresent())
                return true;
            
        }
        if (firstTier != 0) {
            this.initSegmentTier();
        } 
        return false;
    }

    public void closeReplicatedMapQueryTieredEntryPresentDependants() {
        this.closePresenceOfEntry();
    }

    public boolean searchStateAbsent() {
        return (!(searchStatePresent())) && (!(searchStateDeleted()));
    }

    protected void putPrefix() {
        this.checkOnEachPublicOperation();
        boolean underUpdatedLockIsHeld = !(this.innerUpdateLock.isHeldByCurrentThread());
        if (underUpdatedLockIsHeld)
            this.innerUpdateLock.lock();
        
        boolean searchResultsNotTrusted = underUpdatedLockIsHeld || (this.nestedContextsLockedOnSameSegment());
        if (((this.hashLookupPosInit()) && (this.searchStateAbsent())) && searchResultsNotTrusted)
            this.closeHashLookupPos();
        
    }

    public void putNewVolatile(long value) {
        assert !(this.searchStatePresent());
        hl().checkValueForPut(value);
        long currentEntry = hl().readEntry(addr(), this.hashLookupPos());
        hl().writeEntryVolatile(addr(), this.hashLookupPos(), currentEntry, searchKey(), value);
    }

    private CompiledReplicatedMapQueryContext.EntryPresence entryPresence = null;

    public boolean presenceOfEntryInit() {
        return (this.entryPresence) != null;
    }

    public void initPresenceOfEntry(CompiledReplicatedMapQueryContext.EntryPresence entryPresence) {
        this.entryPresence = entryPresence;
    }

    private void initPresenceOfEntry() {
        if ((this.searchStatePresent()) || (tieredEntryPresent())) {
            entryPresence = CompiledReplicatedMapQueryContext.EntryPresence.PRESENT;
        } else {
            entryPresence = CompiledReplicatedMapQueryContext.EntryPresence.ABSENT;
        }
    }

    public CompiledReplicatedMapQueryContext.EntryPresence entryPresence() {
        if (!(this.presenceOfEntryInit()))
            this.initPresenceOfEntry();
        
        return this.entryPresence;
    }

    public void closePresenceOfEntry() {
        if (!(this.presenceOfEntryInit()))
            return ;
        
        this.entryPresence = null;
    }

    public boolean entryPresent() {
        return (_MapQuery_entryPresent()) && (!(this.entryDeleted()));
    }

    @Nullable
    @Override
    public MapAbsentEntry<K, V> absentEntry() {
        this.checkOnEachPublicOperation();
        if (entryPresent()) {
            return null;
        } else {
            if (!(this.searchStatePresent())) {
                return this.absentDelegating;
            } else {
                assert this.entryDeleted();
                return this.absent();
            }
        }
    }

    @Override
    public MapReplicableEntry<K, V> entry() {
        return ((MapReplicableEntry<K, V>)(_MapQuery_entry()));
    }

    public int allocatedChunks = 0;

    public boolean allocatedChunksInit() {
        return (this.allocatedChunks) != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert this.allocatedChunksInit() : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!(this.allocatedChunksInit()))
            return ;
        
        this.allocatedChunks = 0;
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy) {
        initAllocatedChunks(this.h().inChunks(entrySize));
        incrementSegmentEntriesIfNeeded();
        long oldSegmentTierBaseAddr = this.segmentBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + (this.keySizeOffset());
        long oldKeyAddr = oldSegmentTierBaseAddr + (this.keyOffset());
        int tierBeforeAllocation = this.segmentTier();
        long pos = this.alloc(allocatedChunks());
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return (this.segmentTier()) != tierBeforeAllocation;
    }

    public final void freeExtraAllocatedChunks() {
        if (((!(this.m().constantlySizedEntry)) && (this.m().couldNotDetermineAlignmentBeforeAllocation)) && ((entrySizeInChunks()) < (this.allocatedChunks()))) {
            this.free(((pos()) + (entrySizeInChunks())), ((this.allocatedChunks()) - (entrySizeInChunks())));
        } else {
            initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public void writeValueAndPutPos(Data<V> value) {
        initValue(value);
        freeExtraAllocatedChunks();
        this.putValueVolatile(pos());
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        long oldPos = pos();
        long oldTierIndex = this.tierIndex();
        _MapEntryStages_relocation(newValue, newSizeOfEverythingBeforeValue);
        this.moveChange(oldTierIndex, oldPos, pos());
    }

    public void innerDefaultReplaceValue(Data<V> newValue) {
        assert this.innerUpdateLock.isHeldByCurrentThread();
        boolean newValueSizeIsDifferent = (newValue.size()) != (this.valueSize());
        if (newValueSizeIsDifferent) {
            long newSizeOfEverythingBeforeValue = newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = keySizeOffset();
            VanillaChronicleMap<?, ?, ?, ?, ?, ?, ?> m = this.m();
            long newValueOffset = m.alignment.alignAddr((entryStartOffset + newSizeOfEverythingBeforeValue));
            long newEntrySize = (newValueOffset + (newValue.size())) - entryStartOffset;
            int newSizeInChunks = m.inChunks(newEntrySize);
            newValueDoesNotFit : if (newSizeInChunks > (entrySizeInChunks())) {
                if (newSizeInChunks > (m.maxChunksPerEntry)) {
                    throw new IllegalArgumentException(((((("Value too large: " + "entry takes ") + newSizeInChunks) + " chunks, ") + (m.maxChunksPerEntry)) + " is maximum."));
                } 
                if (this.freeList().isRangeClear(((pos()) + (entrySizeInChunks())), ((pos()) + newSizeInChunks))) {
                    this.freeList().setRange(((pos()) + (entrySizeInChunks())), ((pos()) + newSizeInChunks));
                    break newValueDoesNotFit;
                } 
                relocation(newValue, newSizeOfEverythingBeforeValue);
                return ;
            } else if (newSizeInChunks < (entrySizeInChunks())) {
                this.freeList().clearRange(((pos()) + newSizeInChunks), ((pos()) + (entrySizeInChunks())));
            } 
        } else {
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            initValue(newValue);
        } else {
            writeValue(newValue);
        }
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        if (entryPresent()) {
            if ((this.valueSize()) > (this.dummyValue.size()))
                this.innerDefaultReplaceValue(this.dummyValue);
            
            this.updatedReplicationStateOnPresentEntry();
            this.writeEntryDeleted();
            this.updateChange();
            this.checksumStrategy.computeAndStoreChecksum();
            this.deleted(((this.deleted()) + 1));
        } else {
            throw new IllegalStateException("Entry is absent in the map when doRemove() is called");
        }
    }

    public void doReplaceValueWithoutChecksum(Data<V> newValue) {
        putPrefix();
        if (entryPresent()) {
            this.innerDefaultReplaceValue(newValue);
            this.incrementModCountGuarded();
            this.setSearchStateGuarded(CompiledReplicatedMapQueryContext.SearchState.PRESENT);
            initPresenceOfEntry(CompiledReplicatedMapQueryContext.EntryPresence.PRESENT);
        } else {
            throw new IllegalStateException("Entry is absent in the map when doReplaceValue() is called");
        }
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        doReplaceValueWithoutChecksum(newValue);
        this.updateChange();
        this.updatedReplicationStateOnPresentEntry();
        this.checksumStrategy.computeAndStoreChecksum();
    }

    public boolean initEntryAndKey(long entrySize) {
        initAllocatedChunks(this.h().inChunks(entrySize));
        incrementSegmentEntriesIfNeeded();
        int tierBeforeAllocation = this.segmentTier();
        long pos = this.alloc(allocatedChunks());
        this.writeNewEntry(pos, this.inputKey());
        return (this.segmentTier()) != tierBeforeAllocation;
    }

    void putEntry(Data<V> value) {
        assert this.searchStateAbsent();
        long entrySize = this.entrySize(this.inputKey().size(), value.size());
        this.initEntryAndKey(entrySize);
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putNewVolatile(this.pos());
    }

    @Override
    public void doInsert(Data<V> value) {
        this.putPrefix();
        this.innerUpdateLock.lock();
        if (!(this.entryPresent())) {
            if (!(this.searchStatePresent())) {
                putEntry(value);
                this.updatedReplicationStateOnAbsentEntry();
                this.setSearchStateGuarded(CompiledReplicatedMapQueryContext.SearchState.PRESENT);
                this.initPresenceOfEntry(CompiledReplicatedMapQueryContext.EntryPresence.PRESENT);
            } else {
                this.innerDefaultReplaceValue(value);
                this.updatedReplicationStateOnPresentEntry();
                this.deleted(((this.deleted()) - 1));
            }
            this.incrementModCountGuarded();
            this.writeEntryPresent();
            this.updateChange();
            this.checksumStrategy.computeAndStoreChecksum();
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
    }

    public long innerRemoteTimestamp;

    public byte innerRemoteIdentifier = ((byte)(0));

    public boolean replicationUpdateInit() {
        return (this.innerRemoteIdentifier) != ((byte)(0));
    }

    public void initReplicationUpdate(long timestamp, byte identifier) {
        innerRemoteTimestamp = timestamp;
        if (identifier == 0)
            throw new IllegalStateException("identifier can\'t be 0");
        
        innerRemoteIdentifier = identifier;
    }

    public byte innerRemoteIdentifier() {
        assert this.replicationUpdateInit() : "ReplicationUpdate should be init";
        return this.innerRemoteIdentifier;
    }

    public long innerRemoteTimestamp() {
        assert this.replicationUpdateInit() : "ReplicationUpdate should be init";
        return this.innerRemoteTimestamp;
    }

    public void closeReplicationUpdate() {
        if (!(this.replicationUpdateInit()))
            return ;
        
        this.innerRemoteIdentifier = ((byte)(0));
    }

    @Override
    public long remoteTimestamp() {
        this.checkOnEachPublicOperation();
        return innerRemoteTimestamp();
    }

    @Override
    public byte remoteIdentifier() {
        this.checkOnEachPublicOperation();
        return innerRemoteIdentifier();
    }

    public long bootstrapTimestamp;

    public long riKeySize = -1;

    public long riValueSize;

    public long riKeyOffset;

    public long riValueOffset;

    public long riTimestamp;

    public byte riId;

    public boolean isDeleted;

    public boolean replicationInputInit() {
        return (this.riKeySize) != (-1);
    }

    public void initReplicationInput(Bytes replicatedInputBytes) {
        initReplicatedInputBytes(replicatedInputBytes);
        bootstrapTimestamp = replicatedInputBytes.readLong();
        riKeySize = this.m().keySizeMarshaller.readSize(replicatedInputBytes);
        riValueSize = this.m().valueSizeMarshaller.readSize(replicatedInputBytes);
        riTimestamp = replicatedInputBytes.readStopBit();
        riId = replicatedInputBytes.readByte();
        this.initReplicationUpdate(riTimestamp, riId);
        isDeleted = replicatedInputBytes.readBoolean();
        riKeyOffset = replicatedInputBytes.position();
        riValueOffset = (riKeyOffset) + (riKeySize);
        this.closeReplicationInputDependants();
    }

    public boolean isDeleted() {
        assert this.replicationInputInit() : "ReplicationInput should be init";
        return this.isDeleted;
    }

    public byte riId() {
        assert this.replicationInputInit() : "ReplicationInput should be init";
        return this.riId;
    }

    public long bootstrapTimestamp() {
        assert this.replicationInputInit() : "ReplicationInput should be init";
        return this.bootstrapTimestamp;
    }

    public long riKeyOffset() {
        assert this.replicationInputInit() : "ReplicationInput should be init";
        return this.riKeyOffset;
    }

    public long riKeySize() {
        assert this.replicationInputInit() : "ReplicationInput should be init";
        return this.riKeySize;
    }

    public long riValueOffset() {
        assert this.replicationInputInit() : "ReplicationInput should be init";
        return this.riValueOffset;
    }

    public long riValueSize() {
        assert this.replicationInputInit() : "ReplicationInput should be init";
        return this.riValueSize;
    }

    public void closeReplicationInput() {
        if (!(this.replicationInputInit()))
            return ;
        
        this.closeReplicationInputDependants();
        this.riKeySize = -1;
    }

    public void closeReplicationInputDependants() {
        this.replicatedInputKeyBytesValue.closeReplicatedInputKeyBytesDataSizeDependants();
        this.replicatedInputValueBytesValue.closeReplicatedInputValueBytesDataSizeDependants();
        this.replicatedInputKeyBytesValue.closeReplicatedInputKeyBytesDataGetUsingDependants();
        this.replicatedInputValueBytesValue.closeReplicatedInputValueBytesDataGetUsingDependants();
    }

    public void processReplicatedEvent() {
        if ((riId()) == (this.m().identifier())) {
            return ;
        } 
        this.m().setLastModificationTime(riId(), bootstrapTimestamp());
        this.initInputKey(this.replicatedInputKeyBytesValue);
        boolean debugEnabled = this.LOG.isDebugEnabled();
        this.innerUpdateLock.lock();
        if (isDeleted()) {
            if (debugEnabled) {
                this.LOG.debug("READING FROM SOURCE -  into local-id={}, remote={}, remove(key={})", this.m().identifier(), riId(), this.inputKey());
            } 
            this.m().remoteOperations.remove(this);
            return ;
        } 
        String message = null;
        if (debugEnabled) {
            message = String.format("READING FROM SOURCE -  into local-id=%d, remote-id=%d, put(key=%s,", this.m().identifier(), riId(), this.inputKey());
        } 
        this.m().remoteOperations.put(this, this.replicatedInputValueBytesValue);
        if (debugEnabled) {
            this.LOG.debug((((message + "value=") + (this.replicatedInputValueBytesValue)) + ")"));
        } 
    }

    public Bytes inputBytes = null;

    public boolean inputBytesInit() {
        return (this.inputBytes) != null;
    }

    public void initInputBytes(Bytes inputBytes) {
        this.inputBytes = inputBytes;
        inputStore.setBytes(inputBytes);
        this.closeInputBytesDependants();
    }

    public Bytes inputBytes() {
        assert this.inputBytesInit() : "InputBytes should be init";
        return this.inputBytes;
    }

    public void closeInputBytes() {
        if (!(this.inputBytesInit()))
            return ;
        
        this.closeInputBytesDependants();
        this.inputBytes = null;
    }

    public void closeInputBytesDependants() {
        this.closeInputKeyOffsets();
        this.closeFirstInputValueOffsets();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataGetUsingDependants();
        this.inputKeyBytesValue.closeInputKeyBytesDataGetUsingDependants();
        this.closeSecondInputValueOffsets();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataGetUsingDependants();
    }

    public long inputKeySize = -1;

    public long inputKeyOffset;

    public boolean inputKeyOffsetsInit() {
        return (this.inputKeySize) != (-1);
    }

    private void initInputKeyOffsets() {
        inputKeySize = this.h().keySizeMarshaller.readSize(inputBytes());
        inputKeyOffset = inputBytes().position();
        this.closeInputKeyOffsetsDependants();
    }

    public long inputKeyOffset() {
        if (!(this.inputKeyOffsetsInit()))
            this.initInputKeyOffsets();
        
        return this.inputKeyOffset;
    }

    public long inputKeySize() {
        if (!(this.inputKeyOffsetsInit()))
            this.initInputKeyOffsets();
        
        return this.inputKeySize;
    }

    public void closeInputKeyOffsets() {
        if (!(this.inputKeyOffsetsInit()))
            return ;
        
        this.closeInputKeyOffsetsDependants();
        this.inputKeySize = -1;
    }

    public void closeInputKeyOffsetsDependants() {
        this.closeFirstInputValueOffsets();
        this.inputKeyBytesValue.closeInputKeyBytesDataSizeDependants();
        this.inputKeyBytesValue.closeInputKeyBytesDataGetUsingDependants();
    }

    public long firstInputValueSize = -1;

    public long firstInputValueOffset;

    public boolean firstInputValueOffsetsInit() {
        return (this.firstInputValueSize) != (-1);
    }

    private void initFirstInputValueOffsets() {
        this.inputBytes().position(((this.inputKeyOffset()) + (this.inputKeySize())));
        firstInputValueSize = this.m().valueSizeMarshaller.readSize(this.inputBytes());
        firstInputValueOffset = this.inputBytes().position();
        this.closeFirstInputValueOffsetsDependants();
    }

    public long firstInputValueOffset() {
        if (!(this.firstInputValueOffsetsInit()))
            this.initFirstInputValueOffsets();
        
        return this.firstInputValueOffset;
    }

    public long firstInputValueSize() {
        if (!(this.firstInputValueOffsetsInit()))
            this.initFirstInputValueOffsets();
        
        return this.firstInputValueSize;
    }

    public void closeFirstInputValueOffsets() {
        if (!(this.firstInputValueOffsetsInit()))
            return ;
        
        this.closeFirstInputValueOffsetsDependants();
        this.firstInputValueSize = -1;
    }

    public void closeFirstInputValueOffsetsDependants() {
        this.closeSecondInputValueOffsets();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataSizeDependants();
        this.inputFirstValueBytesValue.closeInputFirstValueBytesDataGetUsingDependants();
    }

    public long secondInputValueSize = -1;

    public long secondInputValueOffset;

    public boolean secondInputValueOffsetsInit() {
        return (this.secondInputValueSize) != (-1);
    }

    private void initSecondInputValueOffsets() {
        this.inputBytes().position(((firstInputValueOffset()) + (firstInputValueSize())));
        secondInputValueSize = this.m().valueSizeMarshaller.readSize(this.inputBytes());
        secondInputValueOffset = this.inputBytes().position();
        this.closeSecondInputValueOffsetsDependants();
    }

    public long secondInputValueOffset() {
        if (!(this.secondInputValueOffsetsInit()))
            this.initSecondInputValueOffsets();
        
        return this.secondInputValueOffset;
    }

    public long secondInputValueSize() {
        if (!(this.secondInputValueOffsetsInit()))
            this.initSecondInputValueOffsets();
        
        return this.secondInputValueSize;
    }

    public void closeSecondInputValueOffsets() {
        if (!(this.secondInputValueOffsetsInit()))
            return ;
        
        this.closeSecondInputValueOffsetsDependants();
        this.secondInputValueSize = -1;
    }

    public void closeSecondInputValueOffsetsDependants() {
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataSizeDependants();
        this.inputSecondValueBytesValue.closeInputSecondValueBytesDataGetUsingDependants();
    }
}