/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.impl.JavaLangBytesReusableBytesStore;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.io.serialization.JDKObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;

public abstract class CopyingInstanceData<I>
extends AbstractData<I> {
    private final JavaLangBytesReusableBytesStore bytesStore = new JavaLangBytesReusableBytesStore();

    public DirectBytes getBuffer(DirectBytes b, long capacity) {
        if (b != null) {
            if (b.capacity() >= capacity) {
                return (DirectBytes)b.clear();
            }
            DirectStore store = (DirectStore)b.store();
            store.resize(capacity, false);
            DirectBytes bytes = store.bytes();
            this.bytesStore.setBytes((Bytes)bytes);
            return bytes;
        }
        DirectBytes bytes = new DirectStore((ObjectSerializer)JDKObjectSerializer.INSTANCE, Math.max(1L, capacity), true).bytes();
        this.bytesStore.setBytes((Bytes)bytes);
        return bytes;
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytesStore;
    }

    public abstract I instance();

    public abstract DirectBytes buffer();

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return this.buffer().limit();
    }

    @Override
    public I get() {
        return this.instance();
    }
}

