/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.lang.io.NativeBytes;

public enum TierCountersArea {

    public static final long NEXT_TIER_INDEX_OFFSET = 0L;
    public static final long PREV_TIER_INDEX_OFFSET = 8L;
    public static final long NEXT_POS_TO_SEARCH_FROM_TIERED_OFFSET = 16L;
    public static final long SEGMENT_INDEX_OFFSET = 24L;
    public static final long TIER_OFFSET = 28L;

    public static long nextTierIndex(long address) {
        return NativeBytes.UNSAFE.getLong(address + 0L);
    }

    public static void nextTierIndex(long address, long nextTierIndex) {
        NativeBytes.UNSAFE.putLong(address + 0L, nextTierIndex);
    }

    public static long nextPosToSearchFromTiered(long address) {
        return NativeBytes.UNSAFE.getLong(address + 16L);
    }

    public static void nextPosToSearchFromTiered(long address, long nextPosToSearchFrom) {
        NativeBytes.UNSAFE.putLong(address + 16L, nextPosToSearchFrom);
    }

    public static long prevTierIndex(long address) {
        return NativeBytes.UNSAFE.getLong(address + 8L);
    }

    public static void prevTierIndex(long address, long prevTierIndex) {
        NativeBytes.UNSAFE.putLong(address + 8L, prevTierIndex);
    }

    public static int segmentIndex(long address) {
        return NativeBytes.UNSAFE.getInt(address + 24L);
    }

    public static void segmentIndex(long address, int segmentIndex) {
        NativeBytes.UNSAFE.putInt(address + 24L, segmentIndex);
    }

    public static int tier(long address) {
        return NativeBytes.UNSAFE.getInt(address + 28L);
    }

    public static void tier(long address, int tier) {
        NativeBytes.UNSAFE.putInt(address + 28L, tier);
    }
}

